/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import org.apache.kafka.streams.EqualityCheck;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SessionWindowsTest {
    private static final long ANY_SIZE = 123L;
    private static final long ANY_OTHER_SIZE = 456L;
    private static final long ANY_GRACE = 1024L;

    @Test
    public void shouldSetWindowGap() {
        long anyGap = 42L;
        Assertions.assertEquals((long)42L, (long)SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(42L)).inactivityGap());
        Assertions.assertEquals((long)42L, (long)SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(42L), (Duration)Duration.ofMillis(1024L)).inactivityGap());
    }

    @Test
    public void gracePeriodShouldEnforceBoundaries() {
        SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(0L));
        try {
            SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(-1L));
            Assertions.fail((String)"should not accept negatives");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void noGraceAPIShouldNotSetGracePeriod() {
        Assertions.assertEquals((long)0L, (long)SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(3L)).gracePeriodMs());
        Assertions.assertEquals((long)0L, (long)SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(123L)).gracePeriodMs());
        Assertions.assertEquals((long)0L, (long)SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(456L)).gracePeriodMs());
    }

    @Test
    public void withGraceAPIShouldSetGracePeriod() {
        Assertions.assertEquals((long)1024L, (long)SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(1024L)).gracePeriodMs());
        Assertions.assertEquals((long)1024L, (long)SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(123L), (Duration)Duration.ofMillis(1024L)).gracePeriodMs());
        Assertions.assertEquals((long)1024L, (long)SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(456L), (Duration)Duration.ofMillis(1024L)).gracePeriodMs());
    }

    @Test
    public void windowSizeMustNotBeNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(-1L)));
    }

    @Test
    public void windowSizeMustNotBeZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(0L)));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForPositiveCases() {
        EqualityCheck.verifyEquality(SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(1L)), SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(1L)));
        EqualityCheck.verifyEquality(SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(11L)), SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(11L)));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForNegativeCases() {
        EqualityCheck.verifyInEquality(SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(9L)), SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(1L)));
        EqualityCheck.verifyInEquality(SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(9L), (Duration)Duration.ofMillis(9L)), SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(9L)));
        EqualityCheck.verifyInEquality(SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(9L)), SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(6L)));
    }
}

