/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.Map;
import org.apache.kafka.streams.EqualityCheck;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimeWindowsTest {
    private static final long ANY_SIZE = 123L;
    private static final long ANY_GRACE = 1024L;

    @Test
    public void shouldSetWindowSize() {
        Assertions.assertEquals((long)123L, (long)TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis((long)123L)).sizeMs);
        Assertions.assertEquals((long)123L, (long)TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis((long)123L), (Duration)Duration.ofMillis((long)1024L)).sizeMs);
    }

    @Test
    public void shouldSetWindowAdvance() {
        long anyAdvance = 4L;
        Assertions.assertEquals((long)4L, (long)TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis((long)123L)).advanceBy((Duration)Duration.ofMillis((long)4L)).advanceMs);
    }

    @Test
    public void windowSizeMustNotBeZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(0L)));
    }

    @Test
    public void windowSizeMustNotBeNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(-1L)));
    }

    @Test
    public void advanceIntervalMustNotBeZero() {
        TimeWindows windowSpec = TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(123L));
        try {
            windowSpec.advanceBy(Duration.ofMillis(0L));
            Assertions.fail((String)"should not accept zero advance parameter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void advanceIntervalMustNotBeNegative() {
        TimeWindows windowSpec = TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(123L));
        try {
            windowSpec.advanceBy(Duration.ofMillis(-1L));
            Assertions.fail((String)"should not accept negative advance parameter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void advanceIntervalMustNotBeLargerThanWindowSize() {
        TimeWindows windowSpec = TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(123L));
        try {
            windowSpec.advanceBy(Duration.ofMillis(124L));
            Assertions.fail((String)"should not accept advance greater than window size");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void gracePeriodShouldEnforceBoundaries() {
        TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(0L));
        try {
            TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(-1L));
            Assertions.fail((String)"should not accept negatives");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldComputeWindowsForHoppingWindows() {
        TimeWindows windows = TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(12L)).advanceBy(Duration.ofMillis(5L));
        Map matched = windows.windowsFor(21L);
        Assertions.assertEquals((long)3L, (long)matched.size());
        Assertions.assertEquals((Object)new TimeWindow(10L, 22L), matched.get(10L));
        Assertions.assertEquals((Object)new TimeWindow(15L, 27L), matched.get(15L));
        Assertions.assertEquals((Object)new TimeWindow(20L, 32L), matched.get(20L));
    }

    @Test
    public void shouldComputeWindowsForBarelyOverlappingHoppingWindows() {
        TimeWindows windows = TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(6L)).advanceBy(Duration.ofMillis(5L));
        Map matched = windows.windowsFor(7L);
        Assertions.assertEquals((int)1, (int)matched.size());
        Assertions.assertEquals((Object)new TimeWindow(5L, 11L), matched.get(5L));
    }

    @Test
    public void shouldComputeWindowsForTumblingWindows() {
        TimeWindows windows = TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(12L));
        Map matched = windows.windowsFor(21L);
        Assertions.assertEquals((int)1, (int)matched.size());
        Assertions.assertEquals((Object)new TimeWindow(12L, 24L), matched.get(12L));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForPositiveCases() {
        EqualityCheck.verifyEquality(TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(3L)), TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(3L)));
        EqualityCheck.verifyEquality(TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(1L)), TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(1L)));
        EqualityCheck.verifyEquality(TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(4L)), TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(4L)));
        EqualityCheck.verifyEquality(TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(33L)), TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(33L)));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForNegativeCases() {
        EqualityCheck.verifyInEquality(TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(9L)), TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(3L)));
        EqualityCheck.verifyInEquality(TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(9L), (Duration)Duration.ofMillis(9L)), TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(9L)));
        EqualityCheck.verifyInEquality(TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(2L)), TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(1L)));
        EqualityCheck.verifyInEquality(TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(2L)), TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(1L)));
        EqualityCheck.verifyInEquality(TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(9L)), TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(4L)));
        EqualityCheck.verifyInEquality(TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(4L), (Duration)Duration.ofMillis(2L)).advanceBy(Duration.ofMillis(2L)), TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(2L)).advanceBy(Duration.ofMillis(2L)));
        EqualityCheck.verifyInEquality(TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(2L)).advanceBy(Duration.ofMillis(1L)), TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(2L)).advanceBy(Duration.ofMillis(2L)));
        Assertions.assertNotEquals((Object)TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(1L)).advanceBy(Duration.ofMillis(2L)), (Object)TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(2L)).advanceBy(Duration.ofMillis(2L)));
    }
}

