/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ChangedDeserializer;
import org.apache.kafka.streams.kstream.internals.ChangedSerializer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChangedSerdeTest {
    private static final String TOPIC = "some-topic";
    private static final Serializer<String> STRING_SERIALIZER = Serdes.String().serializer();
    private static final ChangedSerializer<String> CHANGED_STRING_SERIALIZER = new ChangedSerializer(STRING_SERIALIZER);
    private static final ChangedDeserializer<String> CHANGED_STRING_DESERIALIZER = new ChangedDeserializer(Serdes.String().deserializer());
    private static final int ENCODING_FLAG_SIZE = 1;
    private static final int IS_LATEST_FLAG_SIZE = 1;
    private static final int MAX_VARINT_LENGTH = 5;
    final String nonNullNewValue = "hello";
    final String nonNullOldValue = "world";

    private static <T> void checkRoundTrip(T data, Serializer<T> serializer, Deserializer<T> deserializer) {
        byte[] serialized = serializer.serialize(TOPIC, data);
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Object deserialized = deserializer.deserialize(TOPIC, serialized);
        MatcherAssert.assertThat((Object)deserialized, (Matcher)Matchers.is(data));
    }

    @Test
    public void serializerShouldThrowIfGivenAChangeWithBothNewAndOldValuesAsNull() {
        Change data = new Change(null, null);
        Assertions.assertThrows(StreamsException.class, () -> CHANGED_STRING_SERIALIZER.serialize(TOPIC, data));
    }

    @Test
    public void serializerShouldThrowIfGivenAChangeWithBothNonNullNewAndOldValuesAndIsUpgrade() {
        Change data = new Change((Object)"hello", (Object)"world");
        ChangedSerializer serializer = new ChangedSerializer(Serdes.String().serializer());
        Map<String, String> configs = Collections.singletonMap("upgrade.from", StreamsConfig.UPGRADE_FROM_33);
        serializer.configure(configs, false);
        Assertions.assertThrows(StreamsException.class, () -> serializer.serialize(TOPIC, data));
    }

    @Test
    public void shouldSerializeAndDeserializeChangeWithNonNullNewAndOldValues() {
        Change data = new Change((Object)"hello", (Object)"world");
        ChangedSerdeTest.checkRoundTrip(data, CHANGED_STRING_SERIALIZER, CHANGED_STRING_DESERIALIZER);
    }

    @Test
    public void shouldSerializeAndDeserializeChangeWithNonNullNewValueAndNullOldValue() {
        Change data = new Change((Object)"hello", null);
        ChangedSerdeTest.checkRoundTrip(data, CHANGED_STRING_SERIALIZER, CHANGED_STRING_DESERIALIZER);
    }

    @Test
    public void shouldSerializeAndDeserializeChangeWithNullNewValueAndNonNullOldValue() {
        Change data = new Change(null, (Object)"world");
        ChangedSerdeTest.checkRoundTrip(data, CHANGED_STRING_SERIALIZER, CHANGED_STRING_DESERIALIZER);
    }

    @Test
    public void shouldThrowErrorIfEncountersAnUnknownByteValueForOldNewFlag() {
        Change data = new Change(null, (Object)"world");
        byte[] serialized = CHANGED_STRING_SERIALIZER.serialize(TOPIC, data);
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        ByteBuffer buffer = ByteBuffer.wrap(serialized);
        buffer.position(serialized.length - 1);
        buffer.put((byte)-1);
        Assertions.assertThrows(StreamsException.class, () -> CHANGED_STRING_DESERIALIZER.deserialize(TOPIC, serialized));
    }

    @Test
    public void shouldDeserializeReservedVersions3Through5() {
        ChangedSerdeTest.checkRoundTripForReservedVersion((Change<String>)new Change((Object)"hello", null, true));
        ChangedSerdeTest.checkRoundTripForReservedVersion((Change<String>)new Change(null, (Object)"world", true));
        ChangedSerdeTest.checkRoundTripForReservedVersion((Change<String>)new Change((Object)"hello", (Object)"world", true));
        ChangedSerdeTest.checkRoundTripForReservedVersion((Change<String>)new Change((Object)"hello", null, false));
        ChangedSerdeTest.checkRoundTripForReservedVersion((Change<String>)new Change(null, (Object)"world", false));
        ChangedSerdeTest.checkRoundTripForReservedVersion((Change<String>)new Change((Object)"hello", (Object)"world", false));
    }

    private static byte[] serializeVersions3Through5(String topic, Change<String> data) {
        ByteBuffer buf;
        int capacity;
        byte isLatest;
        boolean oldValueIsNotNull = data.oldValue != null;
        boolean newValueIsNotNull = data.newValue != null;
        byte[] newData = STRING_SERIALIZER.serialize(topic, null, (Object)((String)data.newValue));
        byte[] oldData = STRING_SERIALIZER.serialize(topic, null, (Object)((String)data.oldValue));
        int newDataLength = newValueIsNotNull ? newData.length : 0;
        int oldDataLength = oldValueIsNotNull ? oldData.length : 0;
        byte by = isLatest = data.isLatest ? (byte)1 : 0;
        if (newValueIsNotNull && oldValueIsNotNull) {
            capacity = 5 + newDataLength + oldDataLength + 1 + 1;
            buf = ByteBuffer.allocate(capacity);
            ByteUtils.writeVarint((int)newDataLength, (ByteBuffer)buf);
            buf.put(newData).put(oldData).put(isLatest).put((byte)5);
        } else if (newValueIsNotNull) {
            capacity = newDataLength + 1 + 1;
            buf = ByteBuffer.allocate(capacity);
            buf.put(newData).put(isLatest).put((byte)4);
        } else if (oldValueIsNotNull) {
            capacity = oldDataLength + 1 + 1;
            buf = ByteBuffer.allocate(capacity);
            buf.put(oldData).put(isLatest).put((byte)3);
        } else {
            throw new StreamsException("Both old and new values are null in ChangeSerializer, which is not allowed.");
        }
        byte[] serialized = new byte[buf.position()];
        buf.position(0);
        buf.get(serialized);
        return serialized;
    }

    private static void checkRoundTripForReservedVersion(Change<String> data) {
        byte[] serialized = ChangedSerdeTest.serializeVersions3Through5(TOPIC, data);
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Change deserialized = CHANGED_STRING_DESERIALIZER.deserialize(TOPIC, serialized);
        MatcherAssert.assertThat((Object)deserialized, (Matcher)Matchers.is(data));
    }
}

