/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.test.MockApiProcessor;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KStreamGlobalKTableLeftJoinTest {
    private static final KeyValueTimestamp[] EMPTY = new KeyValueTimestamp[0];
    private final String streamTopic = "streamTopic";
    private final String globalTableTopic = "globalTableTopic";
    private TestInputTopic<Integer, String> inputStreamTopic;
    private TestInputTopic<String, String> inputTableTopic;
    private final int[] expectedKeys = new int[]{0, 1, 2, 3};
    private MockApiProcessor<Integer, String, Void, Void> processor;
    private TopologyTestDriver driver;
    private StreamsBuilder builder;

    @BeforeEach
    public void setUp() {
        this.init(Optional.empty());
    }

    private void initWithVersionedStore(long historyRetentionMs) {
        this.init(Optional.of(historyRetentionMs));
    }

    private void init(Optional<Long> versionedStoreHistoryRetentionMs) {
        this.builder = new StreamsBuilder();
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        Consumed streamConsumed = Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String());
        Consumed tableConsumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        KStream stream = this.builder.stream("streamTopic", streamConsumed);
        GlobalKTable table = versionedStoreHistoryRetentionMs.isPresent() ? this.builder.globalTable("globalTableTopic", tableConsumed, Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"table", (Duration)Duration.ofMillis(versionedStoreHistoryRetentionMs.get())))) : this.builder.globalTable("globalTableTopic", tableConsumed);
        KeyValueMapper keyMapper = (key, value) -> {
            String[] tokens = value.split(",");
            return tokens.length > 1 ? tokens[1] : null;
        };
        stream.leftJoin(table, keyMapper, MockValueJoiner.TOSTRING_JOINER).process(supplier, new String[0]);
        Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());
        this.driver = new TopologyTestDriver(this.builder.build(), props);
        this.processor = supplier.theCapturedProcessor();
        this.inputStreamTopic = this.driver.createInputTopic("streamTopic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ofMillis(1L));
        this.inputTableTopic = this.driver.createInputTopic("globalTableTopic", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ofMillis(1L));
    }

    @AfterEach
    public void cleanup() {
        this.driver.close();
    }

    private void pushToStream(int messageCount, String valuePrefix, boolean includeForeignKey, boolean includeNullKey) {
        for (int i = 0; i < messageCount; ++i) {
            String value = valuePrefix + this.expectedKeys[i];
            if (includeForeignKey) {
                value = value + ",FKey" + this.expectedKeys[i];
            }
            Integer key = this.expectedKeys[i];
            if (includeNullKey && i == 0) {
                key = null;
            }
            this.inputStreamTopic.pipeInput((Object)key, (Object)value);
        }
    }

    private void pushToGlobalTable(int messageCount, String valuePrefix) {
        for (int i = 0; i < messageCount; ++i) {
            this.inputTableTopic.pipeInput((Object)("FKey" + this.expectedKeys[i]), (Object)(valuePrefix + this.expectedKeys[i]));
        }
    }

    private void pushNullValueToGlobalTable(int messageCount) {
        for (int i = 0; i < messageCount; ++i) {
            this.inputTableTopic.pipeInput((Object)("FKey" + this.expectedKeys[i]), (Object)null);
        }
    }

    @Test
    public void shouldNotRequireCopartitioning() {
        Collection copartitionGroups = TopologyWrapper.getInternalTopologyBuilder(this.builder.build()).copartitionGroups();
        Assertions.assertEquals((int)0, (int)copartitionGroups.size(), (String)"KStream-GlobalKTable joins do not need to be co-partitioned");
    }

    @Test
    public void shouldNotJoinWithEmptyGlobalTableOnStreamUpdates() {
        this.pushToStream(2, "X", true, false);
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0,FKey0+null", 0L), new KeyValueTimestamp<Integer, String>(1, "X1,FKey1+null", 1L));
    }

    @Test
    public void shouldNotJoinOnGlobalTableUpdates() {
        this.pushToStream(2, "X", true, false);
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0,FKey0+null", 0L), new KeyValueTimestamp<Integer, String>(1, "X1,FKey1+null", 1L));
        this.pushToGlobalTable(2, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X", true, false);
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0,FKey0+Y0", 2L), new KeyValueTimestamp<Integer, String>(1, "X1,FKey1+Y1", 3L), new KeyValueTimestamp<Integer, String>(2, "X2,FKey2+null", 4L), new KeyValueTimestamp<Integer, String>(3, "X3,FKey3+null", 5L));
        this.pushToGlobalTable(4, "YY");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X", true, false);
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0,FKey0+YY0", 6L), new KeyValueTimestamp<Integer, String>(1, "X1,FKey1+YY1", 7L), new KeyValueTimestamp<Integer, String>(2, "X2,FKey2+YY2", 8L), new KeyValueTimestamp<Integer, String>(3, "X3,FKey3+YY3", 9L));
        this.pushToGlobalTable(4, "YYY");
        this.processor.checkAndClearProcessResult(EMPTY);
    }

    @Test
    public void shouldJoinRegardlessIfMatchFoundOnStreamUpdates() {
        this.pushToGlobalTable(2, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X", true, false);
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0,FKey0+Y0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1,FKey1+Y1", 1L), new KeyValueTimestamp<Integer, String>(2, "X2,FKey2+null", 2L), new KeyValueTimestamp<Integer, String>(3, "X3,FKey3+null", 3L));
    }

    @Test
    public void shouldClearGlobalTableEntryOnNullValueUpdates() {
        this.pushToGlobalTable(4, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X", true, false);
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0,FKey0+Y0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1,FKey1+Y1", 1L), new KeyValueTimestamp<Integer, String>(2, "X2,FKey2+Y2", 2L), new KeyValueTimestamp<Integer, String>(3, "X3,FKey3+Y3", 3L));
        this.pushNullValueToGlobalTable(2);
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X", true, false);
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0,FKey0+null", 4L), new KeyValueTimestamp<Integer, String>(1, "X1,FKey1+null", 5L), new KeyValueTimestamp<Integer, String>(2, "X2,FKey2+Y2", 6L), new KeyValueTimestamp<Integer, String>(3, "X3,FKey3+Y3", 7L));
    }

    @Test
    public void shouldJoinOnNullKeyMapperValues() {
        this.pushToGlobalTable(4, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "XXX", false, false);
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "XXX0+null", 0L), new KeyValueTimestamp<Integer, String>(1, "XXX1+null", 1L), new KeyValueTimestamp<Integer, String>(2, "XXX2+null", 2L), new KeyValueTimestamp<Integer, String>(3, "XXX3+null", 3L));
        MatcherAssert.assertThat((Object)((Metric)this.driver.metrics().get(new MetricName("dropped-records-total", "stream-task-metrics", "", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)Thread.currentThread().getName()), Utils.mkEntry((Object)"task-id", (Object)"0_0")})))).metricValue(), (Matcher)Matchers.is((Object)0.0));
    }

    @Test
    public void shouldJoinOnNullKeyMapperValuesWithNullKeys() {
        this.pushToGlobalTable(4, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "XXX", false, true);
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Object, String>(null, "XXX0+null", 0L), new KeyValueTimestamp<Integer, String>(1, "XXX1+null", 1L), new KeyValueTimestamp<Integer, String>(2, "XXX2+null", 2L), new KeyValueTimestamp<Integer, String>(3, "XXX3+null", 3L));
        MatcherAssert.assertThat((Object)((Metric)this.driver.metrics().get(new MetricName("dropped-records-total", "stream-task-metrics", "", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)Thread.currentThread().getName()), Utils.mkEntry((Object)"task-id", (Object)"0_0")})))).metricValue(), (Matcher)Matchers.is((Object)0.0));
    }

    @Test
    public void shouldJoinOnNullKey() {
        this.pushToGlobalTable(4, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X", true, true);
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Object, String>(null, "X0,FKey0+Y0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1,FKey1+Y1", 1L), new KeyValueTimestamp<Integer, String>(2, "X2,FKey2+Y2", 2L), new KeyValueTimestamp<Integer, String>(3, "X3,FKey3+Y3", 3L));
    }
}

