/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.StreamJoined;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.BuiltInDslStoreSuppliers;
import org.apache.kafka.streams.state.DslKeyValueParams;
import org.apache.kafka.streams.state.DslStoreSuppliers;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.streams.test.TestRecord;
import org.apache.kafka.test.MockApiProcessor;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KStreamKStreamOuterJoinTest {
    private final String topic1 = "topic1";
    private final String topic2 = "topic2";
    private final Consumed<Integer, String> consumed = Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String());
    private final Consumed<Integer, Long> consumed2 = Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Long());
    private static final Properties PROPS = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());

    @Test
    public void testOuterJoinDuplicatesWithFixDisabledOldApi() {
        StreamsBuilder builder = new StreamsBuilder();
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of((Duration)Duration.ofMillis(100L)).grace(Duration.ofMillis(10L)), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(PROPS), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            Assertions.assertEquals((int)2, (int)driver.getAllStateStores().size());
            inputTopic1.pipeInput((Object)0, (Object)"A0", 0L);
            inputTopic1.pipeInput((Object)0, (Object)"A0-0", 0L);
            inputTopic2.pipeInput((Object)0, (Object)10L, 0L);
            inputTopic2.pipeInput((Object)1, (Object)21L, 0L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "A0+null", 0L), new KeyValueTimestamp<Integer, String>(0, "A0-0+null", 0L), new KeyValueTimestamp<Integer, String>(0, "A0+10", 0L), new KeyValueTimestamp<Integer, String>(0, "A0-0+10", 0L), new KeyValueTimestamp<Integer, String>(1, "null+21", 0L));
        }
    }

    @Test
    public void testOuterJoinDuplicates() {
        StreamsBuilder builder = new StreamsBuilder();
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(100L), (Duration)Duration.ofMillis(10L)), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            inputTopic1.pipeInput((Object)0, (Object)"A0", 0L);
            inputTopic1.pipeInput((Object)0, (Object)"A0-0", 0L);
            inputTopic2.pipeInput((Object)1, (Object)11L, 0L);
            inputTopic2.pipeInput((Object)1, (Object)12L, 0L);
            inputTopic2.pipeInput((Object)1, (Object)10L, 111L);
            inputTopic2.pipeInput((Object)3, (Object)100L, 211L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(1, "null+11", 0L), new KeyValueTimestamp<Integer, String>(1, "null+12", 0L), new KeyValueTimestamp<Integer, String>(0, "A0+null", 0L), new KeyValueTimestamp<Integer, String>(0, "A0-0+null", 0L));
            inputTopic1.pipeInput((Object)2, (Object)"A2", 200L);
            inputTopic1.pipeInput((Object)2, (Object)"A2-0", 200L);
            inputTopic2.pipeInput((Object)2, (Object)13L, 201L);
            inputTopic2.pipeInput((Object)2, (Object)14L, 201L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "A2+13", 201L), new KeyValueTimestamp<Integer, String>(2, "A2-0+13", 201L), new KeyValueTimestamp<Integer, String>(2, "A2+14", 201L), new KeyValueTimestamp<Integer, String>(2, "A2-0+14", 201L));
            inputTopic2.pipeInput((Object)3, (Object)100L, 1500L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(1, "null+10", 111L), new KeyValueTimestamp<Integer, String>(3, "null+100", 211L));
        }
    }

    @Test
    public void testLeftExpiredNonJoinedRecordsAreEmittedByTheLeftProcessor() {
        StreamsBuilder builder = new StreamsBuilder();
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(100L)), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            long windowStart = 0L;
            inputTopic1.pipeInput((Object)0, (Object)"A0", 1L);
            inputTopic1.pipeInput((Object)1, (Object)"A1", 2L);
            inputTopic1.pipeInput((Object)0, (Object)"A0-0", 3L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic2.pipeInput((Object)1, (Object)11L, 3L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(1, "A1+11", 3L));
            inputTopic1.pipeInput((Object)2, (Object)"dummy", 401L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "A0+null", 1L), new KeyValueTimestamp<Integer, String>(0, "A0-0+null", 3L));
            inputTopic2.pipeInput((Object)2, (Object)100L, 401L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "dummy+100", 401L));
        }
    }

    @Test
    public void testLeftExpiredNonJoinedRecordsAreEmittedByTheRightProcessor() {
        StreamsBuilder builder = new StreamsBuilder();
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(100L), (Duration)Duration.ofMillis(0L)), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            long windowStart = 0L;
            inputTopic1.pipeInput((Object)0, (Object)"A0", 1L);
            inputTopic1.pipeInput((Object)1, (Object)"A1", 2L);
            inputTopic1.pipeInput((Object)0, (Object)"A0-0", 3L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic2.pipeInput((Object)1, (Object)11L, 3L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(1, "A1+11", 3L));
            inputTopic2.pipeInput((Object)2, (Object)100L, 401L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "A0+null", 1L), new KeyValueTimestamp<Integer, String>(0, "A0-0+null", 3L));
            inputTopic1.pipeInput((Object)2, (Object)"dummy", 402L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "dummy+100", 402L));
        }
    }

    @Test
    public void testRightExpiredNonJoinedRecordsAreEmittedByTheLeftProcessor() {
        StreamsBuilder builder = new StreamsBuilder();
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(100L)), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            long windowStart = 0L;
            inputTopic2.pipeInput((Object)0, (Object)10L, 1L);
            inputTopic2.pipeInput((Object)1, (Object)11L, 2L);
            inputTopic2.pipeInput((Object)0, (Object)12L, 3L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic1.pipeInput((Object)1, (Object)"A1", 3L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(1, "A1+11", 3L));
            inputTopic1.pipeInput((Object)2, (Object)"dummy", 401L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "null+10", 1L), new KeyValueTimestamp<Integer, String>(0, "null+12", 3L));
            inputTopic2.pipeInput((Object)2, (Object)100L, 402L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "dummy+100", 402L));
        }
    }

    @Test
    public void testRightExpiredNonJoinedRecordsAreEmittedByTheRightProcessor() {
        StreamsBuilder builder = new StreamsBuilder();
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(100L), (Duration)Duration.ofMillis(0L)), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            long windowStart = 0L;
            inputTopic2.pipeInput((Object)0, (Object)10L, 1L);
            inputTopic2.pipeInput((Object)1, (Object)11L, 2L);
            inputTopic2.pipeInput((Object)0, (Object)12L, 3L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic1.pipeInput((Object)1, (Object)"A1", 3L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(1, "A1+11", 3L));
            inputTopic2.pipeInput((Object)2, (Object)100L, 401L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "null+10", 1L), new KeyValueTimestamp<Integer, String>(0, "null+12", 3L));
            inputTopic1.pipeInput((Object)2, (Object)"dummy", 402L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "dummy+100", 402L));
        }
    }

    @Test
    public void testOrdering() {
        StreamsBuilder builder = new StreamsBuilder();
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(100L)), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            inputTopic1.pipeInput((Object)0, (Object)"A0", 0L);
            inputTopic1.pipeInput((Object)1, (Object)"A1", 100L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic2.pipeInput((Object)1, (Object)11L, 110L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "A0+null", 0L), new KeyValueTimestamp<Integer, String>(1, "A1+11", 110L));
        }
    }

    @Test
    public void testGracePeriod() {
        StreamsBuilder builder = new StreamsBuilder();
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(100L), (Duration)Duration.ofMillis(10L)), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        Collection copartitionGroups = TopologyWrapper.getInternalTopologyBuilder(builder.build()).copartitionGroups();
        Assertions.assertEquals((int)1, (int)copartitionGroups.size());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("topic1", "topic2")), copartitionGroups.iterator().next());
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            inputTopic1.pipeInput((Object)0, (Object)"A0", 0L);
            inputTopic2.pipeInput((Object)1, (Object)11L, 0L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic1.pipeInput((Object)1, (Object)"A1", 101L);
            inputTopic2.pipeInput((Object)0, (Object)10L, 101L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic2.pipeInput((Object)0, (Object)100L, 112L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(1, "null+11", 0L), new KeyValueTimestamp<Integer, String>(0, "A0+null", 0L));
        }
    }

    @Test
    public void testEmitAllNonJoinedResultsForAsymmetricWindow() {
        StreamsBuilder builder = new StreamsBuilder();
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(5L)).after(Duration.ofMillis(20L)), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        Collection copartitionGroups = TopologyWrapper.getInternalTopologyBuilder(builder.build()).copartitionGroups();
        Assertions.assertEquals((int)1, (int)copartitionGroups.size());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("topic1", "topic2")), copartitionGroups.iterator().next());
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            inputTopic1.pipeInput((Object)0, (Object)"A0", 29L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic1.pipeInput((Object)1, (Object)"A1", 30L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic2.pipeInput((Object)2, (Object)12L, 31L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic2.pipeInput((Object)3, (Object)13L, 36L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic2.pipeInput((Object)4, (Object)14L, 37L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "null+12", 31L));
            inputTopic2.pipeInput((Object)5, (Object)15L, 50L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "A0+null", 29L), new KeyValueTimestamp<Integer, String>(3, "null+13", 36L), new KeyValueTimestamp<Integer, String>(4, "null+14", 37L));
        }
    }

    @Test
    public void testOuterJoinWithInMemoryCustomSuppliers() {
        JoinWindows joinWindows = JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(100L));
        WindowBytesStoreSupplier thisStoreSupplier = Stores.inMemoryWindowStore((String)"in-memory-join-store", (Duration)Duration.ofMillis(joinWindows.size() + joinWindows.gracePeriodMs()), (Duration)Duration.ofMillis(joinWindows.size()), (boolean)true);
        WindowBytesStoreSupplier otherStoreSupplier = Stores.inMemoryWindowStore((String)"in-memory-join-store-other", (Duration)Duration.ofMillis(joinWindows.size() + joinWindows.gracePeriodMs()), (Duration)Duration.ofMillis(joinWindows.size()), (boolean)true);
        StreamJoined streamJoined = StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long());
        this.runOuterJoin((StreamJoined<Integer, String, Long>)streamJoined.withThisStoreSupplier(thisStoreSupplier).withOtherStoreSupplier(otherStoreSupplier), joinWindows);
    }

    @Test
    public void testOuterJoinWithDefaultSuppliers() {
        JoinWindows joinWindows = JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(100L));
        StreamJoined streamJoined = StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long());
        this.runOuterJoin((StreamJoined<Integer, String, Long>)streamJoined, joinWindows);
    }

    public void runOuterJoin(StreamJoined<Integer, String, Long> streamJoined, JoinWindows joinWindows) {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, joinWindows, streamJoined);
        joined.process(supplier, new String[0]);
        Collection copartitionGroups = TopologyWrapper.getInternalTopologyBuilder(builder.build()).copartitionGroups();
        Assertions.assertEquals((int)1, (int)copartitionGroups.size());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("topic1", "topic2")), copartitionGroups.iterator().next());
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            int i;
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            Assertions.assertEquals((int)3, (int)driver.getAllStateStores().size());
            for (i = 0; i < 2; ++i) {
                inputTopic1.pipeInput((Object)expectedKeys[i], (Object)("A" + expectedKeys[i]));
            }
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            for (i = 0; i < 2; ++i) {
                inputTopic2.pipeInput((Object)expectedKeys[i], (Object)((long)expectedKeys[i] + 10L));
            }
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "A0+10", 0L), new KeyValueTimestamp<Integer, String>(1, "A1+11", 0L));
            for (i = 0; i < 3; ++i) {
                inputTopic1.pipeInput((Object)expectedKeys[i], (Object)("B" + expectedKeys[i]));
            }
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "B0+10", 0L), new KeyValueTimestamp<Integer, String>(1, "B1+11", 0L));
            for (int expectedKey : expectedKeys) {
                inputTopic2.pipeInput((Object)expectedKey, (Object)((long)expectedKey + 20L));
            }
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "A0+20", 0L), new KeyValueTimestamp<Integer, String>(0, "B0+20", 0L), new KeyValueTimestamp<Integer, String>(1, "A1+21", 0L), new KeyValueTimestamp<Integer, String>(1, "B1+21", 0L), new KeyValueTimestamp<Integer, String>(2, "B2+22", 0L));
            for (int expectedKey : expectedKeys) {
                inputTopic1.pipeInput((Object)expectedKey, (Object)("C" + expectedKey));
            }
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "C0+10", 0L), new KeyValueTimestamp<Integer, String>(0, "C0+20", 0L), new KeyValueTimestamp<Integer, String>(1, "C1+11", 0L), new KeyValueTimestamp<Integer, String>(1, "C1+21", 0L), new KeyValueTimestamp<Integer, String>(2, "C2+22", 0L), new KeyValueTimestamp<Integer, String>(3, "C3+23", 0L));
            inputTopic1.pipeInput((Object)0, (Object)"dummy", 400L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
        }
    }

    @Test
    public void testWindowing() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(100L)), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        Collection copartitionGroups = TopologyWrapper.getInternalTopologyBuilder(builder.build()).copartitionGroups();
        Assertions.assertEquals((int)1, (int)copartitionGroups.size());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("topic1", "topic2")), copartitionGroups.iterator().next());
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor<Integer, String, Void, Void> processor = supplier.theCapturedProcessor();
            long time = 0L;
            for (int i = 0; i < 2; ++i) {
                inputTopic1.pipeInput((Object)expectedKeys[i], (Object)("A" + expectedKeys[i]), 0L);
            }
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            for (int expectedKey : expectedKeys) {
                inputTopic2.pipeInput((Object)expectedKey, (Object)((long)expectedKey + 10L), 0L);
            }
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "A0+10", 0L), new KeyValueTimestamp<Integer, String>(1, "A1+11", 0L));
            this.testUpperWindowBound(expectedKeys, driver, processor);
            this.testLowerWindowBound(expectedKeys, driver, processor);
        }
    }

    @Test
    public void testShouldNotEmitLeftJoinResultForAsymmetricBeforeWindow() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(100L)).before(Duration.ZERO), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            long time = 0L;
            for (int i = 0; i < 2; ++i) {
                inputTopic1.pipeInput((Object)expectedKeys[i], (Object)("A" + expectedKeys[i]), time + (long)i);
            }
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic2.pipeInput((Object)expectedKeys[0], (Object)((long)expectedKeys[0] + 10L), time += 100L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "A0+10", 100L));
            inputTopic2.pipeInput((Object)expectedKeys[1], (Object)((long)expectedKeys[1] + 10L), time += 2L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(1, "A1+null", 1L));
            inputTopic2.pipeInput((Object)expectedKeys[2], (Object)((long)expectedKeys[2] + 10L), ++time);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(1, "null+11", 102L));
            inputTopic1.pipeInput((Object)expectedKeys[2], (Object)("A" + expectedKeys[2]), time);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "A2+12", 103L));
        }
    }

    @Test
    public void testShouldNotEmitLeftJoinResultForAsymmetricAfterWindow() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(100L)).after(Duration.ZERO), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            long time = 0L;
            for (int i = 0; i < 2; ++i) {
                inputTopic1.pipeInput((Object)expectedKeys[i], (Object)("A" + expectedKeys[i]), time + (long)i);
            }
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "A0+null", 0L));
            inputTopic2.pipeInput((Object)expectedKeys[1], (Object)((long)expectedKeys[1] + 10L), ++time);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(1, "A1+11", 1L));
            inputTopic2.pipeInput((Object)expectedKeys[2], (Object)((long)expectedKeys[2] + 10L), time += 100L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic2.pipeInput((Object)expectedKeys[3], (Object)((long)expectedKeys[3] + 10L), time);
            processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
            inputTopic1.pipeInput((Object)expectedKeys[2], (Object)("A" + expectedKeys[2]), time += 100L);
            processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "A2+12", 201L));
        }
    }

    @Test
    public void testShouldForwardCurrentHeaders() {
        StreamsBuilder builder = new StreamsBuilder();
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed2);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(100L), (Duration)Duration.ofMillis(10L)), StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.Long()));
        joined.process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), PROPS);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor processor = supplier.theCapturedProcessor();
            inputTopic1.pipeInput(new TestRecord((Object)0, (Object)"A0", (Headers)new RecordHeaders(new Header[]{new RecordHeader("h", new byte[]{1})}), Long.valueOf(0L)));
            inputTopic2.pipeInput(new TestRecord((Object)1, (Object)10L, (Headers)new RecordHeaders(new Header[]{new RecordHeader("h", new byte[]{2})}), Long.valueOf(0L)));
            inputTopic2.pipeInput(new TestRecord((Object)3, (Object)100L, (Headers)new RecordHeaders(new Header[]{new RecordHeader("h", new byte[]{3})}), Long.valueOf(211L)));
            processor.checkAndClearProcessedRecords(new Record((Object)1, (Object)"null+10", 0L, (Headers)new RecordHeaders(new Header[]{new RecordHeader("h", new byte[]{3})})), new Record((Object)0, (Object)"A0+null", 0L, (Headers)new RecordHeaders(new Header[]{new RecordHeader("h", new byte[]{3})})));
            inputTopic1.pipeInput(new TestRecord((Object)2, (Object)"A2", (Headers)new RecordHeaders(new Header[]{new RecordHeader("h", new byte[]{4})}), Long.valueOf(200L)));
            inputTopic2.pipeInput(new TestRecord((Object)2, (Object)12L, (Headers)new RecordHeaders(new Header[]{new RecordHeader("h", new byte[]{5})}), Long.valueOf(200L)));
            processor.checkAndClearProcessedRecords(new Record((Object)2, (Object)"A2+12", 200L, (Headers)new RecordHeaders(new Header[]{new RecordHeader("h", new byte[]{5})})));
        }
    }

    private void testUpperWindowBound(int[] expectedKeys, TopologyTestDriver driver, MockApiProcessor<Integer, String, Void, Void> processor) {
        TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
        TestInputTopic inputTopic2 = driver.createInputTopic("topic2", (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
        long time = 1000L;
        for (int i = 0; i < expectedKeys.length; ++i) {
            inputTopic2.pipeInput((Object)expectedKeys[i], (Object)((long)expectedKeys[i] + 20L), time + (long)i);
        }
        processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "null+12", 0L), new KeyValueTimestamp<Integer, String>(3, "null+13", 0L));
        time = 1100L;
        for (int expectedKey : expectedKeys) {
            inputTopic1.pipeInput((Object)expectedKey, (Object)("B" + expectedKey), time);
        }
        processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "B0+20", 1100L), new KeyValueTimestamp<Integer, String>(1, "B1+21", 1100L), new KeyValueTimestamp<Integer, String>(2, "B2+22", 1100L), new KeyValueTimestamp<Integer, String>(3, "B3+23", 1100L));
        ++time;
        for (int expectedKey : expectedKeys) {
            inputTopic1.pipeInput((Object)expectedKey, (Object)("C" + expectedKey), time);
        }
        processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(1, "C1+21", 1101L), new KeyValueTimestamp<Integer, String>(2, "C2+22", 1101L), new KeyValueTimestamp<Integer, String>(3, "C3+23", 1101L));
        ++time;
        for (int expectedKey : expectedKeys) {
            inputTopic1.pipeInput((Object)expectedKey, (Object)("D" + expectedKey), time);
        }
        processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "D2+22", 1102L), new KeyValueTimestamp<Integer, String>(3, "D3+23", 1102L));
        ++time;
        for (int expectedKey : expectedKeys) {
            inputTopic1.pipeInput((Object)expectedKey, (Object)("E" + expectedKey), time);
        }
        processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(3, "E3+23", 1103L));
        ++time;
        for (int expectedKey : expectedKeys) {
            inputTopic1.pipeInput((Object)expectedKey, (Object)("F" + expectedKey), time);
        }
        processor.checkAndClearProcessResult(new KeyValueTimestamp[0]);
        inputTopic1.pipeInput((Object)0, (Object)"dummy", time += 301L);
        processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "C0+null", 1101L), new KeyValueTimestamp<Integer, String>(0, "D0+null", 1102L), new KeyValueTimestamp<Integer, String>(1, "D1+null", 1102L), new KeyValueTimestamp<Integer, String>(0, "E0+null", 1103L), new KeyValueTimestamp<Integer, String>(1, "E1+null", 1103L), new KeyValueTimestamp<Integer, String>(2, "E2+null", 1103L), new KeyValueTimestamp<Integer, String>(0, "F0+null", 1104L), new KeyValueTimestamp<Integer, String>(1, "F1+null", 1104L), new KeyValueTimestamp<Integer, String>(2, "F2+null", 1104L), new KeyValueTimestamp<Integer, String>(3, "F3+null", 1104L));
    }

    private void testLowerWindowBound(int[] expectedKeys, TopologyTestDriver driver, MockApiProcessor<Integer, String, Void, Void> processor) {
        TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
        long time = 899L;
        for (int expectedKey : expectedKeys) {
            inputTopic1.pipeInput((Object)expectedKey, (Object)("G" + expectedKey), time);
        }
        processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "G0+null", 899L), new KeyValueTimestamp<Integer, String>(1, "G1+null", 899L), new KeyValueTimestamp<Integer, String>(2, "G2+null", 899L), new KeyValueTimestamp<Integer, String>(3, "G3+null", 899L));
        ++time;
        for (int expectedKey : expectedKeys) {
            inputTopic1.pipeInput((Object)expectedKey, (Object)("H" + expectedKey), time);
        }
        processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "H0+20", 1000L), new KeyValueTimestamp<Integer, String>(1, "H1+null", 900L), new KeyValueTimestamp<Integer, String>(2, "H2+null", 900L), new KeyValueTimestamp<Integer, String>(3, "H3+null", 900L));
        ++time;
        for (int expectedKey : expectedKeys) {
            inputTopic1.pipeInput((Object)expectedKey, (Object)("I" + expectedKey), time);
        }
        processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "I0+20", 1000L), new KeyValueTimestamp<Integer, String>(1, "I1+21", 1001L), new KeyValueTimestamp<Integer, String>(2, "I2+null", 901L), new KeyValueTimestamp<Integer, String>(3, "I3+null", 901L));
        ++time;
        for (int expectedKey : expectedKeys) {
            inputTopic1.pipeInput((Object)expectedKey, (Object)("J" + expectedKey), time);
        }
        processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "J0+20", 1000L), new KeyValueTimestamp<Integer, String>(1, "J1+21", 1001L), new KeyValueTimestamp<Integer, String>(2, "J2+22", 1002L), new KeyValueTimestamp<Integer, String>(3, "J3+null", 902L));
        ++time;
        for (int expectedKey : expectedKeys) {
            inputTopic1.pipeInput((Object)expectedKey, (Object)("K" + expectedKey), time);
        }
        processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "K0+20", 1000L), new KeyValueTimestamp<Integer, String>(1, "K1+21", 1001L), new KeyValueTimestamp<Integer, String>(2, "K2+22", 1002L), new KeyValueTimestamp<Integer, String>(3, "K3+23", 1003L));
        inputTopic1.pipeInput((Object)0, (Object)"dummy", time + 200L);
        processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "dummy+null", 1103L));
    }

    @Test
    public void testShouldJoinWithNonTimestampedStore() {
        CapturingStoreSuppliers suppliers = new CapturingStoreSuppliers();
        StreamJoined streamJoined = StreamJoined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.String()).withDslStoreSuppliers((DslStoreSuppliers)suppliers);
        StreamsBuilder builder = new StreamsBuilder();
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream1 = builder.stream("topic1", this.consumed);
        KStream stream2 = builder.stream("topic2", this.consumed);
        KStream joined = stream1.outerJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(100L)), streamJoined);
        joined.process(supplier, new String[0]);
        try (TopologyTestDriver ignored = new TopologyTestDriver(builder.build(PROPS), PROPS);){
            MatcherAssert.assertThat((String)"Expected stream joined to supply builders that create non-timestamped stores", (!WrappedStateStore.isTimestamped((StateStore)suppliers.capture.get().get()) ? 1 : 0) != 0);
        }
    }

    public static class CapturingStoreSuppliers
    extends BuiltInDslStoreSuppliers.RocksDBDslStoreSuppliers {
        final AtomicReference<KeyValueBytesStoreSupplier> capture = new AtomicReference();

        public KeyValueBytesStoreSupplier keyValueStore(DslKeyValueParams params) {
            KeyValueBytesStoreSupplier result = super.keyValueStore(params);
            this.capture.set(result);
            return result;
        }
    }
}

