/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.internals.KStreamPrint;
import org.apache.kafka.streams.kstream.internals.PrintForeachAction;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class KStreamPrintTest {
    private ByteArrayOutputStream byteOutStream;
    private Processor<Integer, String, Void, Void> printProcessor;
    @Mock
    private ProcessorContext<Void, Void> processorContext;

    @BeforeEach
    public void setUp() {
        this.byteOutStream = new ByteArrayOutputStream();
        KStreamPrint kStreamPrint = new KStreamPrint((ForeachAction)new PrintForeachAction((OutputStream)this.byteOutStream, (key, value) -> String.format("%d, %s", key, value), "test-stream"));
        this.printProcessor = kStreamPrint.get();
        this.printProcessor.init(this.processorContext);
    }

    @Test
    public void testPrintStreamWithProvidedKeyValueMapper() {
        List<KeyValue> inputRecords = Arrays.asList(new KeyValue((Object)0, (Object)"zero"), new KeyValue((Object)1, (Object)"one"), new KeyValue((Object)2, (Object)"two"), new KeyValue((Object)3, (Object)"three"));
        String[] expectedResult = new String[]{"[test-stream]: 0, zero", "[test-stream]: 1, one", "[test-stream]: 2, two", "[test-stream]: 3, three"};
        for (KeyValue record : inputRecords) {
            Record r = new Record((Object)((Integer)record.key), (Object)((String)record.value), 0L);
            this.printProcessor.process(r);
        }
        this.printProcessor.close();
        String[] flushOutDatas = new String(this.byteOutStream.toByteArray(), StandardCharsets.UTF_8).split("\\r*\\n");
        for (int i = 0; i < flushOutDatas.length; ++i) {
            Assertions.assertEquals((Object)expectedResult[i], (Object)flushOutDatas[i]);
        }
    }
}

