/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Repartitioned;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.test.TestRecord;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class KStreamRepartitionTest {
    private final String inputTopic = "input-topic";
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());
    private StreamsBuilder builder;

    @BeforeEach
    public void setUp() {
        this.builder = new StreamsBuilder();
    }

    @Test
    public void shouldInvokePartitionerWhenSet() {
        int[] expectedKeys = new int[]{0, 1};
        StreamPartitioner streamPartitionerMock = (StreamPartitioner)Mockito.mock(StreamPartitioner.class);
        Mockito.when((Object)streamPartitionerMock.partitions(ArgumentMatchers.anyString(), (Object)ArgumentMatchers.eq((int)0), (Object)((String)ArgumentMatchers.eq((Object)"X0")), ArgumentMatchers.anyInt())).thenReturn(Optional.of(Collections.singleton(1)));
        Mockito.when((Object)streamPartitionerMock.partitions(ArgumentMatchers.anyString(), (Object)ArgumentMatchers.eq((int)1), (Object)((String)ArgumentMatchers.eq((Object)"X1")), ArgumentMatchers.anyInt())).thenReturn(Optional.of(Collections.singleton(1)));
        String repartitionOperationName = "test";
        Repartitioned repartitioned = Repartitioned.streamPartitioner((StreamPartitioner)streamPartitionerMock).withName("test");
        this.builder.stream("input-topic").repartition(repartitioned);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic testInputTopic = driver.createInputTopic("input-topic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
            String topicName = this.repartitionOutputTopic(this.props, "test");
            TestOutputTopic testOutputTopic = driver.createOutputTopic(topicName, (Deserializer)new IntegerDeserializer(), (Deserializer)new StringDeserializer());
            for (int i = 0; i < 2; ++i) {
                testInputTopic.pipeInput((Object)expectedKeys[i], (Object)("X" + expectedKeys[i]), (long)(i + 10));
            }
            MatcherAssert.assertThat((Object)testOutputTopic.readRecord(), (Matcher)CoreMatchers.equalTo((Object)new TestRecord((Object)0, (Object)"X0", Instant.ofEpochMilli(10L))));
            MatcherAssert.assertThat((Object)testOutputTopic.readRecord(), (Matcher)CoreMatchers.equalTo((Object)new TestRecord((Object)1, (Object)"X1", Instant.ofEpochMilli(11L))));
            Assertions.assertTrue((boolean)testOutputTopic.readRecordsToList().isEmpty());
        }
        ((StreamPartitioner)Mockito.verify((Object)streamPartitionerMock)).partitions(ArgumentMatchers.anyString(), (Object)ArgumentMatchers.eq((int)0), (Object)((String)ArgumentMatchers.eq((Object)"X0")), ArgumentMatchers.anyInt());
        ((StreamPartitioner)Mockito.verify((Object)streamPartitionerMock)).partitions(ArgumentMatchers.anyString(), (Object)ArgumentMatchers.eq((int)1), (Object)((String)ArgumentMatchers.eq((Object)"X1")), ArgumentMatchers.anyInt());
    }

    @Test
    public void shouldThrowAnExceptionWhenNumberOfPartitionsOfRepartitionOperationsDoNotMatchWhenJoining() {
        String topicB = "topic-b";
        String outputTopic = "topic-output";
        String topicBRepartitionedName = "topic-b-scale-up";
        String inputTopicRepartitionedName = "input-topic-scale-up";
        int topicBNumberOfPartitions = 2;
        int inputTopicNumberOfPartitions = 4;
        StreamsBuilder builder = new StreamsBuilder();
        Repartitioned inputTopicRepartitioned = Repartitioned.as((String)"input-topic-scale-up").withNumberOfPartitions(4);
        Repartitioned topicBRepartitioned = Repartitioned.as((String)"topic-b-scale-up").withNumberOfPartitions(2);
        KStream topicBStream = builder.stream("topic-b", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).repartition(topicBRepartitioned);
        builder.stream("input-topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).repartition(inputTopicRepartitioned).join(topicBStream, (value1, value2) -> value2, JoinWindows.of((Duration)Duration.ofSeconds(10L))).to("topic-output");
        Map repartitionTopicsWithNumOfPartitions = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.toRepartitionTopicName("topic-b-scale-up"), (Object)2), Utils.mkEntry((Object)this.toRepartitionTopicName("input-topic-scale-up"), (Object)4)});
        TopologyException expected = (TopologyException)Assertions.assertThrows(TopologyException.class, () -> builder.build(this.props));
        String expectedErrorMessage = String.format("Following topics do not have the same number of partitions: [%s]", new TreeMap(repartitionTopicsWithNumOfPartitions));
        Assertions.assertNotNull((Object)((Object)expected));
        Assertions.assertTrue((boolean)expected.getMessage().contains(expectedErrorMessage));
    }

    private String toRepartitionTopicName(String input) {
        return input + "-repartition";
    }

    private String repartitionOutputTopic(Properties props, String repartitionOperationName) {
        return props.getProperty("application.id") + "-" + repartitionOperationName + "-repartition";
    }
}

