/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyDescription;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.TopologyTestDriverWrapper;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.ChangedDeserializer;
import org.apache.kafka.streams.kstream.internals.ChangedSerializer;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.SinkNode;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockMapper;
import org.apache.kafka.test.MockReducer;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class KTableImplTest {
    private final Consumed<String, String> stringConsumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
    private final Consumed<String, String> consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
    private final Produced<String, String> produced = Produced.with((Serde)Serdes.String(), (Serde)Serdes.String());
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());
    private final Serde<String> mySerde = new Serdes.StringSerde();
    private KTable<String, String> table;

    @BeforeEach
    public void setUp() {
        this.table = new StreamsBuilder().table("test");
    }

    @Test
    public void testKTable() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        String topic2 = "topic2";
        KTable table1 = builder.table("topic1", this.consumed);
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        table1.toStream().process(supplier, new String[0]);
        KTable table2 = table1.mapValues(s -> Integer.valueOf(s));
        table2.toStream().process(supplier, new String[0]);
        KTable table3 = table2.filter((key, value) -> value % 2 == 0);
        table3.toStream().process(supplier, new String[0]);
        table1.toStream().to("topic2", this.produced);
        KTable table4 = builder.table("topic2", this.consumed);
        table4.toStream().process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic1", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            inputTopic.pipeInput((Object)"A", (Object)"01", 5L);
            inputTopic.pipeInput((Object)"B", (Object)"02", 100L);
            inputTopic.pipeInput((Object)"C", (Object)"03", 0L);
            inputTopic.pipeInput((Object)"D", (Object)"04", 0L);
            inputTopic.pipeInput((Object)"A", (Object)"05", 10L);
            inputTopic.pipeInput((Object)"A", (Object)"06", 8L);
        }
        List processors = supplier.capturedProcessors(4);
        Assertions.assertEquals(Arrays.asList(new KeyValueTimestamp<String, String>("A", "01", 5L), new KeyValueTimestamp<String, String>("B", "02", 100L), new KeyValueTimestamp<String, String>("C", "03", 0L), new KeyValueTimestamp<String, String>("D", "04", 0L), new KeyValueTimestamp<String, String>("A", "05", 10L), new KeyValueTimestamp<String, String>("A", "06", 8L)), processors.get(0).processed());
        Assertions.assertEquals(Arrays.asList(new KeyValueTimestamp<String, Integer>("A", 1, 5L), new KeyValueTimestamp<String, Integer>("B", 2, 100L), new KeyValueTimestamp<String, Integer>("C", 3, 0L), new KeyValueTimestamp<String, Integer>("D", 4, 0L), new KeyValueTimestamp<String, Integer>("A", 5, 10L), new KeyValueTimestamp<String, Integer>("A", 6, 8L)), processors.get(1).processed());
        Assertions.assertEquals(Arrays.asList(new KeyValueTimestamp<String, Object>("A", null, 5L), new KeyValueTimestamp<String, Integer>("B", 2, 100L), new KeyValueTimestamp<String, Object>("C", null, 0L), new KeyValueTimestamp<String, Integer>("D", 4, 0L), new KeyValueTimestamp<String, Object>("A", null, 10L), new KeyValueTimestamp<String, Integer>("A", 6, 8L)), processors.get(2).processed());
        Assertions.assertEquals(Arrays.asList(new KeyValueTimestamp<String, String>("A", "01", 5L), new KeyValueTimestamp<String, String>("B", "02", 100L), new KeyValueTimestamp<String, String>("C", "03", 0L), new KeyValueTimestamp<String, String>("D", "04", 0L), new KeyValueTimestamp<String, String>("A", "05", 10L), new KeyValueTimestamp<String, String>("A", "06", 8L)), processors.get(3).processed());
    }

    @Test
    public void testMaterializedKTable() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        String topic2 = "topic2";
        KTable table1 = builder.table("topic1", this.consumed, Materialized.as((String)"fred"));
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        table1.toStream().process(supplier, new String[0]);
        KTable table2 = table1.mapValues(s -> Integer.valueOf(s));
        table2.toStream().process(supplier, new String[0]);
        KTable table3 = table2.filter((key, value) -> value % 2 == 0);
        table3.toStream().process(supplier, new String[0]);
        table1.toStream().to("topic2", this.produced);
        KTable table4 = builder.table("topic2", this.consumed);
        table4.toStream().process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic1", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            inputTopic.pipeInput((Object)"A", (Object)"01", 5L);
            inputTopic.pipeInput((Object)"B", (Object)"02", 100L);
            inputTopic.pipeInput((Object)"C", (Object)"03", 0L);
            inputTopic.pipeInput((Object)"D", (Object)"04", 0L);
            inputTopic.pipeInput((Object)"A", (Object)"05", 10L);
            inputTopic.pipeInput((Object)"A", (Object)"06", 8L);
        }
        List processors = supplier.capturedProcessors(4);
        Assertions.assertEquals(Arrays.asList(new KeyValueTimestamp<String, String>("A", "01", 5L), new KeyValueTimestamp<String, String>("B", "02", 100L), new KeyValueTimestamp<String, String>("C", "03", 0L), new KeyValueTimestamp<String, String>("D", "04", 0L), new KeyValueTimestamp<String, String>("A", "05", 10L), new KeyValueTimestamp<String, String>("A", "06", 8L)), processors.get(0).processed());
        Assertions.assertEquals(Arrays.asList(new KeyValueTimestamp<String, Integer>("A", 1, 5L), new KeyValueTimestamp<String, Integer>("B", 2, 100L), new KeyValueTimestamp<String, Integer>("C", 3, 0L), new KeyValueTimestamp<String, Integer>("D", 4, 0L), new KeyValueTimestamp<String, Integer>("A", 5, 10L), new KeyValueTimestamp<String, Integer>("A", 6, 8L)), processors.get(1).processed());
        Assertions.assertEquals(Arrays.asList(new KeyValueTimestamp<String, Integer>("B", 2, 100L), new KeyValueTimestamp<String, Integer>("D", 4, 0L), new KeyValueTimestamp<String, Integer>("A", 6, 8L)), processors.get(2).processed());
        Assertions.assertEquals(Arrays.asList(new KeyValueTimestamp<String, String>("A", "01", 5L), new KeyValueTimestamp<String, String>("B", "02", 100L), new KeyValueTimestamp<String, String>("C", "03", 0L), new KeyValueTimestamp<String, String>("D", "04", 0L), new KeyValueTimestamp<String, String>("A", "05", 10L), new KeyValueTimestamp<String, String>("A", "06", 8L)), processors.get(3).processed());
    }

    @Test
    public void shouldPreserveSerdesForOperators() {
        StreamsBuilder builder = new StreamsBuilder();
        KTable table1 = builder.table("topic-2", this.stringConsumed);
        ConsumedInternal consumedInternal = new ConsumedInternal(this.stringConsumed);
        KeyValueMapper selector = (key, value) -> key;
        ValueMapper mapper = value -> value;
        ValueJoiner joiner = (value1, value2) -> value1;
        ValueTransformerWithKeySupplier valueTransformerWithKeySupplier = () -> new ValueTransformerWithKey<String, String, String>(){

            public void init(ProcessorContext context) {
            }

            public String transform(String key, String value) {
                return value;
            }

            public void close() {
            }
        };
        Assertions.assertEquals((Object)((AbstractStream)table1.filter((key, value) -> false)).keySerde(), (Object)consumedInternal.keySerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.filter((key, value) -> false)).valueSerde(), (Object)consumedInternal.valueSerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.filter((key, value) -> false, Materialized.with(this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.filter((key, value) -> false, Materialized.with(this.mySerde, this.mySerde))).valueSerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.filterNot((key, value) -> false)).keySerde(), (Object)consumedInternal.keySerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.filterNot((key, value) -> false)).valueSerde(), (Object)consumedInternal.valueSerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.filterNot((key, value) -> false, Materialized.with(this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.filterNot((key, value) -> false, Materialized.with(this.mySerde, this.mySerde))).valueSerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.mapValues(mapper)).keySerde(), (Object)consumedInternal.keySerde());
        Assertions.assertNull((Object)((AbstractStream)table1.mapValues(mapper)).valueSerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.mapValues(mapper, Materialized.with(this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.mapValues(mapper, Materialized.with(this.mySerde, this.mySerde))).valueSerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.toStream()).keySerde(), (Object)consumedInternal.keySerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.toStream()).valueSerde(), (Object)consumedInternal.valueSerde());
        Assertions.assertNull((Object)((AbstractStream)table1.toStream(selector)).keySerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.toStream(selector)).valueSerde(), (Object)consumedInternal.valueSerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.transformValues(valueTransformerWithKeySupplier, new String[0])).keySerde(), (Object)consumedInternal.keySerde());
        Assertions.assertNull((Object)((AbstractStream)table1.transformValues(valueTransformerWithKeySupplier, new String[0])).valueSerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.transformValues(valueTransformerWithKeySupplier, Materialized.with(this.mySerde, this.mySerde), new String[0])).keySerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.transformValues(valueTransformerWithKeySupplier, Materialized.with(this.mySerde, this.mySerde), new String[0])).valueSerde(), this.mySerde);
        Assertions.assertNull((Object)((AbstractStream)table1.groupBy(KeyValue::new)).keySerde());
        Assertions.assertNull((Object)((AbstractStream)table1.groupBy(KeyValue::new)).valueSerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.groupBy(KeyValue::new, Grouped.with(this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.groupBy(KeyValue::new, Grouped.with(this.mySerde, this.mySerde))).valueSerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.join(table1, joiner)).keySerde(), (Object)consumedInternal.keySerde());
        Assertions.assertNull((Object)((AbstractStream)table1.join(table1, joiner)).valueSerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.join(table1, joiner, Materialized.with(this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.join(table1, joiner, Materialized.with(this.mySerde, this.mySerde))).valueSerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.leftJoin(table1, joiner)).keySerde(), (Object)consumedInternal.keySerde());
        Assertions.assertNull((Object)((AbstractStream)table1.leftJoin(table1, joiner)).valueSerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.leftJoin(table1, joiner, Materialized.with(this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.leftJoin(table1, joiner, Materialized.with(this.mySerde, this.mySerde))).valueSerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.outerJoin(table1, joiner)).keySerde(), (Object)consumedInternal.keySerde());
        Assertions.assertNull((Object)((AbstractStream)table1.outerJoin(table1, joiner)).valueSerde());
        Assertions.assertEquals((Object)((AbstractStream)table1.outerJoin(table1, joiner, Materialized.with(this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assertions.assertEquals((Object)((AbstractStream)table1.outerJoin(table1, joiner, Materialized.with(this.mySerde, this.mySerde))).valueSerde(), this.mySerde);
    }

    @Test
    public void testStateStoreLazyEval() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        String topic2 = "topic2";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        builder.table("topic2", this.consumed);
        KTableImpl table1Mapped = (KTableImpl)table1.mapValues(s -> Integer.valueOf(s));
        table1Mapped.filter((key, value) -> value % 2 == 0);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            Assertions.assertEquals((int)0, (int)driver.getAllStateStores().size());
        }
    }

    @Test
    public void testStateStore() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        String topic2 = "topic2";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)builder.table("topic2", this.consumed);
        KTableImpl table1Mapped = (KTableImpl)table1.mapValues(s -> Integer.valueOf(s));
        KTableImpl table1MappedFiltered = (KTableImpl)table1Mapped.filter((key, value) -> value % 2 == 0);
        table2.join((KTable)table1MappedFiltered, (v1, v2) -> v1 + v2);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            Assertions.assertEquals((int)2, (int)driver.getAllStateStores().size());
        }
    }

    @Test
    public void shouldNotEnableSendingOldValuesIfNotMaterializedAlreadyAndNotForcedToMaterialize() {
        StreamsBuilder builder = new StreamsBuilder();
        KTableImpl table = (KTableImpl)builder.table("topic1", this.consumed);
        table.enableSendingOldValues(false);
        MatcherAssert.assertThat((Object)table.sendingOldValueEnabled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldEnableSendingOldValuesIfNotMaterializedAlreadyButForcedToMaterialize() {
        StreamsBuilder builder = new StreamsBuilder();
        KTableImpl table = (KTableImpl)builder.table("topic1", this.consumed);
        table.enableSendingOldValues(true);
        MatcherAssert.assertThat((Object)table.sendingOldValueEnabled(), (Matcher)Matchers.is((Object)true));
    }

    private void assertTopologyContainsProcessor(Topology topology, String processorName) {
        for (TopologyDescription.Subtopology subtopology : topology.describe().subtopologies()) {
            for (TopologyDescription.Node node : subtopology.nodes()) {
                if (!node.name().equals(processorName)) continue;
                return;
            }
        }
        throw new AssertionError((Object)("No processor named '" + processorName + "'found in the provided Topology:\n" + String.valueOf(topology.describe())));
    }

    @Test
    public void shouldCreateSourceAndSinkNodesForRepartitioningTopic() throws Exception {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        String storeName1 = "storeName1";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed, Materialized.as((String)"storeName1").withKeySerde(Serdes.String()).withValueSerde(Serdes.String()));
        table1.groupBy(MockMapper.noOpKeyValueMapper()).aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)"mock-result1"));
        table1.groupBy(MockMapper.noOpKeyValueMapper()).reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, Materialized.as((String)"mock-result2"));
        Topology topology = builder.build();
        try (TopologyTestDriverWrapper driver = new TopologyTestDriverWrapper(topology, this.props);){
            Assertions.assertEquals((int)3, (int)driver.getAllStateStores().size());
            this.assertTopologyContainsProcessor(topology, "KSTREAM-SINK-0000000003");
            this.assertTopologyContainsProcessor(topology, "KSTREAM-SOURCE-0000000004");
            this.assertTopologyContainsProcessor(topology, "KSTREAM-SINK-0000000007");
            this.assertTopologyContainsProcessor(topology, "KSTREAM-SOURCE-0000000008");
            Field valSerializerField = ((SinkNode)driver.getProcessor("KSTREAM-SINK-0000000003")).getClass().getDeclaredField("valSerializer");
            Field valDeserializerField = ((SourceNode)driver.getProcessor("KSTREAM-SOURCE-0000000004")).getClass().getDeclaredField("valDeserializer");
            valSerializerField.setAccessible(true);
            valDeserializerField.setAccessible(true);
            Assertions.assertNotNull((Object)((ChangedSerializer)valSerializerField.get(driver.getProcessor("KSTREAM-SINK-0000000003"))).inner());
            Assertions.assertNotNull((Object)((ChangedDeserializer)valDeserializerField.get(driver.getProcessor("KSTREAM-SOURCE-0000000004"))).inner());
            Assertions.assertNotNull((Object)((ChangedSerializer)valSerializerField.get(driver.getProcessor("KSTREAM-SINK-0000000007"))).inner());
            Assertions.assertNotNull((Object)((ChangedDeserializer)valDeserializerField.get(driver.getProcessor("KSTREAM-SOURCE-0000000008"))).inner());
        }
    }

    @Test
    public void shouldNotAllowNullSelectorOnToStream() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.toStream((KeyValueMapper)null));
    }

    @Test
    public void shouldNotAllowNullPredicateOnFilter() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.filter(null));
    }

    @Test
    public void shouldNotAllowNullPredicateOnFilterNot() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.filterNot(null));
    }

    @Test
    public void shouldNotAllowNullMapperOnMapValues() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.mapValues((ValueMapper)null));
    }

    @Test
    public void shouldNotAllowNullMapperOnMapValueWithKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.mapValues((ValueMapperWithKey)null));
    }

    @Test
    public void shouldNotAllowNullSelectorOnGroupBy() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.groupBy(null));
    }

    @Test
    public void shouldNotAllowNullOtherTableOnJoin() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.join(null, MockValueJoiner.TOSTRING_JOINER));
    }

    @Test
    public void shouldAllowNullStoreInJoin() {
        this.table.join(this.table, MockValueJoiner.TOSTRING_JOINER);
    }

    @Test
    public void shouldNotAllowNullJoinerJoin() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.join(this.table, null));
    }

    @Test
    public void shouldNotAllowNullOtherTableOnOuterJoin() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.outerJoin(null, MockValueJoiner.TOSTRING_JOINER));
    }

    @Test
    public void shouldNotAllowNullJoinerOnOuterJoin() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.outerJoin(this.table, null));
    }

    @Test
    public void shouldNotAllowNullJoinerOnLeftJoin() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.leftJoin(this.table, null));
    }

    @Test
    public void shouldNotAllowNullOtherTableOnLeftJoin() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.leftJoin(null, MockValueJoiner.TOSTRING_JOINER));
    }

    @Test
    public void shouldThrowNullPointerOnFilterWhenMaterializedIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.filter((key, value) -> false, (Materialized)null));
    }

    @Test
    public void shouldThrowNullPointerOnFilterNotWhenMaterializedIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.filterNot((key, value) -> false, (Materialized)null));
    }

    @Test
    public void shouldThrowNullPointerOnJoinWhenMaterializedIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.join(this.table, MockValueJoiner.TOSTRING_JOINER, (Materialized)null));
    }

    @Test
    public void shouldThrowNullPointerOnLeftJoinWhenMaterializedIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.leftJoin(this.table, MockValueJoiner.TOSTRING_JOINER, (Materialized)null));
    }

    @Test
    public void shouldThrowNullPointerOnOuterJoinWhenMaterializedIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.outerJoin(this.table, MockValueJoiner.TOSTRING_JOINER, (Materialized)null));
    }

    @Test
    public void shouldThrowNullPointerOnTransformValuesWithKeyWhenTransformerSupplierIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.table.transformValues(null, new String[0]));
    }

    @Test
    public void shouldThrowNullPointerOnTransformValuesWithKeyWhenMaterializedIsNull() {
        ValueTransformerWithKeySupplier valueTransformerSupplier = (ValueTransformerWithKeySupplier)Mockito.mock(ValueTransformerWithKeySupplier.class);
        Assertions.assertThrows(NullPointerException.class, () -> this.table.transformValues(valueTransformerSupplier, (Materialized)null, new String[0]));
    }

    @Test
    public void shouldThrowNullPointerOnTransformValuesWithKeyWhenStoreNamesNull() {
        ValueTransformerWithKeySupplier valueTransformerSupplier = (ValueTransformerWithKeySupplier)Mockito.mock(ValueTransformerWithKeySupplier.class);
        Assertions.assertThrows(NullPointerException.class, () -> this.table.transformValues(valueTransformerSupplier, (String[])null));
    }
}

