/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.utils.UniqueTopicSerdeScope;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class KTableKTableForeignKeyJoinScenarioTest {
    private static final String LEFT_TABLE = "left_table";
    private static final String RIGHT_TABLE = "right_table";
    private static final String OUTPUT = "output-topic";

    @Test
    public void shouldWorkWithDefaultSerdes() {
        StreamsBuilder builder = new StreamsBuilder();
        KTable aTable = builder.table("A");
        KTable bTable = builder.table("B");
        KTable fkJoinResult = aTable.join(bTable, value -> Integer.parseInt(value.split("-")[0]), (aVal, bVal) -> "(" + aVal + "," + bVal + ")", Materialized.as((String)"asdf"));
        KTable finalJoinResult = aTable.join(fkJoinResult, (aVal, fkJoinVal) -> "(" + aVal + "," + fkJoinVal + ")");
        finalJoinResult.toStream().to("output");
        this.validateTopologyCanProcessData(builder);
    }

    @Test
    public void shouldWorkWithDefaultAndConsumedSerdes() {
        StreamsBuilder builder = new StreamsBuilder();
        KTable aTable = builder.table("A", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        KTable bTable = builder.table("B");
        KTable fkJoinResult = aTable.join(bTable, value -> Integer.parseInt(value.split("-")[0]), (aVal, bVal) -> "(" + aVal + "," + bVal + ")", Materialized.as((String)"asdf"));
        KTable finalJoinResult = aTable.join(fkJoinResult, (aVal, fkJoinVal) -> "(" + aVal + "," + fkJoinVal + ")");
        finalJoinResult.toStream().to("output");
        this.validateTopologyCanProcessData(builder);
    }

    @Test
    public void shouldWorkWithDefaultAndJoinResultSerdes() {
        StreamsBuilder builder = new StreamsBuilder();
        KTable aTable = builder.table("A");
        KTable bTable = builder.table("B");
        KTable fkJoinResult = aTable.join(bTable, value -> Integer.parseInt(value.split("-")[0]), (aVal, bVal) -> "(" + aVal + "," + bVal + ")", Materialized.as((String)"asdf").withKeySerde(Serdes.Integer()).withValueSerde(Serdes.String()));
        KTable finalJoinResult = aTable.join(fkJoinResult, (aVal, fkJoinVal) -> "(" + aVal + "," + fkJoinVal + ")");
        finalJoinResult.toStream().to("output");
        this.validateTopologyCanProcessData(builder);
    }

    @Test
    public void shouldWorkWithDefaultAndEquiJoinResultSerdes() {
        StreamsBuilder builder = new StreamsBuilder();
        KTable aTable = builder.table("A");
        KTable bTable = builder.table("B");
        KTable fkJoinResult = aTable.join(bTable, value -> Integer.parseInt(value.split("-")[0]), (aVal, bVal) -> "(" + aVal + "," + bVal + ")", Materialized.as((String)"asdf"));
        KTable finalJoinResult = aTable.join(fkJoinResult, (aVal, fkJoinVal) -> "(" + aVal + "," + fkJoinVal + ")", Materialized.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        finalJoinResult.toStream().to("output");
        this.validateTopologyCanProcessData(builder);
    }

    @Test
    public void shouldWorkWithDefaultAndProducedSerdes() {
        StreamsBuilder builder = new StreamsBuilder();
        KTable aTable = builder.table("A");
        KTable bTable = builder.table("B");
        KTable fkJoinResult = aTable.join(bTable, value -> Integer.parseInt(value.split("-")[0]), (aVal, bVal) -> "(" + aVal + "," + bVal + ")", Materialized.as((String)"asdf"));
        KTable finalJoinResult = aTable.join(fkJoinResult, (aVal, fkJoinVal) -> "(" + aVal + "," + fkJoinVal + ")");
        finalJoinResult.toStream().to("output", Produced.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        this.validateTopologyCanProcessData(builder);
    }

    @Test
    public void shouldUseExpectedTopicsWithSerde() {
        String applicationId = "ktable-ktable-joinOnForeignKey";
        Properties streamsConfig = Utils.mkProperties((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"ktable-ktable-joinOnForeignKey"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath())}));
        UniqueTopicSerdeScope serdeScope = new UniqueTopicSerdeScope();
        StreamsBuilder builder = new StreamsBuilder();
        KTable left = builder.table(LEFT_TABLE, Consumed.with(serdeScope.decorateSerde(Serdes.Integer(), streamsConfig, true), serdeScope.decorateSerde(Serdes.String(), streamsConfig, false)));
        KTable right = builder.table(RIGHT_TABLE, Consumed.with(serdeScope.decorateSerde(Serdes.Integer(), streamsConfig, true), serdeScope.decorateSerde(Serdes.String(), streamsConfig, false)));
        left.join(right, value -> Integer.parseInt(value.split("\\|")[1]), (value1, value2) -> "(" + value1 + "," + value2 + ")", Materialized.with(null, serdeScope.decorateSerde(Serdes.String(), streamsConfig, false))).toStream().to(OUTPUT);
        Topology topology = builder.build(streamsConfig);
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, streamsConfig);){
            TestInputTopic leftInput = driver.createInputTopic(LEFT_TABLE, (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
            TestInputTopic rightInput = driver.createInputTopic(RIGHT_TABLE, (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
            leftInput.pipeInput((Object)2, (Object)"lhsValue1|1");
            rightInput.pipeInput((Object)1, (Object)"rhsValue1");
        }
        MatcherAssert.assertThat(serdeScope.registeredTopics(), (Matcher)Matchers.is(Set.of("ktable-ktable-joinOnForeignKey-KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-0000000006-topic-fk--key", "ktable-ktable-joinOnForeignKey-KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-0000000006-topic-pk--key", "ktable-ktable-joinOnForeignKey-KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-0000000006-topic-vh--value", "ktable-ktable-joinOnForeignKey-KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-0000000006-topic--key", "ktable-ktable-joinOnForeignKey-KTABLE-FK-JOIN-SUBSCRIPTION-RESPONSE-0000000014-topic--key", "ktable-ktable-joinOnForeignKey-KTABLE-FK-JOIN-SUBSCRIPTION-RESPONSE-0000000014-topic--value", "ktable-ktable-joinOnForeignKey-left_table-STATE-STORE-0000000000-changelog--key", "ktable-ktable-joinOnForeignKey-left_table-STATE-STORE-0000000000-changelog--value", "ktable-ktable-joinOnForeignKey-right_table-STATE-STORE-0000000003-changelog--key", "ktable-ktable-joinOnForeignKey-right_table-STATE-STORE-0000000003-changelog--value", "output-topic--key", "output-topic--value")));
    }

    @Test
    public void shouldWorkWithCompositeKeyAndProducerIdInValue() {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table(LEFT_TABLE, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable rightTable = builder.table(RIGHT_TABLE, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable joined = leftTable.join(rightTable, value -> value.split("\\|")[0], (leftValue, rightValue) -> "(" + leftValue + "," + rightValue + ")", Materialized.as((String)"store"));
        joined.toStream().to("output");
        try (TopologyTestDriver driver = this.createTopologyTestDriver(builder);){
            TestInputTopic leftInput = driver.createInputTopic(LEFT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestInputTopic rightInput = driver.createInputTopic(RIGHT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic output = driver.createOutputTopic("output", (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            leftInput.pipeInput((Object)"producer1:product1", (Object)"producer1|product1-data");
            leftInput.pipeInput((Object)"producer1:product2", (Object)"producer1|product2-data");
            leftInput.pipeInput((Object)"producer2:product1", (Object)"producer2|product1-data");
            rightInput.pipeInput((Object)"producer1", (Object)"producer1-data");
            rightInput.pipeInput((Object)"producer2", (Object)"producer2-data");
            HashMap<String, String> expectedOutput = new HashMap<String, String>();
            expectedOutput.put("producer1:product1", "(producer1|product1-data,producer1-data)");
            expectedOutput.put("producer1:product2", "(producer1|product2-data,producer1-data)");
            expectedOutput.put("producer2:product1", "(producer2|product1-data,producer2-data)");
            MatcherAssert.assertThat((Object)output.readKeyValuesToMap(), (Matcher)Matchers.is(expectedOutput));
        }
    }

    @Test
    public void shouldWorkWithCompositeKeyAndBiFunctionExtractor() {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table(LEFT_TABLE, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable rightTable = builder.table(RIGHT_TABLE, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable joined = leftTable.join(rightTable, (key, value) -> key.split(":")[0], (leftValue, rightValue) -> "(" + leftValue + "," + rightValue + ")", Materialized.as((String)"store"));
        joined.toStream().to("output");
        try (TopologyTestDriver driver = this.createTopologyTestDriver(builder);){
            TestInputTopic leftInput = driver.createInputTopic(LEFT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestInputTopic rightInput = driver.createInputTopic(RIGHT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic output = driver.createOutputTopic("output", (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            leftInput.pipeInput((Object)"producer1:product1", (Object)"product1-data");
            leftInput.pipeInput((Object)"producer1:product2", (Object)"product2-data");
            leftInput.pipeInput((Object)"producer2:product1", (Object)"product1-data");
            rightInput.pipeInput((Object)"producer1", (Object)"producer1-data");
            rightInput.pipeInput((Object)"producer2", (Object)"producer2-data");
            HashMap<String, String> expectedOutput = new HashMap<String, String>();
            expectedOutput.put("producer1:product1", "(product1-data,producer1-data)");
            expectedOutput.put("producer1:product2", "(product2-data,producer1-data)");
            expectedOutput.put("producer2:product1", "(product1-data,producer2-data)");
            MatcherAssert.assertThat((Object)output.readKeyValuesToMap(), (Matcher)Matchers.is(expectedOutput));
        }
    }

    private TopologyTestDriver createTopologyTestDriver(StreamsBuilder builder) {
        Properties config = new Properties();
        config.setProperty("application.id", "test-app");
        config.setProperty("bootstrap.servers", "dummy:1234");
        config.setProperty("state.dir", TestUtils.tempDirectory().getAbsolutePath());
        config.setProperty("default.key.serde", Serdes.String().getClass().getName());
        config.setProperty("default.value.serde", Serdes.String().getClass().getName());
        return new TopologyTestDriver(builder.build(), config);
    }

    private void validateTopologyCanProcessData(StreamsBuilder builder) {
        Properties config = new Properties();
        config.setProperty("default.key.serde", Serdes.IntegerSerde.class.getName());
        config.setProperty("default.value.serde", Serdes.StringSerde.class.getName());
        config.setProperty("state.dir", TestUtils.tempDirectory().getAbsolutePath());
        try (TopologyTestDriver topologyTestDriver = new TopologyTestDriver(builder.build(), config);){
            TestInputTopic aTopic = topologyTestDriver.createInputTopic("A", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
            TestInputTopic bTopic = topologyTestDriver.createInputTopic("B", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic output = topologyTestDriver.createOutputTopic("output", (Deserializer)new IntegerDeserializer(), (Deserializer)new StringDeserializer());
            aTopic.pipeInput((Object)1, (Object)"999-alpha");
            bTopic.pipeInput((Object)999, (Object)"beta");
            Map x = output.readKeyValuesToMap();
            MatcherAssert.assertThat((Object)x, (Matcher)Matchers.is(Collections.singletonMap(1, "(999-alpha,(999-alpha,beta))")));
        }
    }
}

