/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.InternalNameProvider;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.DslKeyValueParams;
import org.apache.kafka.streams.state.DslSessionParams;
import org.apache.kafka.streams.state.DslStoreSuppliers;
import org.apache.kafka.streams.state.DslWindowParams;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class MaterializedInternalTest {
    private InternalNameProvider nameProvider = (InternalNameProvider)Mockito.mock(InternalNameProvider.class);
    private KeyValueBytesStoreSupplier supplier = (KeyValueBytesStoreSupplier)Mockito.mock(KeyValueBytesStoreSupplier.class);
    private final String prefix = "prefix";

    @Test
    public void shouldGenerateStoreNameWithPrefixIfProvidedNameIsNull() {
        String generatedName = "prefix-store";
        Mockito.when((Object)this.nameProvider.newStoreName("prefix")).thenReturn((Object)"prefix-store");
        MaterializedInternal materialized = new MaterializedInternal(Materialized.with(null, null), this.nameProvider, "prefix");
        MatcherAssert.assertThat((Object)materialized.storeName(), (Matcher)CoreMatchers.equalTo((Object)"prefix-store"));
    }

    @Test
    public void shouldUseProvidedStoreNameWhenSet() {
        String storeName = "store-name";
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store-name"), this.nameProvider, "prefix");
        MatcherAssert.assertThat((Object)materialized.storeName(), (Matcher)CoreMatchers.equalTo((Object)"store-name"));
    }

    @Test
    public void shouldUseStoreNameOfSupplierWhenProvided() {
        String storeName = "other-store-name";
        Mockito.when((Object)this.supplier.name()).thenReturn((Object)"other-store-name");
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.supplier), this.nameProvider, "prefix");
        MatcherAssert.assertThat((Object)materialized.storeName(), (Matcher)CoreMatchers.equalTo((Object)"other-store-name"));
    }

    @Test
    public void shouldUseStoreTypeWhenProvidedViaTopologyConfig() {
        Properties topologyOverrides = new Properties();
        topologyOverrides.put("default.dsl.store", "in_memory");
        StreamsConfig config = new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig());
        InternalTopologyBuilder topologyBuilder = new InternalTopologyBuilder(new TopologyConfig("my-topology", config, topologyOverrides));
        InternalStreamsBuilder internalStreamsBuilder = new InternalStreamsBuilder(topologyBuilder, false);
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.supplier), (InternalNameProvider)internalStreamsBuilder, "prefix");
        MatcherAssert.assertThat((Object)materialized.dslStoreSuppliers(), (Matcher)CoreMatchers.equalTo(Optional.of(Materialized.StoreType.IN_MEMORY)));
    }

    @Test
    public void shouldPreferStoreSupplierWhenProvidedWithStoreTypeViaTopologyConfig() {
        Properties topologyOverrides = new Properties();
        topologyOverrides.put("default.dsl.store", "rocksDB");
        topologyOverrides.put("dsl.store.suppliers.class", TestStoreSupplier.class);
        StreamsConfig config = new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig());
        InternalTopologyBuilder topologyBuilder = new InternalTopologyBuilder(new TopologyConfig("my-topology", config, topologyOverrides));
        InternalStreamsBuilder internalStreamsBuilder = new InternalStreamsBuilder(topologyBuilder, false);
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.supplier), (InternalNameProvider)internalStreamsBuilder, "prefix");
        MatcherAssert.assertThat((Object)materialized.dslStoreSuppliers().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((DslStoreSuppliers)materialized.dslStoreSuppliers().get()), (Matcher)Matchers.instanceOf(TestStoreSupplier.class));
    }

    @Test
    public void shouldReturnEmptyWhenOriginalsAndOverridesDontHaveSuppliersSpecified() {
        Properties topologyOverrides = new Properties();
        StreamsConfig config = new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig());
        InternalTopologyBuilder topologyBuilder = new InternalTopologyBuilder(new TopologyConfig("my-topology", config, topologyOverrides));
        InternalStreamsBuilder internalStreamsBuilder = new InternalStreamsBuilder(topologyBuilder, false);
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.supplier), (InternalNameProvider)internalStreamsBuilder, "prefix");
        MatcherAssert.assertThat((Object)materialized.dslStoreSuppliers().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    public static class TestStoreSupplier
    implements DslStoreSuppliers {
        public KeyValueBytesStoreSupplier keyValueStore(DslKeyValueParams params) {
            return null;
        }

        public WindowBytesStoreSupplier windowStore(DslWindowParams params) {
            return null;
        }

        public SessionBytesStoreSupplier sessionStore(DslSessionParams params) {
            return null;
        }
    }
}

