/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Properties;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.CogroupedKStream;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.TimeWindowedCogroupedKStream;
import org.apache.kafka.streams.kstream.TimeWindowedDeserializer;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.test.TestRecord;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TimeWindowedCogroupedKStreamImplTest {
    private static final Long WINDOW_SIZE = 500L;
    private static final String TOPIC = "topic";
    private static final String TOPIC2 = "topic2";
    private static final String OUTPUT = "output";
    private final StreamsBuilder builder = new StreamsBuilder();
    private KGroupedStream<String, String> groupedStream;
    private KGroupedStream<String, String> groupedStream2;
    private CogroupedKStream<String, String> cogroupedStream;
    private TimeWindowedCogroupedKStream<String, String> windowedCogroupedStream;
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());

    @BeforeEach
    public void setup() {
        KStream stream = this.builder.stream(TOPIC, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KStream stream2 = this.builder.stream(TOPIC2, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.groupedStream = stream.groupByKey(Grouped.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.groupedStream2 = stream2.groupByKey(Grouped.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.cogroupedStream = this.groupedStream.cogroup(MockAggregator.TOSTRING_ADDER).cogroup(this.groupedStream2, MockAggregator.TOSTRING_REMOVER);
        this.windowedCogroupedStream = this.cogroupedStream.windowedBy((Windows)TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(WINDOW_SIZE)));
    }

    @Test
    public void shouldNotHaveNullInitializerOnAggregate() {
        Assertions.assertThrows(NullPointerException.class, () -> this.windowedCogroupedStream.aggregate(null));
    }

    @Test
    public void shouldNotHaveNullMaterializedOnTwoOptionAggregate() {
        Assertions.assertThrows(NullPointerException.class, () -> this.windowedCogroupedStream.aggregate(MockInitializer.STRING_INIT, (Materialized)null));
    }

    @Test
    public void shouldNotHaveNullNamedTwoOptionOnAggregate() {
        Assertions.assertThrows(NullPointerException.class, () -> this.windowedCogroupedStream.aggregate(MockInitializer.STRING_INIT, (Named)null));
    }

    @Test
    public void shouldNotHaveNullInitializerTwoOptionNamedOnAggregate() {
        Assertions.assertThrows(NullPointerException.class, () -> this.windowedCogroupedStream.aggregate(null, Named.as((String)"test")));
    }

    @Test
    public void shouldNotHaveNullInitializerTwoOptionMaterializedOnAggregate() {
        Assertions.assertThrows(NullPointerException.class, () -> this.windowedCogroupedStream.aggregate(null, Materialized.as((String)"test")));
    }

    @Test
    public void shouldNotHaveNullInitializerThreeOptionOnAggregate() {
        Assertions.assertThrows(NullPointerException.class, () -> this.windowedCogroupedStream.aggregate(null, Named.as((String)"test"), Materialized.as((String)"test")));
    }

    @Test
    public void shouldNotHaveNullMaterializedOnAggregate() {
        Assertions.assertThrows(NullPointerException.class, () -> this.windowedCogroupedStream.aggregate(MockInitializer.STRING_INIT, Named.as((String)"Test"), null));
    }

    @Test
    public void shouldNotHaveNullNamedOnAggregate() {
        Assertions.assertThrows(NullPointerException.class, () -> this.windowedCogroupedStream.aggregate(MockInitializer.STRING_INIT, null, Materialized.as((String)"test")));
    }

    @Test
    public void namedParamShouldSetName() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream stream = builder.stream(TOPIC, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.groupedStream = stream.groupByKey(Grouped.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.groupedStream.cogroup(MockAggregator.TOSTRING_ADDER).windowedBy((Windows)TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(WINDOW_SIZE))).aggregate(MockInitializer.STRING_INIT, Named.as((String)"foo"));
        MatcherAssert.assertThat((Object)builder.build().describe().toString(), (Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [topic])\n      --> foo-cogroup-agg-0\n    Processor: foo-cogroup-agg-0 (stores: [COGROUPKSTREAM-AGGREGATE-STATE-STORE-0000000001])\n      --> foo-cogroup-merge\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: foo-cogroup-merge (stores: [])\n      --> none\n      <-- foo-cogroup-agg-0\n\n"));
    }

    @Test
    public void timeWindowAggregateTestStreamsTest() {
        KTable customers = this.windowedCogroupedStream.aggregate(MockInitializer.STRING_INIT, Materialized.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        customers.toStream().to(OUTPUT);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic testInputTopic = driver.createInputTopic(TOPIC, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic testOutputTopic = driver.createOutputTopic(OUTPUT, (Deserializer)new TimeWindowedDeserializer((Deserializer)new StringDeserializer(), WINDOW_SIZE), (Deserializer)new StringDeserializer());
            testInputTopic.pipeInput((Object)"k1", (Object)"A", 0L);
            testInputTopic.pipeInput((Object)"k2", (Object)"A", 0L);
            testInputTopic.pipeInput((Object)"k2", (Object)"A", 1L);
            testInputTopic.pipeInput((Object)"k1", (Object)"A", 2L);
            testInputTopic.pipeInput((Object)"k1", (Object)"B", 3L);
            testInputTopic.pipeInput((Object)"k2", (Object)"B", 3L);
            testInputTopic.pipeInput((Object)"k2", (Object)"B", 4L);
            testInputTopic.pipeInput((Object)"k1", (Object)"B", 4L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A", 0L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A", 0L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A+A", 1L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A+A", 2L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A+A+B", 3L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A+A+B", 3L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A+A+B+B", 4L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A+A+B+B", 4L);
        }
    }

    @Test
    public void timeWindowMixAggregatorsTest() {
        KTable customers = this.windowedCogroupedStream.aggregate(MockInitializer.STRING_INIT, Materialized.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        customers.toStream().to(OUTPUT);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic testInputTopic = driver.createInputTopic(TOPIC, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestInputTopic testInputTopic2 = driver.createInputTopic(TOPIC2, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic testOutputTopic = driver.createOutputTopic(OUTPUT, (Deserializer)new TimeWindowedDeserializer((Deserializer)new StringDeserializer(), WINDOW_SIZE), (Deserializer)new StringDeserializer());
            testInputTopic.pipeInput((Object)"k1", (Object)"A", 0L);
            testInputTopic.pipeInput((Object)"k2", (Object)"A", 0L);
            testInputTopic.pipeInput((Object)"k2", (Object)"A", 1L);
            testInputTopic.pipeInput((Object)"k1", (Object)"A", 2L);
            testInputTopic2.pipeInput((Object)"k1", (Object)"B", 3L);
            testInputTopic2.pipeInput((Object)"k2", (Object)"B", 3L);
            testInputTopic2.pipeInput((Object)"k2", (Object)"B", 4L);
            testInputTopic2.pipeInput((Object)"k1", (Object)"B", 4L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A", 0L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A", 0L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A+A", 1L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A+A", 2L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A+A-B", 3L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A+A-B", 3L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A+A-B-B", 4L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A+A-B-B", 4L);
        }
    }

    @Test
    public void timeWindowAggregateManyWindowsTest() {
        KTable customers = this.groupedStream.cogroup(MockAggregator.TOSTRING_ADDER).windowedBy((Windows)TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(500L))).aggregate(MockInitializer.STRING_INIT, Materialized.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        customers.toStream().to(OUTPUT);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic testInputTopic = driver.createInputTopic(TOPIC, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic testOutputTopic = driver.createOutputTopic(OUTPUT, (Deserializer)new TimeWindowedDeserializer((Deserializer)new StringDeserializer(), WINDOW_SIZE), (Deserializer)new StringDeserializer());
            testInputTopic.pipeInput((Object)"k1", (Object)"A", 0L);
            testInputTopic.pipeInput((Object)"k2", (Object)"A", 499L);
            testInputTopic.pipeInput((Object)"k2", (Object)"A", 500L);
            testInputTopic.pipeInput((Object)"k1", (Object)"A", 500L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A", 0L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A", 499L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A", 500L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A", 500L);
        }
    }

    @Test
    public void timeWindowAggregateOverlappingWindowsTest() {
        KTable customers = this.groupedStream.cogroup(MockAggregator.TOSTRING_ADDER).windowedBy((Windows)TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(500L)).advanceBy(Duration.ofMillis(200L))).aggregate(MockInitializer.STRING_INIT, Materialized.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        customers.toStream().to(OUTPUT);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic testInputTopic = driver.createInputTopic(TOPIC, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic testOutputTopic = driver.createOutputTopic(OUTPUT, (Deserializer)new TimeWindowedDeserializer((Deserializer)new StringDeserializer(), WINDOW_SIZE), (Deserializer)new StringDeserializer());
            testInputTopic.pipeInput((Object)"k1", (Object)"A", 0L);
            testInputTopic.pipeInput((Object)"k2", (Object)"A", 0L);
            testInputTopic.pipeInput((Object)"k1", (Object)"B", 250L);
            testInputTopic.pipeInput((Object)"k2", (Object)"B", 250L);
            testInputTopic.pipeInput((Object)"k2", (Object)"A", 500L);
            testInputTopic.pipeInput((Object)"k1", (Object)"A", 500L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A", 0L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A", 0L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A+B", 250L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+B", 250L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A+B", 250L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+B", 250L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+B+A", 500L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A", 500L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+B+A", 500L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A", 500L);
        }
    }

    @Test
    public void timeWindowMixAggregatorsManyWindowsTest() {
        KTable customers = this.windowedCogroupedStream.aggregate(MockInitializer.STRING_INIT, Materialized.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        customers.toStream().to(OUTPUT);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic testInputTopic = driver.createInputTopic(TOPIC, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestInputTopic testInputTopic2 = driver.createInputTopic(TOPIC2, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic testOutputTopic = driver.createOutputTopic(OUTPUT, (Deserializer)new TimeWindowedDeserializer((Deserializer)new StringDeserializer(), WINDOW_SIZE), (Deserializer)new StringDeserializer());
            testInputTopic.pipeInput((Object)"k1", (Object)"A", 0L);
            testInputTopic.pipeInput((Object)"k2", (Object)"A", 0L);
            testInputTopic.pipeInput((Object)"k2", (Object)"A", 1L);
            testInputTopic.pipeInput((Object)"k1", (Object)"A", 2L);
            testInputTopic2.pipeInput((Object)"k1", (Object)"B", 3L);
            testInputTopic2.pipeInput((Object)"k2", (Object)"B", 3L);
            testInputTopic2.pipeInput((Object)"k2", (Object)"B", 501L);
            testInputTopic2.pipeInput((Object)"k1", (Object)"B", 501L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A", 0L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A", 0L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A+A", 1L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A+A", 2L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0+A+A-B", 3L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0+A+A-B", 3L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k2", "0-B", 501L);
            this.assertOutputKeyValueTimestamp((TestOutputTopic<Windowed<String>, String>)testOutputTopic, "k1", "0-B", 501L);
        }
    }

    private void assertOutputKeyValueTimestamp(TestOutputTopic<Windowed<String>, String> outputTopic, String expectedKey, String expectedValue, long expectedTimestamp) {
        TestRecord realRecord = outputTopic.readRecord();
        TestRecord nonWindowedRecord = new TestRecord((Object)((String)((Windowed)realRecord.getKey()).key()), (Object)((String)realRecord.getValue()), null, realRecord.timestamp());
        TestRecord testRecord = new TestRecord((Object)expectedKey, (Object)expectedValue, null, Long.valueOf(expectedTimestamp));
        MatcherAssert.assertThat((Object)nonWindowedRecord, (Matcher)CoreMatchers.equalTo((Object)testRecord));
    }
}

