/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class TimestampedTupleForwarderTest {
    @Test
    public void shouldSetFlushListenerOnWrappedStateStore() {
        this.setFlushListener(true);
        this.setFlushListener(false);
    }

    private void setFlushListener(boolean sendOldValues) {
        WrappedStateStore store = (WrappedStateStore)Mockito.mock(WrappedStateStore.class);
        TimestampedCacheFlushListener flushListener = (TimestampedCacheFlushListener)Mockito.mock(TimestampedCacheFlushListener.class);
        Mockito.when((Object)store.setFlushListener((CacheFlushListener)flushListener, sendOldValues)).thenReturn((Object)false);
        new TimestampedTupleForwarder((StateStore)store, null, (CacheFlushListener)flushListener, sendOldValues);
    }

    @Test
    public void shouldForwardRecordsIfWrappedStateStoreDoesNotCache() {
        this.shouldForwardRecordsIfWrappedStateStoreDoesNotCache(false);
        this.shouldForwardRecordsIfWrappedStateStoreDoesNotCache(true);
    }

    private void shouldForwardRecordsIfWrappedStateStoreDoesNotCache(boolean sendOldValues) {
        WrappedStateStore store = (WrappedStateStore)Mockito.mock(WrappedStateStore.class);
        InternalProcessorContext context = (InternalProcessorContext)Mockito.mock(InternalProcessorContext.class);
        Mockito.when((Object)store.setFlushListener(null, sendOldValues)).thenReturn((Object)false);
        if (sendOldValues) {
            ((InternalProcessorContext)Mockito.doNothing().when((Object)context)).forward(new Record((Object)"key1", (Object)new Change((Object)"newValue1", (Object)"oldValue1", true), 0L));
            ((InternalProcessorContext)Mockito.doNothing().when((Object)context)).forward(new Record((Object)"key2", (Object)new Change((Object)"newValue2", (Object)"oldValue2", false), 42L));
        } else {
            ((InternalProcessorContext)Mockito.doNothing().when((Object)context)).forward(new Record((Object)"key1", (Object)new Change((Object)"newValue1", null, true), 0L));
            ((InternalProcessorContext)Mockito.doNothing().when((Object)context)).forward(new Record((Object)"key2", (Object)new Change((Object)"newValue2", null, false), 42L));
        }
        TimestampedTupleForwarder forwarder = new TimestampedTupleForwarder((StateStore)store, (ProcessorContext)context, null, sendOldValues);
        forwarder.maybeForward(new Record((Object)"key1", (Object)new Change((Object)"newValue1", (Object)"oldValue1", true), 0L));
        forwarder.maybeForward(new Record((Object)"key2", (Object)new Change((Object)"newValue2", (Object)"oldValue2", false), 42L));
    }

    @Test
    public void shouldNotForwardRecordsIfWrappedStateStoreDoesCache() {
        WrappedStateStore store = (WrappedStateStore)Mockito.mock(WrappedStateStore.class);
        InternalProcessorContext context = (InternalProcessorContext)Mockito.mock(InternalProcessorContext.class);
        Mockito.when((Object)store.setFlushListener(null, false)).thenReturn((Object)true);
        TimestampedTupleForwarder forwarder = new TimestampedTupleForwarder((StateStore)store, (ProcessorContext)context, null, false);
        forwarder.maybeForward(new Record((Object)"key", (Object)new Change((Object)"newValue", (Object)"oldValue", true), 0L));
        forwarder.maybeForward(new Record((Object)"key", (Object)new Change((Object)"newValue", (Object)"oldValue", true), 42L));
    }
}

