/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.UnlimitedWindow;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnlimitedWindowTest {
    private final long start = 50L;
    private final UnlimitedWindow window = new UnlimitedWindow(50L);
    private final SessionWindow sessionWindow = new SessionWindow(50L, 50L);

    @Test
    public void shouldAlwaysOverlap() {
        Assertions.assertTrue((boolean)this.window.overlap((Window)new UnlimitedWindow(49L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new UnlimitedWindow(50L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new UnlimitedWindow(51L)));
    }

    @Test
    public void cannotCompareUnlimitedWindowWithDifferentWindowType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.window.overlap((Window)this.sessionWindow));
    }
}

