/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.clients.producer.internals.BuiltInPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.kstream.TimeWindowedSerializer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.kstream.internals.WindowedSerializer;
import org.apache.kafka.streams.kstream.internals.WindowedStreamPartitioner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WindowedStreamPartitionerTest {
    private final String topicName = "topic";
    private final IntegerSerializer intSerializer = new IntegerSerializer();
    private final StringSerializer stringSerializer = new StringSerializer();
    private final List<PartitionInfo> infos = Arrays.asList(new PartitionInfo("topic", 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic", 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic", 2, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic", 3, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic", 4, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic", 5, Node.noNode(), new Node[0], new Node[0]));
    private final Cluster cluster = new Cluster("cluster", Collections.singletonList(Node.noNode()), this.infos, Collections.emptySet(), Collections.emptySet());

    @Test
    public void testCopartitioning() {
        Random rand = new Random();
        TimeWindowedSerializer timeWindowedSerializer = new TimeWindowedSerializer((Serializer)this.intSerializer);
        WindowedStreamPartitioner streamPartitioner = new WindowedStreamPartitioner((WindowedSerializer)timeWindowedSerializer);
        for (int k = 0; k < 10; ++k) {
            Integer key = rand.nextInt();
            byte[] keyBytes = this.intSerializer.serialize("topic", key);
            String value = key.toString();
            Set<Integer> expected = Set.of(Integer.valueOf(BuiltInPartitioner.partitionForKey((byte[])keyBytes, (int)this.cluster.partitionsForTopic("topic").size())));
            for (int w = 1; w < 10; ++w) {
                TimeWindow window = new TimeWindow((long)(10 * w), (long)(20 * w));
                Windowed windowedKey = new Windowed((Object)key, (Window)window);
                Optional actual = streamPartitioner.partitions("topic", windowedKey, (Object)value, this.infos.size());
                Assertions.assertTrue((boolean)actual.isPresent());
                Assertions.assertEquals(expected, actual.get());
            }
        }
    }
}

