/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.nio.ByteBuffer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.CombinedKey;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.CombinedKeySchema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CombinedKeySchemaTest {
    @Test
    public void nonNullPrimaryKeySerdeTest() {
        CombinedKeySchema cks = new CombinedKeySchema(() -> "fkTopic", Serdes.String(), () -> "pkTopic", Serdes.Integer());
        Integer primary = -999;
        Bytes result = cks.toBytes((Object)"foreignKey", (Object)primary);
        CombinedKey deserializedKey = cks.fromBytes(result);
        Assertions.assertEquals((Object)"foreignKey", (Object)deserializedKey.foreignKey());
        Assertions.assertEquals((Integer)primary, (Integer)((Integer)deserializedKey.primaryKey()));
    }

    @Test
    public void nullPrimaryKeySerdeTest() {
        CombinedKeySchema cks = new CombinedKeySchema(() -> "fkTopic", Serdes.String(), () -> "pkTopic", Serdes.Integer());
        Assertions.assertThrows(NullPointerException.class, () -> cks.toBytes((Object)"foreignKey", null));
    }

    @Test
    public void nullForeignKeySerdeTest() {
        CombinedKeySchema cks = new CombinedKeySchema(() -> "fkTopic", Serdes.String(), () -> "pkTopic", Serdes.Integer());
        Assertions.assertThrows(NullPointerException.class, () -> cks.toBytes(null, (Object)10));
    }

    @Test
    public void prefixKeySerdeTest() {
        CombinedKeySchema cks = new CombinedKeySchema(() -> "fkTopic", Serdes.String(), () -> "pkTopic", Serdes.Integer());
        String foreignKey = "someForeignKey";
        byte[] foreignKeySerializedData = Serdes.String().serializer().serialize("fkTopic", (Object)"someForeignKey");
        Bytes prefix = cks.prefixBytes((Object)"someForeignKey");
        ByteBuffer buf = ByteBuffer.allocate(4 + foreignKeySerializedData.length);
        buf.putInt(foreignKeySerializedData.length);
        buf.put(foreignKeySerializedData);
        Bytes expectedPrefixBytes = Bytes.wrap((byte[])buf.array());
        Assertions.assertEquals((Object)expectedPrefixBytes, (Object)prefix);
    }

    @Test
    public void nullPrefixKeySerdeTest() {
        CombinedKeySchema cks = new CombinedKeySchema(() -> "fkTopic", Serdes.String(), () -> "pkTopic", Serdes.Integer());
        String foreignKey = null;
        Assertions.assertThrows(NullPointerException.class, () -> cks.prefixBytes((Object)foreignKey));
    }
}

