/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.CombinedKeySchema;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.ForeignTableJoinProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.ResponseJoinProcessorSupplierTest;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionResponseWrapper;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapperSerde;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.MockProcessorContext;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.StoreBuilderWrapper;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.test.MockInternalProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ForeignTableJoinProcessorSupplierTests {
    private static final Supplier<String> PK_SERDE_TOPIC_SUPPLIER = () -> "pk-topic";
    private static final CombinedKeySchema<String, String> COMBINED_KEY_SCHEMA = new CombinedKeySchema(() -> "fk-topic", Serdes.String(), PK_SERDE_TOPIC_SUPPLIER, Serdes.String());
    private MockInternalProcessorContext<String, SubscriptionResponseWrapper<String>> context = null;
    private TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>> stateStore = null;
    private Processor<String, Change<String>, String, SubscriptionResponseWrapper<String>> processor = null;
    private File stateDir;
    private final String pk1 = "pk1";
    private final String pk2 = "pk2";
    private final String fk1 = "fk1";
    private final long[] hash = new long[]{1L, 2L};

    @BeforeEach
    public void setUp() {
        this.stateDir = TestUtils.tempDirectory();
        Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());
        this.context = new MockInternalProcessorContext(props, new TaskId(0, 0), this.stateDir);
        StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>>> storeBuilder = this.storeBuilder();
        this.processor = new ForeignTableJoinProcessorSupplier(StoreBuilderWrapper.wrapStoreBuilder(this.storeBuilder()), COMBINED_KEY_SCHEMA).get();
        this.stateStore = (TimestampedKeyValueStore)storeBuilder.build();
        this.context.addStateStore((StateStore)this.stateStore);
        this.stateStore.init(this.context, this.stateStore);
        this.processor.init(this.context);
    }

    @AfterEach
    public void cleanUp() throws IOException {
        if (this.stateStore != null) {
            this.stateStore.close();
        }
        Utils.delete((File)this.stateDir);
    }

    @Test
    public void shouldPropagateRightRecordForEachMatchingPrimaryKey() {
        this.putInStore("fk1", "pk1");
        this.putInStore("fk1", "pk2");
        Record record = new Record((Object)"fk1", (Object)new Change((Object)"new_value", null), 0L);
        this.processor.process(record);
        MatcherAssert.assertThat((Object)this.context.forwarded().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)this.context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pk1", (Object)new SubscriptionResponseWrapper(this.hash, (Object)"new_value", null), 0L)));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)this.context.forwarded().get(1)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pk2", (Object)new SubscriptionResponseWrapper(this.hash, (Object)"new_value", null), 0L)));
    }

    @Test
    public void shouldPropagateNothingIfNoMatchingPrimaryKey() {
        String fk2 = "fk2";
        this.putInStore("fk1", "pk1");
        Record record = new Record((Object)"fk2", (Object)new Change((Object)"new_value", null), 0L);
        this.processor.process(record);
        MatcherAssert.assertThat((Object)this.context.forwarded(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldPropagateTombstoneRightRecordForEachMatchingPrimaryKey() {
        this.putInStore("fk1", "pk1");
        this.putInStore("fk1", "pk2");
        Record record = new Record((Object)"fk1", (Object)new Change(null, (Object)"new_value"), 0L);
        this.processor.process(record);
        MatcherAssert.assertThat((Object)this.context.forwarded().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)this.context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pk1", (Object)new SubscriptionResponseWrapper(this.hash, null, null), 0L)));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)this.context.forwarded().get(1)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pk2", (Object)new SubscriptionResponseWrapper(this.hash, null, null), 0L)));
    }

    @Test
    public void shouldNotMatchForeignKeysHavingThisFKAsPrefix() {
        String fk = "fk";
        this.putInStore("fk1", "pk1");
        this.putInStore("fk", "pk2");
        Record record = new Record((Object)"fk", (Object)new Change((Object)"new_value", null), 0L);
        this.processor.process(record);
        MatcherAssert.assertThat((Object)this.context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)this.context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pk2", (Object)new SubscriptionResponseWrapper(this.hash, (Object)"new_value", null), 0L)));
    }

    @Test
    public void shouldIgnoreRecordWithNullKey() {
        this.putInStore("fk1", "pk1");
        Record record = new Record(null, (Object)new Change((Object)"new_value", null), 0L);
        this.processor.process(record);
        MatcherAssert.assertThat((Object)this.context.forwarded(), (Matcher)Matchers.empty());
        Assertions.assertEquals((Object)1.0, (Object)ResponseJoinProcessorSupplierTest.getDroppedRecordsTotalMetric(this.context));
        Assertions.assertNotEquals((Object)0.0, (Object)ResponseJoinProcessorSupplierTest.getDroppedRecordsRateMetric(this.context));
    }

    private void putInStore(String fk, String pk) {
        SubscriptionWrapper oldWrapper = new SubscriptionWrapper(this.hash, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)pk, 0, null);
        ValueAndTimestamp oldValue = ValueAndTimestamp.make((Object)oldWrapper, (long)0L);
        Bytes key = COMBINED_KEY_SCHEMA.toBytes((Object)fk, (Object)pk);
        this.stateStore.put((Object)key, (Object)oldValue);
    }

    private StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>>> storeBuilder() {
        SubscriptionWrapperSerde subscriptionWrapperSerde = new SubscriptionWrapperSerde(PK_SERDE_TOPIC_SUPPLIER, Serdes.String());
        return Stores.timestampedKeyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.persistentTimestampedKeyValueStore((String)"Store"), (Serde)new Serdes.BytesSerde(), (Serde)subscriptionWrapperSerde);
    }
}

