/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.CombinedKey;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.CombinedKeySchema;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionReceiveProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapperSerde;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.MockProcessorContext;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.StoreBuilderWrapper;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.test.MockInternalProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SubscriptionReceiveProcessorSupplierTest {
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());
    private File stateDir;
    private MockInternalProcessorContext<CombinedKey<String, String>, Change<ValueAndTimestamp<SubscriptionWrapper<String>>>> context;
    private TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>> stateStore = null;
    private static final String FK = "fk1";
    private static final String PK1 = "pk1";
    private static final String PK2 = "pk2";
    private static final Supplier<String> PK_SERDE_TOPIC_SUPPLIER = () -> "pk-topic";
    private static final CombinedKeySchema<String, String> COMBINED_KEY_SCHEMA = new CombinedKeySchema(() -> "fk-topic", Serdes.String(), PK_SERDE_TOPIC_SUPPLIER, Serdes.String());

    @BeforeEach
    public void before() {
        this.stateDir = TestUtils.tempDirectory();
        this.context = new MockInternalProcessorContext(this.props, new TaskId(0, 0), this.stateDir);
    }

    @AfterEach
    public void after() throws IOException {
        if (this.stateStore != null) {
            this.stateStore.close();
        }
        Utils.delete((File)this.stateDir);
    }

    @Test
    public void shouldDetectVersionChange() {
        Assertions.assertEquals((byte)1, (byte)1);
    }

    @Test
    public void shouldDeleteKeyAndPropagateV0() {
        StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>>> storeBuilder = this.storeBuilder();
        SubscriptionReceiveProcessorSupplier<String, String> supplier = this.supplier(storeBuilder);
        Processor processor = supplier.get();
        this.stateStore = (TimestampedKeyValueStore)storeBuilder.build();
        this.context.addStateStore((StateStore)this.stateStore);
        this.stateStore.init(this.context, this.stateStore);
        SubscriptionWrapper oldWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)PK2, 0, null);
        ValueAndTimestamp oldValue = ValueAndTimestamp.make((Object)oldWrapper, (long)0L);
        Bytes key = COMBINED_KEY_SCHEMA.toBytes((Object)FK, (Object)PK1);
        this.stateStore.put((Object)key, (Object)oldValue);
        processor.init(this.context);
        SubscriptionWrapper newWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)PK1, 0, null);
        ValueAndTimestamp newValue = ValueAndTimestamp.make((Object)newWrapper, (long)1L);
        Record record = new Record((Object)FK, (Object)newWrapper, 1L);
        processor.process(record);
        List forwarded = this.context.forwarded();
        Assertions.assertNull((Object)this.stateStore.get((Object)key));
        Assertions.assertEquals((int)1, (int)forwarded.size());
        Assertions.assertEquals((Object)record.withKey((Object)new CombinedKey((Object)FK, (Object)PK1)).withValue((Object)new Change((Object)newValue, (Object)oldValue)), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
    }

    @Test
    public void shouldDeleteKeyAndPropagateV1() {
        StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>>> storeBuilder = this.storeBuilder();
        SubscriptionReceiveProcessorSupplier<String, String> supplier = this.supplier(storeBuilder);
        Processor processor = supplier.get();
        this.stateStore = (TimestampedKeyValueStore)storeBuilder.build();
        this.context.addStateStore((StateStore)this.stateStore);
        this.stateStore.init(this.context, this.stateStore);
        SubscriptionWrapper oldWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)PK2, 1, Integer.valueOf(1));
        ValueAndTimestamp oldValue = ValueAndTimestamp.make((Object)oldWrapper, (long)0L);
        Bytes key = COMBINED_KEY_SCHEMA.toBytes((Object)FK, (Object)PK1);
        this.stateStore.put((Object)key, (Object)oldValue);
        processor.init(this.context);
        SubscriptionWrapper newWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)PK1, 1, Integer.valueOf(1));
        ValueAndTimestamp newValue = ValueAndTimestamp.make((Object)newWrapper, (long)1L);
        Record record = new Record((Object)FK, (Object)newWrapper, 1L);
        processor.process(record);
        List forwarded = this.context.forwarded();
        Assertions.assertNull((Object)this.stateStore.get((Object)key));
        Assertions.assertEquals((int)1, (int)forwarded.size());
        Assertions.assertEquals((Object)record.withKey((Object)new CombinedKey((Object)FK, (Object)PK1)).withValue((Object)new Change((Object)newValue, (Object)oldValue)), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
    }

    @Test
    public void shouldDeleteKeyNoPropagateV0() {
        StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>>> storeBuilder = this.storeBuilder();
        SubscriptionReceiveProcessorSupplier<String, String> supplier = this.supplier(storeBuilder);
        Processor processor = supplier.get();
        this.stateStore = (TimestampedKeyValueStore)storeBuilder.build();
        this.context.addStateStore((StateStore)this.stateStore);
        this.stateStore.init(this.context, this.stateStore);
        SubscriptionWrapper oldWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)PK2, 0, null);
        ValueAndTimestamp oldValue = ValueAndTimestamp.make((Object)oldWrapper, (long)0L);
        Bytes key = COMBINED_KEY_SCHEMA.toBytes((Object)FK, (Object)PK1);
        this.stateStore.put((Object)key, (Object)oldValue);
        processor.init(this.context);
        SubscriptionWrapper newWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)PK1, 0, null);
        ValueAndTimestamp newValue = ValueAndTimestamp.make((Object)newWrapper, (long)1L);
        Record record = new Record((Object)FK, (Object)newWrapper, 1L);
        processor.process(record);
        List forwarded = this.context.forwarded();
        Assertions.assertNull((Object)this.stateStore.get((Object)key));
        Assertions.assertEquals((int)1, (int)forwarded.size());
        Assertions.assertEquals((Object)record.withKey((Object)new CombinedKey((Object)FK, (Object)PK1)).withValue((Object)new Change((Object)newValue, (Object)oldValue)), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
    }

    @Test
    public void shouldDeleteKeyNoPropagateV1() {
        StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>>> storeBuilder = this.storeBuilder();
        SubscriptionReceiveProcessorSupplier<String, String> supplier = this.supplier(storeBuilder);
        Processor processor = supplier.get();
        this.stateStore = (TimestampedKeyValueStore)storeBuilder.build();
        this.context.addStateStore((StateStore)this.stateStore);
        this.stateStore.init(this.context, this.stateStore);
        SubscriptionWrapper oldWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)PK2, 1, Integer.valueOf(1));
        ValueAndTimestamp oldValue = ValueAndTimestamp.make((Object)oldWrapper, (long)0L);
        Bytes key = COMBINED_KEY_SCHEMA.toBytes((Object)FK, (Object)PK1);
        this.stateStore.put((Object)key, (Object)oldValue);
        processor.init(this.context);
        SubscriptionWrapper newWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)PK1, 1, Integer.valueOf(1));
        ValueAndTimestamp newValue = ValueAndTimestamp.make((Object)newWrapper, (long)1L);
        Record record = new Record((Object)FK, (Object)newWrapper, 1L);
        processor.process(record);
        List forwarded = this.context.forwarded();
        Assertions.assertNull((Object)this.stateStore.get((Object)key));
        Assertions.assertEquals((int)1, (int)forwarded.size());
        Assertions.assertEquals((Object)record.withKey((Object)new CombinedKey((Object)FK, (Object)PK1)).withValue((Object)new Change((Object)newValue, (Object)oldValue)), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
    }

    @Test
    public void shouldPropagateOnlyIfFKValAvailableV0() {
        StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>>> storeBuilder = this.storeBuilder();
        SubscriptionReceiveProcessorSupplier<String, String> supplier = this.supplier(storeBuilder);
        Processor processor = supplier.get();
        this.stateStore = (TimestampedKeyValueStore)storeBuilder.build();
        this.context.addStateStore((StateStore)this.stateStore);
        this.stateStore.init(this.context, this.stateStore);
        SubscriptionWrapper oldWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)PK2, 0, null);
        ValueAndTimestamp oldValue = ValueAndTimestamp.make((Object)oldWrapper, (long)0L);
        Bytes key = COMBINED_KEY_SCHEMA.toBytes((Object)FK, (Object)PK1);
        this.stateStore.put((Object)key, (Object)oldValue);
        processor.init(this.context);
        SubscriptionWrapper newWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)PK1, 0, null);
        ValueAndTimestamp newValue = ValueAndTimestamp.make((Object)newWrapper, (long)1L);
        Record record = new Record((Object)FK, (Object)newWrapper, 1L);
        processor.process(record);
        List forwarded = this.context.forwarded();
        Assertions.assertEquals((Object)newValue, (Object)this.stateStore.get((Object)key));
        Assertions.assertEquals((int)1, (int)forwarded.size());
        Assertions.assertEquals((Object)record.withKey((Object)new CombinedKey((Object)FK, (Object)PK1)).withValue((Object)new Change((Object)newValue, (Object)oldValue)), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
    }

    @Test
    public void shouldPropagateOnlyIfFKValAvailableV1() {
        StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>>> storeBuilder = this.storeBuilder();
        SubscriptionReceiveProcessorSupplier<String, String> supplier = this.supplier(storeBuilder);
        Processor processor = supplier.get();
        this.stateStore = (TimestampedKeyValueStore)storeBuilder.build();
        this.context.addStateStore((StateStore)this.stateStore);
        this.stateStore.init(this.context, this.stateStore);
        SubscriptionWrapper oldWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)PK2, 1, Integer.valueOf(1));
        ValueAndTimestamp oldValue = ValueAndTimestamp.make((Object)oldWrapper, (long)0L);
        Bytes key = COMBINED_KEY_SCHEMA.toBytes((Object)FK, (Object)PK1);
        this.stateStore.put((Object)key, (Object)oldValue);
        processor.init(this.context);
        SubscriptionWrapper newWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)PK1, 1, Integer.valueOf(1));
        ValueAndTimestamp newValue = ValueAndTimestamp.make((Object)newWrapper, (long)1L);
        Record record = new Record((Object)FK, (Object)newWrapper, 1L);
        processor.process(record);
        List forwarded = this.context.forwarded();
        Assertions.assertEquals((Object)newValue, (Object)this.stateStore.get((Object)key));
        Assertions.assertEquals((int)1, (int)forwarded.size());
        Assertions.assertEquals((Object)record.withKey((Object)new CombinedKey((Object)FK, (Object)PK1)).withValue((Object)new Change((Object)newValue, (Object)oldValue)), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
    }

    @Test
    public void shouldPropagateNullIfNoFKValAvailableV0() {
        StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>>> storeBuilder = this.storeBuilder();
        SubscriptionReceiveProcessorSupplier<String, String> supplier = this.supplier(storeBuilder);
        Processor processor = supplier.get();
        this.stateStore = (TimestampedKeyValueStore)storeBuilder.build();
        this.context.addStateStore((StateStore)this.stateStore);
        this.stateStore.init(this.context, this.stateStore);
        SubscriptionWrapper oldWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)PK2, 0, null);
        ValueAndTimestamp oldValue = ValueAndTimestamp.make((Object)oldWrapper, (long)0L);
        Bytes key = COMBINED_KEY_SCHEMA.toBytes((Object)FK, (Object)PK1);
        this.stateStore.put((Object)key, (Object)oldValue);
        processor.init(this.context);
        SubscriptionWrapper newWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)PK1, 0, null);
        ValueAndTimestamp newValue = ValueAndTimestamp.make((Object)newWrapper, (long)1L);
        Record record = new Record((Object)FK, (Object)newWrapper, 1L);
        processor.process(record);
        List forwarded = this.context.forwarded();
        Assertions.assertEquals((Object)newValue, (Object)this.stateStore.get((Object)key));
        Assertions.assertEquals((int)1, (int)forwarded.size());
        Assertions.assertEquals((Object)record.withKey((Object)new CombinedKey((Object)FK, (Object)PK1)).withValue((Object)new Change((Object)newValue, (Object)oldValue)), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
    }

    @Test
    public void shouldPropagateNullIfNoFKValAvailableV1() {
        StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>>> storeBuilder = this.storeBuilder();
        SubscriptionReceiveProcessorSupplier<String, String> supplier = this.supplier(storeBuilder);
        Processor processor = supplier.get();
        this.stateStore = (TimestampedKeyValueStore)storeBuilder.build();
        this.context.addStateStore((StateStore)this.stateStore);
        this.stateStore.init(this.context, this.stateStore);
        SubscriptionWrapper oldWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)PK2, 1, Integer.valueOf(1));
        ValueAndTimestamp oldValue = ValueAndTimestamp.make((Object)oldWrapper, (long)0L);
        Bytes key = COMBINED_KEY_SCHEMA.toBytes((Object)FK, (Object)PK1);
        this.stateStore.put((Object)key, (Object)oldValue);
        processor.init(this.context);
        SubscriptionWrapper newWrapper = new SubscriptionWrapper(new long[]{1L, 2L}, SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)PK1, 1, Integer.valueOf(1));
        ValueAndTimestamp newValue = ValueAndTimestamp.make((Object)newWrapper, (long)1L);
        Record record = new Record((Object)FK, (Object)newWrapper, 1L);
        processor.process(record);
        List forwarded = this.context.forwarded();
        Assertions.assertEquals((Object)newValue, (Object)this.stateStore.get((Object)key));
        Assertions.assertEquals((int)1, (int)forwarded.size());
        Assertions.assertEquals((Object)record.withKey((Object)new CombinedKey((Object)FK, (Object)PK1)).withValue((Object)new Change((Object)newValue, (Object)oldValue)), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
    }

    private SubscriptionReceiveProcessorSupplier<String, String> supplier(StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>>> storeBuilder) {
        return new SubscriptionReceiveProcessorSupplier(StoreBuilderWrapper.wrapStoreBuilder(storeBuilder), COMBINED_KEY_SCHEMA);
    }

    private StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<String>>> storeBuilder() {
        SubscriptionWrapperSerde subscriptionWrapperSerde = new SubscriptionWrapperSerde(PK_SERDE_TOPIC_SUPPLIER, Serdes.String());
        return Stores.timestampedKeyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.persistentTimestampedKeyValueStore((String)"Store"), (Serde)new Serdes.BytesSerde(), (Serde)subscriptionWrapperSerde);
    }
}

