/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.ForeignKeyExtractor;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.ResponseJoinProcessorSupplierTest;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionSendProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.processor.api.MockProcessorContext;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.internals.Murmur3;
import org.apache.kafka.test.MockInternalProcessorContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SubscriptionSendProcessorSupplierTest {
    private final Processor<String, Change<LeftValue>, String, SubscriptionWrapper<String>> leftJoinProcessor = new SubscriptionSendProcessorSupplier(ForeignKeyExtractor.fromFunction(LeftValue::getForeignKey), () -> "subscription-topic-fk", () -> "value-serde-topic", Serdes.String(), (Serializer)new LeftValueSerializer(), true).get();
    private final Processor<String, Change<LeftValue>, String, SubscriptionWrapper<String>> innerJoinProcessor = new SubscriptionSendProcessorSupplier(ForeignKeyExtractor.fromFunction(LeftValue::getForeignKey), () -> "subscription-topic-fk", () -> "value-serde-topic", Serdes.String(), (Serializer)new LeftValueSerializer(), false).get();
    private final String pk = "pk";
    private final String fk1 = "fk1";
    private final String fk2 = "fk2";
    private final Processor<String, Change<LeftValue>, String, SubscriptionWrapper<String>> biFunctionLeftJoinProcessor = new SubscriptionSendProcessorSupplier(ForeignKeyExtractor.fromBiFunction((key, value) -> value.getForeignKey() == null ? null : key + value.getForeignKey()), () -> "subscription-topic-fk", () -> "value-serde-topic", Serdes.String(), (Serializer)new LeftValueSerializer(), true).get();
    private final Processor<String, Change<LeftValue>, String, SubscriptionWrapper<String>> biFunctionInnerJoinProcessor = new SubscriptionSendProcessorSupplier(ForeignKeyExtractor.fromBiFunction((key, value) -> value.getForeignKey() == null ? null : key + value.getForeignKey()), () -> "subscription-topic-fk", () -> "value-serde-topic", Serdes.String(), (Serializer)new LeftValueSerializer(), false).get();

    @Test
    public void leftJoinShouldPropagateNewPrimaryKeyWithNonNullFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateNewPrimaryKeyWithNullFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record(null, (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateChangeOfFKFromNonNullToNonNullValue() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk2");
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue("fk1")), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(1)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk2", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateNewRecordOfUnchangedFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)leftRecordValue), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateChangeOfFKFromNonNullToNullValue() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue("fk1")), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateChangeFromNullFKToNonNullFKValue() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue(null)), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateChangeFromNullFKToNullFKValue() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)leftRecordValue), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record(null, (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateDeletionOfAPrimaryKey() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, (Object)new LeftValue("fk1")), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(null, SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateDeletionOfAPrimaryKeyThatHadNullFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, (Object)new LeftValue(null)), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record(null, (Object)new SubscriptionWrapper(null, SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateNothingWhenOldAndNewLeftValueIsNull() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
    }

    @Test
    public void innerJoinShouldPropagateNewPrimaryKey() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void innerJoinShouldNotPropagateNewPrimaryKeyWithNullFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
        Assertions.assertEquals((Object)1.0, (Object)ResponseJoinProcessorSupplierTest.getDroppedRecordsTotalMetric(context));
        Assertions.assertNotEquals((Object)0.0, (Object)ResponseJoinProcessorSupplierTest.getDroppedRecordsRateMetric(context));
    }

    @Test
    public void innerJoinShouldDeleteOldAndPropagateNewFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk2");
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue("fk1")), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(1)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk2", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void innerJoinShouldPropagateNothingWhenOldAndNewFKIsNull() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)leftRecordValue), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
    }

    @Test
    public void innerJoinShouldPropagateChangeFromNullFKToNonNullFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue(null)), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void innerJoinShouldDeleteAndPropagateChangeFromNonNullFKToNullFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue("fk1")), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void innerJoinShouldPropagateUnchangedFKOnlyIfFKExistsInRightTable() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)leftRecordValue), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void innerJoinShouldPropagateDeletionOfPrimaryKey() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, (Object)new LeftValue("fk1")), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(null, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void innerJoinShouldNotPropagateDeletionOfPrimaryKeyWhenPreviousFKIsNull() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, (Object)new LeftValue(null)), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
    }

    @Test
    public void innerJoinShouldPropagateNothingWhenOldAndNewLeftValueIsNull() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
    }

    @Test
    public void biFunctionLeftJoinShouldPropagateNewPrimaryKeyWithNonNullFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionLeftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.biFunctionLeftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, null), 0L));
        String compositeKey = "pkfk1";
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pkfk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void biFunctionLeftJoinShouldPropagateNewPrimaryKeyWithNullFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionLeftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.biFunctionLeftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record(null, (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void biFunctionLeftJoinShouldPropagateChangeOfFKFromNonNullToNonNullValue() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionLeftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk2");
        this.biFunctionLeftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue("fk1")), 0L));
        String compositeKey = "pkfk2";
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(1)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pkfk2", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void biFunctionLeftJoinShouldPropagateNewRecordOfUnchangedFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionLeftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.biFunctionLeftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)leftRecordValue), 0L));
        String compositeKey = "pkfk1";
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pkfk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void biFunctionLeftJoinShouldPropagateChangeOfFKFromNonNullToNullValue() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionLeftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.biFunctionLeftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue("fk1")), 0L));
        String compositeKey = "pkfk1";
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pkfk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void biFunctionLeftJoinShouldPropagateChangeFromNullFKToNonNullFKValue() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionLeftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        String compositeKey = "pkfk1";
        this.biFunctionLeftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue(null)), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pkfk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void biFunctionLeftJoinShouldPropagateChangeFromNullFKToNullFKValue() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionLeftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.biFunctionLeftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)leftRecordValue), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record(null, (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void biFunctionLeftJoinShouldPropagateDeletionOfAPrimaryKey() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionLeftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.biFunctionLeftJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, (Object)new LeftValue("fk1")), 0L));
        String compositeKey = "pkfk1";
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pkfk1", (Object)new SubscriptionWrapper(null, SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void biFunctionLeftJoinShouldPropagateDeletionOfAPrimaryKeyThatHadNullFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionLeftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.biFunctionLeftJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, (Object)new LeftValue(null)), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record(null, (Object)new SubscriptionWrapper(null, SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void biFunctionLeftJoinShouldPropagateNothingWhenOldAndNewLeftValueIsNull() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionLeftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.biFunctionLeftJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
    }

    @Test
    public void biFunctionInnerJoinShouldPropagateNewPrimaryKey() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionInnerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.biFunctionInnerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, null), 0L));
        String compositeKey = "pkfk1";
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pkfk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void biFunctionInnerJoinShouldNotPropagateNewPrimaryKeyWithNullFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionInnerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.biFunctionInnerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
        Assertions.assertEquals((Object)1.0, (Object)ResponseJoinProcessorSupplierTest.getDroppedRecordsTotalMetric(context));
        Assertions.assertNotEquals((Object)0.0, (Object)ResponseJoinProcessorSupplierTest.getDroppedRecordsRateMetric(context));
    }

    @Test
    public void biFunctionInnerJoinShouldDeleteOldAndPropagateNewFK() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionInnerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk2");
        this.biFunctionInnerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue("fk1")), 0L));
        String compositeKey1 = "pkfk1";
        String compositeKey2 = "pkfk2";
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pkfk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(1)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pkfk2", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void biFunctionInnerJoinShouldPropagateNothingWhenOldAndNewFKIsNull() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionInnerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.biFunctionInnerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)leftRecordValue), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
        Assertions.assertEquals((Object)1.0, (Object)ResponseJoinProcessorSupplierTest.getDroppedRecordsTotalMetric(context));
        Assertions.assertNotEquals((Object)0.0, (Object)ResponseJoinProcessorSupplierTest.getDroppedRecordsRateMetric(context));
    }

    @Test
    public void biFunctionInnerJoinShouldPropagateDeletionOfPrimaryKey() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionInnerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.biFunctionInnerJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, (Object)new LeftValue("fk1")), 0L));
        String compositeKey = "pkfk1";
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"pkfk1", (Object)new SubscriptionWrapper(null, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void biFunctionInnerJoinShouldPropagateNothingWhenOldAndNewLeftValueIsNull() {
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        this.biFunctionInnerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.biFunctionInnerJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
    }

    private static long[] hash(LeftValue value) {
        return Murmur3.hash128((byte[])new LeftValueSerializer().serialize("value-serde-topic", value));
    }

    private static class LeftValueSerializer
    implements Serializer<LeftValue> {
        private LeftValueSerializer() {
        }

        public byte[] serialize(String topic, LeftValue data) {
            if (data == null) {
                return null;
            }
            if (data.foreignKey == null) {
                return "null".getBytes();
            }
            return new StringSerializer().serialize(topic, data.getForeignKey());
        }
    }

    private static final class LeftValue {
        private final String foreignKey;

        public LeftValue(String value) {
            this.foreignKey = value;
        }

        public String getForeignKey() {
            return this.foreignKey;
        }
    }
}

