/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Collections;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapperSerde;
import org.apache.kafka.streams.state.internals.Murmur3;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SubscriptionWrapperSerdeTest {
    @Test
    public void shouldSerdeV0Test() {
        boolean version = false;
        String originalKey = "originalKey";
        SubscriptionWrapperSerde swSerde = new SubscriptionWrapperSerde(() -> "pkTopic", Serdes.String());
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{-1, -86, 0, 25});
        Integer primaryPartition = null;
        SubscriptionWrapper wrapper = new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)"originalKey", 0, primaryPartition);
        byte[] serialized = swSerde.serializer().serialize(null, (Object)wrapper);
        SubscriptionWrapper deserialized = (SubscriptionWrapper)swSerde.deserializer().deserialize(null, serialized);
        Assertions.assertEquals((Object)SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)deserialized.instruction());
        Assertions.assertArrayEquals((long[])hashedValue, (long[])deserialized.hash());
        Assertions.assertEquals((Object)"originalKey", (Object)deserialized.primaryKey());
        Assertions.assertEquals(primaryPartition, (Integer)deserialized.primaryPartition());
        Assertions.assertEquals((byte)0, (byte)deserialized.version());
    }

    @Test
    public void shouldSerdeV1Test() {
        boolean version = true;
        String originalKey = "originalKey";
        SubscriptionWrapperSerde swSerde = new SubscriptionWrapperSerde(() -> "pkTopic", Serdes.String());
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{-1, -86, 0, 25});
        Integer primaryPartition = 10;
        SubscriptionWrapper wrapper = new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)"originalKey", 1, primaryPartition);
        byte[] serialized = swSerde.serializer().serialize(null, (Object)wrapper);
        SubscriptionWrapper deserialized = (SubscriptionWrapper)swSerde.deserializer().deserialize(null, serialized);
        Assertions.assertEquals((Object)SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)deserialized.instruction());
        Assertions.assertArrayEquals((long[])hashedValue, (long[])deserialized.hash());
        Assertions.assertEquals((Object)"originalKey", (Object)deserialized.primaryKey());
        Assertions.assertEquals((Integer)primaryPartition, (Integer)deserialized.primaryPartition());
        Assertions.assertEquals((byte)1, (byte)deserialized.version());
    }

    @Test
    public void shouldSerdeWithV0IfUpgradeTest() {
        boolean version = true;
        String originalKey = "originalKey";
        SubscriptionWrapperSerde swSerde = new SubscriptionWrapperSerde(() -> "pkTopic", Serdes.String());
        swSerde.configure(Collections.singletonMap("upgrade.from", StreamsConfig.UPGRADE_FROM_32), true);
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{-1, -86, 0, 25});
        Integer primaryPartition = 10;
        SubscriptionWrapper wrapper = new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)"originalKey", 1, primaryPartition);
        byte[] serialized = swSerde.serializer().serialize(null, (Object)wrapper);
        SubscriptionWrapper deserialized = (SubscriptionWrapper)swSerde.deserializer().deserialize(null, serialized);
        Assertions.assertEquals((Object)SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)deserialized.instruction());
        Assertions.assertArrayEquals((long[])hashedValue, (long[])deserialized.hash());
        Assertions.assertEquals((Object)"originalKey", (Object)deserialized.primaryKey());
        Assertions.assertEquals((int)0, (int)deserialized.version());
        Assertions.assertNull((Object)deserialized.primaryPartition());
    }

    @Test
    public void shouldSerdeNullHashV0Test() {
        boolean version = false;
        String originalKey = "originalKey";
        SubscriptionWrapperSerde swSerde = new SubscriptionWrapperSerde(() -> "pkTopic", Serdes.String());
        long[] hashedValue = null;
        Integer primaryPartition = null;
        SubscriptionWrapper wrapper = new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"originalKey", 0, primaryPartition);
        byte[] serialized = swSerde.serializer().serialize(null, (Object)wrapper);
        SubscriptionWrapper deserialized = (SubscriptionWrapper)swSerde.deserializer().deserialize(null, serialized);
        Assertions.assertEquals((Object)SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)deserialized.instruction());
        Assertions.assertArrayEquals(hashedValue, (long[])deserialized.hash());
        Assertions.assertEquals((Object)"originalKey", (Object)deserialized.primaryKey());
        Assertions.assertEquals(primaryPartition, (Integer)deserialized.primaryPartition());
        Assertions.assertEquals((byte)0, (byte)deserialized.version());
    }

    @Test
    public void shouldSerdeNullHashV1Test() {
        boolean version = true;
        String originalKey = "originalKey";
        SubscriptionWrapperSerde swSerde = new SubscriptionWrapperSerde(() -> "pkTopic", Serdes.String());
        long[] hashedValue = null;
        Integer primaryPartition = 10;
        SubscriptionWrapper wrapper = new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"originalKey", 1, primaryPartition);
        byte[] serialized = swSerde.serializer().serialize(null, (Object)wrapper);
        SubscriptionWrapper deserialized = (SubscriptionWrapper)swSerde.deserializer().deserialize(null, serialized);
        Assertions.assertEquals((Object)SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)deserialized.instruction());
        Assertions.assertArrayEquals(hashedValue, (long[])deserialized.hash());
        Assertions.assertEquals((Object)"originalKey", (Object)deserialized.primaryKey());
        Assertions.assertEquals((Integer)primaryPartition, (Integer)deserialized.primaryPartition());
        Assertions.assertEquals((byte)1, (byte)deserialized.version());
    }

    @Test
    public void shouldSerdeNullPrimaryPartitionOnV0Test() {
        String originalKey = "originalKey";
        SubscriptionWrapperSerde swSerde = new SubscriptionWrapperSerde(() -> "pkTopic", Serdes.String());
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{-1, -86, 0, 25});
        Integer primaryPartition = null;
        boolean version = false;
        SubscriptionWrapper wrapper = new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"originalKey", 0, primaryPartition);
        byte[] serialized = swSerde.serializer().serialize(null, (Object)wrapper);
        SubscriptionWrapper deserialized = (SubscriptionWrapper)swSerde.deserializer().deserialize(null, serialized);
        Assertions.assertEquals((Object)SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)deserialized.instruction());
        Assertions.assertArrayEquals((long[])hashedValue, (long[])deserialized.hash());
        Assertions.assertEquals((Object)"originalKey", (Object)deserialized.primaryKey());
        Assertions.assertEquals(primaryPartition, (Integer)deserialized.primaryPartition());
        Assertions.assertEquals((byte)0, (byte)deserialized.version());
    }

    @Test
    public void shouldThrowExceptionOnNullKeyV0Test() {
        String originalKey = null;
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{-1, -86, 0, 25});
        Integer primaryPartition = 10;
        Assertions.assertThrows(NullPointerException.class, () -> new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)originalKey, 0, primaryPartition));
    }

    @Test
    public void shouldThrowExceptionOnNullKeyV1Test() {
        String originalKey = null;
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{-1, -86, 0, 25});
        Integer primaryPartition = 10;
        Assertions.assertThrows(NullPointerException.class, () -> new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)originalKey, 1, primaryPartition));
    }

    @Test
    public void shouldThrowExceptionOnNullInstructionV0Test() {
        String originalKey = "originalKey";
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{-1, -86, 0, 25});
        Integer primaryPartition = 10;
        Assertions.assertThrows(NullPointerException.class, () -> new SubscriptionWrapper(hashedValue, null, (Object)"originalKey", 0, primaryPartition));
    }

    @Test
    public void shouldThrowExceptionOnNullInstructionV1Test() {
        String originalKey = "originalKey";
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{-1, -86, 0, 25});
        Integer primaryPartition = 10;
        Assertions.assertThrows(NullPointerException.class, () -> new SubscriptionWrapper(hashedValue, null, (Object)"originalKey", 0, primaryPartition));
    }

    @Test
    public void shouldThrowExceptionOnNullPrimaryPartitionV1Test() {
        SubscriptionWrapperSerde swSerde = new SubscriptionWrapperSerde(() -> "pkTopic", Serdes.String());
        String originalKey = "originalKey";
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{-1, -86, 0, 25});
        Integer primaryPartition = null;
        SubscriptionWrapper wrapper = new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"originalKey", 1, primaryPartition);
        Assertions.assertThrows(NullPointerException.class, () -> swSerde.serializer().serialize(null, (Object)wrapper));
    }

    @Test
    public void shouldThrowExceptionOnUnsupportedVersionTest() {
        String originalKey = "originalKey";
        long[] hashedValue = null;
        Integer primaryPartition = 10;
        Assertions.assertThrows(UnsupportedVersionException.class, () -> new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"originalKey", -128, primaryPartition));
    }
}

