/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.time.Duration;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.KStreamSessionWindowAggregate;
import org.apache.kafka.streams.kstream.internals.KStreamWindowAggregate;
import org.apache.kafka.streams.kstream.internals.graph.GraphGraceSearchUtil;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorGraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.utils.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GraphGraceSearchUtilTest {
    @Test
    public void shouldThrowOnNull() {
        try {
            GraphGraceSearchUtil.findAndVerifyWindowGrace(null);
            Assertions.fail((String)"Should have thrown.");
        }
        catch (TopologyException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Invalid topology: Window close time is only defined for windowed computations. Got []."));
        }
    }

    @Test
    public void shouldFailIfThereIsNoGraceAncestor() {
        ProcessorGraphNode gracelessAncestor = new ProcessorGraphNode("graceless", new ProcessorParameters(() -> new Processor<String, Long, String, Long>(){

            public void process(Record<String, Long> record) {
            }
        }, "graceless"));
        ProcessorGraphNode node = new ProcessorGraphNode("stateless", new ProcessorParameters(() -> new Processor<String, Long, String, Long>(){

            public void process(Record<String, Long> record) {
            }
        }, "stateless"));
        gracelessAncestor.addChild((GraphNode)node);
        try {
            GraphGraceSearchUtil.findAndVerifyWindowGrace((GraphNode)node);
            Assertions.fail((String)"should have thrown.");
        }
        catch (TopologyException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Invalid topology: Window close time is only defined for windowed computations. Got [graceless->stateless]."));
        }
    }

    @Test
    public void shouldExtractGraceFromKStreamWindowAggregateNode() {
        TimeWindows windows = TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(1234L));
        ProcessorGraphNode node = new ProcessorGraphNode("asdf", new ProcessorParameters((ProcessorSupplier)new KStreamWindowAggregate((Windows)windows, TestUtils.mockStoreFactory("asdf"), EmitStrategy.onWindowUpdate(), null, null), "asdf"));
        long extracted = GraphGraceSearchUtil.findAndVerifyWindowGrace((GraphNode)node);
        MatcherAssert.assertThat((Object)extracted, (Matcher)CoreMatchers.is((Object)windows.gracePeriodMs()));
    }

    @Test
    public void shouldExtractGraceFromKStreamSessionWindowAggregateNode() {
        SessionWindows windows = SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(1234L));
        ProcessorGraphNode node = new ProcessorGraphNode("asdf", new ProcessorParameters((ProcessorSupplier)new KStreamSessionWindowAggregate(windows, TestUtils.mockStoreFactory("asdf"), EmitStrategy.onWindowUpdate(), null, null, null), "asdf"));
        long extracted = GraphGraceSearchUtil.findAndVerifyWindowGrace((GraphNode)node);
        MatcherAssert.assertThat((Object)extracted, (Matcher)CoreMatchers.is((Object)(windows.gracePeriodMs() + windows.inactivityGap())));
    }

    @Test
    public void shouldExtractGraceFromSessionAncestorThroughStatefulParent() {
        SessionWindows windows = SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(1234L));
        ProcessorGraphNode graceGrandparent = new ProcessorGraphNode("asdf", new ProcessorParameters((ProcessorSupplier)new KStreamSessionWindowAggregate(windows, TestUtils.mockStoreFactory("asdf"), EmitStrategy.onWindowUpdate(), null, null, null), "asdf"));
        ProcessorGraphNode statefulParent = new ProcessorGraphNode("stateful", new ProcessorParameters(() -> new Processor<String, Long, String, Long>(){

            public void process(Record<String, Long> record) {
            }
        }, "dummy"));
        graceGrandparent.addChild((GraphNode)statefulParent);
        ProcessorGraphNode node = new ProcessorGraphNode("stateless", new ProcessorParameters(() -> new Processor<String, Long, String, Long>(){

            public void process(Record<String, Long> record) {
            }
        }, "dummyChild-graceless"));
        statefulParent.addChild((GraphNode)node);
        long extracted = GraphGraceSearchUtil.findAndVerifyWindowGrace((GraphNode)node);
        MatcherAssert.assertThat((Object)extracted, (Matcher)CoreMatchers.is((Object)(windows.gracePeriodMs() + windows.inactivityGap())));
    }

    @Test
    public void shouldExtractGraceFromSessionAncestorThroughStatelessParent() {
        SessionWindows windows = SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(1234L));
        ProcessorGraphNode graceGrandparent = new ProcessorGraphNode("asdf", new ProcessorParameters((ProcessorSupplier)new KStreamSessionWindowAggregate(windows, TestUtils.mockStoreFactory("asdf"), EmitStrategy.onWindowUpdate(), null, null, null), "asdf"));
        ProcessorGraphNode statelessParent = new ProcessorGraphNode("statelessParent", new ProcessorParameters(() -> new Processor<String, Long, String, Long>(){

            public void process(Record<String, Long> record) {
            }
        }, "statelessParent"));
        graceGrandparent.addChild((GraphNode)statelessParent);
        ProcessorGraphNode node = new ProcessorGraphNode("stateless", new ProcessorParameters(() -> new Processor<String, Long, String, Long>(){

            public void process(Record<String, Long> record) {
            }
        }, "stateless"));
        statelessParent.addChild((GraphNode)node);
        long extracted = GraphGraceSearchUtil.findAndVerifyWindowGrace((GraphNode)node);
        MatcherAssert.assertThat((Object)extracted, (Matcher)CoreMatchers.is((Object)(windows.gracePeriodMs() + windows.inactivityGap())));
    }

    @Test
    public void shouldUseMaxIfMultiParentsDoNotAgreeOnGrace() {
        ProcessorGraphNode leftParent = new ProcessorGraphNode("asdf", new ProcessorParameters((ProcessorSupplier)new KStreamSessionWindowAggregate(SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(1234L)), TestUtils.mockStoreFactory("asdf"), EmitStrategy.onWindowUpdate(), null, null, null), "asdf"));
        ProcessorGraphNode rightParent = new ProcessorGraphNode("asdf", new ProcessorParameters((ProcessorSupplier)new KStreamWindowAggregate((Windows)TimeWindows.ofSizeAndGrace((Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(4321L)), TestUtils.mockStoreFactory("asdf"), EmitStrategy.onWindowUpdate(), null, null), "asdf"));
        ProcessorGraphNode node = new ProcessorGraphNode("stateless", new ProcessorParameters(() -> new Processor<String, Long, String, Long>(){

            public void process(Record<String, Long> record) {
            }
        }, "stateless"));
        leftParent.addChild((GraphNode)node);
        rightParent.addChild((GraphNode)node);
        long extracted = GraphGraceSearchUtil.findAndVerifyWindowGrace((GraphNode)node);
        MatcherAssert.assertThat((Object)extracted, (Matcher)CoreMatchers.is((Object)4321L));
    }
}

