/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import java.util.LinkedList;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class ReadOnlyStoreTest {
    @Test
    public void shouldConnectProcessorAndWriteDataToReadOnlyStore() {
        Topology topology = new Topology();
        topology.addReadOnlyStateStore(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"readOnlyStore"), (Serde)new Serdes.IntegerSerde(), (Serde)new Serdes.StringSerde()), "readOnlySource", (Deserializer)new IntegerDeserializer(), (Deserializer)new StringDeserializer(), "storeTopic", "readOnlyProcessor", () -> new Processor<Integer, String, Void, Void>(){
            KeyValueStore<Integer, String> store;

            public void init(ProcessorContext<Void, Void> context) {
                this.store = (KeyValueStore)context.getStateStore("readOnlyStore");
            }

            public void process(Record<Integer, String> record) {
                this.store.put((Object)((Integer)record.key()), (Object)((String)record.value()));
            }
        });
        topology.addSource("source", (Deserializer)new IntegerDeserializer(), (Deserializer)new StringDeserializer(), new String[]{"inputTopic"});
        topology.addProcessor("processor", () -> new Processor<Integer, String, Integer, String>(){
            ProcessorContext<Integer, String> context;
            KeyValueStore<Integer, String> store;

            public void init(ProcessorContext<Integer, String> context) {
                this.context = context;
                this.store = (KeyValueStore)context.getStateStore("readOnlyStore");
            }

            public void process(Record<Integer, String> record) {
                this.context.forward(record.withValue((Object)((String)record.value() + " -- " + (String)this.store.get((Object)((Integer)record.key())))));
            }
        }, new String[]{"source"});
        topology.connectProcessorAndStateStores("processor", new String[]{"readOnlyStore"});
        topology.addSink("sink", "outputTopic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), new String[]{"processor"});
        try (TopologyTestDriver driver = new TopologyTestDriver(topology);){
            TestInputTopic readOnlyStoreTopic = driver.createInputTopic("storeTopic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
            TestInputTopic input = driver.createInputTopic("inputTopic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic output = driver.createOutputTopic("outputTopic", (Deserializer)new IntegerDeserializer(), (Deserializer)new StringDeserializer());
            readOnlyStoreTopic.pipeInput((Object)1, (Object)"foo");
            readOnlyStoreTopic.pipeInput((Object)2, (Object)"bar");
            input.pipeInput((Object)1, (Object)"bar");
            input.pipeInput((Object)2, (Object)"foo");
            KeyValueStore store = driver.getKeyValueStore("readOnlyStore");
            try (KeyValueIterator it = store.all();){
                LinkedList storeContent = new LinkedList();
                it.forEachRemaining(storeContent::add);
                LinkedList<KeyValue> expectedResult = new LinkedList<KeyValue>();
                expectedResult.add(KeyValue.pair((Object)1, (Object)"foo"));
                expectedResult.add(KeyValue.pair((Object)2, (Object)"bar"));
                MatcherAssert.assertThat(storeContent, (Matcher)Matchers.equalTo(expectedResult));
            }
            LinkedList<KeyValue> expectedResult = new LinkedList<KeyValue>();
            expectedResult.add(KeyValue.pair((Object)1, (Object)"bar -- foo"));
            expectedResult.add(KeyValue.pair((Object)2, (Object)"foo -- bar"));
            MatcherAssert.assertThat((Object)output.readKeyValuesToList(), (Matcher)Matchers.equalTo(expectedResult));
        }
    }
}

