/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.ActiveTaskCreator;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamsProducer;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockClientSupplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class ActiveTaskCreatorTest {
    @Mock
    private InternalTopologyBuilder builder;
    @Mock
    private StateDirectory stateDirectory;
    @Mock
    private ChangelogReader changeLogReader;
    private final MockClientSupplier mockClientSupplier = new MockClientSupplier();
    private final StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "clientId", "processId", (Time)new MockTime());
    private final Map<String, Object> properties = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234")});
    final UUID uuid = UUID.randomUUID();
    private ActiveTaskCreator activeTaskCreator;

    @Test
    public void shouldConstructProducerMetricsWithEosDisabled() {
        this.shouldConstructStreamsProducerMetric();
    }

    @Test
    public void shouldConstructClientIdWithEosDisabled() {
        this.createTasks();
        String clientIds = this.activeTaskCreator.producerClientIds();
        MatcherAssert.assertThat((Object)clientIds, (Matcher)CoreMatchers.is((Object)"clientId-StreamThread-0-producer"));
    }

    @Test
    public void shouldCloseIfEosDisabled() {
        this.createTasks();
        this.activeTaskCreator.close();
        MatcherAssert.assertThat((Object)this.mockClientSupplier.producers.get(0).closed(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldReturnBlockedTimeWhenStreamsProducer() {
        double blockedTime = 123.0;
        this.createTasks();
        MockProducer<byte[], byte[]> producer = this.mockClientSupplier.producers.get(0);
        this.addMetric(producer, "flush-time-ns-total", 123.0);
        MatcherAssert.assertThat((Object)this.activeTaskCreator.totalProducerBlockedTime(), (Matcher)Matchers.closeTo((double)123.0, (double)0.01));
    }

    @Test
    public void shouldReturnStreamsProducerIfAtLeastOnceIsEnabled() {
        this.createTasks();
        StreamsProducer threadProducer = this.activeTaskCreator.streamsProducer();
        MatcherAssert.assertThat((Object)this.mockClientSupplier.producers.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)threadProducer.kafkaProducer(), (Matcher)CoreMatchers.is((Object)((Producer)this.mockClientSupplier.producers.get(0))));
    }

    @Test
    public void shouldThrowStreamsExceptionOnErrorCloseIfEosDisabled() {
        this.createTasks();
        this.mockClientSupplier.producers.get((int)0).closeException = new RuntimeException("KABOOM!");
        StreamsException thrown = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> ((ActiveTaskCreator)this.activeTaskCreator).close());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.is((Object)"Thread producer encounter error trying to close."));
        MatcherAssert.assertThat((Object)thrown.getCause().getMessage(), (Matcher)CoreMatchers.is((Object)"KABOOM!"));
    }

    @Test
    public void shouldReturnStreamsProducerIfEosV2Enabled() {
        this.properties.put("processing.guarantee", "exactly_once_v2");
        this.mockClientSupplier.setApplicationIdForProducer("appId");
        this.createTasks();
        StreamsProducer threadProducer = this.activeTaskCreator.streamsProducer();
        MatcherAssert.assertThat((Object)this.mockClientSupplier.producers.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)threadProducer.kafkaProducer(), (Matcher)CoreMatchers.is((Object)((Producer)this.mockClientSupplier.producers.get(0))));
    }

    @Test
    public void shouldConstructProducerMetricsWithEosV2Enabled() {
        this.properties.put("processing.guarantee", "exactly_once_v2");
        this.mockClientSupplier.setApplicationIdForProducer("appId");
        this.shouldConstructStreamsProducerMetric();
    }

    @Test
    public void shouldConstructClientIdWithEosV2Enabled() {
        this.properties.put("processing.guarantee", "exactly_once_v2");
        this.mockClientSupplier.setApplicationIdForProducer("appId");
        this.createTasks();
        String clientIds = this.activeTaskCreator.producerClientIds();
        MatcherAssert.assertThat((Object)clientIds, (Matcher)CoreMatchers.is((Object)"clientId-StreamThread-0-producer"));
    }

    @Test
    public void shouldCloseIfEosV2Enabled() {
        this.properties.put("processing.guarantee", "exactly_once_v2");
        this.mockClientSupplier.setApplicationIdForProducer("appId");
        this.createTasks();
        this.activeTaskCreator.close();
        MatcherAssert.assertThat((Object)this.activeTaskCreator.isClosed(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.mockClientSupplier.producers.get(0).closed(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldNotResetProducerAfterDisableRest() {
        this.properties.put("processing.guarantee", "exactly_once_v2");
        this.mockClientSupplier.setApplicationIdForProducer("appId");
        this.createTasks();
        MatcherAssert.assertThat((Object)this.mockClientSupplier.producers.size(), (Matcher)CoreMatchers.is((Object)1));
        this.activeTaskCreator.close();
        this.activeTaskCreator.reInitializeProducer();
        MatcherAssert.assertThat((String)"Producer should not be recreated after disabling reset", (Object)this.mockClientSupplier.producers.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void shouldThrowStreamsExceptionOnErrorCloseIfEosV2Enabled() {
        this.properties.put("processing.guarantee", "exactly_once_v2");
        this.mockClientSupplier.setApplicationIdForProducer("appId");
        this.createTasks();
        this.mockClientSupplier.producers.get((int)0).closeException = new RuntimeException("KABOOM!");
        StreamsException thrown = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> ((ActiveTaskCreator)this.activeTaskCreator).close());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.is((Object)"Thread producer encounter error trying to close."));
        MatcherAssert.assertThat((Object)thrown.getCause().getMessage(), (Matcher)CoreMatchers.is((Object)"KABOOM!"));
    }

    private void shouldConstructStreamsProducerMetric() {
        this.createTasks();
        MetricName testMetricName = new MetricName("test_metric", "", "", new HashMap());
        KafkaMetric testMetric = new KafkaMetric(new Object(), testMetricName, (MetricValueProvider)((Measurable)(config, now) -> 0.0), null, (Time)new MockTime());
        this.mockClientSupplier.producers.get(0).setMockMetrics(testMetricName, (Metric)testMetric);
        MatcherAssert.assertThat((Object)this.mockClientSupplier.producers.size(), (Matcher)CoreMatchers.is((Object)1));
        Map producerMetrics = this.activeTaskCreator.producerMetrics();
        MatcherAssert.assertThat((Object)producerMetrics.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Metric)producerMetrics.get(testMetricName)), (Matcher)CoreMatchers.is((Object)testMetric));
    }

    private void createTasks() {
        TaskId task00 = new TaskId(0, 0);
        TaskId task01 = new TaskId(0, 1);
        ProcessorTopology topology = (ProcessorTopology)Mockito.mock(ProcessorTopology.class);
        SourceNode sourceNode = (SourceNode)Mockito.mock(SourceNode.class);
        Mockito.when((Object)this.builder.topologyConfigs()).thenReturn((Object)new TopologyConfig(new StreamsConfig(this.properties)));
        Mockito.when((Object)this.builder.buildSubtopology(0)).thenReturn((Object)topology);
        Mockito.when((Object)topology.sinkTopics()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.stateDirectory.getOrCreateDirectoryForTask(task00)).thenReturn((Object)((File)Mockito.mock(File.class)));
        Mockito.when((Object)this.stateDirectory.checkpointFileFor(task00)).thenReturn((Object)((File)Mockito.mock(File.class)));
        Mockito.when((Object)this.stateDirectory.getOrCreateDirectoryForTask(task01)).thenReturn((Object)((File)Mockito.mock(File.class)));
        Mockito.when((Object)this.stateDirectory.checkpointFileFor(task01)).thenReturn((Object)((File)Mockito.mock(File.class)));
        Mockito.when((Object)topology.source("topic")).thenReturn((Object)sourceNode);
        Mockito.when((Object)sourceNode.timestampExtractor()).thenReturn((Object)((TimestampExtractor)Mockito.mock(TimestampExtractor.class)));
        Mockito.when((Object)topology.sources()).thenReturn(Collections.singleton(sourceNode));
        StreamsConfig config = new StreamsConfig(this.properties);
        this.activeTaskCreator = new ActiveTaskCreator(new TopologyMetadata(this.builder, config), config, this.streamsMetrics, this.stateDirectory, this.changeLogReader, new ThreadCache(new LogContext(), 0L, this.streamsMetrics), (Time)new MockTime(), (KafkaClientSupplier)this.mockClientSupplier, "clientId-StreamThread-0", 0, this.uuid, new LogContext().logger(ActiveTaskCreator.class), false, false);
        MatcherAssert.assertThat(this.activeTaskCreator.createTasks(this.mockClientSupplier.consumer, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)task00, Collections.singleton(new TopicPartition("topic", 0))), Utils.mkEntry((Object)task01, Collections.singleton(new TopicPartition("topic", 1)))})).stream().map(Task::id).collect(Collectors.toSet()), (Matcher)CoreMatchers.equalTo(Set.of(task00, task01)));
    }

    private void addMetric(MockProducer<?, ?> producer, String name, final double value) {
        final MetricName metricName = this.metricName(name);
        producer.setMockMetrics(metricName, new Metric(){

            public MetricName metricName() {
                return metricName;
            }

            public Object metricValue() {
                return value;
            }
        });
    }

    private MetricName metricName(String name) {
        return new MetricName(name, "", "", Collections.emptyMap());
    }
}

