/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.kafka.streams.processor.internals.RepartitionTopicConfig;
import org.apache.kafka.streams.processor.internals.assignment.CopartitionedTopicsEnforcer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CopartitionedTopicsEnforcerTest {
    private final CopartitionedTopicsEnforcer validator = new CopartitionedTopicsEnforcer("thread ");
    private final Map<TopicPartition, PartitionInfo> partitions = new HashMap<TopicPartition, PartitionInfo>();
    private final Cluster cluster = Cluster.empty();

    @BeforeEach
    public void before() {
        this.partitions.put(new TopicPartition("first", 0), new PartitionInfo("first", 0, null, null, null));
        this.partitions.put(new TopicPartition("first", 1), new PartitionInfo("first", 1, null, null, null));
        this.partitions.put(new TopicPartition("second", 0), new PartitionInfo("second", 0, null, null, null));
        this.partitions.put(new TopicPartition("second", 1), new PartitionInfo("second", 1, null, null, null));
    }

    @Test
    public void shouldThrowTopologyBuilderExceptionIfNoPartitionsFoundForCoPartitionedTopic() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.validator.enforce(Collections.singleton("topic"), Collections.emptyMap(), this.cluster));
    }

    @Test
    public void shouldThrowTopologyBuilderExceptionIfPartitionCountsForCoPartitionedTopicsDontMatch() {
        this.partitions.remove(new TopicPartition("second", 0));
        Assertions.assertThrows(TopologyException.class, () -> this.validator.enforce(Set.of("first", "second"), Collections.emptyMap(), this.cluster.withPartitions(this.partitions)));
    }

    @Test
    public void shouldEnforceCopartitioningOnRepartitionTopics() {
        InternalTopicConfig config = this.createTopicConfig("repartitioned", 10);
        this.validator.enforce(Set.of("first", "second", config.name()), Collections.singletonMap(config.name(), config), this.cluster.withPartitions(this.partitions));
        MatcherAssert.assertThat((Object)config.numberOfPartitions(), (Matcher)CoreMatchers.equalTo(Optional.of(2)));
    }

    @Test
    public void shouldSetNumPartitionsToMaximumPartitionsWhenAllTopicsAreRepartitionTopics() {
        InternalTopicConfig one = this.createTopicConfig("one", 1);
        InternalTopicConfig two = this.createTopicConfig("two", 15);
        InternalTopicConfig three = this.createTopicConfig("three", 5);
        HashMap<String, InternalTopicConfig> repartitionTopicConfig = new HashMap<String, InternalTopicConfig>();
        repartitionTopicConfig.put(one.name(), one);
        repartitionTopicConfig.put(two.name(), two);
        repartitionTopicConfig.put(three.name(), three);
        this.validator.enforce(Set.of(one.name(), two.name(), three.name()), repartitionTopicConfig, this.cluster);
        MatcherAssert.assertThat((Object)one.numberOfPartitions(), (Matcher)CoreMatchers.equalTo(Optional.of(15)));
        MatcherAssert.assertThat((Object)two.numberOfPartitions(), (Matcher)CoreMatchers.equalTo(Optional.of(15)));
        MatcherAssert.assertThat((Object)three.numberOfPartitions(), (Matcher)CoreMatchers.equalTo(Optional.of(15)));
    }

    @Test
    public void shouldThrowAnExceptionIfRepartitionTopicConfigsWithEnforcedNumOfPartitionsHaveDifferentNumOfPartitions() {
        InternalTopicConfig topic1 = this.createRepartitionTopicConfigWithEnforcedNumberOfPartitions("repartitioned-1", 10);
        InternalTopicConfig topic2 = this.createRepartitionTopicConfigWithEnforcedNumberOfPartitions("repartitioned-2", 5);
        TopologyException ex = (TopologyException)Assertions.assertThrows(TopologyException.class, () -> this.validator.enforce(Set.of(topic1.name(), topic2.name()), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topic1.name(), (Object)topic1), Utils.mkEntry((Object)topic2.name(), (Object)topic2)}), this.cluster.withPartitions(this.partitions)));
        TreeMap sorted = new TreeMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topic1.name(), (Object)((Integer)topic1.numberOfPartitions().get())), Utils.mkEntry((Object)topic2.name(), (Object)((Integer)topic2.numberOfPartitions().get()))}));
        Assertions.assertEquals((Object)String.format("Invalid topology: thread Following topics do not have the same number of partitions: [%s]", sorted), (Object)ex.getMessage());
    }

    @Test
    public void shouldNotThrowAnExceptionWhenRepartitionTopicConfigsWithEnforcedNumOfPartitionsAreValid() {
        InternalTopicConfig topic1 = this.createRepartitionTopicConfigWithEnforcedNumberOfPartitions("repartitioned-1", 10);
        InternalTopicConfig topic2 = this.createRepartitionTopicConfigWithEnforcedNumberOfPartitions("repartitioned-2", 10);
        this.validator.enforce(Set.of(topic1.name(), topic2.name()), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topic1.name(), (Object)topic1), Utils.mkEntry((Object)topic2.name(), (Object)topic2)}), this.cluster.withPartitions(this.partitions));
        MatcherAssert.assertThat((Object)topic1.numberOfPartitions(), (Matcher)CoreMatchers.equalTo(Optional.of(10)));
        MatcherAssert.assertThat((Object)topic2.numberOfPartitions(), (Matcher)CoreMatchers.equalTo(Optional.of(10)));
    }

    @Test
    public void shouldThrowAnExceptionWhenNumberOfPartitionsOfNonRepartitionTopicAndRepartitionTopicWithEnforcedNumOfPartitionsDoNotMatch() {
        InternalTopicConfig topic1 = this.createRepartitionTopicConfigWithEnforcedNumberOfPartitions("repartitioned-1", 10);
        TopologyException ex = (TopologyException)Assertions.assertThrows(TopologyException.class, () -> this.validator.enforce(Set.of(topic1.name(), "second"), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topic1.name(), (Object)topic1)}), this.cluster.withPartitions(this.partitions)));
        Assertions.assertEquals((Object)String.format("Invalid topology: thread Number of partitions [%s] of repartition topic [%s] doesn't match number of partitions [%s] of the source topic.", topic1.numberOfPartitions().get(), topic1.name(), 2), (Object)ex.getMessage());
    }

    @Test
    public void shouldNotThrowAnExceptionWhenNumberOfPartitionsOfNonRepartitionTopicAndRepartitionTopicWithEnforcedNumOfPartitionsMatch() {
        InternalTopicConfig topic1 = this.createRepartitionTopicConfigWithEnforcedNumberOfPartitions("repartitioned-1", 2);
        this.validator.enforce(Set.of(topic1.name(), "second"), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topic1.name(), (Object)topic1)}), this.cluster.withPartitions(this.partitions));
        MatcherAssert.assertThat((Object)topic1.numberOfPartitions(), (Matcher)CoreMatchers.equalTo(Optional.of(2)));
    }

    @Test
    public void shouldDeductNumberOfPartitionsFromRepartitionTopicWithEnforcedNumberOfPartitions() {
        InternalTopicConfig topic1 = this.createRepartitionTopicConfigWithEnforcedNumberOfPartitions("repartitioned-1", 2);
        InternalTopicConfig topic2 = this.createTopicConfig("repartitioned-2", 5);
        InternalTopicConfig topic3 = this.createRepartitionTopicConfigWithEnforcedNumberOfPartitions("repartitioned-3", 2);
        this.validator.enforce(Set.of(topic1.name(), topic2.name()), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topic1.name(), (Object)topic1), Utils.mkEntry((Object)topic2.name(), (Object)topic2), Utils.mkEntry((Object)topic3.name(), (Object)topic3)}), this.cluster.withPartitions(this.partitions));
        Assertions.assertEquals((Object)topic1.numberOfPartitions(), (Object)topic2.numberOfPartitions());
        Assertions.assertEquals((Object)topic2.numberOfPartitions(), (Object)topic3.numberOfPartitions());
    }

    private InternalTopicConfig createTopicConfig(String repartitionTopic, int partitions) {
        RepartitionTopicConfig repartitionTopicConfig = new RepartitionTopicConfig(repartitionTopic, Collections.emptyMap());
        repartitionTopicConfig.setNumberOfPartitions(partitions);
        return repartitionTopicConfig;
    }

    private InternalTopicConfig createRepartitionTopicConfigWithEnforcedNumberOfPartitions(String repartitionTopic, int partitions) {
        return new RepartitionTopicConfig(repartitionTopic, Collections.emptyMap(), partitions, true);
    }
}

