/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.GlobalProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.GlobalStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowStore;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class GlobalProcessorContextImplTest {
    private static final String GLOBAL_STORE_NAME = "global-store";
    private static final String GLOBAL_KEY_VALUE_STORE_NAME = "global-key-value-store";
    private static final String GLOBAL_TIMESTAMPED_KEY_VALUE_STORE_NAME = "global-timestamped-key-value-store";
    private static final String GLOBAL_WINDOW_STORE_NAME = "global-window-store";
    private static final String GLOBAL_TIMESTAMPED_WINDOW_STORE_NAME = "global-timestamped-window-store";
    private static final String GLOBAL_SESSION_STORE_NAME = "global-session-store";
    private static final String UNKNOWN_STORE = "unknown-store";
    private GlobalProcessorContextImpl globalContext;
    @Mock
    private ProcessorNode<Object, Object, Object, Object> child;
    private ProcessorRecordContext recordContext;
    @Mock
    private GlobalStateManager stateManager;

    @BeforeEach
    public void setup() {
        StreamsConfig streamsConfig = (StreamsConfig)Mockito.mock(StreamsConfig.class);
        Mockito.when((Object)streamsConfig.getString("application.id")).thenReturn((Object)"dummy-id");
        this.globalContext = new GlobalProcessorContextImpl(streamsConfig, this.stateManager, null, null, Time.SYSTEM);
        ProcessorNode processorNode = new ProcessorNode("testNode");
        processorNode.addChild(this.child);
        this.globalContext.setCurrentNode(processorNode);
        this.recordContext = (ProcessorRecordContext)Mockito.mock(ProcessorRecordContext.class);
        this.globalContext.setRecordContext(this.recordContext);
    }

    @Test
    public void shouldReturnGlobalOrNullStore() {
        Mockito.when((Object)this.stateManager.globalStore(GLOBAL_STORE_NAME)).thenReturn((Object)((StateStore)Mockito.mock(StateStore.class)));
        MatcherAssert.assertThat((Object)this.globalContext.getStateStore(GLOBAL_STORE_NAME), (Matcher)new IsInstanceOf(StateStore.class));
        Assertions.assertNull((Object)this.globalContext.getStateStore(UNKNOWN_STORE));
    }

    @Test
    public void shouldForwardToSingleChild() {
        ((ProcessorNode)Mockito.doNothing().when(this.child)).process((Record)ArgumentMatchers.any());
        Mockito.when((Object)this.recordContext.timestamp()).thenReturn((Object)0L);
        Mockito.when((Object)this.recordContext.headers()).thenReturn((Object)new RecordHeaders());
        this.globalContext.forward(null, null);
    }

    @Test
    public void shouldFailToForwardUsingToParameter() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.globalContext.forward(null, null, To.all()));
    }

    @Test
    public void shouldNotFailOnNoOpCommit() {
        this.globalContext.commit();
    }

    @Test
    public void shouldNotAllowToSchedulePunctuations() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.globalContext.schedule(null, null, null));
    }

    @Test
    public void shouldNotAllowInitForKeyValueStore() {
        Mockito.when((Object)this.stateManager.globalStore(GLOBAL_KEY_VALUE_STORE_NAME)).thenReturn((Object)((StateStore)Mockito.mock(KeyValueStore.class)));
        StateStore store = this.globalContext.getStateStore(GLOBAL_KEY_VALUE_STORE_NAME);
        try {
            store.init(null, null);
            Assertions.fail((String)"Should have thrown UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowInitForTimestampedKeyValueStore() {
        Mockito.when((Object)this.stateManager.globalStore(GLOBAL_TIMESTAMPED_KEY_VALUE_STORE_NAME)).thenReturn((Object)((StateStore)Mockito.mock(TimestampedKeyValueStore.class)));
        StateStore store = this.globalContext.getStateStore(GLOBAL_TIMESTAMPED_KEY_VALUE_STORE_NAME);
        try {
            store.init(null, null);
            Assertions.fail((String)"Should have thrown UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowInitForWindowStore() {
        Mockito.when((Object)this.stateManager.globalStore(GLOBAL_WINDOW_STORE_NAME)).thenReturn((Object)((StateStore)Mockito.mock(WindowStore.class)));
        StateStore store = this.globalContext.getStateStore(GLOBAL_WINDOW_STORE_NAME);
        try {
            store.init(null, null);
            Assertions.fail((String)"Should have thrown UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowInitForTimestampedWindowStore() {
        Mockito.when((Object)this.stateManager.globalStore(GLOBAL_TIMESTAMPED_WINDOW_STORE_NAME)).thenReturn((Object)((StateStore)Mockito.mock(TimestampedWindowStore.class)));
        StateStore store = this.globalContext.getStateStore(GLOBAL_TIMESTAMPED_WINDOW_STORE_NAME);
        try {
            store.init(null, null);
            Assertions.fail((String)"Should have thrown UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowInitForSessionStore() {
        Mockito.when((Object)this.stateManager.globalStore(GLOBAL_SESSION_STORE_NAME)).thenReturn((Object)((StateStore)Mockito.mock(SessionStore.class)));
        StateStore store = this.globalContext.getStateStore(GLOBAL_SESSION_STORE_NAME);
        try {
            store.init(null, null);
            Assertions.fail((String)"Should have thrown UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowCloseForKeyValueStore() {
        Mockito.when((Object)this.stateManager.globalStore(GLOBAL_KEY_VALUE_STORE_NAME)).thenReturn((Object)((StateStore)Mockito.mock(KeyValueStore.class)));
        StateStore store = this.globalContext.getStateStore(GLOBAL_KEY_VALUE_STORE_NAME);
        try {
            store.close();
            Assertions.fail((String)"Should have thrown UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowCloseForTimestampedKeyValueStore() {
        Mockito.when((Object)this.stateManager.globalStore(GLOBAL_TIMESTAMPED_KEY_VALUE_STORE_NAME)).thenReturn((Object)((StateStore)Mockito.mock(TimestampedKeyValueStore.class)));
        StateStore store = this.globalContext.getStateStore(GLOBAL_TIMESTAMPED_KEY_VALUE_STORE_NAME);
        try {
            store.close();
            Assertions.fail((String)"Should have thrown UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowCloseForWindowStore() {
        Mockito.when((Object)this.stateManager.globalStore(GLOBAL_WINDOW_STORE_NAME)).thenReturn((Object)((StateStore)Mockito.mock(WindowStore.class)));
        StateStore store = this.globalContext.getStateStore(GLOBAL_WINDOW_STORE_NAME);
        try {
            store.close();
            Assertions.fail((String)"Should have thrown UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowCloseForTimestampedWindowStore() {
        Mockito.when((Object)this.stateManager.globalStore(GLOBAL_TIMESTAMPED_WINDOW_STORE_NAME)).thenReturn((Object)((StateStore)Mockito.mock(TimestampedWindowStore.class)));
        StateStore store = this.globalContext.getStateStore(GLOBAL_TIMESTAMPED_WINDOW_STORE_NAME);
        try {
            store.close();
            Assertions.fail((String)"Should have thrown UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowCloseForSessionStore() {
        Mockito.when((Object)this.stateManager.globalStore(GLOBAL_SESSION_STORE_NAME)).thenReturn((Object)((StateStore)Mockito.mock(SessionStore.class)));
        StateStore store = this.globalContext.getStateStore(GLOBAL_SESSION_STORE_NAME);
        try {
            store.close();
            Assertions.fail((String)"Should have thrown UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnCurrentStreamTime() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.globalContext.currentStreamTimeMs());
    }
}

