/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.GlobalStateManagerImpl;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StateManager;
import org.apache.kafka.streams.state.TimestampedBytesStore;
import org.apache.kafka.streams.state.internals.OffsetCheckpoint;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockStateRestoreListener;
import org.apache.kafka.test.NoOpReadOnlyStore;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class GlobalStateManagerImplTest {
    private final MockTime time = new MockTime();
    private final TheStateRestoreCallback stateRestoreCallback = new TheStateRestoreCallback();
    private final MockStateRestoreListener stateRestoreListener = new MockStateRestoreListener();
    private final String storeName1 = "t1-store";
    private final String storeName2 = "t2-store";
    private final String storeName3 = "t3-store";
    private final String storeName4 = "t4-store";
    private final String storeName5 = "t5-store";
    private final TopicPartition t1 = new TopicPartition("t1", 1);
    private final TopicPartition t2 = new TopicPartition("t2", 1);
    private final TopicPartition t3 = new TopicPartition("t3", 1);
    private final TopicPartition t4 = new TopicPartition("t4", 1);
    private final TopicPartition t5 = new TopicPartition("t5", 1);
    private GlobalStateManagerImpl stateManager;
    private StateDirectory stateDirectory;
    private StreamsConfig streamsConfig;
    private NoOpReadOnlyStore<Object, Object> store1;
    private NoOpReadOnlyStore<Object, Object> store2;
    private NoOpReadOnlyStore<Object, Object> store3;
    private NoOpReadOnlyStore<Object, Object> store4;
    private NoOpReadOnlyStore<Object, Object> store5;
    private MockConsumer<byte[], byte[]> consumer;
    private File checkpointFile;
    private ProcessorTopology topology;
    private InternalMockProcessorContext processorContext;
    private Optional<InternalTopologyBuilder.ReprocessFactory<?, ?, ?, ?>> optionalMockReprocessFactory;
    private DeserializationExceptionHandler deserializationExceptionHandler;

    static ProcessorTopology withGlobalStores(List<StateStore> stateStores, Map<String, String> storeToChangelogTopic, Map<String, Optional<InternalTopologyBuilder.ReprocessFactory<?, ?, ?, ?>>> reprocessFactoryMap) {
        return new ProcessorTopology(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), stateStores, storeToChangelogTopic, Collections.emptySet(), reprocessFactoryMap);
    }

    @BeforeEach
    public void before() {
        HashMap<String, String> storeToTopic = new HashMap<String, String>();
        storeToTopic.put("t1-store", this.t1.topic());
        storeToTopic.put("t2-store", this.t2.topic());
        storeToTopic.put("t3-store", this.t3.topic());
        storeToTopic.put("t4-store", this.t4.topic());
        storeToTopic.put("t5-store", this.t5.topic());
        this.store1 = new NoOpReadOnlyStore("t1-store", true);
        this.store2 = new ConverterStore<Object, Object>("t2-store", true);
        this.store3 = new NoOpReadOnlyStore("t3-store");
        this.store4 = new NoOpReadOnlyStore("t4-store");
        this.store5 = new NoOpReadOnlyStore("t5-store");
        this.optionalMockReprocessFactory = (Optional)Mockito.mock(Optional.class);
        Mockito.when((Object)this.optionalMockReprocessFactory.isPresent()).thenReturn((Object)false);
        this.topology = GlobalStateManagerImplTest.withGlobalStores(Arrays.asList(this.store1, this.store2, this.store3, this.store4, this.store5), storeToTopic, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"t1-store", Optional.empty()), Utils.mkEntry((Object)"t2-store", Optional.empty()), Utils.mkEntry((Object)"t3-store", Optional.empty()), Utils.mkEntry((Object)"t4-store", Optional.empty()), Utils.mkEntry((Object)"t5-store", this.optionalMockReprocessFactory)}));
        this.streamsConfig = new StreamsConfig((Map)new Properties(){
            {
                this.put("application.id", "appId");
                this.put("bootstrap.servers", "dummy:1234");
                this.put("state.dir", TestUtils.tempDirectory().getPath());
            }
        });
        this.stateDirectory = new StateDirectory(this.streamsConfig, (Time)this.time, true, false);
        this.consumer = new MockConsumer(AutoOffsetResetStrategy.NONE.name());
        this.stateManager = new GlobalStateManagerImpl(new LogContext("test"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext = new InternalMockProcessorContext(this.stateDirectory.globalStateDir(), this.streamsConfig);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        this.checkpointFile = new File(this.stateManager.baseDir(), ".checkpoint");
    }

    @Test
    public void shouldReadCheckpointOffsets() throws IOException {
        Map<TopicPartition, Long> expected = this.writeCheckpoint();
        this.stateManager.initialize();
        Map offsets = this.stateManager.changelogOffsets();
        Assertions.assertEquals(expected, (Object)offsets);
    }

    @Test
    public void shouldLogWarningMessageWhenIOExceptionInCheckPoint() throws IOException {
        Map<TopicPartition, Long> offsets = Collections.singletonMap(this.t1, 25L);
        this.stateManager.initialize();
        this.stateManager.updateChangelogOffsets(offsets);
        File file = new File(this.stateDirectory.globalStateDir(), ".checkpoint.tmp");
        Files.createFile(file.toPath(), new FileAttribute[0]);
        file.setWritable(false);
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(GlobalStateManagerImpl.class);){
            this.stateManager.checkpoint();
            MatcherAssert.assertThat((Object)appender.getMessages(), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.containsString((String)("Failed to write offset checkpoint file to " + this.checkpointFile.getPath() + " for global stores"))));
        }
    }

    @Test
    public void shouldThrowStreamsExceptionForOldTopicPartitions() throws IOException {
        HashMap<TopicPartition, Long> expectedOffsets = new HashMap<TopicPartition, Long>();
        expectedOffsets.put(this.t1, 1L);
        expectedOffsets.put(this.t2, 1L);
        expectedOffsets.put(this.t3, 1L);
        expectedOffsets.put(this.t4, 1L);
        HashMap<TopicPartition, Long> startOffsets = new HashMap<TopicPartition, Long>(expectedOffsets);
        TopicPartition tOld = new TopicPartition("oldTopic", 1);
        startOffsets.put(tOld, 1L);
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(this.checkpointFile);
        checkpoint.write(startOffsets);
        StreamsException e = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> this.stateManager.initialize());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Encountered a topic-partition not associated with any global state store"));
    }

    @Test
    public void shouldNotDeleteCheckpointFileAfterLoaded() throws IOException {
        this.writeCheckpoint();
        this.stateManager.initialize();
        Assertions.assertTrue((boolean)this.checkpointFile.exists());
    }

    @Test
    public void shouldThrowStreamsExceptionIfFailedToReadCheckpointedOffsets() throws IOException {
        this.writeCorruptCheckpoint();
        Assertions.assertThrows(StreamsException.class, () -> ((GlobalStateManagerImpl)this.stateManager).initialize());
    }

    @Test
    public void shouldInitializeStateStores() {
        this.stateManager.initialize();
        Assertions.assertTrue((boolean)this.store1.initialized);
        Assertions.assertTrue((boolean)this.store2.initialized);
    }

    @Test
    public void shouldReturnInitializedStoreNames() {
        Set storeNames = this.stateManager.initialize();
        Assertions.assertEquals(Set.of("t1-store", "t2-store", "t3-store", "t4-store", "t5-store"), (Object)storeNames);
    }

    @Test
    public void shouldThrowIllegalArgumentIfTryingToRegisterStoreThatIsNotGlobal() {
        this.stateManager.initialize();
        try {
            this.stateManager.registerStore(new NoOpReadOnlyStore("not-in-topology"), (StateRestoreCallback)this.stateRestoreCallback, null);
            Assertions.fail((String)"should have raised an illegal argument exception as store is not in the topology");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionIfAttemptingToRegisterStoreTwice() {
        this.stateManager.initialize();
        this.initializeConsumer(2L, 0L, this.t1);
        this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
        try {
            this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
            Assertions.fail((String)"should have raised an illegal argument exception as store has already been registered");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowStreamsExceptionIfNoPartitionsFoundForStore() {
        this.stateManager.initialize();
        try {
            this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
            Assertions.fail((String)"Should have raised a StreamsException as there are no partition for the store");
        }
        catch (StreamsException streamsException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotConvertValuesIfStoreDoesNotImplementTimestampedBytesStore() {
        this.initializeConsumer(1L, 0L, this.t1);
        this.stateManager.initialize();
        this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
        KeyValue<byte[], byte[]> restoredRecord = this.stateRestoreCallback.restored.get(0);
        Assertions.assertEquals((int)3, (int)((byte[])restoredRecord.key).length);
        Assertions.assertEquals((int)5, (int)((byte[])restoredRecord.value).length);
    }

    @Test
    public void shouldNotConvertValuesIfInnerStoreDoesNotImplementTimestampedBytesStore() {
        this.initializeConsumer(1L, 0L, this.t1);
        this.stateManager.initialize();
        this.stateManager.registerStore((StateStore)new WrappedStateStore<NoOpReadOnlyStore<Object, Object>, Object, Object>(this.store1){}, (StateRestoreCallback)this.stateRestoreCallback, null);
        KeyValue<byte[], byte[]> restoredRecord = this.stateRestoreCallback.restored.get(0);
        Assertions.assertEquals((int)3, (int)((byte[])restoredRecord.key).length);
        Assertions.assertEquals((int)5, (int)((byte[])restoredRecord.value).length);
    }

    @Test
    public void shouldConvertValuesIfStoreImplementsTimestampedBytesStore() {
        this.initializeConsumer(1L, 0L, this.t2);
        this.stateManager.initialize();
        this.stateManager.registerStore(this.store2, (StateRestoreCallback)this.stateRestoreCallback, null);
        KeyValue<byte[], byte[]> restoredRecord = this.stateRestoreCallback.restored.get(0);
        Assertions.assertEquals((int)3, (int)((byte[])restoredRecord.key).length);
        Assertions.assertEquals((int)13, (int)((byte[])restoredRecord.value).length);
    }

    @Test
    public void shouldConvertValuesIfInnerStoreImplementsTimestampedBytesStore() {
        this.initializeConsumer(1L, 0L, this.t2);
        this.stateManager.initialize();
        this.stateManager.registerStore((StateStore)new WrappedStateStore<NoOpReadOnlyStore<Object, Object>, Object, Object>(this.store2){}, (StateRestoreCallback)this.stateRestoreCallback, null);
        KeyValue<byte[], byte[]> restoredRecord = this.stateRestoreCallback.restored.get(0);
        Assertions.assertEquals((int)3, (int)((byte[])restoredRecord.key).length);
        Assertions.assertEquals((int)13, (int)((byte[])restoredRecord.value).length);
    }

    @Test
    public void shouldRestoreRecordsUpToHighwatermark() {
        this.initializeConsumer(2L, 0L, this.t1);
        this.stateManager.initialize();
        this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
        Assertions.assertEquals((int)2, (int)this.stateRestoreCallback.restored.size());
    }

    @Test
    public void shouldListenForRestoreEventsWhenReprocessing() {
        this.setUpReprocessing();
        this.initializeConsumer(6L, 1L, this.t1);
        this.consumer.setMaxPollRecords(2L);
        this.stateManager.initialize();
        this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
        MatcherAssert.assertThat((Object)this.stateRestoreListener.numBatchRestored, (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)this.stateRestoreListener.restoreStartOffset, (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this.stateRestoreListener.restoreEndOffset, (Matcher)CoreMatchers.equalTo((Object)7L));
        MatcherAssert.assertThat((Object)this.stateRestoreListener.totalNumRestored, (Matcher)CoreMatchers.equalTo((Object)6L));
    }

    @Test
    public void shouldListenForRestoreEvents() {
        this.initializeConsumer(6L, 1L, this.t1);
        this.consumer.setMaxPollRecords(2L);
        this.stateManager.initialize();
        this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
        MatcherAssert.assertThat((Object)this.stateRestoreListener.numBatchRestored, (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)this.stateRestoreListener.restoreStartOffset, (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this.stateRestoreListener.restoreEndOffset, (Matcher)CoreMatchers.equalTo((Object)7L));
        MatcherAssert.assertThat((Object)this.stateRestoreListener.totalNumRestored, (Matcher)CoreMatchers.equalTo((Object)6L));
        MatcherAssert.assertThat((Object)this.stateRestoreListener.storeNameCalledStates.get("restore_start"), (Matcher)CoreMatchers.equalTo((Object)this.store1.name()));
        MatcherAssert.assertThat((Object)this.stateRestoreListener.storeNameCalledStates.get("restore_batch"), (Matcher)CoreMatchers.equalTo((Object)this.store1.name()));
        MatcherAssert.assertThat((Object)this.stateRestoreListener.storeNameCalledStates.get("restore_end"), (Matcher)CoreMatchers.equalTo((Object)this.store1.name()));
    }

    @Test
    public void shouldRestoreRecordsFromCheckpointToHighWatermark() throws IOException {
        this.initializeConsumer(5L, 5L, this.t1);
        OffsetCheckpoint offsetCheckpoint = new OffsetCheckpoint(new File(this.stateManager.baseDir(), ".checkpoint"));
        offsetCheckpoint.write(Collections.singletonMap(this.t1, 5L));
        this.stateManager.initialize();
        this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
        Assertions.assertEquals((int)5, (int)this.stateRestoreCallback.restored.size());
    }

    @Test
    public void shouldFlushStateStores() {
        this.stateManager.initialize();
        this.initializeConsumer(1L, 0L, this.t1);
        this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
        this.initializeConsumer(1L, 0L, this.t2);
        this.stateManager.registerStore(this.store2, (StateRestoreCallback)this.stateRestoreCallback, null);
        this.stateManager.flush();
        Assertions.assertTrue((boolean)this.store1.flushed);
        Assertions.assertTrue((boolean)this.store2.flushed);
    }

    @Test
    public void shouldThrowProcessorStateStoreExceptionIfStoreFlushFailed() {
        this.stateManager.initialize();
        this.initializeConsumer(1L, 0L, this.t1);
        this.stateManager.registerStore((StateStore)new NoOpReadOnlyStore<Object, Object>(this.store1.name()){

            @Override
            public void flush() {
                throw new RuntimeException("KABOOM!");
            }
        }, (StateRestoreCallback)this.stateRestoreCallback, null);
        Assertions.assertThrows(StreamsException.class, () -> ((GlobalStateManagerImpl)this.stateManager).flush());
    }

    @Test
    public void shouldCloseStateStores() throws IOException {
        this.stateManager.initialize();
        this.initializeConsumer(1L, 0L, this.t1);
        this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
        this.initializeConsumer(1L, 0L, this.t2);
        this.stateManager.registerStore(this.store2, (StateRestoreCallback)this.stateRestoreCallback, null);
        this.stateManager.close();
        Assertions.assertFalse((boolean)this.store1.isOpen());
        Assertions.assertFalse((boolean)this.store2.isOpen());
    }

    @Test
    public void shouldThrowProcessorStateStoreExceptionIfStoreCloseFailed() {
        this.stateManager.initialize();
        this.initializeConsumer(1L, 0L, this.t1);
        this.stateManager.registerStore((StateStore)new NoOpReadOnlyStore<Object, Object>(this.store1.name()){

            @Override
            public void close() {
                throw new RuntimeException("KABOOM!");
            }
        }, (StateRestoreCallback)this.stateRestoreCallback, null);
        Assertions.assertThrows(ProcessorStateException.class, () -> ((GlobalStateManagerImpl)this.stateManager).close());
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionIfCallbackIsNull() {
        this.stateManager.initialize();
        try {
            this.stateManager.registerStore(this.store1, null, null);
            Assertions.fail((String)"should have thrown due to null callback");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotCloseStoresIfCloseAlreadyCalled() {
        this.stateManager.initialize();
        this.initializeConsumer(1L, 0L, this.t1);
        this.stateManager.registerStore((StateStore)new NoOpReadOnlyStore<Object, Object>("t1-store"){

            @Override
            public void close() {
                if (!this.isOpen()) {
                    throw new RuntimeException("store already closed");
                }
                super.close();
            }
        }, (StateRestoreCallback)this.stateRestoreCallback, null);
        this.stateManager.close();
        this.stateManager.close();
    }

    @Test
    public void shouldAttemptToCloseAllStoresEvenWhenSomeException() {
        this.stateManager.initialize();
        this.initializeConsumer(1L, 0L, this.t1);
        NoOpReadOnlyStore<Object, Object> store = new NoOpReadOnlyStore<Object, Object>("t1-store"){

            @Override
            public void close() {
                super.close();
                throw new RuntimeException("KABOOM!");
            }
        };
        this.stateManager.registerStore((StateStore)store, (StateRestoreCallback)this.stateRestoreCallback, null);
        this.initializeConsumer(1L, 0L, this.t2);
        this.stateManager.registerStore(this.store2, (StateRestoreCallback)this.stateRestoreCallback, null);
        try {
            this.stateManager.close();
        }
        catch (ProcessorStateException processorStateException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)store.isOpen());
        Assertions.assertFalse((boolean)this.store2.isOpen());
    }

    @Test
    public void shouldCheckpointOffsets() throws IOException {
        Map<TopicPartition, Long> offsets = Collections.singletonMap(this.t1, 25L);
        this.stateManager.initialize();
        this.stateManager.updateChangelogOffsets(offsets);
        this.stateManager.checkpoint();
        Map<TopicPartition, Long> result = this.readOffsetsCheckpoint();
        MatcherAssert.assertThat(result, (Matcher)CoreMatchers.equalTo(offsets));
        MatcherAssert.assertThat((Object)this.stateManager.changelogOffsets(), (Matcher)CoreMatchers.equalTo(offsets));
    }

    @Test
    public void shouldNotRemoveOffsetsOfUnUpdatedTablesDuringCheckpoint() {
        this.stateManager.initialize();
        this.initializeConsumer(10L, 0L, this.t1);
        this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
        this.initializeConsumer(20L, 0L, this.t2);
        this.stateManager.registerStore(this.store2, (StateRestoreCallback)this.stateRestoreCallback, null);
        Map initialCheckpoint = this.stateManager.changelogOffsets();
        this.stateManager.updateChangelogOffsets(Collections.singletonMap(this.t1, 101L));
        this.stateManager.checkpoint();
        Map updatedCheckpoint = this.stateManager.changelogOffsets();
        MatcherAssert.assertThat((Object)((Long)updatedCheckpoint.get(this.t2)), (Matcher)CoreMatchers.equalTo((Object)((Long)initialCheckpoint.get(this.t2))));
        MatcherAssert.assertThat((Object)((Long)updatedCheckpoint.get(this.t1)), (Matcher)CoreMatchers.equalTo((Object)101L));
    }

    @Test
    public void shouldSkipNullKeysWhenRestoring() {
        HashMap<TopicPartition, Long> startOffsets = new HashMap<TopicPartition, Long>();
        startOffsets.put(this.t1, 1L);
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.t1, 3L);
        this.consumer.updatePartitions(this.t1.topic(), Collections.singletonList(new PartitionInfo(this.t1.topic(), this.t1.partition(), null, null, null)));
        this.consumer.assign(Collections.singletonList(this.t1));
        this.consumer.updateEndOffsets(endOffsets);
        this.consumer.updateBeginningOffsets(startOffsets);
        this.consumer.addRecord(new ConsumerRecord(this.t1.topic(), this.t1.partition(), 1L, null, (Object)"null".getBytes()));
        byte[] expectedKey = "key".getBytes();
        byte[] expectedValue = "value".getBytes();
        this.consumer.addRecord(new ConsumerRecord(this.t1.topic(), this.t1.partition(), 2L, (Object)expectedKey, (Object)expectedValue));
        this.stateManager.initialize();
        this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
        KeyValue<byte[], byte[]> restoredKv = this.stateRestoreCallback.restored.get(0);
        MatcherAssert.assertThat(this.stateRestoreCallback.restored, (Matcher)CoreMatchers.equalTo(Collections.singletonList(KeyValue.pair((Object)((byte[])restoredKv.key), (Object)((byte[])restoredKv.value)))));
    }

    @Test
    public void shouldCheckpointRestoredOffsetsToFile() throws IOException {
        this.stateManager.initialize();
        this.initializeConsumer(10L, 0L, this.t1);
        this.stateManager.registerStore(this.store1, (StateRestoreCallback)this.stateRestoreCallback, null);
        this.stateManager.checkpoint();
        this.stateManager.close();
        Map checkpointMap = this.stateManager.changelogOffsets();
        MatcherAssert.assertThat((Object)checkpointMap, (Matcher)CoreMatchers.equalTo(Collections.singletonMap(this.t1, 10L)));
        MatcherAssert.assertThat(this.readOffsetsCheckpoint(), (Matcher)CoreMatchers.equalTo((Object)checkpointMap));
    }

    @Test
    public void shouldSkipGlobalInMemoryStoreOffsetsToFile() throws IOException {
        this.stateManager.initialize();
        this.initializeConsumer(10L, 0L, this.t3);
        this.stateManager.registerStore(this.store3, (StateRestoreCallback)this.stateRestoreCallback, null);
        this.stateManager.close();
        MatcherAssert.assertThat(this.readOffsetsCheckpoint(), (Matcher)CoreMatchers.equalTo(Collections.emptyMap()));
    }

    private Map<TopicPartition, Long> readOffsetsCheckpoint() throws IOException {
        OffsetCheckpoint offsetCheckpoint = new OffsetCheckpoint(new File(this.stateManager.baseDir(), ".checkpoint"));
        return offsetCheckpoint.read();
    }

    @Test
    public void shouldNotRetryWhenEndOffsetsThrowsTimeoutExceptionAndTaskTimeoutIsZero() {
        final AtomicInteger numberOfCalls = new AtomicInteger(0);
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public synchronized Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
                numberOfCalls.incrementAndGet();
                throw new TimeoutException("KABOOM!");
            }
        };
        this.initializeConsumer(0L, 0L, this.t1, this.t2, this.t3, this.t4);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"task.timeout.ms", (Object)0L)}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        StreamsException expected = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> this.stateManager.initialize());
        Throwable cause = expected.getCause();
        MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(TimeoutException.class));
        MatcherAssert.assertThat((Object)cause.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"KABOOM!"));
        Assertions.assertEquals((int)numberOfCalls.get(), (int)1);
    }

    @Test
    public void shouldRetryAtLeastOnceWhenEndOffsetsThrowsTimeoutException() {
        final AtomicInteger numberOfCalls = new AtomicInteger(0);
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public synchronized Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
                GlobalStateManagerImplTest.this.time.sleep(100L);
                numberOfCalls.incrementAndGet();
                throw new TimeoutException("KABOOM!");
            }
        };
        this.initializeConsumer(0L, 0L, this.t1, this.t2, this.t3, this.t4);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"task.timeout.ms", (Object)1L)}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        TimeoutException expected = (TimeoutException)Assertions.assertThrows(TimeoutException.class, () -> this.stateManager.initialize());
        MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Global task did not make progress to restore state within 100 ms. Adjust `task.timeout.ms` if needed."));
        Assertions.assertEquals((int)numberOfCalls.get(), (int)2);
    }

    @Test
    public void shouldRetryWhenEndOffsetsThrowsTimeoutExceptionUntilTaskTimeoutExpired() {
        final AtomicInteger numberOfCalls = new AtomicInteger(0);
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public synchronized Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
                GlobalStateManagerImplTest.this.time.sleep(100L);
                numberOfCalls.incrementAndGet();
                throw new TimeoutException("KABOOM!");
            }
        };
        this.initializeConsumer(0L, 0L, this.t1, this.t2, this.t3, this.t4);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"task.timeout.ms", (Object)1000L)}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        TimeoutException expected = (TimeoutException)Assertions.assertThrows(TimeoutException.class, () -> this.stateManager.initialize());
        MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Global task did not make progress to restore state within 1000 ms. Adjust `task.timeout.ms` if needed."));
        Assertions.assertEquals((int)numberOfCalls.get(), (int)11);
    }

    @Test
    public void shouldNotFailOnSlowProgressWhenEndOffsetsThrowsTimeoutException() {
        final AtomicInteger numberOfCalls = new AtomicInteger(0);
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public synchronized Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
                GlobalStateManagerImplTest.this.time.sleep(1L);
                if (numberOfCalls.incrementAndGet() % 3 == 0) {
                    return super.endOffsets(partitions);
                }
                throw new TimeoutException("KABOOM!");
            }

            public synchronized long position(TopicPartition partition) {
                return numberOfCalls.incrementAndGet();
            }
        };
        this.initializeConsumer(0L, 0L, this.t1, this.t2, this.t3, this.t4, this.t5);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"task.timeout.ms", (Object)10L)}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        this.stateManager.initialize();
    }

    @Test
    public void shouldNotRetryWhenPartitionsForThrowsTimeoutExceptionAndTaskTimeoutIsZero() {
        final AtomicInteger numberOfCalls = new AtomicInteger(0);
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public List<PartitionInfo> partitionsFor(String topic) {
                numberOfCalls.incrementAndGet();
                throw new TimeoutException("KABOOM!");
            }
        };
        this.initializeConsumer(0L, 0L, this.t1, this.t2, this.t3, this.t4);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"task.timeout.ms", (Object)0L)}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        StreamsException expected = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> this.stateManager.initialize());
        Throwable cause = expected.getCause();
        MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(TimeoutException.class));
        MatcherAssert.assertThat((Object)cause.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"KABOOM!"));
        Assertions.assertEquals((int)numberOfCalls.get(), (int)1);
    }

    @Test
    public void shouldRetryAtLeastOnceWhenPartitionsForThrowsTimeoutException() {
        final AtomicInteger numberOfCalls = new AtomicInteger(0);
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public List<PartitionInfo> partitionsFor(String topic) {
                GlobalStateManagerImplTest.this.time.sleep(100L);
                numberOfCalls.incrementAndGet();
                throw new TimeoutException("KABOOM!");
            }
        };
        this.initializeConsumer(0L, 0L, this.t1, this.t2, this.t3, this.t4);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"task.timeout.ms", (Object)1L)}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        TimeoutException expected = (TimeoutException)Assertions.assertThrows(TimeoutException.class, () -> this.stateManager.initialize());
        MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Global task did not make progress to restore state within 100 ms. Adjust `task.timeout.ms` if needed."));
        Assertions.assertEquals((int)numberOfCalls.get(), (int)2);
    }

    @Test
    public void shouldRetryWhenPartitionsForThrowsTimeoutExceptionUntilTaskTimeoutExpires() {
        final AtomicInteger numberOfCalls = new AtomicInteger(0);
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public List<PartitionInfo> partitionsFor(String topic) {
                GlobalStateManagerImplTest.this.time.sleep(100L);
                numberOfCalls.incrementAndGet();
                throw new TimeoutException("KABOOM!");
            }
        };
        this.initializeConsumer(0L, 0L, this.t1, this.t2, this.t3, this.t4);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"task.timeout.ms", (Object)1000L)}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        TimeoutException expected = (TimeoutException)Assertions.assertThrows(TimeoutException.class, () -> this.stateManager.initialize());
        MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Global task did not make progress to restore state within 1000 ms. Adjust `task.timeout.ms` if needed."));
        Assertions.assertEquals((int)numberOfCalls.get(), (int)11);
    }

    @Test
    public void shouldNotFailOnSlowProgressWhenPartitionForThrowsTimeoutException() {
        final AtomicInteger numberOfCalls = new AtomicInteger(0);
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public List<PartitionInfo> partitionsFor(String topic) {
                GlobalStateManagerImplTest.this.time.sleep(1L);
                if (numberOfCalls.incrementAndGet() % 3 == 0) {
                    return super.partitionsFor(topic);
                }
                throw new TimeoutException("KABOOM!");
            }

            public synchronized long position(TopicPartition partition) {
                return numberOfCalls.incrementAndGet();
            }
        };
        this.initializeConsumer(0L, 0L, this.t1, this.t2, this.t3, this.t4, this.t5);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"task.timeout.ms", (Object)10L)}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        this.stateManager.initialize();
    }

    @Test
    public void shouldNotRetryWhenPositionThrowsTimeoutExceptionAndTaskTimeoutIsZero() {
        final AtomicInteger numberOfCalls = new AtomicInteger(0);
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public synchronized long position(TopicPartition partition) {
                numberOfCalls.incrementAndGet();
                throw new TimeoutException("KABOOM!");
            }
        };
        this.initializeConsumer(0L, 0L, this.t1, this.t2, this.t3, this.t4);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"task.timeout.ms", (Object)0L)}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        StreamsException expected = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> this.stateManager.initialize());
        Throwable cause = expected.getCause();
        MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(TimeoutException.class));
        MatcherAssert.assertThat((Object)cause.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"KABOOM!"));
        Assertions.assertEquals((int)numberOfCalls.get(), (int)1);
    }

    @Test
    public void shouldRetryAtLeastOnceWhenPositionThrowsTimeoutException() {
        final AtomicInteger numberOfCalls = new AtomicInteger(0);
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public synchronized long position(TopicPartition partition) {
                GlobalStateManagerImplTest.this.time.sleep(100L);
                numberOfCalls.incrementAndGet();
                throw new TimeoutException("KABOOM!");
            }
        };
        this.initializeConsumer(0L, 0L, this.t1, this.t2, this.t3, this.t4);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"task.timeout.ms", (Object)1L)}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        TimeoutException expected = (TimeoutException)Assertions.assertThrows(TimeoutException.class, () -> this.stateManager.initialize());
        MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Global task did not make progress to restore state within 100 ms. Adjust `task.timeout.ms` if needed."));
        Assertions.assertEquals((int)numberOfCalls.get(), (int)2);
    }

    @Test
    public void shouldRetryWhenPositionThrowsTimeoutExceptionUntilTaskTimeoutExpired() {
        final AtomicInteger numberOfCalls = new AtomicInteger(0);
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public synchronized long position(TopicPartition partition) {
                GlobalStateManagerImplTest.this.time.sleep(100L);
                numberOfCalls.incrementAndGet();
                throw new TimeoutException("KABOOM!");
            }
        };
        this.initializeConsumer(0L, 0L, this.t1, this.t2, this.t3, this.t4);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"task.timeout.ms", (Object)1000L)}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        TimeoutException expected = (TimeoutException)Assertions.assertThrows(TimeoutException.class, () -> this.stateManager.initialize());
        MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Global task did not make progress to restore state within 1000 ms. Adjust `task.timeout.ms` if needed."));
        Assertions.assertEquals((int)numberOfCalls.get(), (int)11);
    }

    @Test
    public void shouldNotFailOnSlowProgressWhenPositionThrowsTimeoutException() {
        final AtomicInteger numberOfCalls = new AtomicInteger(0);
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public synchronized long position(TopicPartition partition) {
                GlobalStateManagerImplTest.this.time.sleep(1L);
                if (numberOfCalls.incrementAndGet() % 3 == 0) {
                    return numberOfCalls.incrementAndGet();
                }
                throw new TimeoutException("KABOOM!");
            }
        };
        this.initializeConsumer(0L, 0L, this.t1, this.t2, this.t3, this.t4, this.t5);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"task.timeout.ms", (Object)10L)}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        this.stateManager.initialize();
    }

    @Test
    public void shouldUsePollMsPlusRequestTimeoutInPollDuringRestoreAndTimeoutWhenNoProgressDuringRestore() {
        this.consumer = new MockConsumer<byte[], byte[]>(AutoOffsetResetStrategy.EARLIEST.name()){

            public synchronized ConsumerRecords<byte[], byte[]> poll(Duration timeout) {
                GlobalStateManagerImplTest.this.time.sleep(timeout.toMillis());
                return super.poll(timeout);
            }
        };
        HashMap<TopicPartition, Long> startOffsets = new HashMap<TopicPartition, Long>();
        startOffsets.put(this.t1, 1L);
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.t1, 3L);
        this.consumer.updatePartitions(this.t1.topic(), Collections.singletonList(new PartitionInfo(this.t1.topic(), this.t1.partition(), null, null, null)));
        this.consumer.assign(Collections.singletonList(this.t1));
        this.consumer.updateBeginningOffsets(startOffsets);
        this.consumer.updateEndOffsets(endOffsets);
        this.streamsConfig = new StreamsConfig(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy:1234"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath())}));
        this.stateManager = new GlobalStateManagerImpl(new LogContext("mock"), (Time)this.time, this.topology, this.consumer, this.stateDirectory, (StateRestoreListener)this.stateRestoreListener, this.streamsConfig);
        this.processorContext.setStateManger((StateManager)this.stateManager);
        this.stateManager.setGlobalProcessorContext((InternalProcessorContext)this.processorContext);
        long startTime = this.time.milliseconds();
        TimeoutException exception = (TimeoutException)Assertions.assertThrows(TimeoutException.class, () -> this.stateManager.initialize());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Global task did not make progress to restore state within 301000 ms. Adjust `task.timeout.ms` if needed."));
        MatcherAssert.assertThat((Object)(this.time.milliseconds() - startTime), (Matcher)CoreMatchers.equalTo((Object)331100L));
    }

    private void setUpReprocessing() {
        InternalTopologyBuilder.ReprocessFactory reprocessFactory = (InternalTopologyBuilder.ReprocessFactory)Mockito.mock(InternalTopologyBuilder.ReprocessFactory.class);
        ProcessorSupplier processorSupplier = (ProcessorSupplier)Mockito.mock(ProcessorSupplier.class);
        Processor processor = (Processor)Mockito.mock(Processor.class);
        Deserializer deserializer = (Deserializer)Mockito.mock(Deserializer.class);
        Mockito.when((Object)this.optionalMockReprocessFactory.isPresent()).thenReturn((Object)true);
        Mockito.when(this.optionalMockReprocessFactory.get()).thenReturn((Object)reprocessFactory);
        Mockito.when((Object)reprocessFactory.processorSupplier()).thenReturn((Object)processorSupplier);
        Mockito.when((Object)processorSupplier.get()).thenReturn((Object)processor);
        Mockito.when((Object)reprocessFactory.keyDeserializer()).thenReturn((Object)deserializer);
        Mockito.when((Object)reprocessFactory.valueDeserializer()).thenReturn((Object)deserializer);
        Mockito.when((Object)deserializer.deserialize((String)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any())).thenThrow(new Throwable[]{new StreamsException("fail")});
    }

    @Test
    public void shouldFailOnDeserializationErrorsWhenReprocessing() {
        this.setUpReprocessing();
        this.initializeConsumer(2L, 0L, this.t5);
        this.stateManager.initialize();
        Assertions.assertThrows(StreamsException.class, () -> this.stateManager.registerStore(this.store5, (StateRestoreCallback)this.stateRestoreCallback, null));
    }

    @Test
    public void shouldSkipOnDeserializationErrorsWhenReprocessing() {
        this.stateManager.setDeserializationExceptionHandler((DeserializationExceptionHandler)new LogAndContinueExceptionHandler());
        this.setUpReprocessing();
        this.initializeConsumer(2L, 0L, this.t5);
        this.stateManager.initialize();
        this.stateManager.registerStore(this.store5, (StateRestoreCallback)this.stateRestoreCallback, null);
        Assertions.assertEquals((int)0, (int)this.stateRestoreCallback.restored.size());
    }

    private void writeCorruptCheckpoint() throws IOException {
        File checkpointFile = new File(this.stateManager.baseDir(), ".checkpoint");
        try (OutputStream stream = Files.newOutputStream(checkpointFile.toPath(), new OpenOption[0]);){
            stream.write("0\n1\nfoo".getBytes());
        }
    }

    private void initializeConsumer(long numRecords, long startOffset, TopicPartition ... topicPartitions) {
        this.consumer.assign(Arrays.asList(topicPartitions));
        HashMap<TopicPartition, Long> startOffsets = new HashMap<TopicPartition, Long>();
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        for (TopicPartition topicPartition : topicPartitions) {
            startOffsets.put(topicPartition, startOffset);
            endOffsets.put(topicPartition, startOffset + numRecords);
            this.consumer.updatePartitions(topicPartition.topic(), Collections.singletonList(new PartitionInfo(topicPartition.topic(), topicPartition.partition(), null, null, null)));
            int i = 0;
            while ((long)i < numRecords) {
                this.consumer.addRecord(new ConsumerRecord(topicPartition.topic(), topicPartition.partition(), startOffset + (long)i, (Object)"key".getBytes(), (Object)"value".getBytes()));
                ++i;
            }
        }
        this.consumer.updateEndOffsets(endOffsets);
        this.consumer.updateBeginningOffsets(startOffsets);
    }

    private Map<TopicPartition, Long> writeCheckpoint() throws IOException {
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(this.checkpointFile);
        Map<TopicPartition, Long> expected = Collections.singletonMap(this.t1, 1L);
        checkpoint.write(expected);
        return expected;
    }

    private static class TheStateRestoreCallback
    implements StateRestoreCallback {
        private final List<KeyValue<byte[], byte[]>> restored = new ArrayList<KeyValue<byte[], byte[]>>();

        private TheStateRestoreCallback() {
        }

        public void restore(byte[] key, byte[] value) {
            this.restored.add((KeyValue<byte[], byte[]>)KeyValue.pair((Object)key, (Object)value));
        }
    }

    private static class ConverterStore<K, V>
    extends NoOpReadOnlyStore<K, V>
    implements TimestampedBytesStore {
        ConverterStore(String name, boolean rocksdbStore) {
            super(name, rocksdbStore);
        }
    }
}

