/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.streams.processor.internals.RepartitionTopicConfig;
import org.apache.kafka.streams.processor.internals.UnwindowedUnversionedChangelogTopicConfig;
import org.apache.kafka.streams.processor.internals.VersionedChangelogTopicConfig;
import org.apache.kafka.streams.processor.internals.WindowedChangelogTopicConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InternalTopicConfigTest {
    @Test
    public void shouldThrowNpeIfTopicConfigIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new RepartitionTopicConfig("topic", null));
    }

    @Test
    public void shouldThrowIfNameIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new RepartitionTopicConfig(null, Collections.emptyMap()));
    }

    @Test
    public void shouldThrowIfNameIsInvalid() {
        Assertions.assertThrows(InvalidTopicException.class, () -> new RepartitionTopicConfig("foo bar baz", Collections.emptyMap()));
    }

    @Test
    public void shouldSetCreateTimeByDefaultForWindowedChangelog() {
        WindowedChangelogTopicConfig topicConfig = new WindowedChangelogTopicConfig("name", Collections.emptyMap(), 10L);
        Map properties = topicConfig.properties(Collections.emptyMap(), 0L);
        Assertions.assertEquals((Object)"CreateTime", properties.get("message.timestamp.type"));
    }

    @Test
    public void shouldSetCreateTimeByDefaultForUnwindowedUnversionedChangelog() {
        UnwindowedUnversionedChangelogTopicConfig topicConfig = new UnwindowedUnversionedChangelogTopicConfig("name", Collections.emptyMap());
        Map properties = topicConfig.properties(Collections.emptyMap(), 0L);
        Assertions.assertEquals((Object)"CreateTime", properties.get("message.timestamp.type"));
    }

    @Test
    public void shouldSetCreateTimeByDefaultForVersionedChangelog() {
        VersionedChangelogTopicConfig topicConfig = new VersionedChangelogTopicConfig("name", Collections.emptyMap(), 12L);
        Map properties = topicConfig.properties(Collections.emptyMap(), 0L);
        Assertions.assertEquals((Object)"CreateTime", properties.get("message.timestamp.type"));
    }

    @Test
    public void shouldSetCreateTimeByDefaultForRepartitionTopic() {
        RepartitionTopicConfig topicConfig = new RepartitionTopicConfig("name", Collections.emptyMap());
        Map properties = topicConfig.properties(Collections.emptyMap(), 0L);
        Assertions.assertEquals((Object)"CreateTime", properties.get("message.timestamp.type"));
    }

    @Test
    public void shouldAugmentRetentionMsWithWindowedChangelog() {
        WindowedChangelogTopicConfig topicConfig = new WindowedChangelogTopicConfig("name", Collections.emptyMap(), 10L);
        Assertions.assertEquals((Object)"30", topicConfig.properties(Collections.emptyMap(), 20L).get("retention.ms"));
    }

    @Test
    public void shouldAugmentCompactionLagMsWithVersionedChangelog() {
        VersionedChangelogTopicConfig topicConfig = new VersionedChangelogTopicConfig("name", Collections.emptyMap(), 12L);
        Assertions.assertEquals((Object)Long.toString(86400012L), topicConfig.properties(Collections.emptyMap(), 20L).get("min.compaction.lag.ms"));
    }

    @Test
    public void shouldUseSuppliedConfigsForWindowedChangelogConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("message.timestamp.type", "LogAppendTime");
        WindowedChangelogTopicConfig topicConfig = new WindowedChangelogTopicConfig("name", configs, 10L);
        Map properties = topicConfig.properties(Collections.emptyMap(), 0L);
        Assertions.assertEquals((Object)"LogAppendTime", properties.get("message.timestamp.type"));
    }

    @Test
    public void shouldUseSuppliedConfigsForVersionedChangelogConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("message.timestamp.type", "LogAppendTime");
        VersionedChangelogTopicConfig topicConfig = new VersionedChangelogTopicConfig("name", configs, 12L);
        Map properties = topicConfig.properties(Collections.emptyMap(), 0L);
        Assertions.assertEquals((Object)"LogAppendTime", properties.get("message.timestamp.type"));
    }

    @Test
    public void shouldUseSuppliedConfigsForUnwindowedUnversionedChangelogConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("retention.ms", "1000");
        configs.put("retention.bytes", "10000");
        configs.put("message.timestamp.type", "LogAppendTime");
        UnwindowedUnversionedChangelogTopicConfig topicConfig = new UnwindowedUnversionedChangelogTopicConfig("name", configs);
        Map properties = topicConfig.properties(Collections.emptyMap(), 0L);
        Assertions.assertEquals((Object)"1000", properties.get("retention.ms"));
        Assertions.assertEquals((Object)"10000", properties.get("retention.bytes"));
        Assertions.assertEquals((Object)"LogAppendTime", properties.get("message.timestamp.type"));
    }

    @Test
    public void shouldUseSuppliedConfigsForRepartitionConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("retention.ms", "1000");
        configs.put("message.timestamp.type", "LogAppendTime");
        RepartitionTopicConfig topicConfig = new RepartitionTopicConfig("name", configs);
        Map properties = topicConfig.properties(Collections.emptyMap(), 0L);
        Assertions.assertEquals((Object)"1000", properties.get("retention.ms"));
        Assertions.assertEquals((Object)"LogAppendTime", properties.get("message.timestamp.type"));
    }
}

