/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.AutoOffsetReset;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.apache.kafka.streams.errors.LogAndFailExceptionHandler;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.internals.AutoOffsetResetInternal;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.TopicNameExtractor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.ProcessorWrapper;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.WrappedFixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.WrappedProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.kafka.streams.processor.internals.InternalTopicProperties;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.RepartitionTopicConfig;
import org.apache.kafka.streams.processor.internals.StoreDelegatingProcessorSupplier;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.UnwindowedUnversionedChangelogTopicConfig;
import org.apache.kafka.streams.processor.internals.VersionedChangelogTopicConfig;
import org.apache.kafka.streams.processor.internals.WindowedChangelogTopicConfig;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.VersionedBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.utils.TestUtils;
import org.apache.kafka.test.MockApiProcessor;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.MockKeyValueStoreBuilder;
import org.apache.kafka.test.MockTimestampExtractor;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InternalTopologyBuilderTest {
    private final Serde<String> stringSerde = Serdes.String();
    private final InternalTopologyBuilder builder = new InternalTopologyBuilder();
    private final StoreBuilder<?> storeBuilder = new MockKeyValueStoreBuilder("testStore", false);
    private final StoreFactory storeFactory = new MockKeyValueStoreBuilder("testStore", false).asFactory();

    @Test
    public void shouldAddSourceWithOffsetReset() {
        String noneTopic = "noneTopic";
        String earliestTopic = "earliestTopic";
        String latestTopic = "latestTopic";
        String durationTopic = "durationTopic";
        this.builder.addSource(new AutoOffsetResetInternal(AutoOffsetReset.none()), "source0", null, null, null, new String[]{"noneTopic"});
        this.builder.addSource(new AutoOffsetResetInternal(AutoOffsetReset.earliest()), "source1", null, null, null, new String[]{"earliestTopic"});
        this.builder.addSource(new AutoOffsetResetInternal(AutoOffsetReset.latest()), "source2", null, null, null, new String[]{"latestTopic"});
        this.builder.addSource(new AutoOffsetResetInternal(AutoOffsetReset.byDuration((Duration)Duration.ofSeconds(42L))), "source3", null, null, null, new String[]{"durationTopic"});
        this.builder.initializeSubscription();
        MatcherAssert.assertThat((Object)this.builder.offsetResetStrategy("noneTopic"), (Matcher)CoreMatchers.equalTo((Object)AutoOffsetResetStrategy.NONE));
        MatcherAssert.assertThat((Object)this.builder.offsetResetStrategy("earliestTopic"), (Matcher)CoreMatchers.equalTo((Object)AutoOffsetResetStrategy.EARLIEST));
        MatcherAssert.assertThat((Object)this.builder.offsetResetStrategy("latestTopic"), (Matcher)CoreMatchers.equalTo((Object)AutoOffsetResetStrategy.LATEST));
        MatcherAssert.assertThat((Object)this.builder.offsetResetStrategy("durationTopic").type(), (Matcher)CoreMatchers.equalTo((Object)AutoOffsetResetStrategy.StrategyType.BY_DURATION));
        MatcherAssert.assertThat((Object)((Duration)this.builder.offsetResetStrategy("durationTopic").duration().get()).toSeconds(), (Matcher)CoreMatchers.equalTo((Object)42L));
    }

    @Test
    public void shouldAddSourcePatternWithOffsetReset() {
        String noneTopicPattern = "none.*Topic";
        String earliestTopicPattern = "earliest.*Topic";
        String latestTopicPattern = "latest.*Topic";
        String durationTopicPattern = "duration.*Topic";
        this.builder.addSource(new AutoOffsetResetInternal(AutoOffsetReset.none()), "source0", null, null, null, Pattern.compile("none.*Topic"));
        this.builder.addSource(new AutoOffsetResetInternal(AutoOffsetReset.earliest()), "sourc1", null, null, null, Pattern.compile("earliest.*Topic"));
        this.builder.addSource(new AutoOffsetResetInternal(AutoOffsetReset.latest()), "source2", null, null, null, Pattern.compile("latest.*Topic"));
        this.builder.addSource(new AutoOffsetResetInternal(AutoOffsetReset.byDuration((Duration)Duration.ofSeconds(42L))), "source3", null, null, null, Pattern.compile("duration.*Topic"));
        this.builder.initializeSubscription();
        MatcherAssert.assertThat((Object)this.builder.offsetResetStrategy("noneTestTopic"), (Matcher)CoreMatchers.equalTo((Object)AutoOffsetResetStrategy.NONE));
        MatcherAssert.assertThat((Object)this.builder.offsetResetStrategy("earliestTestTopic"), (Matcher)CoreMatchers.equalTo((Object)AutoOffsetResetStrategy.EARLIEST));
        MatcherAssert.assertThat((Object)this.builder.offsetResetStrategy("latestTestTopic"), (Matcher)CoreMatchers.equalTo((Object)AutoOffsetResetStrategy.LATEST));
        MatcherAssert.assertThat((Object)this.builder.offsetResetStrategy("durationTestTopic").type(), (Matcher)CoreMatchers.equalTo((Object)AutoOffsetResetStrategy.StrategyType.BY_DURATION));
        MatcherAssert.assertThat((Object)((Duration)this.builder.offsetResetStrategy("durationTestTopic").duration().get()).toSeconds(), (Matcher)CoreMatchers.equalTo((Object)42L));
    }

    @Test
    public void shouldAddSourceWithoutOffsetReset() {
        this.builder.addSource(null, "source", null, this.stringSerde.deserializer(), this.stringSerde.deserializer(), new String[]{"test-topic"});
        this.builder.initializeSubscription();
        Assertions.assertEquals(Collections.singletonList("test-topic"), (Object)this.builder.fullSourceTopicNames());
        MatcherAssert.assertThat((Object)this.builder.offsetResetStrategy("test-topic"), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void shouldAddPatternSourceWithoutOffsetReset() {
        Pattern expectedPattern = Pattern.compile("test-.*");
        this.builder.addSource(null, "source", null, this.stringSerde.deserializer(), this.stringSerde.deserializer(), Pattern.compile("test-.*"));
        this.builder.initializeSubscription();
        MatcherAssert.assertThat((String)expectedPattern.pattern(), (Object)this.builder.sourceTopicPatternString(), (Matcher)CoreMatchers.equalTo((Object)"test-.*"));
        MatcherAssert.assertThat((Object)this.builder.offsetResetStrategy("test-topic"), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void shouldNotAllowOffsetResetSourceWithoutTopics() {
        Assertions.assertThrows(TopologyException.class, () -> this.builder.addSource(new AutoOffsetResetInternal(AutoOffsetReset.earliest()), "source", null, this.stringSerde.deserializer(), this.stringSerde.deserializer(), new String[0]));
    }

    @Test
    public void shouldNotAllowOffsetResetSourceWithDuplicateSourceName() {
        this.builder.addSource(new AutoOffsetResetInternal(AutoOffsetReset.earliest()), "source", null, this.stringSerde.deserializer(), this.stringSerde.deserializer(), new String[]{"topic-1"});
        try {
            this.builder.addSource(new AutoOffsetResetInternal(AutoOffsetReset.latest()), "source", null, this.stringSerde.deserializer(), this.stringSerde.deserializer(), new String[]{"topic-2"});
            Assertions.fail((String)"Should throw TopologyException for duplicate source name");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddSourceWithSameName() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic-1"});
        try {
            this.builder.addSource(null, "source", null, null, null, new String[]{"topic-2"});
            Assertions.fail((String)"Should throw TopologyException with source name conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddSourceWithSameTopic() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic-1"});
        try {
            this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-1"});
            Assertions.fail((String)"Should throw TopologyException with topic conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddProcessorWithSameName() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic-1"});
        this.builder.addProcessor("processor", new MockApiProcessorSupplier(), new String[]{"source"});
        try {
            this.builder.addProcessor("processor", new MockApiProcessorSupplier(), new String[]{"source"});
            Assertions.fail((String)"Should throw TopologyException with processor name conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddProcessorWithWrongParent() {
        Assertions.assertThrows(TopologyException.class, () -> this.builder.addProcessor("processor", new MockApiProcessorSupplier(), new String[]{"source"}));
    }

    @Test
    public void testAddProcessorWithSelfParent() {
        Assertions.assertThrows(TopologyException.class, () -> this.builder.addProcessor("processor", new MockApiProcessorSupplier(), new String[]{"processor"}));
    }

    @Test
    public void testAddProcessorWithEmptyParents() {
        Assertions.assertThrows(TopologyException.class, () -> this.builder.addProcessor("processor", new MockApiProcessorSupplier(), new String[0]));
    }

    @Test
    public void testAddProcessorWithNullParents() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.addProcessor("processor", new MockApiProcessorSupplier(), new String[]{null}));
    }

    @Test
    public void testAddProcessorWithBadSupplier() {
        MockApiProcessor processor = new MockApiProcessor();
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.builder.addProcessor("processor", () -> processor, new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"#get() must return a new object each time it is called."));
    }

    @Test
    public void testAddGlobalStoreWithBadSupplier() {
        Processor processor = new MockApiProcessorSupplier().get();
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.builder.addGlobalStore("globalSource", null, null, null, "globalTopic", "global-processor", () -> processor, false));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"#get() must return a new object each time it is called."));
    }

    @Test
    public void testAddSinkWithSameName() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic-1"});
        this.builder.addSink("sink", "topic-2", null, null, null, new String[]{"source"});
        try {
            this.builder.addSink("sink", "topic-3", null, null, null, new String[]{"source"});
            Assertions.fail((String)"Should throw TopologyException with sink name conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddSinkWithWrongParent() {
        Assertions.assertThrows(TopologyException.class, () -> this.builder.addSink("sink", "topic-2", null, null, null, new String[]{"source"}));
    }

    @Test
    public void testAddSinkWithSelfParent() {
        Assertions.assertThrows(TopologyException.class, () -> this.builder.addSink("sink", "topic-2", null, null, null, new String[]{"sink"}));
    }

    @Test
    public void testAddSinkWithEmptyParents() {
        Assertions.assertThrows(TopologyException.class, () -> this.builder.addSink("sink", "topic", null, null, null, new String[0]));
    }

    @Test
    public void testAddSinkWithNullParents() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.addSink("sink", "topic", null, null, null, new String[]{null}));
    }

    @Test
    public void testAddSinkConnectedWithParent() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"source-topic"});
        this.builder.addSink("sink", "dest-topic", null, null, null, new String[]{"source"});
        Map nodeGroups = this.builder.nodeGroups();
        Set nodeGroup = (Set)nodeGroups.get(0);
        Assertions.assertTrue((boolean)nodeGroup.contains("sink"));
        Assertions.assertTrue((boolean)nodeGroup.contains("source"));
    }

    @Test
    public void testAddSinkConnectedWithMultipleParent() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"source-topic"});
        this.builder.addSource(null, "sourceII", null, null, null, new String[]{"source-topicII"});
        this.builder.addSink("sink", "dest-topic", null, null, null, new String[]{"source", "sourceII"});
        Map nodeGroups = this.builder.nodeGroups();
        Set nodeGroup = (Set)nodeGroups.get(0);
        Assertions.assertTrue((boolean)nodeGroup.contains("sink"));
        Assertions.assertTrue((boolean)nodeGroup.contains("source"));
        Assertions.assertTrue((boolean)nodeGroup.contains("sourceII"));
    }

    @Test
    public void testOnlyTopicNameSourceTopics() {
        this.builder.setApplicationId("X");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        this.builder.addSource(null, "source-3", null, null, null, new String[]{"topic-3"});
        this.builder.addInternalTopic("topic-3", InternalTopicProperties.empty());
        this.builder.initializeSubscription();
        Assertions.assertFalse((boolean)this.builder.usesPatternSubscription());
        Assertions.assertEquals(Arrays.asList("X-topic-3", "topic-1", "topic-2"), (Object)this.builder.fullSourceTopicNames());
    }

    @Test
    public void testPatternAndNameSourceTopics() {
        Pattern sourcePattern = Pattern.compile("topic-4|topic-5");
        this.builder.setApplicationId("X");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        this.builder.addSource(null, "source-3", null, null, null, new String[]{"topic-3"});
        this.builder.addSource(null, "source-4", null, null, null, sourcePattern);
        this.builder.addInternalTopic("topic-3", InternalTopicProperties.empty());
        this.builder.initializeSubscription();
        Pattern expectedPattern = Pattern.compile("X-topic-3|topic-1|topic-2|topic-4|topic-5");
        String patternString = this.builder.sourceTopicPatternString();
        Assertions.assertEquals((Object)expectedPattern.pattern(), (Object)Pattern.compile(patternString).pattern());
    }

    @Test
    public void testPatternSourceTopicsWithGlobalTopics() {
        StoreBuilder storeBuilder = new MockKeyValueStoreBuilder("global-store", false).withLoggingDisabled();
        this.builder.setApplicationId("X");
        this.builder.addSource(null, "source-1", null, null, null, Pattern.compile("topic-1"));
        this.builder.addSource(null, "source-2", null, null, null, Pattern.compile("topic-2"));
        this.builder.addGlobalStore("globalSource", null, null, null, "globalTopic", "global-processor", (ProcessorSupplier)new StoreDelegatingProcessorSupplier(new MockApiProcessorSupplier(), Set.of(storeBuilder)), false);
        this.builder.initializeSubscription();
        Pattern expectedPattern = Pattern.compile("topic-1|topic-2");
        String patternString = this.builder.sourceTopicPatternString();
        Assertions.assertEquals((Object)expectedPattern.pattern(), (Object)Pattern.compile(patternString).pattern());
    }

    @Test
    public void testNameSourceTopicsWithGlobalTopics() {
        StoreBuilder storeBuilder = new MockKeyValueStoreBuilder("global-store", false).withLoggingDisabled();
        this.builder.setApplicationId("X");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        this.builder.addGlobalStore("globalSource", null, null, null, "globalTopic", "global-processor", (ProcessorSupplier)new StoreDelegatingProcessorSupplier(new MockApiProcessorSupplier(), Set.of(storeBuilder)), false);
        this.builder.initializeSubscription();
        MatcherAssert.assertThat((Object)this.builder.fullSourceTopicNames(), (Matcher)CoreMatchers.equalTo(Arrays.asList("topic-1", "topic-2")));
    }

    @Test
    public void testPatternSourceTopic() {
        Pattern expectedPattern = Pattern.compile("topic-\\d");
        this.builder.addSource(null, "source-1", null, null, null, expectedPattern);
        this.builder.initializeSubscription();
        String patternString = this.builder.sourceTopicPatternString();
        Assertions.assertEquals((Object)expectedPattern.pattern(), (Object)Pattern.compile(patternString).pattern());
    }

    @Test
    public void testAddMoreThanOnePatternSourceNode() {
        Pattern expectedPattern = Pattern.compile("topics[A-Z]|.*-\\d");
        this.builder.addSource(null, "source-1", null, null, null, Pattern.compile("topics[A-Z]"));
        this.builder.addSource(null, "source-2", null, null, null, Pattern.compile(".*-\\d"));
        this.builder.initializeSubscription();
        String patternString = this.builder.sourceTopicPatternString();
        Assertions.assertEquals((Object)expectedPattern.pattern(), (Object)Pattern.compile(patternString).pattern());
    }

    @Test
    public void testSubscribeTopicNameAndPattern() {
        Pattern expectedPattern = Pattern.compile("topic-bar|topic-foo|.*-\\d");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-foo", "topic-bar"});
        this.builder.addSource(null, "source-2", null, null, null, Pattern.compile(".*-\\d"));
        this.builder.initializeSubscription();
        String patternString = this.builder.sourceTopicPatternString();
        Assertions.assertEquals((Object)expectedPattern.pattern(), (Object)Pattern.compile(patternString).pattern());
    }

    @Test
    public void testPatternMatchesAlreadyProvidedTopicSource() {
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"foo"});
        try {
            this.builder.addSource(null, "source-2", null, null, null, Pattern.compile("f.*"));
            Assertions.fail((String)"Should throw TopologyException with topic name/pattern conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testNamedTopicMatchesAlreadyProvidedPattern() {
        this.builder.addSource(null, "source-1", null, null, null, Pattern.compile("f.*"));
        try {
            this.builder.addSource(null, "source-2", null, null, null, new String[]{"foo"});
            Assertions.fail((String)"Should throw TopologyException with topic name/pattern conflict");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddStateStoreWithNonExistingProcessor() {
        Assertions.assertThrows(TopologyException.class, () -> this.builder.addStateStore(this.storeFactory, new String[]{"no-such-processor"}));
    }

    @Test
    public void testAddStateStoreWithSource() {
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        try {
            this.builder.addStateStore(this.storeFactory, new String[]{"source-1"});
            Assertions.fail((String)"Should throw TopologyException with store cannot be added to source");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddStateStoreWithSink() {
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addSink("sink-1", "topic-1", null, null, null, new String[]{"source-1"});
        try {
            this.builder.addStateStore(this.storeFactory, new String[]{"sink-1"});
            Assertions.fail((String)"Should throw TopologyException with store cannot be added to sink");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowToAddStoresWithSameName() {
        MockKeyValueStoreBuilder otherBuilder = new MockKeyValueStoreBuilder("testStore", false);
        this.builder.addStateStore(this.storeFactory, new String[0]);
        TopologyException exception = (TopologyException)Assertions.assertThrows(TopologyException.class, () -> this.lambda$shouldNotAllowToAddStoresWithSameName$14((StoreBuilder)otherBuilder));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Invalid topology: A different StateStore has already been added with the name testStore"));
    }

    @Test
    public void shouldNotAllowToAddStoresWithSameNameWhenFirstStoreIsGlobal() {
        StoreBuilder globalBuilder = new MockKeyValueStoreBuilder("testStore", false).withLoggingDisabled();
        this.builder.addGlobalStore("global-store", null, null, null, "global-topic", "global-processor", (ProcessorSupplier)new StoreDelegatingProcessorSupplier(new MockApiProcessorSupplier(), Set.of(globalBuilder)), false);
        TopologyException exception = (TopologyException)Assertions.assertThrows(TopologyException.class, () -> this.builder.addStateStore(this.storeFactory, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Invalid topology: A different GlobalStateStore has already been added with the name testStore"));
    }

    @Test
    public void shouldNotAllowToAddStoresWithSameNameWhenSecondStoreIsGlobal() {
        StoreBuilder globalBuilder = new MockKeyValueStoreBuilder("testStore", false).withLoggingDisabled();
        this.builder.addStateStore(this.storeFactory, new String[0]);
        TopologyException exception = (TopologyException)Assertions.assertThrows(TopologyException.class, () -> this.builder.addGlobalStore("global-store", null, null, null, "global-topic", "global-processor", (ProcessorSupplier)new StoreDelegatingProcessorSupplier(new MockApiProcessorSupplier(), Set.of(globalBuilder)), false));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Invalid topology: A different StateStore has already been added with the name testStore"));
    }

    @Test
    public void shouldNotAllowToAddGlobalStoresWithSameName() {
        StoreBuilder firstGlobalBuilder = new MockKeyValueStoreBuilder("testStore", false).withLoggingDisabled();
        StoreBuilder secondGlobalBuilder = new MockKeyValueStoreBuilder("testStore", false).withLoggingDisabled();
        this.builder.addGlobalStore("global-store", null, null, null, "global-topic", "global-processor", (ProcessorSupplier)new StoreDelegatingProcessorSupplier(new MockApiProcessorSupplier(), Set.of(firstGlobalBuilder)), false);
        TopologyException exception = (TopologyException)Assertions.assertThrows(TopologyException.class, () -> this.builder.addGlobalStore("global-store-2", null, null, null, "global-topic", "global-processor-2", (ProcessorSupplier)new StoreDelegatingProcessorSupplier(new MockApiProcessorSupplier(), Set.of(secondGlobalBuilder)), false));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Invalid topology: A different GlobalStateStore has already been added with the name testStore"));
    }

    @Test
    public void testAddStateStore() {
        this.builder.addStateStore(this.storeFactory, new String[0]);
        this.builder.setApplicationId("X");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addProcessor("processor-1", new MockApiProcessorSupplier(), new String[]{"source-1"});
        Assertions.assertEquals((int)0, (int)this.builder.buildTopology().stateStores().size());
        this.builder.connectProcessorAndStateStores("processor-1", new String[]{this.storeFactory.storeName()});
        List suppliers = this.builder.buildTopology().stateStores();
        Assertions.assertEquals((int)1, (int)suppliers.size());
        Assertions.assertEquals((Object)this.storeFactory.storeName(), (Object)((StateStore)suppliers.get(0)).name());
    }

    @Test
    public void testStateStoreNamesForSubtopology() {
        this.builder.addStateStore(this.storeFactory, new String[0]);
        this.builder.setApplicationId("X");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addProcessor("processor-1", new MockApiProcessorSupplier(), new String[]{"source-1"});
        this.builder.connectProcessorAndStateStores("processor-1", new String[]{this.storeFactory.storeName()});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        this.builder.addProcessor("processor-2", new MockApiProcessorSupplier(), new String[]{"source-2"});
        this.builder.buildTopology();
        Set stateStoreNames = this.builder.stateStoreNamesForSubtopology(0);
        MatcherAssert.assertThat((Object)stateStoreNames, (Matcher)CoreMatchers.equalTo(Set.of(this.storeFactory.storeName())));
        Set emptyStoreNames = this.builder.stateStoreNamesForSubtopology(1);
        MatcherAssert.assertThat((Object)emptyStoreNames, (Matcher)CoreMatchers.equalTo(Set.of()));
        Set stateStoreNamesUnknownSubtopology = this.builder.stateStoreNamesForSubtopology(13);
        MatcherAssert.assertThat((Object)stateStoreNamesUnknownSubtopology, (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldAllowAddingSameStoreBuilderMultipleTimes() {
        this.builder.setApplicationId("X");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addStateStore(this.storeFactory, new String[0]);
        this.builder.addProcessor("processor-1", new MockApiProcessorSupplier(), new String[]{"source-1"});
        this.builder.connectProcessorAndStateStores("processor-1", new String[]{this.storeFactory.storeName()});
        this.builder.addStateStore(this.storeFactory, new String[0]);
        this.builder.addProcessor("processor-2", new MockApiProcessorSupplier(), new String[]{"source-1"});
        this.builder.connectProcessorAndStateStores("processor-2", new String[]{this.storeFactory.storeName()});
        Assertions.assertEquals((int)1, (int)this.builder.buildTopology().stateStores().size());
    }

    @Test
    public void testTopicGroups() {
        this.builder.setApplicationId("X");
        this.builder.addInternalTopic("topic-1x", InternalTopicProperties.empty());
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1", "topic-1x"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        this.builder.addSource(null, "source-3", null, null, null, new String[]{"topic-3"});
        this.builder.addSource(null, "source-4", null, null, null, new String[]{"topic-4"});
        this.builder.addSource(null, "source-5", null, null, null, new String[]{"topic-5"});
        this.builder.addProcessor("processor-1", new MockApiProcessorSupplier(), new String[]{"source-1"});
        this.builder.addProcessor("processor-2", new MockApiProcessorSupplier(), new String[]{"source-2", "processor-1"});
        this.builder.copartitionSources(Arrays.asList("source-1", "source-2"));
        this.builder.addProcessor("processor-3", new MockApiProcessorSupplier(), new String[]{"source-3", "source-4"});
        Map topicGroups = this.builder.subtopologyToTopicsInfo();
        HashMap<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> expectedTopicGroups = new HashMap<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo>();
        expectedTopicGroups.put(AssignmentTestUtils.SUBTOPOLOGY_0, new InternalTopologyBuilder.TopicsInfo(Collections.emptySet(), Set.of("topic-1", "X-topic-1x", "topic-2"), Collections.emptyMap(), Collections.emptyMap()));
        expectedTopicGroups.put(AssignmentTestUtils.SUBTOPOLOGY_1, new InternalTopologyBuilder.TopicsInfo(Collections.emptySet(), Set.of("topic-3", "topic-4"), Collections.emptyMap(), Collections.emptyMap()));
        expectedTopicGroups.put(AssignmentTestUtils.SUBTOPOLOGY_2, new InternalTopologyBuilder.TopicsInfo(Collections.emptySet(), Set.of("topic-5"), Collections.emptyMap(), Collections.emptyMap()));
        Assertions.assertEquals((int)3, (int)topicGroups.size());
        Assertions.assertEquals(expectedTopicGroups, (Object)topicGroups);
        Collection copartitionGroups = this.builder.copartitionGroups();
        Assertions.assertEquals(Set.of(Set.of("topic-1", "X-topic-1x", "topic-2")), new HashSet(copartitionGroups));
    }

    @Test
    public void testTopicGroupsByStateStore() {
        this.builder.setApplicationId("X");
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1", "topic-1x"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        this.builder.addSource(null, "source-3", null, null, null, new String[]{"topic-3"});
        this.builder.addSource(null, "source-4", null, null, null, new String[]{"topic-4"});
        this.builder.addSource(null, "source-5", null, null, null, new String[]{"topic-5"});
        this.builder.addProcessor("processor-1", new MockApiProcessorSupplier(), new String[]{"source-1"});
        this.builder.addProcessor("processor-2", new MockApiProcessorSupplier(), new String[]{"source-2"});
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store-1", false), new String[]{"processor-1", "processor-2"});
        this.builder.addProcessor("processor-3", new MockApiProcessorSupplier(), new String[]{"source-3"});
        this.builder.addProcessor("processor-4", new MockApiProcessorSupplier(), new String[]{"source-4"});
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store-2", false), new String[]{"processor-3", "processor-4"});
        this.builder.addProcessor("processor-5", new MockApiProcessorSupplier(), new String[]{"source-5"});
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store-3", false), new String[0]);
        this.builder.connectProcessorAndStateStores("processor-5", new String[]{"store-3"});
        this.builder.buildTopology();
        Map topicGroups = this.builder.subtopologyToTopicsInfo();
        HashMap<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo> expectedTopicGroups = new HashMap<TopologyMetadata.Subtopology, InternalTopologyBuilder.TopicsInfo>();
        String store1 = ProcessorStateManager.storeChangelogTopic((String)"X", (String)"store-1", (String)this.builder.topologyName());
        String store2 = ProcessorStateManager.storeChangelogTopic((String)"X", (String)"store-2", (String)this.builder.topologyName());
        String store3 = ProcessorStateManager.storeChangelogTopic((String)"X", (String)"store-3", (String)this.builder.topologyName());
        expectedTopicGroups.put(AssignmentTestUtils.SUBTOPOLOGY_0, new InternalTopologyBuilder.TopicsInfo(Collections.emptySet(), Set.of("topic-1", "topic-1x", "topic-2"), Collections.emptyMap(), Collections.singletonMap(store1, new UnwindowedUnversionedChangelogTopicConfig(store1, Collections.emptyMap()))));
        expectedTopicGroups.put(AssignmentTestUtils.SUBTOPOLOGY_1, new InternalTopologyBuilder.TopicsInfo(Collections.emptySet(), Set.of("topic-3", "topic-4"), Collections.emptyMap(), Collections.singletonMap(store2, new UnwindowedUnversionedChangelogTopicConfig(store2, Collections.emptyMap()))));
        expectedTopicGroups.put(AssignmentTestUtils.SUBTOPOLOGY_2, new InternalTopologyBuilder.TopicsInfo(Collections.emptySet(), Set.of("topic-5"), Collections.emptyMap(), Collections.singletonMap(store3, new UnwindowedUnversionedChangelogTopicConfig(store3, Collections.emptyMap()))));
        Assertions.assertEquals((int)3, (int)topicGroups.size());
        Assertions.assertEquals(expectedTopicGroups, (Object)topicGroups);
    }

    @Test
    public void testBuild() {
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1", "topic-1x"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        this.builder.addSource(null, "source-3", null, null, null, new String[]{"topic-3"});
        this.builder.addSource(null, "source-4", null, null, null, new String[]{"topic-4"});
        this.builder.addSource(null, "source-5", null, null, null, new String[]{"topic-5"});
        this.builder.addProcessor("processor-1", new MockApiProcessorSupplier(), new String[]{"source-1"});
        this.builder.addProcessor("processor-2", new MockApiProcessorSupplier(), new String[]{"source-2", "processor-1"});
        this.builder.addProcessor("processor-3", new MockApiProcessorSupplier(), new String[]{"source-3", "source-4"});
        this.builder.setApplicationId("X");
        ProcessorTopology topology0 = this.builder.buildSubtopology(0);
        ProcessorTopology topology1 = this.builder.buildSubtopology(1);
        ProcessorTopology topology2 = this.builder.buildSubtopology(2);
        Assertions.assertEquals(Set.of("source-1", "source-2", "processor-1", "processor-2"), this.nodeNames(topology0.processors()));
        Assertions.assertEquals(Set.of("source-3", "source-4", "processor-3"), this.nodeNames(topology1.processors()));
        Assertions.assertEquals(Set.of("source-5"), this.nodeNames(topology2.processors()));
    }

    @Test
    public void shouldAllowIncrementalBuilds() {
        Map oldNodeGroups = this.builder.nodeGroups();
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1"});
        this.builder.addSource(null, "source-2", null, null, null, new String[]{"topic-2"});
        Map newNodeGroups = this.builder.nodeGroups();
        Assertions.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addSource(null, "source-3", null, null, null, Pattern.compile(""));
        this.builder.addSource(null, "source-4", null, null, null, Pattern.compile(""));
        newNodeGroups = this.builder.nodeGroups();
        Assertions.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addProcessor("processor-1", new MockApiProcessorSupplier(), new String[]{"source-1"});
        this.builder.addProcessor("processor-2", new MockApiProcessorSupplier(), new String[]{"source-2"});
        this.builder.addProcessor("processor-3", new MockApiProcessorSupplier(), new String[]{"source-3"});
        newNodeGroups = this.builder.nodeGroups();
        Assertions.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addSink("sink-1", "sink-topic", null, null, null, new String[]{"processor-1"});
        newNodeGroups = this.builder.nodeGroups();
        Assertions.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addSink("sink-2", (k, v, ctx) -> "sink-topic", null, null, null, new String[]{"processor-2"});
        newNodeGroups = this.builder.nodeGroups();
        Assertions.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store-1", false), new String[]{"processor-1", "processor-2"});
        newNodeGroups = this.builder.nodeGroups();
        Assertions.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store-2", false), new String[0]);
        this.builder.connectProcessorAndStateStores("processor-2", new String[]{"store-2"});
        this.builder.connectProcessorAndStateStores("processor-3", new String[]{"store-2"});
        newNodeGroups = this.builder.nodeGroups();
        Assertions.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
        oldNodeGroups = newNodeGroups;
        StoreBuilder globalBuilder = new MockKeyValueStoreBuilder("global-store", false).withLoggingDisabled();
        this.builder.addGlobalStore("globalSource", null, null, null, "globalTopic", "global-processor", (ProcessorSupplier)new StoreDelegatingProcessorSupplier(new MockApiProcessorSupplier(), Set.of(globalBuilder)), false);
        newNodeGroups = this.builder.nodeGroups();
        Assertions.assertNotEquals((Object)oldNodeGroups, (Object)newNodeGroups);
    }

    @Test
    public void shouldNotAllowNullNameWhenAddingSink() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.addSink(null, "topic", null, null, null, new String[0]));
    }

    @Test
    public void shouldNotAllowNullTopicWhenAddingSink() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.addSink("name", (String)null, null, null, null, new String[0]));
    }

    @Test
    public void shouldNotAllowNullTopicChooserWhenAddingSink() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.addSink("name", (TopicNameExtractor)null, null, null, null, new String[0]));
    }

    @Test
    public void shouldNotAllowNullNameWhenAddingProcessor() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.addProcessor(null, () -> null, new String[0]));
    }

    @Test
    public void shouldNotAllowNullProcessorSupplier() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.addProcessor("name", (ProcessorSupplier)null, new String[0]));
    }

    @Test
    public void shouldNotAllowNullNameWhenAddingSource() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.addSource(null, null, null, null, null, Pattern.compile(".*")));
    }

    @Test
    public void shouldNotAllowNullProcessorNameWhenConnectingProcessorAndStateStores() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.connectProcessorAndStateStores(null, new String[]{"store"}));
    }

    @Test
    public void shouldNotAllowNullStateStoreNameWhenConnectingProcessorAndStateStores() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.connectProcessorAndStateStores("processor", new String[]{null}));
    }

    @Test
    public void shouldNotAddNullInternalTopic() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.addInternalTopic(null, InternalTopicProperties.empty()));
    }

    @Test
    public void shouldNotAddNullInternalTopicProperties() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.addInternalTopic("topic", null));
    }

    @Test
    public void shouldNotSetApplicationIdToNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.setApplicationId(null));
    }

    @Test
    public void shouldNotSetStreamsConfigToNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.setStreamsConfig(null));
    }

    @Test
    public void shouldNotAddNullStateStoreSupplier() {
        Assertions.assertThrows(NullPointerException.class, () -> this.builder.addStateStore((StoreBuilder)null, new String[0]));
    }

    private Set<String> nodeNames(Collection<ProcessorNode<?, ?, ?, ?>> nodes) {
        HashSet<String> nodeNames = new HashSet<String>();
        for (ProcessorNode<?, ?, ?, ?> node : nodes) {
            nodeNames.add(node.name());
        }
        return nodeNames;
    }

    @Test
    public void shouldAssociateStateStoreNameWhenStateStoreSupplierIsInternal() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic"});
        this.builder.addProcessor("processor", new MockApiProcessorSupplier(), new String[]{"source"});
        this.builder.addStateStore(this.storeFactory, new String[]{"processor"});
        Map stateStoreNameToSourceTopic = this.builder.stateStoreNameToFullSourceTopicNames();
        Assertions.assertEquals((int)1, (int)stateStoreNameToSourceTopic.size());
        Assertions.assertEquals(Collections.singletonList("topic"), stateStoreNameToSourceTopic.get("testStore"));
    }

    @Test
    public void shouldAssociateStateStoreNameWhenStateStoreSupplierIsExternal() {
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic"});
        this.builder.addProcessor("processor", new MockApiProcessorSupplier(), new String[]{"source"});
        this.builder.addStateStore(this.storeFactory, new String[]{"processor"});
        Map stateStoreNameToSourceTopic = this.builder.stateStoreNameToFullSourceTopicNames();
        Assertions.assertEquals((int)1, (int)stateStoreNameToSourceTopic.size());
        Assertions.assertEquals(Collections.singletonList("topic"), stateStoreNameToSourceTopic.get("testStore"));
    }

    @Test
    public void shouldCorrectlyMapStateStoreToInternalTopics() {
        this.builder.setApplicationId("appId");
        this.builder.addInternalTopic("internal-topic", InternalTopicProperties.empty());
        this.builder.addSource(null, "source", null, null, null, new String[]{"internal-topic"});
        this.builder.addProcessor("processor", new MockApiProcessorSupplier(), new String[]{"source"});
        this.builder.addStateStore(this.storeFactory, new String[]{"processor"});
        Map stateStoreNameToSourceTopic = this.builder.stateStoreNameToFullSourceTopicNames();
        Assertions.assertEquals((int)1, (int)stateStoreNameToSourceTopic.size());
        Assertions.assertEquals(Collections.singletonList("appId-internal-topic"), stateStoreNameToSourceTopic.get("testStore"));
    }

    @Test
    public void shouldAddInternalTopicConfigForWindowStores() {
        this.builder.setApplicationId("appId");
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic"});
        this.builder.addProcessor("processor", new MockApiProcessorSupplier(), new String[]{"source"});
        this.builder.addStateStore(Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.persistentWindowStore((String)"store1", (Duration)Duration.ofSeconds(30L), (Duration)Duration.ofSeconds(10L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.String()), new String[]{"processor"});
        this.builder.addStateStore(Stores.sessionStoreBuilder((SessionBytesStoreSupplier)Stores.persistentSessionStore((String)"store2", (Duration)Duration.ofSeconds(30L)), (Serde)Serdes.String(), (Serde)Serdes.String()), new String[]{"processor"});
        this.builder.buildTopology();
        Map topicGroups = this.builder.subtopologyToTopicsInfo();
        InternalTopologyBuilder.TopicsInfo topicsInfo = (InternalTopologyBuilder.TopicsInfo)topicGroups.values().iterator().next();
        InternalTopicConfig topicConfig1 = (InternalTopicConfig)topicsInfo.stateChangelogTopics.get("appId-store1-changelog");
        Map properties1 = topicConfig1.properties(Collections.emptyMap(), 10000L);
        Assertions.assertEquals((int)3, (int)properties1.size());
        Assertions.assertEquals((Object)"compact,delete", properties1.get("cleanup.policy"));
        Assertions.assertEquals((Object)"40000", properties1.get("retention.ms"));
        Assertions.assertEquals((Object)"appId-store1-changelog", (Object)topicConfig1.name());
        Assertions.assertInstanceOf(WindowedChangelogTopicConfig.class, (Object)topicConfig1);
        InternalTopicConfig topicConfig2 = (InternalTopicConfig)topicsInfo.stateChangelogTopics.get("appId-store2-changelog");
        Map properties2 = topicConfig2.properties(Collections.emptyMap(), 10000L);
        Assertions.assertEquals((int)3, (int)properties2.size());
        Assertions.assertEquals((Object)"compact,delete", properties2.get("cleanup.policy"));
        Assertions.assertEquals((Object)"40000", properties2.get("retention.ms"));
        Assertions.assertEquals((Object)"appId-store2-changelog", (Object)topicConfig2.name());
        Assertions.assertInstanceOf(WindowedChangelogTopicConfig.class, (Object)topicConfig2);
    }

    @Test
    public void shouldAddInternalTopicConfigForVersionedStores() {
        this.builder.setApplicationId("appId");
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic"});
        this.builder.addProcessor("processor", new MockApiProcessorSupplier(), new String[]{"source"});
        this.builder.addStateStore(Stores.versionedKeyValueStoreBuilder((VersionedBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"vstore", (Duration)Duration.ofMillis(60000L)), (Serde)Serdes.String(), (Serde)Serdes.String()), new String[]{"processor"});
        this.builder.buildTopology();
        Map topicGroups = this.builder.subtopologyToTopicsInfo();
        InternalTopologyBuilder.TopicsInfo topicsInfo = (InternalTopologyBuilder.TopicsInfo)topicGroups.values().iterator().next();
        InternalTopicConfig topicConfig = (InternalTopicConfig)topicsInfo.stateChangelogTopics.get("appId-vstore-changelog");
        Map properties = topicConfig.properties(Collections.emptyMap(), 10000L);
        Assertions.assertEquals((int)3, (int)properties.size());
        Assertions.assertEquals((Object)"compact", properties.get("cleanup.policy"));
        Assertions.assertEquals((Object)Long.toString(86460000L), properties.get("min.compaction.lag.ms"));
        Assertions.assertEquals((Object)"appId-vstore-changelog", (Object)topicConfig.name());
        Assertions.assertInstanceOf(VersionedChangelogTopicConfig.class, (Object)topicConfig);
    }

    @Test
    public void shouldAddInternalTopicConfigForNonWindowNonVersionedStores() {
        this.builder.setApplicationId("appId");
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic"});
        this.builder.addProcessor("processor", new MockApiProcessorSupplier(), new String[]{"source"});
        this.builder.addStateStore(this.storeFactory, new String[]{"processor"});
        this.builder.buildTopology();
        Map topicGroups = this.builder.subtopologyToTopicsInfo();
        InternalTopologyBuilder.TopicsInfo topicsInfo = (InternalTopologyBuilder.TopicsInfo)topicGroups.values().iterator().next();
        InternalTopicConfig topicConfig = (InternalTopicConfig)topicsInfo.stateChangelogTopics.get("appId-testStore-changelog");
        Map properties = topicConfig.properties(Collections.emptyMap(), 10000L);
        Assertions.assertEquals((int)2, (int)properties.size());
        Assertions.assertEquals((Object)"compact", properties.get("cleanup.policy"));
        Assertions.assertEquals((Object)"appId-testStore-changelog", (Object)topicConfig.name());
        Assertions.assertInstanceOf(UnwindowedUnversionedChangelogTopicConfig.class, (Object)topicConfig);
    }

    @Test
    public void shouldAddInternalTopicConfigForRepartitionTopics() {
        this.builder.setApplicationId("appId");
        this.builder.addInternalTopic("foo", InternalTopicProperties.empty());
        this.builder.addSource(null, "source", null, null, null, new String[]{"foo"});
        this.builder.buildTopology();
        InternalTopologyBuilder.TopicsInfo topicsInfo = (InternalTopologyBuilder.TopicsInfo)this.builder.subtopologyToTopicsInfo().values().iterator().next();
        InternalTopicConfig topicConfig = (InternalTopicConfig)topicsInfo.repartitionSourceTopics.get("appId-foo");
        Map properties = topicConfig.properties(Collections.emptyMap(), 10000L);
        Assertions.assertEquals((int)4, (int)properties.size());
        Assertions.assertEquals((Object)String.valueOf(-1), properties.get("retention.ms"));
        Assertions.assertEquals((Object)"delete", properties.get("cleanup.policy"));
        Assertions.assertEquals((Object)"appId-foo", (Object)topicConfig.name());
        Assertions.assertInstanceOf(RepartitionTopicConfig.class, (Object)topicConfig);
    }

    @Test
    public void shouldSetCorrectSourceNodesWithRegexUpdatedTopics() {
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-foo"});
        this.builder.addSource(null, "source-2", null, null, null, Pattern.compile("topic-[A-C]"));
        this.builder.addSource(null, "source-3", null, null, null, Pattern.compile("topic-\\d"));
        HashSet<String> updatedTopics = new HashSet<String>();
        updatedTopics.add("topic-B");
        updatedTopics.add("topic-3");
        updatedTopics.add("topic-A");
        this.builder.addSubscribedTopicsFromMetadata(updatedTopics, null);
        this.builder.setApplicationId("test-id");
        Map topicGroups = this.builder.subtopologyToTopicsInfo();
        Assertions.assertTrue((boolean)((InternalTopologyBuilder.TopicsInfo)topicGroups.get((Object)AssignmentTestUtils.SUBTOPOLOGY_0)).sourceTopics.contains("topic-foo"));
        Assertions.assertTrue((boolean)((InternalTopologyBuilder.TopicsInfo)topicGroups.get((Object)AssignmentTestUtils.SUBTOPOLOGY_1)).sourceTopics.contains("topic-A"));
        Assertions.assertTrue((boolean)((InternalTopologyBuilder.TopicsInfo)topicGroups.get((Object)AssignmentTestUtils.SUBTOPOLOGY_1)).sourceTopics.contains("topic-B"));
        Assertions.assertTrue((boolean)((InternalTopologyBuilder.TopicsInfo)topicGroups.get((Object)AssignmentTestUtils.SUBTOPOLOGY_2)).sourceTopics.contains("topic-3"));
    }

    @Test
    public void shouldSetTopologyConfigOnRewriteTopology() {
        Properties globalProps = StreamsTestUtils.getStreamsConfig();
        globalProps.put("max.task.idle.ms", (Object)100L);
        StreamsConfig globalStreamsConfig = new StreamsConfig((Map)globalProps);
        InternalTopologyBuilder topologyBuilder = this.builder.rewriteTopology(globalStreamsConfig);
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs(), (Matcher)CoreMatchers.equalTo((Object)new TopologyConfig(null, globalStreamsConfig, new Properties())));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().getTaskConfig().maxTaskIdleMs, (Matcher)CoreMatchers.equalTo((Object)100L));
    }

    @Test
    public void shouldUseNonDeprecatedConfigToSetCacheBytesWhenBothDeprecatedAndNonDeprecatedConfigsUsed() {
        Properties globalProps = StreamsTestUtils.getStreamsConfig();
        globalProps.put("statestore.cache.max.bytes", (Object)200L);
        globalProps.put("cache.max.bytes.buffering", (Object)100L);
        StreamsConfig globalStreamsConfig = new StreamsConfig((Map)globalProps);
        InternalTopologyBuilder topologyBuilder = this.builder.rewriteTopology(globalStreamsConfig);
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs(), (Matcher)CoreMatchers.equalTo((Object)new TopologyConfig(null, globalStreamsConfig, new Properties())));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().cacheSize, (Matcher)CoreMatchers.equalTo((Object)200L));
    }

    @Test
    public void shouldOverrideGlobalStreamsConfigWhenGivenNamedTopologyProps() {
        Properties topologyOverrides = new Properties();
        topologyOverrides.put("statestore.cache.max.bytes", (Object)12345L);
        topologyOverrides.put("max.task.idle.ms", (Object)500L);
        topologyOverrides.put("task.timeout.ms", (Object)1000L);
        topologyOverrides.put("buffered.records.per.partition", (Object)15);
        topologyOverrides.put("default.timestamp.extractor", MockTimestampExtractor.class);
        topologyOverrides.put("deserialization.exception.handler", LogAndContinueExceptionHandler.class);
        topologyOverrides.put("default.dsl.store", "in_memory");
        StreamsConfig config = new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig());
        InternalTopologyBuilder topologyBuilder = new InternalTopologyBuilder(new TopologyConfig("my-topology", config, topologyOverrides));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().cacheSize, (Matcher)CoreMatchers.is((Object)12345L));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().getTaskConfig().maxTaskIdleMs, (Matcher)CoreMatchers.equalTo((Object)500L));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().getTaskConfig().taskTimeoutMs, (Matcher)CoreMatchers.equalTo((Object)1000L));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().getTaskConfig().maxBufferedSize, (Matcher)CoreMatchers.equalTo((Object)15));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().getTaskConfig().timestampExtractor.getClass(), (Matcher)CoreMatchers.equalTo(MockTimestampExtractor.class));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().getTaskConfig().deserializationExceptionHandler.getClass(), (Matcher)CoreMatchers.equalTo(LogAndContinueExceptionHandler.class));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().parseStoreType(), (Matcher)CoreMatchers.equalTo((Object)Materialized.StoreType.IN_MEMORY));
    }

    @Test
    public void newDeserializationExceptionHandlerConfigShouldOverwriteOldOne() {
        Properties topologyOverrides = new Properties();
        topologyOverrides.put("default.deserialization.exception.handler", LogAndFailExceptionHandler.class);
        topologyOverrides.put("deserialization.exception.handler", LogAndContinueExceptionHandler.class);
        StreamsConfig config = new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig());
        InternalTopologyBuilder topologyBuilder = new InternalTopologyBuilder(new TopologyConfig("my-topology", config, topologyOverrides));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().getTaskConfig().deserializationExceptionHandler.getClass(), (Matcher)CoreMatchers.equalTo(LogAndContinueExceptionHandler.class));
    }

    @Test
    public void shouldNotOverrideGlobalStreamsConfigWhenGivenUnnamedTopologyProps() {
        Properties streamsProps = StreamsTestUtils.getStreamsConfig();
        streamsProps.put("statestore.cache.max.bytes", (Object)12345L);
        streamsProps.put("max.task.idle.ms", (Object)500L);
        streamsProps.put("task.timeout.ms", (Object)1000L);
        streamsProps.put("buffered.records.per.partition", (Object)15);
        streamsProps.put("default.timestamp.extractor", MockTimestampExtractor.class);
        streamsProps.put("default.deserialization.exception.handler", LogAndContinueExceptionHandler.class);
        StreamsConfig config = new StreamsConfig((Map)streamsProps);
        InternalTopologyBuilder topologyBuilder = new InternalTopologyBuilder(new TopologyConfig("my-topology", config, new Properties()));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().cacheSize, (Matcher)CoreMatchers.is((Object)12345L));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().getTaskConfig().maxTaskIdleMs, (Matcher)CoreMatchers.is((Object)500L));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().getTaskConfig().taskTimeoutMs, (Matcher)CoreMatchers.is((Object)1000L));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().getTaskConfig().maxBufferedSize, (Matcher)CoreMatchers.is((Object)15));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().getTaskConfig().timestampExtractor.getClass(), (Matcher)CoreMatchers.is(MockTimestampExtractor.class));
        MatcherAssert.assertThat((Object)topologyBuilder.topologyConfigs().getTaskConfig().deserializationExceptionHandler.getClass(), (Matcher)CoreMatchers.is(LogAndContinueExceptionHandler.class));
    }

    @Test
    public void shouldAddTimestampExtractorPerSource() {
        this.builder.addSource(null, "source", (TimestampExtractor)new MockTimestampExtractor(), null, null, new String[]{"topic"});
        ProcessorTopology processorTopology = this.builder.rewriteTopology(new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig())).buildTopology();
        MatcherAssert.assertThat((Object)processorTopology.source("topic").timestampExtractor(), (Matcher)IsInstanceOf.instanceOf(MockTimestampExtractor.class));
    }

    @Test
    public void shouldAddTimestampExtractorWithPatternPerSource() {
        Pattern pattern = Pattern.compile("t.*");
        this.builder.addSource(null, "source", (TimestampExtractor)new MockTimestampExtractor(), null, null, pattern);
        ProcessorTopology processorTopology = this.builder.rewriteTopology(new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig())).buildTopology();
        MatcherAssert.assertThat((Object)processorTopology.source(pattern.pattern()).timestampExtractor(), (Matcher)IsInstanceOf.instanceOf(MockTimestampExtractor.class));
    }

    @Test
    public void shouldSortProcessorNodesCorrectly() {
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topic2"});
        this.builder.addProcessor("processor1", new MockApiProcessorSupplier(), new String[]{"source1"});
        this.builder.addProcessor("processor2", new MockApiProcessorSupplier(), new String[]{"source1", "source2"});
        this.builder.addProcessor("processor3", new MockApiProcessorSupplier(), new String[]{"processor2"});
        this.builder.addSink("sink1", "topic2", null, null, null, new String[]{"processor1", "processor3"});
        Assertions.assertEquals((int)1, (int)this.builder.describe().subtopologies().size());
        Iterator iterator = ((InternalTopologyBuilder.SubtopologyDescription)this.builder.describe().subtopologies().iterator().next()).nodesInOrder();
        Assertions.assertTrue((boolean)iterator.hasNext());
        InternalTopologyBuilder.AbstractNode node = (InternalTopologyBuilder.AbstractNode)iterator.next();
        Assertions.assertEquals((Object)"source1", (Object)node.name);
        Assertions.assertEquals((int)6, (int)node.size);
        Assertions.assertTrue((boolean)iterator.hasNext());
        node = (InternalTopologyBuilder.AbstractNode)iterator.next();
        Assertions.assertEquals((Object)"source2", (Object)node.name);
        Assertions.assertEquals((int)4, (int)node.size);
        Assertions.assertTrue((boolean)iterator.hasNext());
        node = (InternalTopologyBuilder.AbstractNode)iterator.next();
        Assertions.assertEquals((Object)"processor2", (Object)node.name);
        Assertions.assertEquals((int)3, (int)node.size);
        Assertions.assertTrue((boolean)iterator.hasNext());
        node = (InternalTopologyBuilder.AbstractNode)iterator.next();
        Assertions.assertEquals((Object)"processor1", (Object)node.name);
        Assertions.assertEquals((int)2, (int)node.size);
        Assertions.assertTrue((boolean)iterator.hasNext());
        node = (InternalTopologyBuilder.AbstractNode)iterator.next();
        Assertions.assertEquals((Object)"processor3", (Object)node.name);
        Assertions.assertEquals((int)2, (int)node.size);
        Assertions.assertTrue((boolean)iterator.hasNext());
        node = (InternalTopologyBuilder.AbstractNode)iterator.next();
        Assertions.assertEquals((Object)"sink1", (Object)node.name);
        Assertions.assertEquals((int)1, (int)node.size);
    }

    @Test
    public void shouldConnectRegexMatchedTopicsToStateStore() {
        this.builder.addSource(null, "ingest", null, null, null, Pattern.compile("topic-\\d+"));
        this.builder.addProcessor("my-processor", new MockApiProcessorSupplier(), new String[]{"ingest"});
        this.builder.addStateStore(this.storeFactory, new String[]{"my-processor"});
        HashSet<String> updatedTopics = new HashSet<String>();
        updatedTopics.add("topic-2");
        updatedTopics.add("topic-3");
        updatedTopics.add("topic-A");
        this.builder.addSubscribedTopicsFromMetadata(updatedTopics, "test-thread");
        this.builder.setApplicationId("test-app");
        Map stateStoreAndTopics = this.builder.stateStoreNameToFullSourceTopicNames();
        List topics = (List)stateStoreAndTopics.get(this.storeFactory.storeName());
        Assertions.assertEquals((int)2, (int)topics.size(), (String)"Expected to contain two topics");
        Assertions.assertTrue((boolean)topics.contains("topic-2"));
        Assertions.assertTrue((boolean)topics.contains("topic-3"));
        Assertions.assertFalse((boolean)topics.contains("topic-A"));
    }

    @Test
    public void shouldNotAllowToAddGlobalStoreWithSourceNameEqualsProcessorName() {
        String sameNameForSourceAndProcessor = "sameName";
        Assertions.assertThrows(TopologyException.class, () -> this.builder.addGlobalStore("sameName", null, null, null, "anyTopicName", "sameName", (ProcessorSupplier)new StoreDelegatingProcessorSupplier(new MockApiProcessorSupplier(), Set.of(this.storeBuilder)), false));
    }

    @Test
    public void shouldThrowIfNameIsNull() {
        Exception e = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new InternalTopologyBuilder.Source(null, Collections.emptySet(), null));
        Assertions.assertEquals((Object)"name cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfTopicAndPatternAreNull() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new InternalTopologyBuilder.Source("name", null, null));
        Assertions.assertEquals((Object)"Either topics or pattern must be not-null, but both are null.", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfBothTopicAndPatternAreNotNull() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new InternalTopologyBuilder.Source("name", Collections.emptySet(), Pattern.compile("")));
        Assertions.assertEquals((Object)"Either topics or pattern must be null, but both are not null.", (Object)e.getMessage());
    }

    @Test
    public void sourceShouldBeEqualIfNameAndTopicListAreTheSame() {
        InternalTopologyBuilder.Source base = new InternalTopologyBuilder.Source("name", Collections.singleton("topic"), null);
        InternalTopologyBuilder.Source sameAsBase = new InternalTopologyBuilder.Source("name", Collections.singleton("topic"), null);
        MatcherAssert.assertThat((Object)base, (Matcher)CoreMatchers.equalTo((Object)sameAsBase));
    }

    @Test
    public void sourceShouldBeEqualIfNameAndPatternAreTheSame() {
        InternalTopologyBuilder.Source base = new InternalTopologyBuilder.Source("name", null, Pattern.compile("topic"));
        InternalTopologyBuilder.Source sameAsBase = new InternalTopologyBuilder.Source("name", null, Pattern.compile("topic"));
        MatcherAssert.assertThat((Object)base, (Matcher)CoreMatchers.equalTo((Object)sameAsBase));
    }

    @Test
    public void sourceShouldNotBeEqualForDifferentNamesWithSameTopicList() {
        InternalTopologyBuilder.Source base = new InternalTopologyBuilder.Source("name", Collections.singleton("topic"), null);
        InternalTopologyBuilder.Source differentName = new InternalTopologyBuilder.Source("name2", Collections.singleton("topic"), null);
        MatcherAssert.assertThat((Object)base, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)differentName)));
    }

    @Test
    public void sourceShouldNotBeEqualForDifferentNamesWithSamePattern() {
        InternalTopologyBuilder.Source base = new InternalTopologyBuilder.Source("name", null, Pattern.compile("topic"));
        InternalTopologyBuilder.Source differentName = new InternalTopologyBuilder.Source("name2", null, Pattern.compile("topic"));
        MatcherAssert.assertThat((Object)base, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)differentName)));
    }

    @Test
    public void sourceShouldNotBeEqualForDifferentTopicList() {
        InternalTopologyBuilder.Source base = new InternalTopologyBuilder.Source("name", Collections.singleton("topic"), null);
        InternalTopologyBuilder.Source differentTopicList = new InternalTopologyBuilder.Source("name", Collections.emptySet(), null);
        InternalTopologyBuilder.Source differentTopic = new InternalTopologyBuilder.Source("name", Collections.singleton("topic2"), null);
        MatcherAssert.assertThat((Object)base, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)differentTopicList)));
        MatcherAssert.assertThat((Object)base, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)differentTopic)));
    }

    @Test
    public void sourceShouldNotBeEqualForDifferentPattern() {
        InternalTopologyBuilder.Source base = new InternalTopologyBuilder.Source("name", null, Pattern.compile("topic"));
        InternalTopologyBuilder.Source differentPattern = new InternalTopologyBuilder.Source("name", null, Pattern.compile("topic2"));
        InternalTopologyBuilder.Source overlappingPattern = new InternalTopologyBuilder.Source("name", null, Pattern.compile("top*"));
        MatcherAssert.assertThat((Object)base, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)differentPattern)));
        MatcherAssert.assertThat((Object)base, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)overlappingPattern)));
    }

    @Test
    public void shouldHaveCorrectInternalTopicConfigWhenInternalTopicPropertiesArePresent() {
        int numberOfPartitions = 10;
        this.builder.setApplicationId("Z");
        this.builder.addInternalTopic("topic-1z", new InternalTopicProperties(Integer.valueOf(10)));
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1z"});
        Map topicGroups = this.builder.subtopologyToTopicsInfo();
        Map repartitionSourceTopics = ((InternalTopologyBuilder.TopicsInfo)topicGroups.get((Object)AssignmentTestUtils.SUBTOPOLOGY_0)).repartitionSourceTopics;
        Assertions.assertEquals(repartitionSourceTopics.get("Z-topic-1z"), (Object)new RepartitionTopicConfig("Z-topic-1z", Collections.emptyMap(), 10, true));
    }

    @Test
    public void shouldHandleWhenTopicPropertiesNumberOfPartitionsIsNull() {
        this.builder.setApplicationId("T");
        this.builder.addInternalTopic("topic-1t", InternalTopicProperties.empty());
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1t"});
        Map topicGroups = this.builder.subtopologyToTopicsInfo();
        Map repartitionSourceTopics = ((InternalTopologyBuilder.TopicsInfo)topicGroups.get((Object)AssignmentTestUtils.SUBTOPOLOGY_0)).repartitionSourceTopics;
        Assertions.assertEquals(repartitionSourceTopics.get("T-topic-1t"), (Object)new RepartitionTopicConfig("T-topic-1t", Collections.emptyMap()));
    }

    @Test
    public void shouldHaveCorrectInternalTopicConfigWhenInternalTopicPropertiesAreNotPresent() {
        this.builder.setApplicationId("Y");
        this.builder.addInternalTopic("topic-1y", InternalTopicProperties.empty());
        this.builder.addSource(null, "source-1", null, null, null, new String[]{"topic-1y"});
        Map topicGroups = this.builder.subtopologyToTopicsInfo();
        Map repartitionSourceTopics = ((InternalTopologyBuilder.TopicsInfo)topicGroups.get((Object)AssignmentTestUtils.SUBTOPOLOGY_0)).repartitionSourceTopics;
        Assertions.assertEquals(repartitionSourceTopics.get("Y-topic-1y"), (Object)new RepartitionTopicConfig("Y-topic-1y", Collections.emptyMap()));
    }

    @Test
    public void shouldConnectGlobalStateStoreToInputTopic() {
        String globalStoreName = "global-store";
        String globalTopic = "global-topic";
        StoreBuilder storeBuilder = new MockKeyValueStoreBuilder("global-store", false).withLoggingDisabled();
        this.builder.setApplicationId("X");
        this.builder.addGlobalStore("globalSource", null, null, null, "global-topic", "global-processor", (ProcessorSupplier)new StoreDelegatingProcessorSupplier(new MockApiProcessorSupplier(), Set.of(storeBuilder)), false);
        this.builder.initializeSubscription();
        this.builder.rewriteTopology(new StreamsConfig((Map)Utils.mkProperties((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"asdf"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"asdf")}))));
        MatcherAssert.assertThat((Object)((String)this.builder.buildGlobalStateTopology().storeToChangelogTopic().get("global-store")), (Matcher)CoreMatchers.is((Object)"global-topic"));
    }

    @Test
    public void shouldWrapProcessorSupplier() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", ProcessorSkippingWrapper.class);
        InternalTopologyBuilder builder = new InternalTopologyBuilder(new TopologyConfig(new StreamsConfig(props)));
        ProcessorSupplier throwingProcessorSupplier = () -> record -> {
            throw new RuntimeException("oops, don't call process on me!");
        };
        WrappedProcessorSupplier wrappedProcessorSupplier = builder.wrapProcessorSupplier("name", throwingProcessorSupplier);
        Processor throwingProcessor = throwingProcessorSupplier.get();
        Processor wrappedProcessor = wrappedProcessorSupplier.get();
        Record input = new Record((Object)"key", (Object)"value", 0L);
        Assertions.assertThrows(RuntimeException.class, () -> throwingProcessor.process(input));
        wrappedProcessor.process(input);
    }

    @Test
    public void shouldWrapFixedKeyProcessorSupplier() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", ProcessorSkippingWrapper.class.getName());
        InternalTopologyBuilder builder = new InternalTopologyBuilder(new TopologyConfig(new StreamsConfig(props)));
        FixedKeyProcessorSupplier throwingProcessorSupplier = () -> record -> {
            throw new RuntimeException("oops, don't call process on me!");
        };
        WrappedFixedKeyProcessorSupplier wrappedProcessorSupplier = builder.wrapFixedKeyProcessorSupplier("name", throwingProcessorSupplier);
        FixedKeyProcessor throwingProcessor = throwingProcessorSupplier.get();
        FixedKeyProcessor wrappedProcessor = wrappedProcessorSupplier.get();
        FixedKeyRecord input = null;
        Assertions.assertThrows(RuntimeException.class, () -> throwingProcessor.process(input));
        wrappedProcessor.process(input);
    }

    @Test
    public void shouldThrowOnInvalidProcessorWrapperClassName() {
        Map<Object, Object> props = TestUtils.dummyStreamsConfigMap();
        props.put("processor.wrapper.class", "invalid.class");
        Assertions.assertThrows(ConfigException.class, () -> new InternalTopologyBuilder(new TopologyConfig(new StreamsConfig(props))));
    }

    private /* synthetic */ void lambda$shouldNotAllowToAddStoresWithSameName$14(StoreBuilder otherBuilder) throws Throwable {
        this.builder.addStateStore(otherBuilder, new String[0]);
    }

    public static class ProcessorSkippingWrapper
    implements ProcessorWrapper {
        public <KIn, VIn, KOut, VOut> WrappedProcessorSupplier<KIn, VIn, KOut, VOut> wrapProcessorSupplier(String processorName, ProcessorSupplier<KIn, VIn, KOut, VOut> processorSupplier) {
            return () -> record -> {};
        }

        public <KIn, VIn, VOut> WrappedFixedKeyProcessorSupplier<KIn, VIn, VOut> wrapFixedKeyProcessorSupplier(String processorName, FixedKeyProcessorSupplier<KIn, VIn, VOut> processorSupplier) {
            return () -> record -> {};
        }
    }
}

