/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ChangelogRecordDeserializationHelper;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.ProcessorMetadata;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.PositionSerde;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class ProcessorContextImplTest {
    private ProcessorContextImpl context;
    private final StreamsConfig streamsConfig = this.streamsConfigMock();
    @Mock
    private RecordCollector recordCollector;
    @Mock
    private ProcessorStateManager stateManager;
    private static final String KEY = "key";
    private static final Bytes KEY_BYTES = Bytes.wrap((byte[])"key".getBytes());
    private static final long VALUE = 42L;
    private static final byte[] VALUE_BYTES = String.valueOf(42L).getBytes();
    private static final long TIMESTAMP = 21L;
    private static final long STREAM_TIME = 50L;
    private static final ValueAndTimestamp<Long> VALUE_AND_TIMESTAMP = ValueAndTimestamp.make((Object)42L, (long)21L);
    private static final String STORE_NAME = "underlying-store";
    private static final String REGISTERED_STORE_NAME = "registered-store";
    private static final TopicPartition CHANGELOG_PARTITION = new TopicPartition("store-changelog", 1);
    private boolean flushExecuted = false;
    private boolean putExecuted = false;
    private boolean putWithTimestampExecuted;
    private boolean putIfAbsentExecuted = false;
    private boolean putAllExecuted = false;
    private boolean deleteExecuted = false;
    private boolean removeExecuted = false;
    @Mock
    private KeyValueIterator<String, Long> rangeIter;
    @Mock
    private KeyValueIterator<String, ValueAndTimestamp<Long>> timestampedRangeIter;
    @Mock
    private KeyValueIterator<String, Long> allIter;
    @Mock
    private KeyValueIterator<String, ValueAndTimestamp<Long>> timestampedAllIter;
    @Mock
    private WindowStoreIterator windowStoreIter;
    private final List<KeyValueIterator<Windowed<String>, Long>> iters = new ArrayList<KeyValueIterator<Windowed<String>, Long>>(7);
    private final List<KeyValueIterator<Windowed<String>, ValueAndTimestamp<Long>>> timestampedIters = new ArrayList<KeyValueIterator<Windowed<String>, ValueAndTimestamp<Long>>>(7);

    private void foreachSetUp() {
        for (int i = 0; i < 7; ++i) {
            this.iters.add(i, (KeyValueIterator<Windowed<String>, Long>)((KeyValueIterator)Mockito.mock(KeyValueIterator.class)));
            this.timestampedIters.add(i, (KeyValueIterator<Windowed<String>, ValueAndTimestamp<Long>>)((KeyValueIterator)Mockito.mock(KeyValueIterator.class)));
        }
    }

    private ProcessorContextImpl getStandbyContext() {
        ProcessorStateManager stateManager = (ProcessorStateManager)Mockito.mock(ProcessorStateManager.class);
        Mockito.when((Object)stateManager.taskType()).thenReturn((Object)Task.TaskType.STANDBY);
        return this.buildProcessorContextImpl(this.streamsConfig, stateManager);
    }

    @Test
    public void globalKeyValueStoreShouldBeReadOnly() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        Mockito.when((Object)this.stateManager.globalStore(ArgumentMatchers.anyString())).thenReturn(null);
        KeyValueStore keyValueStoreMock = (KeyValueStore)Mockito.mock(KeyValueStore.class);
        Mockito.when((Object)this.stateManager.globalStore("GlobalKeyValueStore")).thenAnswer(answer -> this.keyValueStoreMock((KeyValueStore<String, Long>)keyValueStoreMock));
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.doTest("GlobalKeyValueStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            this.checkThrowsUnsupportedOperation(() -> ((KeyValueStore)store).flush(), "flush()");
            this.checkThrowsUnsupportedOperation(() -> store.put((Object)"1", (Object)1L), "put()");
            this.checkThrowsUnsupportedOperation(() -> store.putIfAbsent((Object)"1", (Object)1L), "putIfAbsent()");
            this.checkThrowsUnsupportedOperation(() -> store.putAll(Collections.emptyList()), "putAll()");
            this.checkThrowsUnsupportedOperation(() -> store.delete((Object)"1"), "delete()");
            Assertions.assertEquals((Long)42L, (Long)((Long)store.get((Object)KEY)));
            Assertions.assertEquals(this.rangeIter, (Object)store.range((Object)"one", (Object)"two"));
            Assertions.assertEquals(this.allIter, (Object)store.all());
            Assertions.assertEquals((long)42L, (long)store.approximateNumEntries());
        });
    }

    @Test
    public void globalTimestampedKeyValueStoreShouldBeReadOnly() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        Mockito.when((Object)this.stateManager.globalStore(ArgumentMatchers.anyString())).thenReturn(null);
        TimestampedKeyValueStore timestampedKeyValueStoreMock = (TimestampedKeyValueStore)Mockito.mock(TimestampedKeyValueStore.class);
        Mockito.when((Object)this.stateManager.globalStore("GlobalTimestampedKeyValueStore")).thenAnswer(answer -> this.timestampedKeyValueStoreMock((TimestampedKeyValueStore<String, Long>)timestampedKeyValueStoreMock));
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.doTest("GlobalTimestampedKeyValueStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            this.checkThrowsUnsupportedOperation(() -> ((TimestampedKeyValueStore)store).flush(), "flush()");
            this.checkThrowsUnsupportedOperation(() -> store.put((Object)"1", (Object)ValueAndTimestamp.make((Object)1L, (long)2L)), "put()");
            this.checkThrowsUnsupportedOperation(() -> store.putIfAbsent((Object)"1", (Object)ValueAndTimestamp.make((Object)1L, (long)2L)), "putIfAbsent()");
            this.checkThrowsUnsupportedOperation(() -> store.putAll(Collections.emptyList()), "putAll()");
            this.checkThrowsUnsupportedOperation(() -> store.delete((Object)"1"), "delete()");
            Assertions.assertEquals(VALUE_AND_TIMESTAMP, (Object)store.get((Object)KEY));
            Assertions.assertEquals(this.timestampedRangeIter, (Object)store.range((Object)"one", (Object)"two"));
            Assertions.assertEquals(this.timestampedAllIter, (Object)store.all());
            Assertions.assertEquals((long)42L, (long)store.approximateNumEntries());
        });
    }

    @Test
    public void globalWindowStoreShouldBeReadOnly() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        Mockito.when((Object)this.stateManager.globalStore(ArgumentMatchers.anyString())).thenReturn(null);
        WindowStore windowStore = (WindowStore)Mockito.mock(WindowStore.class);
        Mockito.when((Object)this.stateManager.globalStore("GlobalWindowStore")).thenAnswer(answer -> this.windowStoreMock((WindowStore<String, Long>)windowStore));
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.doTest("GlobalWindowStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            this.checkThrowsUnsupportedOperation(() -> ((WindowStore)store).flush(), "flush()");
            this.checkThrowsUnsupportedOperation(() -> store.put((Object)"1", (Object)1L, 1L), "put()");
            Assertions.assertEquals(this.iters.get(0), (Object)store.fetchAll(0L, 0L));
            Assertions.assertEquals((Object)this.windowStoreIter, (Object)store.fetch((Object)KEY, 0L, 1L));
            Assertions.assertEquals(this.iters.get(1), (Object)store.fetch((Object)KEY, (Object)KEY, 0L, 1L));
            Assertions.assertEquals((Long)42L, (Long)((Long)store.fetch((Object)KEY, 1L)));
            Assertions.assertEquals(this.iters.get(2), (Object)store.all());
        });
    }

    @Test
    public void globalTimestampedWindowStoreShouldBeReadOnly() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        Mockito.when((Object)this.stateManager.globalStore(ArgumentMatchers.anyString())).thenReturn(null);
        TimestampedWindowStore windowStore = (TimestampedWindowStore)Mockito.mock(TimestampedWindowStore.class);
        Mockito.when((Object)this.stateManager.globalStore("GlobalTimestampedWindowStore")).thenAnswer(answer -> this.timestampedWindowStoreMock((TimestampedWindowStore<String, Long>)windowStore));
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.doTest("GlobalTimestampedWindowStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            this.checkThrowsUnsupportedOperation(() -> ((TimestampedWindowStore)store).flush(), "flush()");
            this.checkThrowsUnsupportedOperation(() -> store.put((Object)"1", (Object)ValueAndTimestamp.make((Object)1L, (long)1L), 1L), "put() [with timestamp]");
            Assertions.assertEquals(this.timestampedIters.get(0), (Object)store.fetchAll(0L, 0L));
            Assertions.assertEquals((Object)this.windowStoreIter, (Object)store.fetch((Object)KEY, 0L, 1L));
            Assertions.assertEquals(this.timestampedIters.get(1), (Object)store.fetch((Object)KEY, (Object)KEY, 0L, 1L));
            Assertions.assertEquals(VALUE_AND_TIMESTAMP, (Object)store.fetch((Object)KEY, 1L));
            Assertions.assertEquals(this.timestampedIters.get(2), (Object)store.all());
        });
    }

    @Test
    public void globalSessionStoreShouldBeReadOnly() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        Mockito.when((Object)this.stateManager.globalStore(ArgumentMatchers.anyString())).thenReturn(null);
        SessionStore sessionStore = (SessionStore)Mockito.mock(SessionStore.class);
        Mockito.when((Object)this.stateManager.globalStore("GlobalSessionStore")).thenAnswer(answer -> this.sessionStoreMock((SessionStore<String, Long>)sessionStore));
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.doTest("GlobalSessionStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            this.checkThrowsUnsupportedOperation(() -> ((SessionStore)store).flush(), "flush()");
            this.checkThrowsUnsupportedOperation(() -> store.remove(null), "remove()");
            this.checkThrowsUnsupportedOperation(() -> store.put(null, null), "put()");
            Assertions.assertEquals(this.iters.get(3), (Object)store.findSessions((Object)KEY, 1L, 2L));
            Assertions.assertEquals(this.iters.get(4), (Object)store.findSessions((Object)KEY, (Object)KEY, 1L, 2L));
            Assertions.assertEquals(this.iters.get(5), (Object)store.fetch((Object)KEY));
            Assertions.assertEquals(this.iters.get(6), (Object)store.fetch((Object)KEY, (Object)KEY));
        });
    }

    @Test
    public void localKeyValueStoreShouldNotAllowInitOrClose() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        Mockito.when((Object)this.stateManager.globalStore(ArgumentMatchers.anyString())).thenReturn(null);
        KeyValueStore keyValueStoreMock = (KeyValueStore)Mockito.mock(KeyValueStore.class);
        Mockito.when((Object)this.stateManager.store("LocalKeyValueStore")).thenAnswer(answer -> this.keyValueStoreMock((KeyValueStore<String, Long>)keyValueStoreMock));
        this.mockStateStoreFlush((StateStore)keyValueStoreMock);
        this.mockKeyValueStoreOperation((KeyValueStore<String, Long>)keyValueStoreMock);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.doTest("LocalKeyValueStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            store.flush();
            Assertions.assertTrue((boolean)this.flushExecuted);
            store.put((Object)"1", (Object)1L);
            Assertions.assertTrue((boolean)this.putExecuted);
            store.putIfAbsent((Object)"1", (Object)1L);
            Assertions.assertTrue((boolean)this.putIfAbsentExecuted);
            store.putAll(Collections.emptyList());
            Assertions.assertTrue((boolean)this.putAllExecuted);
            store.delete((Object)"1");
            Assertions.assertTrue((boolean)this.deleteExecuted);
            Assertions.assertEquals((Long)42L, (Long)((Long)store.get((Object)KEY)));
            Assertions.assertEquals(this.rangeIter, (Object)store.range((Object)"one", (Object)"two"));
            Assertions.assertEquals(this.allIter, (Object)store.all());
            Assertions.assertEquals((long)42L, (long)store.approximateNumEntries());
        });
    }

    @Test
    public void localTimestampedKeyValueStoreShouldNotAllowInitOrClose() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        Mockito.when((Object)this.stateManager.globalStore(ArgumentMatchers.anyString())).thenReturn(null);
        TimestampedKeyValueStore timestampedKeyValueStoreMock = (TimestampedKeyValueStore)Mockito.mock(TimestampedKeyValueStore.class);
        Mockito.when((Object)this.stateManager.store("LocalTimestampedKeyValueStore")).thenAnswer(answer -> this.timestampedKeyValueStoreMock((TimestampedKeyValueStore<String, Long>)timestampedKeyValueStoreMock));
        this.mockTimestampedKeyValueOperation((TimestampedKeyValueStore<String, Long>)timestampedKeyValueStoreMock);
        this.mockStateStoreFlush((StateStore)timestampedKeyValueStoreMock);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.doTest("LocalTimestampedKeyValueStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            store.flush();
            Assertions.assertTrue((boolean)this.flushExecuted);
            store.put((Object)"1", (Object)ValueAndTimestamp.make((Object)1L, (long)2L));
            Assertions.assertTrue((boolean)this.putExecuted);
            store.putIfAbsent((Object)"1", (Object)ValueAndTimestamp.make((Object)1L, (long)2L));
            Assertions.assertTrue((boolean)this.putIfAbsentExecuted);
            store.putAll(Collections.emptyList());
            Assertions.assertTrue((boolean)this.putAllExecuted);
            store.delete((Object)"1");
            Assertions.assertTrue((boolean)this.deleteExecuted);
            Assertions.assertEquals(VALUE_AND_TIMESTAMP, (Object)store.get((Object)KEY));
            Assertions.assertEquals(this.timestampedRangeIter, (Object)store.range((Object)"one", (Object)"two"));
            Assertions.assertEquals(this.timestampedAllIter, (Object)store.all());
            Assertions.assertEquals((long)42L, (long)store.approximateNumEntries());
        });
    }

    @Test
    public void localWindowStoreShouldNotAllowInitOrClose() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        Mockito.when((Object)this.stateManager.globalStore(ArgumentMatchers.anyString())).thenReturn(null);
        WindowStore windowStore = (WindowStore)Mockito.mock(WindowStore.class);
        Mockito.when((Object)this.stateManager.store("LocalWindowStore")).thenAnswer(answer -> this.windowStoreMock((WindowStore<String, Long>)windowStore));
        this.mockStateStoreFlush((StateStore)windowStore);
        ((WindowStore)Mockito.doAnswer(answer -> {
            this.putExecuted = true;
            return null;
        }).when((Object)windowStore)).put((Object)ArgumentMatchers.anyString(), (Object)ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.doTest("LocalWindowStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            store.flush();
            Assertions.assertTrue((boolean)this.flushExecuted);
            store.put((Object)"1", (Object)1L, 1L);
            Assertions.assertTrue((boolean)this.putExecuted);
            Assertions.assertEquals(this.iters.get(0), (Object)store.fetchAll(0L, 0L));
            Assertions.assertEquals((Object)this.windowStoreIter, (Object)store.fetch((Object)KEY, 0L, 1L));
            Assertions.assertEquals(this.iters.get(1), (Object)store.fetch((Object)KEY, (Object)KEY, 0L, 1L));
            Assertions.assertEquals((Long)42L, (Long)((Long)store.fetch((Object)KEY, 1L)));
            Assertions.assertEquals(this.iters.get(2), (Object)store.all());
        });
    }

    @Test
    public void localTimestampedWindowStoreShouldNotAllowInitOrClose() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        Mockito.when((Object)this.stateManager.globalStore(ArgumentMatchers.anyString())).thenReturn(null);
        TimestampedWindowStore windowStore = (TimestampedWindowStore)Mockito.mock(TimestampedWindowStore.class);
        Mockito.when((Object)this.stateManager.store("LocalTimestampedWindowStore")).thenAnswer(answer -> this.timestampedWindowStoreMock((TimestampedWindowStore<String, Long>)windowStore));
        this.mockStateStoreFlush((StateStore)windowStore);
        ((TimestampedWindowStore)Mockito.doAnswer(answer -> {
            this.putExecuted = true;
            return null;
        }).doAnswer(answer -> {
            this.putWithTimestampExecuted = true;
            return null;
        }).when((Object)windowStore)).put((Object)ArgumentMatchers.anyString(), (Object)((ValueAndTimestamp)ArgumentMatchers.any(ValueAndTimestamp.class)), ArgumentMatchers.anyLong());
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.doTest("LocalTimestampedWindowStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            store.flush();
            Assertions.assertTrue((boolean)this.flushExecuted);
            store.put((Object)"1", (Object)ValueAndTimestamp.make((Object)1L, (long)1L), 1L);
            Assertions.assertTrue((boolean)this.putExecuted);
            store.put((Object)"1", (Object)ValueAndTimestamp.make((Object)1L, (long)1L), 1L);
            Assertions.assertTrue((boolean)this.putWithTimestampExecuted);
            Assertions.assertEquals(this.timestampedIters.get(0), (Object)store.fetchAll(0L, 0L));
            Assertions.assertEquals((Object)this.windowStoreIter, (Object)store.fetch((Object)KEY, 0L, 1L));
            Assertions.assertEquals(this.timestampedIters.get(1), (Object)store.fetch((Object)KEY, (Object)KEY, 0L, 1L));
            Assertions.assertEquals(VALUE_AND_TIMESTAMP, (Object)store.fetch((Object)KEY, 1L));
            Assertions.assertEquals(this.timestampedIters.get(2), (Object)store.all());
        });
    }

    @Test
    public void localSessionStoreShouldNotAllowInitOrClose() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        Mockito.when((Object)this.stateManager.globalStore(ArgumentMatchers.anyString())).thenReturn(null);
        SessionStore sessionStore = (SessionStore)Mockito.mock(SessionStore.class);
        Mockito.when((Object)this.stateManager.store("LocalSessionStore")).thenAnswer(answer -> this.sessionStoreMock((SessionStore<String, Long>)sessionStore));
        this.mockStateStoreFlush((StateStore)sessionStore);
        ((SessionStore)Mockito.doAnswer(answer -> {
            this.putExecuted = true;
            return null;
        }).when((Object)sessionStore)).put((Windowed)ArgumentMatchers.any(), (Object)((Long)ArgumentMatchers.any()));
        ((SessionStore)Mockito.doAnswer(answer -> {
            this.removeExecuted = true;
            return null;
        }).when((Object)sessionStore)).remove((Windowed)ArgumentMatchers.any());
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.doTest("LocalSessionStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            store.flush();
            Assertions.assertTrue((boolean)this.flushExecuted);
            store.remove(null);
            Assertions.assertTrue((boolean)this.removeExecuted);
            store.put(null, null);
            Assertions.assertTrue((boolean)this.putExecuted);
            Assertions.assertEquals(this.iters.get(3), (Object)store.findSessions((Object)KEY, 1L, 2L));
            Assertions.assertEquals(this.iters.get(4), (Object)store.findSessions((Object)KEY, (Object)KEY, 1L, 2L));
            Assertions.assertEquals(this.iters.get(5), (Object)store.fetch((Object)KEY));
            Assertions.assertEquals(this.iters.get(6), (Object)store.fetch((Object)KEY, (Object)KEY));
        });
    }

    @Test
    public void shouldNotSendRecordHeadersToChangelogTopic() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        Mockito.when((Object)this.stateManager.registeredChangelogPartitionFor(REGISTERED_STORE_NAME)).thenReturn((Object)CHANGELOG_PARTITION);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        StreamTask task1 = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task1, this.recordCollector, null);
        this.context.logChange(REGISTERED_STORE_NAME, KEY_BYTES, VALUE_BYTES, 21L, Position.emptyPosition());
        ((RecordCollector)Mockito.verify((Object)this.recordCollector)).send(CHANGELOG_PARTITION.topic(), (Object)KEY_BYTES, (Object)VALUE_BYTES, null, Integer.valueOf(CHANGELOG_PARTITION.partition()), Long.valueOf(21L), (Serializer)ProcessorContextImpl.BYTES_KEY_SERIALIZER, (Serializer)ProcessorContextImpl.BYTEARRAY_VALUE_SERIALIZER, null, null);
    }

    @Test
    public void shouldSendRecordHeadersToChangelogTopicWhenConsistencyEnabled() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        Mockito.when((Object)this.stateManager.registeredChangelogPartitionFor(REGISTERED_STORE_NAME)).thenReturn((Object)CHANGELOG_PARTITION);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        Position position = Position.emptyPosition();
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)ChangelogRecordDeserializationHelper.CHANGELOG_VERSION_HEADER_RECORD_CONSISTENCY);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position).array()));
        StreamTask task1 = (StreamTask)Mockito.mock(StreamTask.class);
        this.context = this.buildProcessorContextImpl(this.streamsConfigWithConsistencyMock(), this.stateManager);
        this.context.transitionToActive(task1, this.recordCollector, null);
        this.context.logChange(REGISTERED_STORE_NAME, KEY_BYTES, VALUE_BYTES, 21L, position);
        ((RecordCollector)Mockito.verify((Object)this.recordCollector)).send(CHANGELOG_PARTITION.topic(), (Object)KEY_BYTES, (Object)VALUE_BYTES, (Headers)headers, Integer.valueOf(CHANGELOG_PARTITION.partition()), Long.valueOf(21L), (Serializer)ProcessorContextImpl.BYTES_KEY_SERIALIZER, (Serializer)ProcessorContextImpl.BYTEARRAY_VALUE_SERIALIZER, null, null);
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnLogChange() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.logChange("Store", Bytes.wrap((byte[])"k".getBytes()), null, 0L, Position.emptyPosition()));
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnGetStateStore() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.getStateStore("store"));
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnForward() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.forward((Object)KEY, (Object)"value"));
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnForwardWithTo() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.forward((Object)KEY, (Object)"value", To.child((String)"child-name")));
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnCommit() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.commit());
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnSchedule() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.schedule(Duration.ofMillis(100L), PunctuationType.STREAM_TIME, t -> {}));
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnTopic() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.topic());
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnPartition() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.partition());
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnOffset() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.offset());
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnTimestamp() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.timestamp());
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnCurrentNode() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.currentNode());
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnSetRecordContext() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.setRecordContext((ProcessorRecordContext)Mockito.mock(ProcessorRecordContext.class)));
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionOnRecordContext() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context = this.getStandbyContext();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.recordContext());
    }

    @Test
    public void shouldMatchStreamTime() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        Mockito.when((Object)task.streamTime()).thenReturn((Object)50L);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        Assertions.assertEquals((long)50L, (long)this.context.currentStreamTimeMs());
    }

    @Test
    public void shouldAddAndGetProcessorKeyValue() {
        this.foreachSetUp();
        Mockito.when((Object)this.stateManager.taskType()).thenReturn((Object)Task.TaskType.ACTIVE);
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        this.context.transitionToActive(task, null, null);
        this.mockProcessorNodeWithLocalKeyValueStore();
        this.context.addProcessorMetadataKeyValue("key1", 100L);
        Long value = this.context.processorMetadataForKey("key1");
        Assertions.assertEquals((long)100L, (long)value);
        Long noValue = this.context.processorMetadataForKey("nokey");
        Assertions.assertNull((Object)noValue);
    }

    @Test
    public void shouldSetAndGetProcessorMetaData() {
        this.foreachSetUp();
        this.context = this.buildProcessorContextImpl(this.streamsConfig, this.stateManager);
        this.mockProcessorNodeWithLocalKeyValueStore();
        ProcessorMetadata emptyMetadata = new ProcessorMetadata();
        this.context.setProcessorMetadata(emptyMetadata);
        Assertions.assertEquals((Object)emptyMetadata, (Object)this.context.processorMetadata());
        ProcessorMetadata metadata = new ProcessorMetadata(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"key1", (Object)10L), Utils.mkEntry((Object)"key2", (Object)100L)}));
        this.context.setProcessorMetadata(metadata);
        Assertions.assertEquals((long)10L, (long)this.context.processorMetadataForKey("key1"));
        Assertions.assertEquals((long)100L, (long)this.context.processorMetadataForKey("key2"));
        Assertions.assertThrows(NullPointerException.class, () -> this.context.setProcessorMetadata(null));
    }

    private void mockProcessorNodeWithLocalKeyValueStore() {
        this.context.setCurrentNode(new ProcessorNode("fake", (Processor)null, new HashSet<String>(Arrays.asList("LocalKeyValueStore", "LocalTimestampedKeyValueStore", "LocalWindowStore", "LocalTimestampedWindowStore", "LocalSessionStore"))));
    }

    private ProcessorContextImpl buildProcessorContextImpl(StreamsConfig streamsConfig, ProcessorStateManager stateManager) {
        return new ProcessorContextImpl((TaskId)Mockito.mock(TaskId.class), streamsConfig, stateManager, (StreamsMetricsImpl)Mockito.mock(StreamsMetricsImpl.class), (ThreadCache)Mockito.mock(ThreadCache.class));
    }

    private KeyValueStore<String, Long> keyValueStoreMock(KeyValueStore<String, Long> keyValueStoreMock) {
        this.initStateStoreMock((StateStore)keyValueStoreMock);
        Mockito.when((Object)((Long)keyValueStoreMock.get((Object)KEY))).thenReturn((Object)42L);
        Mockito.when((Object)keyValueStoreMock.approximateNumEntries()).thenReturn((Object)42L);
        Mockito.when((Object)keyValueStoreMock.range((Object)"one", (Object)"two")).thenReturn(this.rangeIter);
        Mockito.when((Object)keyValueStoreMock.all()).thenReturn(this.allIter);
        return keyValueStoreMock;
    }

    private void mockKeyValueStoreOperation(KeyValueStore<String, Long> keyValueStoreMock) {
        ((KeyValueStore)Mockito.doAnswer(answer -> {
            this.putExecuted = true;
            return null;
        }).when(keyValueStoreMock)).put((Object)ArgumentMatchers.anyString(), (Object)ArgumentMatchers.anyLong());
        ((KeyValueStore)Mockito.doAnswer(answer -> {
            this.putIfAbsentExecuted = true;
            return null;
        }).when(keyValueStoreMock)).putIfAbsent((Object)ArgumentMatchers.anyString(), (Object)ArgumentMatchers.anyLong());
        ((KeyValueStore)Mockito.doAnswer(answer -> {
            this.putAllExecuted = true;
            return null;
        }).when(keyValueStoreMock)).putAll((List)ArgumentMatchers.any(List.class));
        ((KeyValueStore)Mockito.doAnswer(answer -> {
            this.deleteExecuted = true;
            return null;
        }).when(keyValueStoreMock)).delete((Object)ArgumentMatchers.anyString());
    }

    private TimestampedKeyValueStore<String, Long> timestampedKeyValueStoreMock(TimestampedKeyValueStore<String, Long> timestampedKeyValueStoreMock) {
        this.initStateStoreMock((StateStore)timestampedKeyValueStoreMock);
        Mockito.when((Object)((ValueAndTimestamp)timestampedKeyValueStoreMock.get((Object)KEY))).thenReturn(VALUE_AND_TIMESTAMP);
        Mockito.when((Object)timestampedKeyValueStoreMock.approximateNumEntries()).thenReturn((Object)42L);
        Mockito.when((Object)timestampedKeyValueStoreMock.range((Object)"one", (Object)"two")).thenReturn(this.timestampedRangeIter);
        Mockito.when((Object)timestampedKeyValueStoreMock.all()).thenReturn(this.timestampedAllIter);
        return timestampedKeyValueStoreMock;
    }

    private void mockTimestampedKeyValueOperation(TimestampedKeyValueStore<String, Long> timestampedKeyValueStoreMock) {
        ((TimestampedKeyValueStore)Mockito.doAnswer(answer -> {
            this.putExecuted = true;
            return null;
        }).when(timestampedKeyValueStoreMock)).put((Object)ArgumentMatchers.anyString(), (Object)((ValueAndTimestamp)ArgumentMatchers.any(ValueAndTimestamp.class)));
        ((TimestampedKeyValueStore)Mockito.doAnswer(answer -> {
            this.putIfAbsentExecuted = true;
            return null;
        }).when(timestampedKeyValueStoreMock)).putIfAbsent((Object)ArgumentMatchers.anyString(), (Object)((ValueAndTimestamp)ArgumentMatchers.any(ValueAndTimestamp.class)));
        ((TimestampedKeyValueStore)Mockito.doAnswer(answer -> {
            this.putAllExecuted = true;
            return null;
        }).when(timestampedKeyValueStoreMock)).putAll((List)ArgumentMatchers.any(List.class));
        ((TimestampedKeyValueStore)Mockito.doAnswer(answer -> {
            this.deleteExecuted = true;
            return null;
        }).when(timestampedKeyValueStoreMock)).delete((Object)ArgumentMatchers.anyString());
    }

    private WindowStore<String, Long> windowStoreMock(WindowStore<String, Long> windowStore) {
        this.initStateStoreMock((StateStore)windowStore);
        Mockito.when((Object)windowStore.fetchAll(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(this.iters.get(0));
        Mockito.when((Object)windowStore.fetch((Object)ArgumentMatchers.anyString(), (Object)ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(this.iters.get(1));
        Mockito.when((Object)windowStore.fetch((Object)ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)this.windowStoreIter);
        Mockito.when((Object)((Long)windowStore.fetch((Object)ArgumentMatchers.anyString(), ArgumentMatchers.anyLong()))).thenReturn((Object)42L);
        Mockito.when((Object)windowStore.all()).thenReturn(this.iters.get(2));
        return windowStore;
    }

    private TimestampedWindowStore<String, Long> timestampedWindowStoreMock(TimestampedWindowStore<String, Long> windowStore) {
        this.initStateStoreMock((StateStore)windowStore);
        Mockito.when((Object)windowStore.fetchAll(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(this.timestampedIters.get(0));
        Mockito.when((Object)windowStore.fetch((Object)ArgumentMatchers.anyString(), (Object)ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(this.timestampedIters.get(1));
        Mockito.when((Object)windowStore.fetch((Object)ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)this.windowStoreIter);
        Mockito.when((Object)((ValueAndTimestamp)windowStore.fetch((Object)ArgumentMatchers.anyString(), ArgumentMatchers.anyLong()))).thenReturn(VALUE_AND_TIMESTAMP);
        Mockito.when((Object)windowStore.all()).thenReturn(this.timestampedIters.get(2));
        return windowStore;
    }

    private SessionStore<String, Long> sessionStoreMock(SessionStore<String, Long> sessionStore) {
        this.initStateStoreMock((StateStore)sessionStore);
        Mockito.when((Object)sessionStore.findSessions((Object)ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(this.iters.get(3));
        Mockito.when((Object)sessionStore.findSessions((Object)ArgumentMatchers.anyString(), (Object)ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(this.iters.get(4));
        Mockito.when((Object)sessionStore.fetch((Object)ArgumentMatchers.anyString())).thenReturn(this.iters.get(5));
        Mockito.when((Object)sessionStore.fetch((Object)ArgumentMatchers.anyString(), (Object)ArgumentMatchers.anyString())).thenReturn(this.iters.get(6));
        return sessionStore;
    }

    private StreamsConfig streamsConfigMock() {
        StreamsConfig streamsConfig = (StreamsConfig)Mockito.mock(StreamsConfig.class);
        Mockito.when((Object)streamsConfig.originals()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)streamsConfig.values()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)streamsConfig.getString("application.id")).thenReturn((Object)"add-id");
        return streamsConfig;
    }

    private StreamsConfig streamsConfigWithConsistencyMock() {
        StreamsConfig streamsConfig = (StreamsConfig)Mockito.mock(StreamsConfig.class);
        HashMap<String, Boolean> myValues = new HashMap<String, Boolean>();
        myValues.put("__iq.consistency.offset.vector.enabled__", true);
        Mockito.when((Object)streamsConfig.originals()).thenReturn(myValues);
        Mockito.when((Object)streamsConfig.values()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)streamsConfig.getString("application.id")).thenReturn((Object)"add-id");
        return streamsConfig;
    }

    private void initStateStoreMock(StateStore stateStore) {
        Mockito.when((Object)stateStore.name()).thenReturn((Object)STORE_NAME);
        Mockito.when((Object)stateStore.persistent()).thenReturn((Object)true);
        Mockito.when((Object)stateStore.isOpen()).thenReturn((Object)true);
    }

    private void mockStateStoreFlush(StateStore stateStore) {
        ((StateStore)Mockito.doAnswer(answer -> {
            this.flushExecuted = true;
            return null;
        }).when((Object)stateStore)).flush();
    }

    private <T extends StateStore> void doTest(final String name, final Consumer<T> checker) {
        Processor<String, Long, String, Long> processor = new Processor<String, Long, String, Long>(){

            public void init(ProcessorContext<String, Long> context) {
                StateStore store = context.getStateStore(name);
                checker.accept(store);
            }

            public void process(Record<String, Long> record) {
            }

            public void close() {
            }
        };
        processor.init((ProcessorContext)this.context);
    }

    private void verifyStoreCannotBeInitializedOrClosed(StateStore store) {
        Assertions.assertEquals((Object)STORE_NAME, (Object)store.name());
        Assertions.assertTrue((boolean)store.persistent());
        Assertions.assertTrue((boolean)store.isOpen());
        this.checkThrowsUnsupportedOperation(() -> store.init(null, null), "init()");
        this.checkThrowsUnsupportedOperation(() -> ((StateStore)store).close(), "close()");
    }

    private void checkThrowsUnsupportedOperation(Runnable check, String name) {
        try {
            check.run();
            Assertions.fail((String)(name + " should throw exception"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

