/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ProcessorContextTest {
    private ProcessorContext context;

    @BeforeEach
    public void prepare() {
        StreamsConfig streamsConfig = (StreamsConfig)Mockito.mock(StreamsConfig.class);
        ((StreamsConfig)Mockito.doReturn((Object)"add-id").when((Object)streamsConfig)).getString("application.id");
        ((StreamsConfig)Mockito.doReturn((Object)Serdes.ByteArray()).when((Object)streamsConfig)).defaultValueSerde();
        ((StreamsConfig)Mockito.doReturn((Object)Serdes.ByteArray()).when((Object)streamsConfig)).defaultKeySerde();
        ProcessorStateManager stateManager = (ProcessorStateManager)Mockito.mock(ProcessorStateManager.class);
        ((ProcessorStateManager)Mockito.doReturn((Object)Task.TaskType.ACTIVE).when((Object)stateManager)).taskType();
        this.context = new ProcessorContextImpl((TaskId)Mockito.mock(TaskId.class), streamsConfig, stateManager, (StreamsMetricsImpl)Mockito.mock(StreamsMetricsImpl.class), (ThreadCache)Mockito.mock(ThreadCache.class));
        ((InternalProcessorContext)this.context).transitionToActive((StreamTask)Mockito.mock(StreamTask.class), null, null);
    }

    @Test
    public void shouldNotAllowToScheduleZeroMillisecondPunctuation() {
        try {
            this.context.schedule(Duration.ofMillis(0L), null, null);
            Assertions.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)Matchers.equalTo((Object)"The minimum supported scheduling interval is 1 millisecond."));
        }
    }

    @Test
    public void shouldNotAllowToScheduleSubMillisecondPunctuation() {
        try {
            this.context.schedule(Duration.ofNanos(999999L), null, null);
            Assertions.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)Matchers.equalTo((Object)"The minimum supported scheduling interval is 1 millisecond."));
        }
    }
}

