/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProcessorRecordContextTest {
    private static final long MIN_SIZE = 20L;

    @Test
    public void shouldNotAllowNullHeaders() {
        Assertions.assertThrows(NullPointerException.class, () -> new ProcessorRecordContext(42L, 73L, 0, "topic", null));
    }

    @Test
    public void shouldEstimateNullTopicAndEmptyHeadersAsZeroLength() {
        RecordHeaders headers = new RecordHeaders();
        ProcessorRecordContext context = new ProcessorRecordContext(42L, 73L, 0, null, (Headers)new RecordHeaders());
        Assertions.assertEquals((long)20L, (long)context.residentMemorySizeEstimate());
    }

    @Test
    public void shouldEstimateEmptyHeaderAsZeroLength() {
        ProcessorRecordContext context = new ProcessorRecordContext(42L, 73L, 0, null, (Headers)new RecordHeaders());
        Assertions.assertEquals((long)20L, (long)context.residentMemorySizeEstimate());
    }

    @Test
    public void shouldEstimateTopicLength() {
        ProcessorRecordContext context = new ProcessorRecordContext(42L, 73L, 0, "topic", (Headers)new RecordHeaders());
        Assertions.assertEquals((long)25L, (long)context.residentMemorySizeEstimate());
    }

    @Test
    public void shouldEstimateHeadersLength() {
        RecordHeaders headers = new RecordHeaders();
        headers.add("header-key", "header-value".getBytes());
        ProcessorRecordContext context = new ProcessorRecordContext(42L, 73L, 0, null, (Headers)headers);
        Assertions.assertEquals((long)42L, (long)context.residentMemorySizeEstimate());
    }

    @Test
    public void shouldEstimateNullValueInHeaderAsZero() {
        RecordHeaders headers = new RecordHeaders();
        headers.add("header-key", null);
        ProcessorRecordContext context = new ProcessorRecordContext(42L, 73L, 0, null, (Headers)headers);
        Assertions.assertEquals((long)30L, (long)context.residentMemorySizeEstimate());
    }
}

