/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ReadOnlyTask;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ReadOnlyTaskTest {
    private final List<String> readOnlyMethods = new LinkedList<String>(){
        {
            this.add("needsInitializationOrRestoration");
            this.add("inputPartitions");
            this.add("changelogPartitions");
            this.add("commitRequested");
            this.add("commitNeeded");
            this.add("isActive");
            this.add("changelogOffsets");
            this.add("state");
            this.add("id");
            this.add("store");
        }
    };
    private final List<String> objectMethods = new LinkedList<String>(){
        {
            this.add("wait");
            this.add("equals");
            this.add("getClass");
            this.add("hashCode");
            this.add("notify");
            this.add("notifyAll");
            this.add("toString");
        }
    };
    final Task task = StreamsTestUtils.TaskBuilder.statelessTask(new TaskId(1, 0)).build();

    ReadOnlyTaskTest() {
    }

    @Test
    public void shouldDelegateNeedsInitializationOrRestoration() {
        ReadOnlyTask readOnlyTask = new ReadOnlyTask(this.task);
        readOnlyTask.needsInitializationOrRestoration();
        ((Task)Mockito.verify((Object)this.task)).needsInitializationOrRestoration();
    }

    @Test
    public void shouldDelegateId() {
        ReadOnlyTask readOnlyTask = new ReadOnlyTask(this.task);
        readOnlyTask.id();
        ((Task)Mockito.verify((Object)this.task)).id();
    }

    @Test
    public void shouldDelegateIsActive() {
        ReadOnlyTask readOnlyTask = new ReadOnlyTask(this.task);
        readOnlyTask.isActive();
        ((Task)Mockito.verify((Object)this.task)).isActive();
    }

    @Test
    public void shouldDelegateInputPartitions() {
        ReadOnlyTask readOnlyTask = new ReadOnlyTask(this.task);
        readOnlyTask.inputPartitions();
        ((Task)Mockito.verify((Object)this.task)).inputPartitions();
    }

    @Test
    public void shouldDelegateChangelogPartitions() {
        ReadOnlyTask readOnlyTask = new ReadOnlyTask(this.task);
        readOnlyTask.changelogPartitions();
        ((Task)Mockito.verify((Object)this.task)).changelogPartitions();
    }

    @Test
    public void shouldDelegateCommitRequested() {
        ReadOnlyTask readOnlyTask = new ReadOnlyTask(this.task);
        readOnlyTask.commitRequested();
        ((Task)Mockito.verify((Object)this.task)).commitRequested();
    }

    @Test
    public void shouldDelegateState() {
        ReadOnlyTask readOnlyTask = new ReadOnlyTask(this.task);
        readOnlyTask.state();
        ((Task)Mockito.verify((Object)this.task)).state();
    }

    @Test
    public void shouldDelegateCommitNeededIfStandby() {
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(new TaskId(1, 0), Set.of(new TopicPartition("topic", 0))).build();
        ReadOnlyTask readOnlyTask = new ReadOnlyTask((Task)standbyTask);
        readOnlyTask.commitNeeded();
        ((StandbyTask)Mockito.verify((Object)standbyTask)).commitNeeded();
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionForCommitNeededIfActive() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(new TaskId(1, 0), Set.of(new TopicPartition("topic", 0))).build();
        ReadOnlyTask readOnlyTask = new ReadOnlyTask((Task)statefulTask);
        Exception exception = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> ((ReadOnlyTask)readOnlyTask).commitNeeded());
        Assertions.assertEquals((Object)"This task is read-only", (Object)exception.getMessage());
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionForForbiddenMethods() {
        ReadOnlyTask readOnlyTask = new ReadOnlyTask(this.task);
        for (Method method : ReadOnlyTask.class.getMethods()) {
            String methodName = method.getName();
            if (this.readOnlyMethods.contains(methodName) || this.objectMethods.contains(methodName)) continue;
            this.shouldThrowUnsupportedOperationException(readOnlyTask, method);
        }
    }

    private void shouldThrowUnsupportedOperationException(ReadOnlyTask readOnlyTask, Method method) {
        Exception exception = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            try {
                method.invoke((Object)readOnlyTask, this.getParameters(method.getParameterTypes()));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }, (String)("Something unexpected happened during invocation of method '" + method.getName() + "'!"));
        Assertions.assertEquals((Object)"This task is read-only", (Object)exception.getMessage());
    }

    private Object[] getParameters(Class<?>[] parameterTypes) throws Exception {
        Object[] parameters = new Object[parameterTypes.length];
        block26: for (int i = 0; i < parameterTypes.length; ++i) {
            switch (parameterTypes[i].getName()) {
                case "boolean": {
                    parameters[i] = true;
                    continue block26;
                }
                case "long": {
                    parameters[i] = 0;
                    continue block26;
                }
                case "java.util.Set": {
                    parameters[i] = Collections.emptySet();
                    continue block26;
                }
                case "java.util.Collection": {
                    parameters[i] = Collections.emptySet();
                    continue block26;
                }
                case "java.util.Map": {
                    parameters[i] = Collections.emptyMap();
                    continue block26;
                }
                case "org.apache.kafka.common.TopicPartition": {
                    parameters[i] = new TopicPartition("topic", 0);
                    continue block26;
                }
                case "org.apache.kafka.clients.consumer.OffsetAndMetadata": {
                    parameters[i] = new OffsetAndMetadata(0L, Optional.empty(), "");
                    continue block26;
                }
                case "java.lang.Exception": {
                    parameters[i] = new IllegalStateException();
                    continue block26;
                }
                case "java.util.function.Consumer": {
                    parameters[i] = ignored -> {};
                    continue block26;
                }
                case "java.lang.Iterable": {
                    parameters[i] = Collections.emptySet();
                    continue block26;
                }
                case "org.apache.kafka.common.utils.Time": {
                    parameters[i] = Time.SYSTEM;
                    continue block26;
                }
                default: {
                    parameters[i] = parameterTypes[i].getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        }
        return parameters;
    }
}

