/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.ErrorHandlerContext;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.RecordDeserializer;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class RecordDeserializerTest {
    private final String sourceNodeName = "source-node";
    private final TaskId taskId = new TaskId(0, 0);
    private final RecordHeaders headers = new RecordHeaders(new Header[]{new RecordHeader("key", "value".getBytes())});
    private final ConsumerRecord<byte[], byte[]> rawRecord = new ConsumerRecord("topic", 1, 1L, 10L, TimestampType.LOG_APPEND_TIME, 3, 5, (Object)new byte[0], (Object)new byte[0], (Headers)this.headers, Optional.of(5));
    private final InternalProcessorContext<Void, Void> context = new InternalMockProcessorContext();

    @Test
    public void shouldReturnConsumerRecordWithDeserializedValueWhenNoExceptions() {
        try (Metrics metrics = new Metrics();){
            RecordDeserializer recordDeserializer = new RecordDeserializer((SourceNode)new TheSourceNode("source-node", false, false, "key", "value"), null, new LogContext(), metrics.sensor("dropped-records"));
            ConsumerRecord record = recordDeserializer.deserialize(null, this.rawRecord);
            Assertions.assertEquals((Object)this.rawRecord.topic(), (Object)record.topic());
            Assertions.assertEquals((int)this.rawRecord.partition(), (int)record.partition());
            Assertions.assertEquals((long)this.rawRecord.offset(), (long)record.offset());
            Assertions.assertEquals((Object)"key", (Object)record.key());
            Assertions.assertEquals((Object)"value", (Object)record.value());
            Assertions.assertEquals((long)this.rawRecord.timestamp(), (long)record.timestamp());
            Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)record.timestampType());
            Assertions.assertEquals((Object)this.rawRecord.headers(), (Object)record.headers());
            Assertions.assertEquals((Object)this.rawRecord.leaderEpoch(), (Object)record.leaderEpoch());
        }
    }

    @ParameterizedTest
    @CsvSource(value={"true, true", "true, false", "false, true"})
    public void shouldThrowStreamsExceptionWhenDeserializationFailsAndExceptionHandlerRepliesWithFail(boolean keyThrowsException, boolean valueThrowsException) {
        try (Metrics metrics = new Metrics();){
            RecordDeserializer recordDeserializer = new RecordDeserializer((SourceNode)new TheSourceNode("source-node", keyThrowsException, valueThrowsException, "key", "value"), (DeserializationExceptionHandler)new DeserializationExceptionHandlerMock(Optional.of(DeserializationExceptionHandler.DeserializationHandlerResponse.FAIL), this.rawRecord, "source-node", this.taskId), new LogContext(), metrics.sensor("dropped-records"));
            StreamsException e = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> recordDeserializer.deserialize(this.context, this.rawRecord));
            Assertions.assertEquals((Object)e.getMessage(), (Object)"Deserialization exception handler is set to fail upon a deserialization error. If you would rather have the streaming pipeline continue after a deserialization error, please set the deserialization.exception.handler appropriately.");
        }
    }

    @ParameterizedTest
    @CsvSource(value={"true, true", "true, false", "false, true"})
    public void shouldNotThrowStreamsExceptionWhenDeserializationFailsAndExceptionHandlerRepliesWithContinue(boolean keyThrowsException, boolean valueThrowsException) {
        try (Metrics metrics = new Metrics();){
            RecordDeserializer recordDeserializer = new RecordDeserializer((SourceNode)new TheSourceNode("source-node", keyThrowsException, valueThrowsException, "key", "value"), (DeserializationExceptionHandler)new DeserializationExceptionHandlerMock(Optional.of(DeserializationExceptionHandler.DeserializationHandlerResponse.CONTINUE), this.rawRecord, "source-node", this.taskId), new LogContext(), metrics.sensor("dropped-records"));
            ConsumerRecord record = recordDeserializer.deserialize(this.context, this.rawRecord);
            Assertions.assertNull((Object)record);
        }
    }

    @Test
    public void shouldFailWhenDeserializationFailsAndExceptionHandlerReturnsNull() {
        try (Metrics metrics = new Metrics();){
            RecordDeserializer recordDeserializer = new RecordDeserializer((SourceNode)new TheSourceNode("source-node", true, false, "key", "value"), (DeserializationExceptionHandler)new DeserializationExceptionHandlerMock(Optional.empty(), this.rawRecord, "source-node", this.taskId), new LogContext(), metrics.sensor("dropped-records"));
            StreamsException exception = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> recordDeserializer.deserialize(this.context, this.rawRecord));
            Assertions.assertEquals((Object)"Fatal user code error in deserialization error callback", (Object)exception.getMessage());
            Assertions.assertInstanceOf(NullPointerException.class, (Object)exception.getCause());
            Assertions.assertEquals((Object)"Invalid DeserializationExceptionHandler response.", (Object)exception.getCause().getMessage());
        }
    }

    @Test
    public void shouldFailWhenDeserializationFailsAndExceptionHandlerThrows() {
        try (Metrics metrics = new Metrics();){
            RecordDeserializer recordDeserializer = new RecordDeserializer((SourceNode)new TheSourceNode("source-node", true, false, "key", "value"), (DeserializationExceptionHandler)new DeserializationExceptionHandlerMock(null, this.rawRecord, "source-node", this.taskId), new LogContext(), metrics.sensor("dropped-records"));
            StreamsException exception = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> recordDeserializer.deserialize(this.context, this.rawRecord));
            Assertions.assertEquals((Object)"Fatal user code error in deserialization error callback", (Object)exception.getMessage());
            Assertions.assertEquals((Object)"CRASH", (Object)exception.getCause().getMessage());
        }
    }

    static class TheSourceNode
    extends SourceNode<Object, Object> {
        private final boolean keyThrowsException;
        private final boolean valueThrowsException;
        private final Object key;
        private final Object value;

        TheSourceNode(String name, boolean keyThrowsException, boolean valueThrowsException, Object key, Object value) {
            super(name, null, null);
            this.keyThrowsException = keyThrowsException;
            this.valueThrowsException = valueThrowsException;
            this.key = key;
            this.value = value;
        }

        public Object deserializeKey(String topic, Headers headers, byte[] data) {
            if (this.keyThrowsException) {
                throw new RuntimeException("KABOOM!");
            }
            return this.key;
        }

        public Object deserializeValue(String topic, Headers headers, byte[] data) {
            if (this.valueThrowsException) {
                throw new RuntimeException("KABOOM!");
            }
            return this.value;
        }
    }

    public static class DeserializationExceptionHandlerMock
    implements DeserializationExceptionHandler {
        private final Optional<DeserializationExceptionHandler.DeserializationHandlerResponse> response;
        private final ConsumerRecord<byte[], byte[]> expectedRecord;
        private final String expectedProcessorNodeId;
        private final TaskId expectedTaskId;

        public DeserializationExceptionHandlerMock(Optional<DeserializationExceptionHandler.DeserializationHandlerResponse> response, ConsumerRecord<byte[], byte[]> record, String processorNodeId, TaskId taskId) {
            this.response = response;
            this.expectedRecord = record;
            this.expectedProcessorNodeId = processorNodeId;
            this.expectedTaskId = taskId;
        }

        public DeserializationExceptionHandler.DeserializationHandlerResponse handle(ErrorHandlerContext context, ConsumerRecord<byte[], byte[]> record, Exception exception) {
            Assertions.assertEquals((Object)this.expectedRecord.topic(), (Object)context.topic());
            Assertions.assertEquals((int)this.expectedRecord.partition(), (int)context.partition());
            Assertions.assertEquals((long)this.expectedRecord.offset(), (long)context.offset());
            Assertions.assertEquals((Object)this.expectedProcessorNodeId, (Object)context.processorNodeId());
            Assertions.assertEquals((Object)this.expectedTaskId, (Object)context.taskId());
            Assertions.assertEquals((long)this.expectedRecord.timestamp(), (long)context.timestamp());
            Assertions.assertEquals(this.expectedRecord, record);
            Assertions.assertInstanceOf(RuntimeException.class, (Object)exception);
            Assertions.assertEquals((Object)"KABOOM!", (Object)exception.getMessage());
            if (this.response == null) {
                throw new RuntimeException("CRASH");
            }
            return this.response.orElse(null);
        }

        public void configure(Map<String, ?> configs) {
        }
    }
}

