/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.streams.processor.internals.RepartitionTopicConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RepartitionTopicConfigTest {
    @Test
    public void shouldThrowAnExceptionWhenSettingNumberOfPartitionsIfTheyAreEnforced() {
        String name = "my-topic";
        RepartitionTopicConfig repartitionTopicConfig = new RepartitionTopicConfig("my-topic", Collections.emptyMap(), 10, true);
        UnsupportedOperationException ex = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> repartitionTopicConfig.setNumberOfPartitions(2));
        Assertions.assertEquals((Object)String.format("number of partitions are enforced on topic %s and can't be altered.", "my-topic"), (Object)ex.getMessage());
    }

    @Test
    public void shouldNotThrowAnExceptionWhenSettingNumberOfPartitionsIfTheyAreNotEnforced() {
        String name = "my-topic";
        RepartitionTopicConfig repartitionTopicConfig = new RepartitionTopicConfig("my-topic", Collections.emptyMap(), 10, false);
        repartitionTopicConfig.setNumberOfPartitions(4);
        Assertions.assertEquals((Object)repartitionTopicConfig.numberOfPartitions(), Optional.of(4));
    }
}

