/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.SensorAccessor;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockSourceNode;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class SourceNodeTest {
    private MockedStatic<WrappingNullableUtils> utilsMock;

    @BeforeEach
    public void setup() {
        this.utilsMock = Mockito.mockStatic(WrappingNullableUtils.class);
    }

    @AfterEach
    public void cleanup() {
        this.utilsMock.close();
    }

    @Test
    public void shouldProvideTopicHeadersAndDataToKeyDeserializer() {
        MockSourceNode<String, String> sourceNode = new MockSourceNode<String, String>(new TheDeserializer(), new TheDeserializer());
        RecordHeaders headers = new RecordHeaders();
        String deserializeKey = (String)sourceNode.deserializeKey("topic", (Headers)headers, "data".getBytes(StandardCharsets.UTF_8));
        MatcherAssert.assertThat((Object)deserializeKey, (Matcher)CoreMatchers.is((Object)("topic" + String.valueOf(headers) + "data")));
    }

    @Test
    public void shouldProvideTopicHeadersAndDataToValueDeserializer() {
        MockSourceNode<String, String> sourceNode = new MockSourceNode<String, String>(new TheDeserializer(), new TheDeserializer());
        RecordHeaders headers = new RecordHeaders();
        String deserializedValue = (String)sourceNode.deserializeValue("topic", (Headers)headers, "data".getBytes(StandardCharsets.UTF_8));
        MatcherAssert.assertThat((Object)deserializedValue, (Matcher)CoreMatchers.is((Object)("topic" + String.valueOf(headers) + "data")));
    }

    @Test
    public void shouldExposeProcessMetrics() {
        Metrics metrics = new Metrics();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, "test-client", "processId", (Time)new MockTime());
        InternalMockProcessorContext context = new InternalMockProcessorContext(streamsMetrics);
        SourceNode node = new SourceNode(context.currentNode().name(), (Deserializer)new TheDeserializer(), (Deserializer)new TheDeserializer());
        node.init(context);
        String threadId = Thread.currentThread().getName();
        String groupName = "stream-processor-node-metrics";
        Map metricTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)threadId), Utils.mkEntry((Object)"task-id", (Object)context.taskId().toString()), Utils.mkEntry((Object)"processor-node-id", (Object)node.name())});
        Assertions.assertTrue((boolean)StreamsTestUtils.containsMetric(metrics, "process-rate", "stream-processor-node-metrics", metricTags));
        Assertions.assertTrue((boolean)StreamsTestUtils.containsMetric(metrics, "process-total", "stream-processor-node-metrics", metricTags));
        String parentGroupName = "stream-task-metrics";
        metricTags.remove("processor-node-id");
        Assertions.assertTrue((boolean)StreamsTestUtils.containsMetric(metrics, "process-rate", "stream-task-metrics", metricTags));
        Assertions.assertTrue((boolean)StreamsTestUtils.containsMetric(metrics, "process-total", "stream-task-metrics", metricTags));
        String sensorNamePrefix = "internal." + threadId + ".task." + context.taskId().toString();
        Sensor processSensor = metrics.getSensor(sensorNamePrefix + ".node." + context.currentNode().name() + ".s.process");
        SensorAccessor sensorAccessor = new SensorAccessor(processSensor);
        MatcherAssert.assertThat(sensorAccessor.parents().stream().map(Sensor::name).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{sensorNamePrefix + ".s.process"}));
    }

    @Test
    public void shouldThrowStreamsExceptionOnUndefinedKeySerde() {
        InternalMockProcessorContext context = new InternalMockProcessorContext();
        SourceNode node = new SourceNode(context.currentNode().name(), (Deserializer)new TheDeserializer(), (Deserializer)new TheDeserializer());
        this.utilsMock.when(() -> WrappingNullableUtils.prepareKeyDeserializer((Deserializer)((Deserializer)ArgumentMatchers.any()), (ProcessorContext)((ProcessorContext)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new ConfigException("Please set StreamsConfig#DEFAULT_KEY_SERDE_CLASS_CONFIG")});
        Throwable exception = Assertions.assertThrows(StreamsException.class, () -> node.init((InternalProcessorContext)context));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Failed to initialize key serdes for source node TESTING_NODE"));
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"Please set StreamsConfig#DEFAULT_KEY_SERDE_CLASS_CONFIG"));
    }

    @Test
    public void shouldThrowStreamsExceptionOnUndefinedValueSerde() {
        InternalMockProcessorContext context = new InternalMockProcessorContext();
        SourceNode node = new SourceNode(context.currentNode().name(), (Deserializer)new TheDeserializer(), (Deserializer)new TheDeserializer());
        this.utilsMock.when(() -> WrappingNullableUtils.prepareValueDeserializer((Deserializer)((Deserializer)ArgumentMatchers.any()), (ProcessorContext)((ProcessorContext)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new ConfigException("Please set StreamsConfig#DEFAULT_VALUE_SERDE_CLASS_CONFIG")});
        Throwable exception = Assertions.assertThrows(StreamsException.class, () -> node.init((InternalProcessorContext)context));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Failed to initialize value serdes for source node TESTING_NODE"));
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"Please set StreamsConfig#DEFAULT_VALUE_SERDE_CLASS_CONFIG"));
    }

    @Test
    public void shouldThrowStreamsExceptionWithExplicitErrorMessage() {
        InternalMockProcessorContext context = new InternalMockProcessorContext();
        SourceNode node = new SourceNode(context.currentNode().name(), (Deserializer)new TheDeserializer(), (Deserializer)new TheDeserializer());
        this.utilsMock.when(() -> WrappingNullableUtils.prepareKeyDeserializer((Deserializer)((Deserializer)ArgumentMatchers.any()), (ProcessorContext)((ProcessorContext)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new StreamsException("")});
        Throwable exception = Assertions.assertThrows(StreamsException.class, () -> node.init((InternalProcessorContext)context));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Failed to initialize key serdes for source node TESTING_NODE"));
    }

    public static class TheDeserializer
    implements Deserializer<String> {
        public String deserialize(String topic, Headers headers, byte[] data) {
            return topic + String.valueOf(headers) + new String(data, StandardCharsets.UTF_8);
        }

        public String deserialize(String topic, byte[] data) {
            return this.deserialize(topic, null, data);
        }
    }
}

