/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetadata;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.testutil.DummyStreamsConfig;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.internals.StreamsMetadataImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StreamsMetadataStateTest {
    private StreamsMetadataState metadataState;
    private HostInfo hostOne;
    private HostInfo hostTwo;
    private HostInfo hostThree;
    private TopicPartition topic1P0;
    private TopicPartition topic2P0;
    private TopicPartition topic3P0;
    private Map<HostInfo, Set<TopicPartition>> hostToActivePartitions;
    private Map<HostInfo, Set<TopicPartition>> hostToStandbyPartitions;
    private StreamsBuilder builder;
    private TopicPartition topic1P1;
    private TopicPartition topic2P1;
    private TopicPartition topic4P0;
    private Map<TopicPartition, PartitionInfo> partitionInfos;
    private final String globalTable = "global-table";
    private final LogContext logContext = new LogContext(String.format("test [%s] ", "StreamsMetadataStateTest"));
    private StreamPartitioner<String, Object> partitioner;
    private Set<String> storeNames;

    @BeforeEach
    public void before() {
        this.builder = new StreamsBuilder();
        KStream one = this.builder.stream("topic-one");
        one.groupByKey().count(Materialized.as((String)"table-one"));
        KStream two = this.builder.stream("topic-two");
        two.groupByKey().count(Materialized.as((String)"table-two"));
        this.builder.stream("topic-three").groupByKey().count(Materialized.as((String)"table-three"));
        one.merge(two).groupByKey().count(Materialized.as((String)"merged-table"));
        this.builder.stream("topic-four").mapValues(value -> value);
        this.builder.globalTable("global-topic", Consumed.with(null, null), Materialized.as((String)"global-table"));
        TopologyWrapper.getInternalTopologyBuilder(this.builder.build()).setApplicationId("appId");
        this.topic1P0 = new TopicPartition("topic-one", 0);
        this.topic1P1 = new TopicPartition("topic-one", 1);
        this.topic2P0 = new TopicPartition("topic-two", 0);
        this.topic2P1 = new TopicPartition("topic-two", 1);
        this.topic3P0 = new TopicPartition("topic-three", 0);
        this.topic4P0 = new TopicPartition("topic-four", 0);
        this.hostOne = new HostInfo("host-one", 8080);
        this.hostTwo = new HostInfo("host-two", 9090);
        this.hostThree = new HostInfo("host-three", 7070);
        this.hostToActivePartitions = new HashMap<HostInfo, Set<TopicPartition>>();
        this.hostToActivePartitions.put(this.hostOne, Set.of(this.topic1P0, this.topic2P1, this.topic4P0));
        this.hostToActivePartitions.put(this.hostTwo, Set.of(this.topic2P0, this.topic1P1));
        this.hostToActivePartitions.put(this.hostThree, Collections.singleton(this.topic3P0));
        this.hostToStandbyPartitions = new HashMap<HostInfo, Set<TopicPartition>>();
        this.hostToStandbyPartitions.put(this.hostThree, Set.of(this.topic1P0, this.topic2P1, this.topic4P0));
        this.hostToStandbyPartitions.put(this.hostOne, Set.of(this.topic2P0, this.topic1P1));
        this.hostToStandbyPartitions.put(this.hostTwo, Collections.singleton(this.topic3P0));
        this.partitionInfos = new HashMap<TopicPartition, PartitionInfo>();
        this.partitionInfos.put(new TopicPartition("topic-one", 0), new PartitionInfo("topic-one", 0, null, null, null));
        this.partitionInfos.put(new TopicPartition("topic-one", 1), new PartitionInfo("topic-one", 1, null, null, null));
        this.partitionInfos.put(new TopicPartition("topic-two", 0), new PartitionInfo("topic-two", 0, null, null, null));
        this.partitionInfos.put(new TopicPartition("topic-two", 1), new PartitionInfo("topic-two", 1, null, null, null));
        this.partitionInfos.put(new TopicPartition("topic-three", 0), new PartitionInfo("topic-three", 0, null, null, null));
        this.partitionInfos.put(new TopicPartition("topic-four", 0), new PartitionInfo("topic-four", 0, null, null, null));
        TopologyMetadata topologyMetadata = new TopologyMetadata(TopologyWrapper.getInternalTopologyBuilder(this.builder.build()), (StreamsConfig)new DummyStreamsConfig());
        topologyMetadata.buildAndRewriteTopology();
        this.metadataState = new StreamsMetadataState(topologyMetadata, this.hostOne, this.logContext);
        this.metadataState.onChange(this.hostToActivePartitions, this.hostToStandbyPartitions, this.partitionInfos);
        this.partitioner = (topic, key, value, numPartitions) -> Optional.of(Collections.singleton(1));
        this.storeNames = Set.of("table-one", "table-two", "merged-table", "global-table");
    }

    @Test
    public void shouldNotThrowExceptionWhenOnChangeNotCalled() {
        Collection metadata = new StreamsMetadataState(new TopologyMetadata(TopologyWrapper.getInternalTopologyBuilder(this.builder.build()), (StreamsConfig)new DummyStreamsConfig()), this.hostOne, this.logContext).allMetadataForStore("store");
        Assertions.assertEquals((int)0, (int)metadata.size());
    }

    @Test
    public void shouldGetAllStreamInstances() {
        StreamsMetadataImpl one = new StreamsMetadataImpl(this.hostOne, Set.of("global-table", "table-one", "table-two", "merged-table"), Set.of(this.topic1P0, this.topic2P1, this.topic4P0), Set.of("table-one", "table-two", "merged-table"), Set.of(this.topic2P0, this.topic1P1));
        StreamsMetadataImpl two = new StreamsMetadataImpl(this.hostTwo, Set.of("global-table", "table-two", "table-one", "merged-table"), Set.of(this.topic2P0, this.topic1P1), Set.of("table-three"), Set.of(this.topic3P0));
        StreamsMetadataImpl three = new StreamsMetadataImpl(this.hostThree, Set.of("global-table", "table-three"), Collections.singleton(this.topic3P0), Set.of("table-one", "table-two", "merged-table"), Set.of(this.topic1P0, this.topic2P1, this.topic4P0));
        Collection actual = this.metadataState.allMetadata();
        Assertions.assertEquals((int)3, (int)actual.size());
        Assertions.assertTrue((boolean)actual.contains(one), (String)("expected " + String.valueOf(actual) + " to contain " + String.valueOf(one)));
        Assertions.assertTrue((boolean)actual.contains(two), (String)("expected " + String.valueOf(actual) + " to contain " + String.valueOf(two)));
        Assertions.assertTrue((boolean)actual.contains(three), (String)("expected " + String.valueOf(actual) + " to contain " + String.valueOf(three)));
    }

    @Test
    public void shouldGetAllStreamsInstancesWithNoStores() {
        this.builder.stream("topic-five").filter((key, value) -> true).to("some-other-topic");
        TopicPartition tp5 = new TopicPartition("topic-five", 1);
        HostInfo hostFour = new HostInfo("host-four", 8080);
        this.hostToActivePartitions.put(hostFour, Set.of(tp5));
        this.metadataState.onChange(this.hostToActivePartitions, Collections.emptyMap(), Collections.singletonMap(tp5, new PartitionInfo("topic-five", 1, null, null, null)));
        StreamsMetadataImpl expected = new StreamsMetadataImpl(hostFour, Collections.singleton("global-table"), Collections.singleton(tp5), Collections.emptySet(), Collections.emptySet());
        Collection actual = this.metadataState.allMetadata();
        Assertions.assertTrue((boolean)actual.contains(expected), (String)("expected " + String.valueOf(actual) + " to contain " + String.valueOf(expected)));
    }

    @Test
    public void shouldGetInstancesForStoreName() {
        StreamsMetadataImpl one = new StreamsMetadataImpl(this.hostOne, Set.of("global-table", "table-one", "table-two", "merged-table"), Set.of(this.topic1P0, this.topic2P1, this.topic4P0), Set.of("table-one", "table-two", "merged-table"), Set.of(this.topic2P0, this.topic1P1));
        StreamsMetadataImpl two = new StreamsMetadataImpl(this.hostTwo, Set.of("global-table", "table-two", "table-one", "merged-table"), Set.of(this.topic2P0, this.topic1P1), Set.of("table-three"), Set.of(this.topic3P0));
        Collection actual = this.metadataState.allMetadataForStore("table-one");
        Map actualAsMap = actual.stream().collect(Collectors.toMap(StreamsMetadata::hostInfo, Function.identity()));
        Assertions.assertEquals((int)3, (int)actual.size());
        Assertions.assertTrue((boolean)actual.contains(one), (String)("expected " + String.valueOf(actual) + " to contain " + String.valueOf(one)));
        Assertions.assertTrue((boolean)actual.contains(two), (String)("expected " + String.valueOf(actual) + " to contain " + String.valueOf(two)));
        Assertions.assertTrue((boolean)((StreamsMetadata)actualAsMap.get(this.hostThree)).standbyStateStoreNames().contains("table-one"), (String)("expected " + String.valueOf(this.hostThree) + " to contain as standby"));
    }

    @Test
    public void shouldThrowIfStoreNameIsNullOnGetAllInstancesWithStore() {
        Assertions.assertThrows(NullPointerException.class, () -> this.metadataState.allMetadataForStore(null));
    }

    @Test
    public void shouldReturnEmptyCollectionOnGetAllInstancesWithStoreWhenStoreDoesntExist() {
        Collection actual = this.metadataState.allMetadataForStore("not-a-store");
        Assertions.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    public void shouldGetInstanceWithKey() {
        TopicPartition tp4 = new TopicPartition("topic-three", 1);
        this.hostToActivePartitions.put(this.hostTwo, Set.of(this.topic2P0, tp4));
        this.metadataState.onChange(this.hostToActivePartitions, this.hostToStandbyPartitions, Collections.singletonMap(tp4, new PartitionInfo("topic-three", 1, null, null, null)));
        KeyQueryMetadata expected = new KeyQueryMetadata(this.hostThree, Set.of(this.hostTwo), 0);
        KeyQueryMetadata actual = this.metadataState.keyQueryMetadataForKey("table-three", (Object)"the-key", Serdes.String().serializer());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldGetInstanceWithKeyAndCustomPartitioner() {
        TopicPartition tp4 = new TopicPartition("topic-three", 1);
        this.hostToActivePartitions.put(this.hostTwo, Set.of(this.topic2P0, tp4));
        this.metadataState.onChange(this.hostToActivePartitions, this.hostToStandbyPartitions, Collections.singletonMap(tp4, new PartitionInfo("topic-three", 1, null, null, null)));
        KeyQueryMetadata expected = new KeyQueryMetadata(this.hostTwo, Collections.emptySet(), 1);
        KeyQueryMetadata actual = this.metadataState.keyQueryMetadataForKey("table-three", (Object)"the-key", this.partitioner);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertEquals((int)1, (int)actual.partition());
    }

    @Test
    public void shouldFailWhenIqQueriedWithCustomPartitionerReturningMultiplePartitions() {
        TopicPartition tp4 = new TopicPartition("topic-three", 1);
        this.hostToActivePartitions.put(this.hostTwo, Set.of(this.topic2P0, tp4));
        this.metadataState.onChange(this.hostToActivePartitions, this.hostToStandbyPartitions, Collections.singletonMap(tp4, new PartitionInfo("topic-three", 1, null, null, null)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.metadataState.keyQueryMetadataForKey("table-three", (Object)"the-key", (StreamPartitioner)new MultiValuedPartitioner()));
    }

    @Test
    public void shouldReturnNotAvailableWhenClusterIsEmpty() {
        this.metadataState.onChange(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        KeyQueryMetadata result = this.metadataState.keyQueryMetadataForKey("table-one", (Object)"a", Serdes.String().serializer());
        Assertions.assertEquals((Object)KeyQueryMetadata.NOT_AVAILABLE, (Object)result);
    }

    @Test
    public void shouldGetInstanceWithKeyWithMergedStreams() {
        TopicPartition topic2P2 = new TopicPartition("topic-two", 2);
        this.hostToActivePartitions.put(this.hostTwo, Set.of(this.topic2P0, this.topic1P1, topic2P2));
        this.hostToStandbyPartitions.put(this.hostOne, Set.of(this.topic2P0, this.topic1P1, topic2P2));
        this.metadataState.onChange(this.hostToActivePartitions, this.hostToStandbyPartitions, Collections.singletonMap(topic2P2, new PartitionInfo("topic-two", 2, null, null, null)));
        KeyQueryMetadata expected = new KeyQueryMetadata(this.hostTwo, Set.of(this.hostOne), 2);
        KeyQueryMetadata actual = this.metadataState.keyQueryMetadataForKey("merged-table", (Object)"the-key", (topic, key, value, numPartitions) -> Optional.of(Collections.singleton(2)));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldReturnNullOnGetWithKeyWhenStoreDoesntExist() {
        KeyQueryMetadata actual = this.metadataState.keyQueryMetadataForKey("not-a-store", (Object)"key", Serdes.String().serializer());
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void shouldThrowWhenKeyIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.metadataState.keyQueryMetadataForKey("table-three", null, Serdes.String().serializer()));
    }

    @Test
    public void shouldThrowWhenSerializerIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.metadataState.keyQueryMetadataForKey("table-three", (Object)"key", (Serializer)null));
    }

    @Test
    public void shouldThrowIfStoreNameIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.metadataState.keyQueryMetadataForKey(null, (Object)"key", Serdes.String().serializer()));
    }

    @Test
    public void shouldThrowIfStreamPartitionerIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.metadataState.keyQueryMetadataForKey(null, (Object)"key", (StreamPartitioner)null));
    }

    @Test
    public void shouldHaveGlobalStoreInAllMetadata() {
        Collection metadata = this.metadataState.allMetadataForStore("global-table");
        Assertions.assertEquals((int)3, (int)metadata.size());
        for (StreamsMetadata streamsMetadata : metadata) {
            Assertions.assertTrue((boolean)streamsMetadata.stateStoreNames().contains("global-table"));
        }
    }

    @Test
    public void shouldGetLocalMetadataWithRightActiveStandbyInfo() {
        Assertions.assertEquals((Object)this.hostOne, (Object)this.metadataState.getLocalMetadata().hostInfo());
        Assertions.assertEquals(this.hostToActivePartitions.get(this.hostOne), (Object)this.metadataState.getLocalMetadata().topicPartitions());
        Assertions.assertEquals(this.hostToStandbyPartitions.get(this.hostOne), (Object)this.metadataState.getLocalMetadata().standbyTopicPartitions());
        Assertions.assertEquals(this.storeNames, (Object)this.metadataState.getLocalMetadata().stateStoreNames());
        Assertions.assertEquals(this.storeNames.stream().filter(s -> !s.equals("global-table")).collect(Collectors.toSet()), (Object)this.metadataState.getLocalMetadata().standbyStateStoreNames());
    }

    @Test
    public void shouldGetQueryMetadataForGlobalStoreWithKey() {
        KeyQueryMetadata metadata = this.metadataState.keyQueryMetadataForKey("global-table", (Object)"key", Serdes.String().serializer());
        Assertions.assertEquals((Object)this.hostOne, (Object)metadata.activeHost());
        Assertions.assertTrue((boolean)metadata.standbyHosts().isEmpty());
    }

    @Test
    public void shouldGetAnyHostForGlobalStoreByKeyIfMyHostUnknown() {
        StreamsMetadataState streamsMetadataState = new StreamsMetadataState(new TopologyMetadata(TopologyWrapper.getInternalTopologyBuilder(this.builder.build()), (StreamsConfig)new DummyStreamsConfig()), StreamsMetadataState.UNKNOWN_HOST, this.logContext);
        streamsMetadataState.onChange(this.hostToActivePartitions, this.hostToStandbyPartitions, this.partitionInfos);
        Assertions.assertNotNull((Object)streamsMetadataState.keyQueryMetadataForKey("global-table", (Object)"key", Serdes.String().serializer()));
    }

    @Test
    public void shouldGetQueryMetadataForGlobalStoreWithKeyAndPartitioner() {
        KeyQueryMetadata metadata = this.metadataState.keyQueryMetadataForKey("global-table", (Object)"key", this.partitioner);
        Assertions.assertEquals((Object)this.hostOne, (Object)metadata.activeHost());
        Assertions.assertTrue((boolean)metadata.standbyHosts().isEmpty());
    }

    @Test
    public void shouldGetAnyHostForGlobalStoreByKeyAndPartitionerIfMyHostUnknown() {
        StreamsMetadataState streamsMetadataState = new StreamsMetadataState(new TopologyMetadata(TopologyWrapper.getInternalTopologyBuilder(this.builder.build()), (StreamsConfig)new DummyStreamsConfig()), StreamsMetadataState.UNKNOWN_HOST, this.logContext);
        streamsMetadataState.onChange(this.hostToActivePartitions, this.hostToStandbyPartitions, this.partitionInfos);
        Assertions.assertNotNull((Object)streamsMetadataState.keyQueryMetadataForKey("global-table", (Object)"key", this.partitioner));
    }

    @Test
    public void shouldReturnAllMetadataThatRemainsValidAfterChange() {
        Collection allMetadata = this.metadataState.allMetadata();
        ArrayList copy = new ArrayList(allMetadata);
        Assertions.assertFalse((boolean)allMetadata.isEmpty(), (String)"invalid test");
        this.metadataState.onChange(Collections.emptyMap(), Collections.emptyMap(), this.partitionInfos);
        Assertions.assertEquals((Object)allMetadata, copy, (String)"encapsulation broken");
    }

    @Test
    public void shouldNotReturnMutableReferenceToInternalAllMetadataCollection() {
        Collection allMetadata = this.metadataState.allMetadata();
        Assertions.assertFalse((boolean)allMetadata.isEmpty(), (String)"invalid test");
        try {
            allMetadata.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)this.metadataState.allMetadata().isEmpty(), (String)"encapsulation broken");
    }

    static class MultiValuedPartitioner
    implements StreamPartitioner<String, Object> {
        MultiValuedPartitioner() {
        }

        public Optional<Set<Integer>> partitions(String topic, String key, Object value, int numPartitions) {
            HashSet<Integer> partitions = new HashSet<Integer>();
            partitions.add(0);
            partitions.add(1);
            return Optional.of(partitions);
        }
    }
}

