/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RoundRobinPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidPidMappingException;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskMigratedException;
import org.apache.kafka.streams.internals.StreamsConfigUtils;
import org.apache.kafka.streams.processor.internals.StreamsProducer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class StreamsProducerTest {
    private static final double BUFFER_POOL_WAIT_TIME = 1.0;
    private static final double FLUSH_TME = 2.0;
    private static final double TXN_INIT_TIME = 3.0;
    private static final double TXN_BEGIN_TIME = 4.0;
    private static final double TXN_SEND_OFFSETS_TIME = 5.0;
    private static final double TXN_COMMIT_TIME = 6.0;
    private static final double TXN_ABORT_TIME = 7.0;
    private static final double METADATA_WAIT_TIME = 8.0;
    private final LogContext logContext = new LogContext("test ");
    private final String topic = "topic";
    private final Cluster cluster = new Cluster("cluster", Collections.singletonList(Node.noNode()), Collections.singletonList(new PartitionInfo("topic", 0, Node.noNode(), new Node[0], new Node[0])), Collections.emptySet(), Collections.emptySet());
    private final Time mockTime = (Time)Mockito.mock(Time.class);
    final Producer<byte[], byte[]> mockedProducer = (Producer)Mockito.mock(Producer.class);
    private final StreamsProducer streamsProducerWithMock = new StreamsProducer(this.mockedProducer, StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, this.mockTime, this.logContext);
    private final StreamsProducer eosStreamsProducerWithMock = new StreamsProducer(this.mockedProducer, StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, this.mockTime, this.logContext);
    private final MockProducer<byte[], byte[]> nonEosMockProducer = new MockProducer(this.cluster, true, (Partitioner)new RoundRobinPartitioner(), (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    private final MockProducer<byte[], byte[]> eosMockProducer = new MockProducer(this.cluster, true, (Partitioner)new RoundRobinPartitioner(), (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    private StreamsProducer nonEosStreamsProducer;
    private StreamsProducer eosStreamsProducer;
    private final ProducerRecord<byte[], byte[]> record = new ProducerRecord("topic", Integer.valueOf(0), Long.valueOf(0L), (Object)new byte[0], (Object)new byte[0], (Iterable)new RecordHeaders());
    private final Map<TopicPartition, OffsetAndMetadata> offsetsAndMetadata = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopicPartition("topic", 0), (Object)new OffsetAndMetadata(0L, null))});

    @BeforeEach
    public void before() {
        this.nonEosStreamsProducer = new StreamsProducer(this.nonEosMockProducer, StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, this.mockTime, this.logContext);
        this.eosStreamsProducer = new StreamsProducer(this.eosMockProducer, StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, this.mockTime, this.logContext);
        this.eosStreamsProducer.initTransaction();
        Mockito.when((Object)this.mockTime.nanoseconds()).thenReturn((Object)Time.SYSTEM.nanoseconds());
    }

    @Test
    public void shouldResetTransactionInFlightOnClose() {
        this.eosStreamsProducer.send(new ProducerRecord("topic", (Object)new byte[1]), (metadata, error) -> {});
        MatcherAssert.assertThat((Object)this.eosStreamsProducer.transactionInFlight(), (Matcher)Matchers.is((Object)true));
        this.eosStreamsProducer.close();
        MatcherAssert.assertThat((Object)this.eosStreamsProducer.transactionInFlight(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldResetTransactionInFlightOnReset() {
        this.eosStreamsProducer.send(new ProducerRecord("topic", (Object)new byte[1]), (metadata, error) -> {});
        MatcherAssert.assertThat((Object)this.eosStreamsProducer.transactionInFlight(), (Matcher)Matchers.is((Object)true));
        this.eosStreamsProducer.resetProducer(null);
        MatcherAssert.assertThat((Object)this.eosStreamsProducer.transactionInFlight(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldForwardCallToPartitionsFor() {
        List expectedPartitionInfo = Collections.emptyList();
        Mockito.when((Object)this.mockedProducer.partitionsFor("topic")).thenReturn(expectedPartitionInfo);
        List partitionInfo = this.streamsProducerWithMock.partitionsFor("topic");
        MatcherAssert.assertThat((Object)partitionInfo, (Matcher)Matchers.sameInstance(expectedPartitionInfo));
    }

    @Test
    public void shouldForwardCallToFlush() {
        this.streamsProducerWithMock.flush();
        ((Producer)Mockito.verify(this.mockedProducer)).flush();
    }

    @Test
    public void shouldForwardCallToMetrics() {
        HashMap metrics = new HashMap();
        Mockito.when((Object)this.mockedProducer.metrics()).thenReturn(metrics);
        Assertions.assertSame(metrics, (Object)this.streamsProducerWithMock.metrics());
    }

    @Test
    public void shouldForwardCallToClose() {
        this.streamsProducerWithMock.close();
        ((Producer)Mockito.verify(this.mockedProducer)).close();
    }

    @Test
    public void shouldFailIfProcessingModeIsNull() {
        NullPointerException thrown = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> new StreamsProducer(this.mockedProducer, null, this.mockTime, this.logContext));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"processingMode cannot be null"));
    }

    @Test
    public void shouldFailIfProducerIsNull() {
        NullPointerException thrown = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> new StreamsProducer(null, StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, this.mockTime, this.logContext));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"producer cannot be null"));
    }

    @Test
    public void shouldFailIfTimeIsNull() {
        NullPointerException thrown = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> new StreamsProducer(this.mockedProducer, StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, null, this.logContext));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"time cannot be null"));
    }

    @Test
    public void shouldFailIfLogContextIsNull() {
        NullPointerException thrown = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> new StreamsProducer(this.mockedProducer, StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, this.mockTime, null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"logContext cannot be null"));
    }

    @Test
    public void shouldFailOnResetProducerForAtLeastOnce() {
        IllegalStateException thrown = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.nonEosStreamsProducer.resetProducer(null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Expected EOS to be enabled, but processing mode is at_least_once"));
    }

    @Test
    public void shouldNotInitTxIfEosDisable() {
        MatcherAssert.assertThat((Object)this.nonEosMockProducer.transactionInitialized(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldNotBeginTxOnSendIfEosDisable() {
        this.nonEosStreamsProducer.send(this.record, null);
        MatcherAssert.assertThat((Object)this.nonEosMockProducer.transactionInFlight(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldForwardRecordOnSend() {
        this.nonEosStreamsProducer.send(this.record, null);
        MatcherAssert.assertThat((Object)this.nonEosMockProducer.history().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ProducerRecord)this.nonEosMockProducer.history().get(0)), (Matcher)Matchers.is(this.record));
    }

    @Test
    public void shouldFailOnInitTxIfEosDisabled() {
        IllegalStateException thrown = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((StreamsProducer)this.nonEosStreamsProducer).initTransaction());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Exactly-once is not enabled [test]"));
    }

    @Test
    public void shouldThrowStreamsExceptionOnSendError() {
        this.nonEosMockProducer.sendException = new KafkaException("KABOOM!");
        StreamsException thrown = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> this.nonEosStreamsProducer.send(this.record, null));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.is((Object)this.nonEosMockProducer.sendException));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Error encountered trying to send record to topic topic [test]"));
    }

    @Test
    public void shouldFailOnSendFatal() {
        this.nonEosMockProducer.sendException = new RuntimeException("KABOOM!");
        RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.nonEosStreamsProducer.send(this.record, null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"KABOOM!"));
    }

    @Test
    public void shouldFailOnCommitIfEosDisabled() {
        IllegalStateException thrown = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.nonEosStreamsProducer.commitTransaction(null, new ConsumerGroupMetadata("appId")));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Exactly-once is not enabled [test]"));
    }

    @Test
    public void shouldFailOnAbortIfEosDisabled() {
        IllegalStateException thrown = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((StreamsProducer)this.nonEosStreamsProducer).abortTransaction());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Exactly-once is not enabled [test]"));
    }

    @Test
    public void shouldInitTxOnEos() {
        MatcherAssert.assertThat((Object)this.eosMockProducer.transactionInitialized(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldBeginTxOnEosSend() {
        this.eosStreamsProducer.send(this.record, null);
        MatcherAssert.assertThat((Object)this.eosMockProducer.transactionInFlight(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldContinueTxnSecondEosSend() {
        this.eosStreamsProducer.send(this.record, null);
        this.eosStreamsProducer.send(this.record, null);
        MatcherAssert.assertThat((Object)this.eosMockProducer.transactionInFlight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.eosMockProducer.uncommittedRecords().size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void shouldForwardRecordButNotCommitOnEosSend() {
        this.eosStreamsProducer.send(this.record, null);
        MatcherAssert.assertThat((Object)this.eosMockProducer.transactionInFlight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.eosMockProducer.history().isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.eosMockProducer.uncommittedRecords().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ProducerRecord)this.eosMockProducer.uncommittedRecords().get(0)), (Matcher)Matchers.is(this.record));
    }

    @Test
    public void shouldBeginTxOnEosCommit() {
        this.eosStreamsProducerWithMock.initTransaction();
        this.eosStreamsProducerWithMock.commitTransaction(this.offsetsAndMetadata, new ConsumerGroupMetadata("appId"));
        ((Producer)Mockito.verify(this.mockedProducer)).initTransactions();
        ((Producer)Mockito.verify(this.mockedProducer)).beginTransaction();
        ((Producer)Mockito.verify(this.mockedProducer)).sendOffsetsToTransaction(this.offsetsAndMetadata, new ConsumerGroupMetadata("appId"));
        ((Producer)Mockito.verify(this.mockedProducer)).commitTransaction();
    }

    @Test
    public void shouldSendOffsetToTxOnEosCommit() {
        this.eosStreamsProducer.commitTransaction(this.offsetsAndMetadata, new ConsumerGroupMetadata("appId"));
        MatcherAssert.assertThat((Object)this.eosMockProducer.sentOffsets(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldCommitTxOnEosCommit() {
        this.eosStreamsProducer.send(this.record, null);
        MatcherAssert.assertThat((Object)this.eosMockProducer.transactionInFlight(), (Matcher)Matchers.is((Object)true));
        this.eosStreamsProducer.commitTransaction(this.offsetsAndMetadata, new ConsumerGroupMetadata("appId"));
        MatcherAssert.assertThat((Object)this.eosMockProducer.transactionInFlight(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.eosMockProducer.uncommittedRecords().isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.eosMockProducer.uncommittedOffsets().isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.eosMockProducer.history().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ProducerRecord)this.eosMockProducer.history().get(0)), (Matcher)Matchers.is(this.record));
        MatcherAssert.assertThat((Object)this.eosMockProducer.consumerGroupOffsetsHistory().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Map)((Map)this.eosMockProducer.consumerGroupOffsetsHistory().get(0)).get("appId")), (Matcher)Matchers.is(this.offsetsAndMetadata));
    }

    @Test
    public void shouldCommitTxWithConsumerGroupMetadataOnEosCommit() {
        Mockito.when((Object)this.mockedProducer.send(this.record, null)).thenReturn(null);
        StreamsProducer streamsProducer = new StreamsProducer(this.mockedProducer, StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, this.mockTime, this.logContext);
        streamsProducer.initTransaction();
        streamsProducer.send(this.record, null);
        streamsProducer.commitTransaction(null, new ConsumerGroupMetadata("appId"));
        ((Producer)Mockito.verify(this.mockedProducer)).initTransactions();
        ((Producer)Mockito.verify(this.mockedProducer)).beginTransaction();
        ((Producer)Mockito.verify(this.mockedProducer)).sendOffsetsToTransaction(null, new ConsumerGroupMetadata("appId"));
        ((Producer)Mockito.verify(this.mockedProducer)).commitTransaction();
    }

    @Test
    public void shouldAbortTxOnEosAbort() {
        this.eosStreamsProducer.send(this.record, null);
        MatcherAssert.assertThat((Object)this.eosMockProducer.transactionInFlight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.eosMockProducer.uncommittedRecords().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ProducerRecord)this.eosMockProducer.uncommittedRecords().get(0)), (Matcher)Matchers.is(this.record));
        this.eosStreamsProducer.abortTransaction();
        MatcherAssert.assertThat((Object)this.eosMockProducer.transactionInFlight(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.eosMockProducer.uncommittedRecords().isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.eosMockProducer.uncommittedOffsets().isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.eosMockProducer.history().isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.eosMockProducer.consumerGroupOffsetsHistory().isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldSkipAbortTxOnEosAbortIfNotTxInFlight() {
        this.eosStreamsProducerWithMock.initTransaction();
        this.eosStreamsProducerWithMock.abortTransaction();
        ((Producer)Mockito.verify(this.mockedProducer)).initTransactions();
    }

    @Test
    public void shouldThrowTimeoutExceptionOnEosInitTxTimeout() {
        this.nonEosMockProducer.initTransactionException = new TimeoutException("KABOOM!");
        StreamsProducer streamsProducer = new StreamsProducer(this.nonEosMockProducer, StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, this.mockTime, this.logContext);
        TimeoutException thrown = (TimeoutException)Assertions.assertThrows(TimeoutException.class, () -> ((StreamsProducer)streamsProducer).initTransaction());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"KABOOM!"));
    }

    @Test
    public void shouldFailOnMaybeBeginTransactionIfTransactionsNotInitializedForEos() {
        StreamsProducer streamsProducer = new StreamsProducer(this.nonEosMockProducer, StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, this.mockTime, this.logContext);
        IllegalStateException thrown = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> streamsProducer.send(this.record, null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"MockProducer hasn't been initialized for transactions."));
    }

    @Test
    public void shouldThrowStreamsExceptionOnEosInitError() {
        this.nonEosMockProducer.initTransactionException = new KafkaException("KABOOM!");
        StreamsProducer streamsProducer = new StreamsProducer(this.nonEosMockProducer, StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, this.mockTime, this.logContext);
        StreamsException thrown = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> ((StreamsProducer)streamsProducer).initTransaction());
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.is((Object)this.nonEosMockProducer.initTransactionException));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Error encountered trying to initialize transactions [test]"));
    }

    @Test
    public void shouldFailOnEosInitFatal() {
        this.nonEosMockProducer.initTransactionException = new RuntimeException("KABOOM!");
        StreamsProducer streamsProducer = new StreamsProducer(this.nonEosMockProducer, StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, this.mockTime, this.logContext);
        RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ((StreamsProducer)streamsProducer).initTransaction());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"KABOOM!"));
    }

    @Test
    public void shouldThrowTaskMigrateExceptionOnEosBeginTxnFenced() {
        this.eosMockProducer.fenceProducer();
        TaskMigratedException thrown = (TaskMigratedException)Assertions.assertThrows(TaskMigratedException.class, () -> this.eosStreamsProducer.send(null, null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Producer got fenced trying to begin a new transaction [test]; it means all tasks belonging to this thread should be migrated."));
    }

    @Test
    public void shouldThrowTaskMigrateExceptionOnEosBeginTxnError() {
        this.eosMockProducer.beginTransactionException = new KafkaException("KABOOM!");
        StreamsException thrown = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> this.eosStreamsProducer.send(null, null));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.is((Object)this.eosMockProducer.beginTransactionException));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Error encountered trying to begin a new transaction [test]"));
    }

    @Test
    public void shouldFailOnEosBeginTxnFatal() {
        this.eosMockProducer.beginTransactionException = new RuntimeException("KABOOM!");
        RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.eosStreamsProducer.send(null, null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"KABOOM!"));
    }

    @Test
    public void shouldThrowTaskMigratedExceptionOnEosSendProducerFenced() {
        this.testThrowTaskMigratedExceptionOnEosSend((RuntimeException)new ProducerFencedException("KABOOM!"));
    }

    @Test
    public void shouldThrowTaskMigratedExceptionOnEosSendPInvalidPidMapping() {
        this.testThrowTaskMigratedExceptionOnEosSend((RuntimeException)new InvalidPidMappingException("KABOOM!"));
    }

    @Test
    public void shouldThrowTaskMigratedExceptionOnEosSendInvalidEpoch() {
        this.testThrowTaskMigratedExceptionOnEosSend((RuntimeException)new InvalidProducerEpochException("KABOOM!"));
    }

    private void testThrowTaskMigratedExceptionOnEosSend(RuntimeException exception) {
        this.eosMockProducer.sendException = new KafkaException((Throwable)exception);
        TaskMigratedException thrown = (TaskMigratedException)Assertions.assertThrows(TaskMigratedException.class, () -> this.eosStreamsProducer.send(this.record, null));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.is((Object)exception));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Producer got fenced trying to send a record [test]; it means all tasks belonging to this thread should be migrated."));
    }

    @Test
    public void shouldThrowTaskMigratedExceptionOnEosSendUnknownPid() {
        UnknownProducerIdException exception = new UnknownProducerIdException("KABOOM!");
        this.eosMockProducer.sendException = new KafkaException((Throwable)exception);
        TaskMigratedException thrown = (TaskMigratedException)Assertions.assertThrows(TaskMigratedException.class, () -> this.eosStreamsProducer.send(this.record, null));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.is((Object)exception));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Producer got fenced trying to send a record [test]; it means all tasks belonging to this thread should be migrated."));
    }

    @Test
    public void shouldThrowTaskMigrateExceptionOnEosSendOffsetProducerFenced() {
        this.testThrowTaskMigrateExceptionOnEosSendOffset((RuntimeException)new ProducerFencedException("KABOOM!"));
    }

    @Test
    public void shouldThrowTaskMigrateExceptionOnEosSendOffsetInvalidPidMapping() {
        this.testThrowTaskMigrateExceptionOnEosSendOffset((RuntimeException)new InvalidPidMappingException("KABOOM!"));
    }

    @Test
    public void shouldThrowTaskMigrateExceptionOnEosSendOffsetInvalidEpoch() {
        this.testThrowTaskMigrateExceptionOnEosSendOffset((RuntimeException)new InvalidProducerEpochException("KABOOM!"));
    }

    private void testThrowTaskMigrateExceptionOnEosSendOffset(RuntimeException exception) {
        this.eosMockProducer.sendOffsetsToTransactionException = exception;
        TaskMigratedException thrown = (TaskMigratedException)Assertions.assertThrows(TaskMigratedException.class, () -> this.eosStreamsProducer.commitTransaction(null, new ConsumerGroupMetadata("appId")));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.is((Object)this.eosMockProducer.sendOffsetsToTransactionException));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Producer got fenced trying to commit a transaction [test]; it means all tasks belonging to this thread should be migrated."));
    }

    @Test
    public void shouldThrowStreamsExceptionOnEosSendOffsetError() {
        this.eosMockProducer.sendOffsetsToTransactionException = new KafkaException("KABOOM!");
        StreamsException thrown = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> this.eosStreamsProducer.commitTransaction(null, new ConsumerGroupMetadata("appId")));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.is((Object)this.eosMockProducer.sendOffsetsToTransactionException));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Error encountered trying to commit a transaction [test]"));
    }

    @Test
    public void shouldFailOnEosSendOffsetFatal() {
        this.eosMockProducer.sendOffsetsToTransactionException = new RuntimeException("KABOOM!");
        RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.eosStreamsProducer.commitTransaction(null, new ConsumerGroupMetadata("appId")));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"KABOOM!"));
    }

    @Test
    public void shouldThrowTaskMigratedExceptionOnEosCommitWithProducerFenced() {
        this.testThrowTaskMigratedExceptionOnEos((RuntimeException)new ProducerFencedException("KABOOM!"));
    }

    @Test
    public void shouldThrowTaskMigratedExceptionOnEosCommitWithInvalidPidMapping() {
        this.testThrowTaskMigratedExceptionOnEos((RuntimeException)new InvalidPidMappingException("KABOOM!"));
    }

    @Test
    public void shouldThrowTaskMigratedExceptionOnEosCommitWithInvalidEpoch() {
        this.testThrowTaskMigratedExceptionOnEos((RuntimeException)new InvalidProducerEpochException("KABOOM!"));
    }

    private void testThrowTaskMigratedExceptionOnEos(RuntimeException exception) {
        this.eosMockProducer.commitTransactionException = exception;
        TaskMigratedException thrown = (TaskMigratedException)Assertions.assertThrows(TaskMigratedException.class, () -> this.eosStreamsProducer.commitTransaction(this.offsetsAndMetadata, new ConsumerGroupMetadata("appId")));
        MatcherAssert.assertThat((Object)this.eosMockProducer.sentOffsets(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.is((Object)this.eosMockProducer.commitTransactionException));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Producer got fenced trying to commit a transaction [test]; it means all tasks belonging to this thread should be migrated."));
    }

    @Test
    public void shouldThrowStreamsExceptionOnEosCommitTxError() {
        this.eosMockProducer.commitTransactionException = new KafkaException("KABOOM!");
        StreamsException thrown = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> this.eosStreamsProducer.commitTransaction(this.offsetsAndMetadata, new ConsumerGroupMetadata("appId")));
        MatcherAssert.assertThat((Object)this.eosMockProducer.sentOffsets(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.is((Object)this.eosMockProducer.commitTransactionException));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Error encountered trying to commit a transaction [test]"));
    }

    @Test
    public void shouldFailOnEosCommitTxFatal() {
        this.eosMockProducer.commitTransactionException = new RuntimeException("KABOOM!");
        RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.eosStreamsProducer.commitTransaction(this.offsetsAndMetadata, new ConsumerGroupMetadata("appId")));
        MatcherAssert.assertThat((Object)this.eosMockProducer.sentOffsets(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"KABOOM!"));
    }

    @Test
    public void shouldSwallowExceptionOnEosAbortTxProducerFenced() {
        this.testSwallowExceptionOnEosAbortTx((RuntimeException)new ProducerFencedException("KABOOM!"));
    }

    @Test
    public void shouldSwallowExceptionOnEosAbortTxInvalidPidMapping() {
        this.testSwallowExceptionOnEosAbortTx((RuntimeException)new InvalidPidMappingException("KABOOM!"));
    }

    @Test
    public void shouldSwallowExceptionOnEosAbortTxInvalidEpoch() {
        this.testSwallowExceptionOnEosAbortTx((RuntimeException)new InvalidProducerEpochException("KABOOM!"));
    }

    private void testSwallowExceptionOnEosAbortTx(RuntimeException exception) {
        Mockito.when((Object)this.mockedProducer.send(this.record, null)).thenReturn(null);
        ((Producer)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when(this.mockedProducer)).abortTransaction();
        this.eosStreamsProducerWithMock.initTransaction();
        this.eosStreamsProducerWithMock.send(this.record, null);
        this.eosStreamsProducerWithMock.abortTransaction();
        ((Producer)Mockito.verify(this.mockedProducer)).initTransactions();
        ((Producer)Mockito.verify(this.mockedProducer)).beginTransaction();
    }

    @Test
    public void shouldThrowStreamsExceptionOnEosAbortTxError() {
        this.eosMockProducer.abortTransactionException = new KafkaException("KABOOM!");
        this.eosStreamsProducer.send(this.record, null);
        StreamsException thrown = (StreamsException)Assertions.assertThrows(StreamsException.class, () -> ((StreamsProducer)this.eosStreamsProducer).abortTransaction());
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.is((Object)this.eosMockProducer.abortTransactionException));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Error encounter trying to abort a transaction [test]"));
    }

    @Test
    public void shouldFailOnEosAbortTxFatal() {
        this.eosMockProducer.abortTransactionException = new RuntimeException("KABOOM!");
        this.eosStreamsProducer.send(this.record, null);
        RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ((StreamsProducer)this.eosStreamsProducer).abortTransaction());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"KABOOM!"));
    }

    @Test
    public void shouldCloseExistingProducerOnResetProducer() {
        this.eosStreamsProducer.resetProducer(null);
        Assertions.assertTrue((boolean)this.eosMockProducer.closed());
    }

    @Test
    public void shouldSetNewProducerOnResetProducer() {
        Producer newProducer = (Producer)Mockito.mock(Producer.class);
        this.eosStreamsProducer.resetProducer(newProducer);
        MatcherAssert.assertThat((Object)this.eosStreamsProducer.kafkaProducer(), (Matcher)Matchers.is((Object)newProducer));
    }

    @Test
    public void shouldResetTransactionInitializedOnResetProducer() {
        StreamsProducer streamsProducer = new StreamsProducer(this.mockedProducer, StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, this.mockTime, this.logContext);
        streamsProducer.initTransaction();
        Mockito.when((Object)this.mockedProducer.metrics()).thenReturn(Collections.emptyMap());
        streamsProducer.resetProducer(this.mockedProducer);
        streamsProducer.initTransaction();
        ((Producer)Mockito.verify(this.mockedProducer)).close();
        ((Producer)Mockito.verify(this.mockedProducer, (VerificationMode)Mockito.times((int)2))).initTransactions();
    }

    @Test
    public void shouldComputeTotalBlockedTime() {
        this.setProducerMetrics(this.nonEosMockProducer, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0);
        double expectedTotalBlocked = 36.0;
        MatcherAssert.assertThat((Object)this.nonEosStreamsProducer.totalBlockedTime(), (Matcher)Matchers.closeTo((double)36.0, (double)0.01));
    }

    @Test
    public void shouldComputeTotalBlockedTimeAfterReset() {
        this.setProducerMetrics(this.eosMockProducer, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0);
        double expectedTotalBlocked = 36.0;
        MatcherAssert.assertThat((Object)this.eosStreamsProducer.totalBlockedTime(), (Matcher)Matchers.equalTo((Object)36.0));
        long closeStart = 1L;
        long clodeDelay = 1L;
        Mockito.when((Object)this.mockTime.nanoseconds()).thenReturn((Object)1L).thenReturn((Object)2L);
        this.eosStreamsProducer.resetProducer(this.eosMockProducer);
        this.setProducerMetrics(this.eosMockProducer, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0);
        MatcherAssert.assertThat((Object)this.eosStreamsProducer.totalBlockedTime(), (Matcher)Matchers.closeTo((double)73.0, (double)0.01));
    }

    private MetricName metricName(String name) {
        return new MetricName(name, "", "", Collections.emptyMap());
    }

    private void addMetric(MockProducer<?, ?> producer, String name, final double value) {
        final MetricName metricName = this.metricName(name);
        producer.setMockMetrics(metricName, new Metric(){

            public MetricName metricName() {
                return metricName;
            }

            public Object metricValue() {
                return value;
            }
        });
    }

    private void setProducerMetrics(MockProducer<?, ?> producer, double bufferPoolWaitTime, double flushTime, double txnInitTime, double txnBeginTime, double txnSendOffsetsTime, double txnCommitTime, double txnAbortTime, double metadataWaitTime) {
        this.addMetric(producer, "bufferpool-wait-time-ns-total", bufferPoolWaitTime);
        this.addMetric(producer, "flush-time-ns-total", flushTime);
        this.addMetric(producer, "txn-init-time-ns-total", txnInitTime);
        this.addMetric(producer, "txn-begin-time-ns-total", txnBeginTime);
        this.addMetric(producer, "txn-send-offsets-time-ns-total", txnSendOffsetsTime);
        this.addMetric(producer, "txn-commit-time-ns-total", txnCommitTime);
        this.addMetric(producer, "txn-abort-time-ns-total", txnAbortTime);
        this.addMetric(producer, "metadata-wait-time-ns-total", metadataWaitTime);
    }
}

