/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.internals.StreamsConfigUtils;
import org.apache.kafka.streams.processor.internals.StreamsProducer;
import org.apache.kafka.streams.processor.internals.TaskExecutionMetadata;
import org.apache.kafka.streams.processor.internals.TaskExecutor;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.Tasks;
import org.apache.kafka.streams.processor.internals.TasksRegistry;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TaskExecutorTest {
    @Test
    public void testPunctuateWithPause() {
        Tasks tasks = (Tasks)Mockito.mock(Tasks.class);
        TaskManager taskManager = (TaskManager)Mockito.mock(TaskManager.class);
        TaskExecutionMetadata metadata = (TaskExecutionMetadata)Mockito.mock(TaskExecutionMetadata.class);
        TaskExecutor taskExecutor = new TaskExecutor((TasksRegistry)tasks, taskManager, metadata, new LogContext());
        taskExecutor.punctuate();
        ((Tasks)Mockito.verify((Object)tasks)).activeTasks();
    }

    @Test
    public void testCommitWithOpenTransactionButNoOffsetsEOSV2() {
        Tasks tasks = (Tasks)Mockito.mock(Tasks.class);
        TaskManager taskManager = (TaskManager)Mockito.mock(TaskManager.class);
        ConsumerGroupMetadata groupMetadata = (ConsumerGroupMetadata)Mockito.mock(ConsumerGroupMetadata.class);
        Mockito.when((Object)taskManager.consumerGroupMetadata()).thenReturn((Object)groupMetadata);
        TaskExecutionMetadata metadata = (TaskExecutionMetadata)Mockito.mock(TaskExecutionMetadata.class);
        StreamsProducer producer = (StreamsProducer)Mockito.mock(StreamsProducer.class);
        Mockito.when((Object)metadata.processingMode()).thenReturn((Object)StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2);
        Mockito.when((Object)taskManager.streamsProducer()).thenReturn((Object)producer);
        Mockito.when((Object)producer.transactionInFlight()).thenReturn((Object)true);
        TaskExecutor taskExecutor = new TaskExecutor((TasksRegistry)tasks, taskManager, metadata, new LogContext());
        taskExecutor.commitOffsetsOrTransaction(Collections.emptyMap());
        ((StreamsProducer)Mockito.verify((Object)producer)).commitTransaction(Collections.emptyMap(), groupMetadata);
    }
}

