/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.streams.internals.UpgradeFromValues;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.AssignorConfiguration;
import org.apache.kafka.streams.processor.internals.assignment.ReferenceContainer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class AssignorConfigurationTest {
    private final Map<String, Object> config = new HashMap<String, Object>();

    @BeforeEach
    public void setup() {
        this.config.put("application.id", "app.id");
        this.config.put("bootstrap.servers", "dummy");
        this.config.put("__reference.container.instance__", Mockito.mock(ReferenceContainer.class));
    }

    @Test
    public void configsShouldRejectZeroWarmups() {
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new AssignmentConfigs(Long.valueOf(1L), Integer.valueOf(0), Integer.valueOf(1), Long.valueOf(1L), AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"Invalid value 0 for configuration max.warmup.replicas"));
    }

    @Test
    public void shouldSupportAllUpgradeFromVersionsFromCooperativeRebalancingOn() {
        boolean beforeCooperative = true;
        for (UpgradeFromValues upgradeFrom : UpgradeFromValues.values()) {
            if (upgradeFrom.toString().equals("2.4")) {
                beforeCooperative = false;
            }
            this.config.put("upgrade.from", upgradeFrom.toString());
            if (beforeCooperative) {
                Assertions.assertThrows(ConfigException.class, () -> new AssignorConfiguration(this.config));
                continue;
            }
            Assertions.assertDoesNotThrow(() -> new AssignorConfiguration(this.config));
        }
    }
}

