/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.ClientTagAwareStandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.ConstrainedPrioritySet;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignmentUtils;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignorFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ClientTagAwareStandbyTaskAssignorTest {
    private static final String ZONE_TAG = "zone";
    private static final String CLUSTER_TAG = "cluster";
    private static final String ZONE_1 = "zone1";
    private static final String ZONE_2 = "zone2";
    private static final String ZONE_3 = "zone3";
    private static final String CLUSTER_1 = "cluster1";
    private static final String CLUSTER_2 = "cluster2";
    private static final String CLUSTER_3 = "cluster3";
    private StandbyTaskAssignor standbyTaskAssignor;

    @BeforeEach
    public void setup() {
        this.standbyTaskAssignor = new ClientTagAwareStandbyTaskAssignor();
    }

    @Test
    public void shouldNotAssignStatelessTasksToAnyClients() {
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2);
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_4, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_4, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1)), Utils.mkEntry((Object)AssignmentTestUtils.PID_5, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_5, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_6, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_6, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_7, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_7, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_3)}), AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_2)), Utils.mkEntry((Object)AssignmentTestUtils.PID_8, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_8, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_3)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_9, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_9, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_3)}), new TaskId[0]))});
        Set<TaskId> allActiveTasks = ClientTagAwareStandbyTaskAssignorTest.findAllActiveTasks(clientStates);
        AssignmentConfigs assignmentConfigs = ClientTagAwareStandbyTaskAssignorTest.newAssignmentConfigs(2, ZONE_TAG, CLUSTER_TAG);
        this.standbyTaskAssignor.assign(clientStates, allActiveTasks, statefulTasks, assignmentConfigs);
        Set statelessTasks = allActiveTasks.stream().filter(taskId -> !statefulTasks.contains(taskId)).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)clientStates.values().stream().allMatch(clientState -> statelessTasks.stream().noneMatch(arg_0 -> ((ClientState)clientState).hasStandbyTask(arg_0))));
    }

    @Test
    public void shouldRemoveClientToRemainingStandbysAndNotPopulatePendingStandbyTasksToClientIdWhenAllStandbyTasksWereAssigned() {
        int numStandbyReplicas = 2;
        Set<String> rackAwareAssignmentTags = Set.of(ZONE_TAG, CLUSTER_TAG);
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_0_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), AssignmentTestUtils.TASK_0_1)), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_3)}), AssignmentTestUtils.TASK_0_2))});
        ConstrainedPrioritySet constrainedPrioritySet = StandbyTaskAssignmentUtils.createLeastLoadedPrioritySetConstrainedByAssignedTask((Map)clientStates);
        Set<TaskId> allActiveTasks = ClientTagAwareStandbyTaskAssignorTest.findAllActiveTasks(clientStates);
        Map taskToClientId = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)AssignmentTestUtils.PID_1), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)AssignmentTestUtils.PID_2), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)AssignmentTestUtils.PID_3)});
        HashMap tagKeyToValues = new HashMap();
        HashMap tagEntryToClients = new HashMap();
        new ClientTagAwareStandbyTaskAssignor().fillClientsTagStatistics(clientStates, tagEntryToClients, tagKeyToValues);
        HashMap pendingStandbyTasksToClientId = new HashMap();
        Map tasksToRemainingStandbys = StandbyTaskAssignmentUtils.computeTasksToRemainingStandbys((int)2, allActiveTasks);
        for (TaskId activeTaskId : allActiveTasks) {
            new ClientTagAwareStandbyTaskAssignor().assignStandbyTasksToClientsWithDifferentTags(2, constrainedPrioritySet, activeTaskId, (ProcessId)taskToClientId.get(activeTaskId), rackAwareAssignmentTags, clientStates, tasksToRemainingStandbys, tagKeyToValues, tagEntryToClients, pendingStandbyTasksToClientId);
        }
        Assertions.assertTrue((boolean)tasksToRemainingStandbys.isEmpty());
        Assertions.assertTrue((boolean)pendingStandbyTasksToClientId.isEmpty());
    }

    @Test
    public void shouldUpdateClientToRemainingStandbysAndPendingStandbyTasksToClientIdWhenNotAllStandbyTasksWereAssigned() {
        Set<String> rackAwareAssignmentTags = Set.of(ZONE_TAG, CLUSTER_TAG);
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_0_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), AssignmentTestUtils.TASK_0_1)), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_3)}), AssignmentTestUtils.TASK_0_2))});
        ConstrainedPrioritySet constrainedPrioritySet = StandbyTaskAssignmentUtils.createLeastLoadedPrioritySetConstrainedByAssignedTask((Map)clientStates);
        int numStandbyReplicas = 3;
        Set<TaskId> allActiveTasks = ClientTagAwareStandbyTaskAssignorTest.findAllActiveTasks(clientStates);
        Map taskToClientId = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)AssignmentTestUtils.PID_1), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)AssignmentTestUtils.PID_2), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)AssignmentTestUtils.PID_3)});
        HashMap tagKeyToValues = new HashMap();
        HashMap tagEntryToClients = new HashMap();
        new ClientTagAwareStandbyTaskAssignor().fillClientsTagStatistics(clientStates, tagEntryToClients, tagKeyToValues);
        HashMap pendingStandbyTasksToClientId = new HashMap();
        Map tasksToRemainingStandbys = StandbyTaskAssignmentUtils.computeTasksToRemainingStandbys((int)3, allActiveTasks);
        for (TaskId activeTaskId2 : allActiveTasks) {
            new ClientTagAwareStandbyTaskAssignor().assignStandbyTasksToClientsWithDifferentTags(3, constrainedPrioritySet, activeTaskId2, (ProcessId)taskToClientId.get(activeTaskId2), rackAwareAssignmentTags, clientStates, tasksToRemainingStandbys, tagKeyToValues, tagEntryToClients, pendingStandbyTasksToClientId);
        }
        allActiveTasks.forEach(activeTaskId -> Assertions.assertEquals((long)1L, (long)((Integer)tasksToRemainingStandbys.get(activeTaskId)).longValue(), (String)String.format("Active task with id [%s] didn't match expected number of remaining standbys value.", activeTaskId)));
        allActiveTasks.forEach(activeTaskId -> Assertions.assertEquals(taskToClientId.get(activeTaskId), pendingStandbyTasksToClientId.get(activeTaskId), (String)String.format("Active task with id [%s] didn't match expected client ID value.", activeTaskId)));
    }

    @Test
    public void shouldPermitTaskMovementWhenClientTagsMatch() {
        ClientState source = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0]);
        ClientState destination = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0]);
        Assertions.assertTrue((boolean)this.standbyTaskAssignor.isAllowedTaskMovement(source, destination));
    }

    @Test
    public void shouldDeclineTaskMovementWhenClientTagsDoNotMatch() {
        ClientState source = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0]);
        ClientState destination = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0]);
        Assertions.assertFalse((boolean)this.standbyTaskAssignor.isAllowedTaskMovement(source, destination));
    }

    @Test
    public void shouldPermitSingleTaskMoveWhenClientTagMatch() {
        ClientState source = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0]);
        ClientState destination = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0]);
        ClientState clientState = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), new TaskId[0]);
        Map clientStateMap = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)source), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)destination), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)clientState)});
        TaskId taskId = new TaskId(0, 0);
        clientState.assignActive(taskId);
        source.assignStandby(taskId);
        Assertions.assertTrue((boolean)this.standbyTaskAssignor.isAllowedTaskMovement(source, destination, taskId, clientStateMap));
    }

    @Test
    public void shouldPermitSingleTaskMoveWhenDifferentClientTagCountNotChange() {
        ClientState source = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0]);
        ClientState destination = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0]);
        ClientState clientState = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), new TaskId[0]);
        Map clientStateMap = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)source), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)destination), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)clientState)});
        TaskId taskId = new TaskId(0, 0);
        clientState.assignActive(taskId);
        source.assignStandby(taskId);
        Assertions.assertTrue((boolean)this.standbyTaskAssignor.isAllowedTaskMovement(source, destination, taskId, clientStateMap));
    }

    @Test
    public void shouldDeclineSingleTaskMoveWhenReduceClientTagCount() {
        ClientState source = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0]);
        ClientState destination = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0]);
        ClientState clientState = ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), new TaskId[0]);
        Map clientStateMap = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)source), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)destination), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)clientState)});
        TaskId taskId = new TaskId(0, 0);
        clientState.assignActive(taskId);
        source.assignStandby(taskId);
        Assertions.assertFalse((boolean)this.standbyTaskAssignor.isAllowedTaskMovement(source, destination, taskId, clientStateMap));
    }

    @Test
    public void shouldDistributeStandbyTasksWhenActiveTasksAreLocatedOnSameZone() {
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_4, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_4, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1)), Utils.mkEntry((Object)AssignmentTestUtils.PID_5, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_5, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_6, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_6, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_7, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_7, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_3)}), AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_2)), Utils.mkEntry((Object)AssignmentTestUtils.PID_8, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_8, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_3)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_9, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_9, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_3)}), new TaskId[0]))});
        Set<TaskId> allActiveTasks = ClientTagAwareStandbyTaskAssignorTest.findAllActiveTasks(clientStates);
        AssignmentConfigs assignmentConfigs = ClientTagAwareStandbyTaskAssignorTest.newAssignmentConfigs(2, ZONE_TAG, CLUSTER_TAG);
        this.standbyTaskAssignor.assign(clientStates, allActiveTasks, allActiveTasks, assignmentConfigs);
        Assertions.assertTrue((boolean)clientStates.values().stream().allMatch(ClientState::reachedCapacity));
        Stream.of(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_4, AssignmentTestUtils.PID_7).forEach(client -> ClientTagAwareStandbyTaskAssignorTest.assertStandbyTaskCountForClientEqualsTo(clientStates, client, 0));
        Stream.of(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_8, AssignmentTestUtils.PID_9).forEach(client -> ClientTagAwareStandbyTaskAssignorTest.assertStandbyTaskCountForClientEqualsTo(clientStates, client, 2));
        ClientTagAwareStandbyTaskAssignorTest.assertTotalNumberOfStandbyTasksEqualsTo(clientStates, 12);
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_0_0, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_9, AssignmentTestUtils.PID_5), Set.of(AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_8))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_1_0, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_9, AssignmentTestUtils.PID_5), Set.of(AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_8))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_0_1, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_9), Set.of(AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_8))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_1_1, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_9), Set.of(AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_8))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_0_2, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_3), Set.of(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_6))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_1_2, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_3), Set.of(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_6))));
    }

    @Test
    public void shouldDistributeStandbyTasksUsingFunctionAndSupplierTags() {
        Map racksForProcess = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)"rack1"), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)"rack2"), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)"rack3"), Utils.mkEntry((Object)AssignmentTestUtils.PID_4, (Object)"rack1"), Utils.mkEntry((Object)AssignmentTestUtils.PID_5, (Object)"rack2"), Utils.mkEntry((Object)AssignmentTestUtils.PID_6, (Object)"rack3"), Utils.mkEntry((Object)AssignmentTestUtils.PID_7, (Object)"rack1"), Utils.mkEntry((Object)AssignmentTestUtils.PID_8, (Object)"rack2"), Utils.mkEntry((Object)AssignmentTestUtils.PID_9, (Object)"rack3")});
        RackAwareTaskAssignor rackAwareTaskAssignor = (RackAwareTaskAssignor)Mockito.mock(RackAwareTaskAssignor.class);
        Mockito.when((Object)rackAwareTaskAssignor.validClientRack()).thenReturn((Object)true);
        Mockito.when((Object)rackAwareTaskAssignor.racksForProcess()).thenReturn((Object)racksForProcess);
        AssignmentConfigs assignmentConfigs = ClientTagAwareStandbyTaskAssignorTest.newAssignmentConfigs(2, new String[0]);
        this.standbyTaskAssignor = StandbyTaskAssignorFactory.create((AssignmentConfigs)assignmentConfigs, (RackAwareTaskAssignor)rackAwareTaskAssignor);
        ((RackAwareTaskAssignor)Mockito.verify((Object)rackAwareTaskAssignor, (VerificationMode)Mockito.times((int)1))).racksForProcess();
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 2, Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 2, Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1)), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 2, Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_2)), Utils.mkEntry((Object)AssignmentTestUtils.PID_4, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_4, 2, Utils.mkMap((Map.Entry[])new Map.Entry[0]), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_5, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_5, 2, Utils.mkMap((Map.Entry[])new Map.Entry[0]), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_6, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_6, 2, Utils.mkMap((Map.Entry[])new Map.Entry[0]), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_7, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_7, 2, Utils.mkMap((Map.Entry[])new Map.Entry[0]), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_8, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_8, 2, Utils.mkMap((Map.Entry[])new Map.Entry[0]), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_9, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_9, 2, Utils.mkMap((Map.Entry[])new Map.Entry[0]), new TaskId[0]))});
        Map clientStatesWithTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1)}), AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2)}), AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1)), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3)}), AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_2)), Utils.mkEntry((Object)AssignmentTestUtils.PID_4, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_4, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_5, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_5, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_6, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_6, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_7, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_7, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_8, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_8, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_9, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_9, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3)}), new TaskId[0]))});
        Set<TaskId> allActiveTasks = ClientTagAwareStandbyTaskAssignorTest.findAllActiveTasks(clientStates);
        this.standbyTaskAssignor.assign(clientStates, allActiveTasks, allActiveTasks, assignmentConfigs);
        AssignmentConfigs assignmentConfigsWithTags = ClientTagAwareStandbyTaskAssignorTest.newAssignmentConfigs(2, ZONE_TAG);
        this.standbyTaskAssignor = new ClientTagAwareStandbyTaskAssignor();
        this.standbyTaskAssignor.assign(clientStatesWithTags, allActiveTasks, allActiveTasks, assignmentConfigsWithTags);
        Stream.of(clientStates, clientStatesWithTags).forEach(cs -> {
            Assertions.assertTrue((boolean)cs.values().stream().allMatch(ClientState::reachedCapacity));
            Stream.of(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3).forEach(client -> ClientTagAwareStandbyTaskAssignorTest.assertStandbyTaskCountForClientEqualsTo(cs, client, 0));
            Stream.of(AssignmentTestUtils.PID_4, AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_7, AssignmentTestUtils.PID_8, AssignmentTestUtils.PID_9).forEach(client -> ClientTagAwareStandbyTaskAssignorTest.assertStandbyTaskCountForClientEqualsTo(cs, client, 2));
            ClientTagAwareStandbyTaskAssignorTest.assertTotalNumberOfStandbyTasksEqualsTo(cs, 12);
            Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.containsStandbyTasks(AssignmentTestUtils.TASK_0_0, cs, Set.of(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_8, AssignmentTestUtils.PID_9)));
            Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.containsStandbyTasks(AssignmentTestUtils.TASK_1_0, cs, Set.of(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_8, AssignmentTestUtils.PID_9)));
            Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.containsStandbyTasks(AssignmentTestUtils.TASK_0_1, cs, Set.of(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_4, AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_7, AssignmentTestUtils.PID_9)));
            Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.containsStandbyTasks(AssignmentTestUtils.TASK_1_1, cs, Set.of(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_4, AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_7, AssignmentTestUtils.PID_9)));
            Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.containsStandbyTasks(AssignmentTestUtils.TASK_0_2, cs, Set.of(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_4, AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_7, AssignmentTestUtils.PID_8)));
            Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.containsStandbyTasks(AssignmentTestUtils.TASK_1_2, cs, Set.of(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_4, AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_7, AssignmentTestUtils.PID_8)));
        });
    }

    @Test
    public void shouldDistributeStandbyTasksWhenActiveTasksAreLocatedOnSameCluster() {
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1)), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_2)), Utils.mkEntry((Object)AssignmentTestUtils.PID_4, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_4, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_5, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_5, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_6, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_6, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_7, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_7, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_3)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_8, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_8, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_3)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_9, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_9, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_3)}), new TaskId[0]))});
        Set<TaskId> allActiveTasks = ClientTagAwareStandbyTaskAssignorTest.findAllActiveTasks(clientStates);
        AssignmentConfigs assignmentConfigs = ClientTagAwareStandbyTaskAssignorTest.newAssignmentConfigs(2, ZONE_TAG, CLUSTER_TAG);
        this.standbyTaskAssignor.assign(clientStates, allActiveTasks, allActiveTasks, assignmentConfigs);
        Assertions.assertTrue((boolean)clientStates.values().stream().allMatch(ClientState::reachedCapacity));
        Stream.of(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3).forEach(client -> ClientTagAwareStandbyTaskAssignorTest.assertStandbyTaskCountForClientEqualsTo(clientStates, client, 0));
        Stream.of(AssignmentTestUtils.PID_4, AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_7, AssignmentTestUtils.PID_8, AssignmentTestUtils.PID_9).forEach(client -> ClientTagAwareStandbyTaskAssignorTest.assertStandbyTaskCountForClientEqualsTo(clientStates, client, 2));
        ClientTagAwareStandbyTaskAssignorTest.assertTotalNumberOfStandbyTasksEqualsTo(clientStates, 12);
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_0_0, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_9, AssignmentTestUtils.PID_5), Set.of(AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_8))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_1_0, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_9, AssignmentTestUtils.PID_5), Set.of(AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_8))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_0_1, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_4, AssignmentTestUtils.PID_9), Set.of(AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_7))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_1_1, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_4, AssignmentTestUtils.PID_9), Set.of(AssignmentTestUtils.PID_6, AssignmentTestUtils.PID_7))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_0_2, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_7), Set.of(AssignmentTestUtils.PID_4, AssignmentTestUtils.PID_8))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_1_2, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_7), Set.of(AssignmentTestUtils.PID_4, AssignmentTestUtils.PID_8))));
    }

    @Test
    public void shouldDoThePartialRackAwareness() {
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1)}), AssignmentTestUtils.TASK_0_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_4, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_4, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_5, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_5, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_6, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_6, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3)}), AssignmentTestUtils.TASK_1_0))});
        Set<TaskId> allActiveTasks = ClientTagAwareStandbyTaskAssignorTest.findAllActiveTasks(clientStates);
        AssignmentConfigs assignmentConfigs = ClientTagAwareStandbyTaskAssignorTest.newAssignmentConfigs(2, CLUSTER_TAG, ZONE_TAG);
        this.standbyTaskAssignor.assign(clientStates, allActiveTasks, allActiveTasks, assignmentConfigs);
        Stream.of(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_5).forEach(client -> ClientTagAwareStandbyTaskAssignorTest.assertStandbyTaskCountForClientEqualsTo(clientStates, client, 1));
        Stream.of(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_4, AssignmentTestUtils.PID_6).forEach(client -> ClientTagAwareStandbyTaskAssignorTest.assertStandbyTaskCountForClientEqualsTo(clientStates, client, 0, 1));
        ClientTagAwareStandbyTaskAssignorTest.assertTotalNumberOfStandbyTasksEqualsTo(clientStates, 4);
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_0_0, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_3), Set.of(AssignmentTestUtils.PID_5, AssignmentTestUtils.PID_6))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_1_0, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_4), Set.of(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_1))));
    }

    @Test
    public void shouldDistributeClientsOnDifferentZoneTagsEvenWhenClientsReachedCapacity() {
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_0_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_0_1)), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_0_2)), Utils.mkEntry((Object)AssignmentTestUtils.PID_4, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_4, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_1_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_5, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_5, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_1_1)), Utils.mkEntry((Object)AssignmentTestUtils.PID_6, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_6, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_3), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_1_2))});
        Set<TaskId> allActiveTasks = ClientTagAwareStandbyTaskAssignorTest.findAllActiveTasks(clientStates);
        AssignmentConfigs assignmentConfigs = ClientTagAwareStandbyTaskAssignorTest.newAssignmentConfigs(1, ZONE_TAG, CLUSTER_TAG);
        this.standbyTaskAssignor.assign(clientStates, allActiveTasks, allActiveTasks, assignmentConfigs);
        clientStates.keySet().forEach(client -> ClientTagAwareStandbyTaskAssignorTest.assertStandbyTaskCountForClientEqualsTo(clientStates, client, 1));
        ClientTagAwareStandbyTaskAssignorTest.assertTotalNumberOfStandbyTasksEqualsTo(clientStates, 6);
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_0_0, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_2), Set.of(AssignmentTestUtils.PID_5), Set.of(AssignmentTestUtils.PID_3), Set.of(AssignmentTestUtils.PID_6))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_1_0, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_2), Set.of(AssignmentTestUtils.PID_5), Set.of(AssignmentTestUtils.PID_3), Set.of(AssignmentTestUtils.PID_6))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_0_1, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_1), Set.of(AssignmentTestUtils.PID_4), Set.of(AssignmentTestUtils.PID_3), Set.of(AssignmentTestUtils.PID_6))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_1_1, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_1), Set.of(AssignmentTestUtils.PID_4), Set.of(AssignmentTestUtils.PID_3), Set.of(AssignmentTestUtils.PID_6))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_0_2, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_1), Set.of(AssignmentTestUtils.PID_4), Set.of(AssignmentTestUtils.PID_2), Set.of(AssignmentTestUtils.PID_5))));
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_1_2, clientStates, Arrays.asList(Set.of(AssignmentTestUtils.PID_1), Set.of(AssignmentTestUtils.PID_4), Set.of(AssignmentTestUtils.PID_2), Set.of(AssignmentTestUtils.PID_5))));
    }

    @Test
    public void shouldIgnoreTagsThatAreNotPresentInRackAwareness() {
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1)}), AssignmentTestUtils.TASK_0_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_2)}), new TaskId[0])), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 1, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_2), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1)}), new TaskId[0]))});
        Set<TaskId> allActiveTasks = ClientTagAwareStandbyTaskAssignorTest.findAllActiveTasks(clientStates);
        AssignmentConfigs assignmentConfigs = ClientTagAwareStandbyTaskAssignorTest.newAssignmentConfigs(1, CLUSTER_TAG);
        this.standbyTaskAssignor.assign(clientStates, allActiveTasks, allActiveTasks, assignmentConfigs);
        ClientTagAwareStandbyTaskAssignorTest.assertTotalNumberOfStandbyTasksEqualsTo(clientStates, 1);
        Assertions.assertEquals((int)1, (int)((ClientState)clientStates.get(AssignmentTestUtils.PID_3)).standbyTaskCount());
    }

    @Test
    public void shouldHandleOverlappingTagValuesBetweenDifferentTagKeys() {
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1)}), AssignmentTestUtils.TASK_0_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 2, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ZONE_TAG, (Object)CLUSTER_1), Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_3)}), new TaskId[0]))});
        Set<TaskId> allActiveTasks = ClientTagAwareStandbyTaskAssignorTest.findAllActiveTasks(clientStates);
        AssignmentConfigs assignmentConfigs = ClientTagAwareStandbyTaskAssignorTest.newAssignmentConfigs(1, ZONE_TAG, CLUSTER_TAG);
        this.standbyTaskAssignor.assign(clientStates, allActiveTasks, allActiveTasks, assignmentConfigs);
        ClientTagAwareStandbyTaskAssignorTest.assertTotalNumberOfStandbyTasksEqualsTo(clientStates, 1);
        Assertions.assertTrue((boolean)ClientTagAwareStandbyTaskAssignorTest.standbyClientsHonorRackAwareness(AssignmentTestUtils.TASK_0_0, clientStates, Collections.singletonList(Set.of(AssignmentTestUtils.PID_2))));
    }

    @Test
    public void shouldDistributeStandbyTasksOnLeastLoadedClientsWhenClientsAreNotOnDifferentTagDimensions() {
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 3, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1)}), AssignmentTestUtils.TASK_0_0)), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_2, 3, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1)}), AssignmentTestUtils.TASK_0_1)), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_3, 3, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1)}), AssignmentTestUtils.TASK_0_2)), Utils.mkEntry((Object)AssignmentTestUtils.PID_4, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_4, 3, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1)}), AssignmentTestUtils.TASK_1_0))});
        Set<TaskId> allActiveTasks = ClientTagAwareStandbyTaskAssignorTest.findAllActiveTasks(clientStates);
        AssignmentConfigs assignmentConfigs = ClientTagAwareStandbyTaskAssignorTest.newAssignmentConfigs(1, CLUSTER_TAG, ZONE_TAG);
        this.standbyTaskAssignor.assign(clientStates, allActiveTasks, allActiveTasks, assignmentConfigs);
        ClientTagAwareStandbyTaskAssignorTest.assertTotalNumberOfStandbyTasksEqualsTo(clientStates, 4);
        Assertions.assertEquals((int)1, (int)((ClientState)clientStates.get(AssignmentTestUtils.PID_1)).standbyTaskCount());
        Assertions.assertEquals((int)1, (int)((ClientState)clientStates.get(AssignmentTestUtils.PID_2)).standbyTaskCount());
        Assertions.assertEquals((int)1, (int)((ClientState)clientStates.get(AssignmentTestUtils.PID_3)).standbyTaskCount());
        Assertions.assertEquals((int)1, (int)((ClientState)clientStates.get(AssignmentTestUtils.PID_4)).standbyTaskCount());
    }

    @Test
    public void shouldNotAssignStandbyTasksIfThereAreNoEnoughClients() {
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)ClientTagAwareStandbyTaskAssignorTest.createClientStateWithCapacity(AssignmentTestUtils.PID_1, 3, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CLUSTER_TAG, (Object)CLUSTER_1), Utils.mkEntry((Object)ZONE_TAG, (Object)ZONE_1)}), AssignmentTestUtils.TASK_0_0))});
        Set<TaskId> allActiveTasks = ClientTagAwareStandbyTaskAssignorTest.findAllActiveTasks(clientStates);
        AssignmentConfigs assignmentConfigs = ClientTagAwareStandbyTaskAssignorTest.newAssignmentConfigs(1, CLUSTER_TAG, ZONE_TAG);
        this.standbyTaskAssignor.assign(clientStates, allActiveTasks, allActiveTasks, assignmentConfigs);
        ClientTagAwareStandbyTaskAssignorTest.assertTotalNumberOfStandbyTasksEqualsTo(clientStates, 0);
        Assertions.assertEquals((int)0, (int)((ClientState)clientStates.get(AssignmentTestUtils.PID_1)).standbyTaskCount());
    }

    private static void assertTotalNumberOfStandbyTasksEqualsTo(Map<ProcessId, ClientState> clientStates, int expectedTotalNumberOfStandbyTasks) {
        int actualTotalNumberOfStandbyTasks = clientStates.values().stream().map(ClientState::standbyTaskCount).reduce(0, Integer::sum);
        Assertions.assertEquals((int)expectedTotalNumberOfStandbyTasks, (int)actualTotalNumberOfStandbyTasks);
    }

    private static void assertStandbyTaskCountForClientEqualsTo(Map<ProcessId, ClientState> clientStates, ProcessId client, int ... expectedStandbyTaskCounts) {
        int standbyTaskCount = clientStates.get(client).standbyTaskCount();
        String msg = String.format("Client [%s] doesn't have expected number of standby tasks. Expected any of %s, actual [%s]", client, Arrays.toString(expectedStandbyTaskCounts), standbyTaskCount);
        Assertions.assertTrue((boolean)Arrays.stream(expectedStandbyTaskCounts).anyMatch(expectedStandbyTaskCount -> expectedStandbyTaskCount == standbyTaskCount), (String)msg);
    }

    private static boolean standbyClientsHonorRackAwareness(TaskId activeTaskId, Map<ProcessId, ClientState> clientStates, List<Set<ProcessId>> validClientIdsBasedOnRackAwareAssignmentTags) {
        Set<ProcessId> standbyTaskClientIds = ClientTagAwareStandbyTaskAssignorTest.findAllStandbyTaskClients(clientStates, activeTaskId);
        return validClientIdsBasedOnRackAwareAssignmentTags.stream().filter(it -> it.equals(standbyTaskClientIds)).count() == 1L;
    }

    private static boolean containsStandbyTasks(TaskId activeTaskId, Map<ProcessId, ClientState> clientStates, Set<ProcessId> validClientIdsBasedOnRackAwareAssignmentTags) {
        Set<ProcessId> standbyTaskClientIds = ClientTagAwareStandbyTaskAssignorTest.findAllStandbyTaskClients(clientStates, activeTaskId);
        return validClientIdsBasedOnRackAwareAssignmentTags.containsAll(standbyTaskClientIds);
    }

    private static Set<ProcessId> findAllStandbyTaskClients(Map<ProcessId, ClientState> clientStates, TaskId task) {
        return clientStates.keySet().stream().filter(clientId -> ((ClientState)clientStates.get(clientId)).standbyTasks().contains(task)).collect(Collectors.toSet());
    }

    private static AssignmentConfigs newAssignmentConfigs(int numStandbyReplicas, String ... rackAwareAssignmentTags) {
        return new AssignmentConfigs(Long.valueOf(0L), Integer.valueOf(1), Integer.valueOf(numStandbyReplicas), Long.valueOf(60000L), Arrays.asList(rackAwareAssignmentTags));
    }

    private static ClientState createClientStateWithCapacity(ProcessId processId, int capacity, Map<String, String> clientTags, TaskId ... tasks) {
        ClientState clientState = new ClientState(processId, capacity, clientTags);
        Optional.ofNullable(tasks).ifPresent(t -> clientState.assignActiveTasks(Arrays.asList(t)));
        return clientState;
    }

    private static Set<TaskId> findAllActiveTasks(Map<ProcessId, ClientState> clientStates) {
        return clientStates.entrySet().stream().flatMap(clientStateEntry -> ((ClientState)clientStateEntry.getValue()).activeTasks().stream()).collect(Collectors.toSet());
    }
}

