/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.FallbackPriorTaskAssignor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class FallbackPriorTaskAssignorTest {
    private final Map<ProcessId, ClientState> clients = new TreeMap<ProcessId, ClientState>();

    @Test
    public void shouldViolateBalanceToPreserveActiveTaskStickiness() {
        ClientState c1 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        ClientState c2 = this.createClient(AssignmentTestUtils.PID_2, 1);
        List<TaskId> taskIds = Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        Collections.shuffle(taskIds);
        boolean probingRebalanceNeeded = new FallbackPriorTaskAssignor().assign(this.clients, new HashSet<TaskId>(taskIds), new HashSet<TaskId>(taskIds), null, new AssignmentConfigs(Long.valueOf(0L), Integer.valueOf(1), Integer.valueOf(0), Long.valueOf(60000L), AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS));
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.equalTo(Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.empty());
    }

    private ClientState createClient(ProcessId processId, int capacity) {
        return this.createClientWithPreviousActiveTasks(processId, capacity, new TaskId[0]);
    }

    private ClientState createClientWithPreviousActiveTasks(ProcessId processId, int capacity, TaskId ... taskIds) {
        ClientState clientState = new ClientState(capacity);
        clientState.addPreviousActiveTasks(Set.of(taskIds));
        this.clients.put(processId, clientState);
        return clientState;
    }
}

