/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.HighAvailabilityTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareTaskAssignor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class HighAvailabilityTaskAssignorTest {
    private final Time time = new MockTime();

    private AssignmentConfigs getConfigWithoutStandbys(String rackAwareStrategy) {
        return new AssignmentConfigs(100L, 2, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
    }

    private AssignmentConfigs getConfigWithStandbys(String rackAwareStrategy) {
        return this.getConfigWithStandbys(1, rackAwareStrategy);
    }

    private AssignmentConfigs getConfigWithStandbys(int replicaNum, String rackAwareStrategy) {
        return new AssignmentConfigs(100L, 2, replicaNum, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
    }

    static Stream<Arguments> parameter() {
        return Stream.of(Arguments.of((Object[])new Object[]{"none", false, 1}), Arguments.of((Object[])new Object[]{"min_traffic", true, 1}), Arguments.of((Object[])new Object[]{"balance_subtopology", true, 4}));
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldBeStickyForActiveAndStandbyTasksWhileWarmingUp(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTaskIds = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2);
        ClientState clientState1 = new ClientState(allTaskIds, Collections.emptySet(), allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> 0L)), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), allTaskIds, allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> 10L)), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_2);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> Long.MAX_VALUE)), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_3);
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)clientState1), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)clientState2), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)clientState3)});
        AssignmentConfigs configs = new AssignmentConfigs(11L, 2, 1, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(2, null), Set.of(AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean unstable = new HighAvailabilityTaskAssignor().assign(clientStates, allTaskIds, allTaskIds, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)clientState1, AssignmentTestUtils.hasAssignedTasks(allTaskIds.size()));
        MatcherAssert.assertThat((Object)clientState2, AssignmentTestUtils.hasAssignedTasks(allTaskIds.size()));
        MatcherAssert.assertThat((Object)clientState3, AssignmentTestUtils.hasAssignedTasks(2));
        MatcherAssert.assertThat((Object)unstable, (Matcher)Matchers.is((Object)true));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTaskIds, clientStates, true, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldSkipWarmupsWhenAcceptableLagIsMax(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTaskIds = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2);
        ClientState clientState1 = new ClientState(allTaskIds, Collections.emptySet(), allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> 0L)), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> Long.MAX_VALUE)), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_2);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> Long.MAX_VALUE)), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_3);
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)clientState1), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)clientState2), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)clientState3)});
        AssignmentConfigs configs = new AssignmentConfigs(Long.MAX_VALUE, 1, 1, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(2, null), Set.of(AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean unstable = new HighAvailabilityTaskAssignor().assign(clientStates, allTaskIds, allTaskIds, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)clientState1, AssignmentTestUtils.hasAssignedTasks(6));
        MatcherAssert.assertThat((Object)clientState2, AssignmentTestUtils.hasAssignedTasks(6));
        MatcherAssert.assertThat((Object)clientState3, AssignmentTestUtils.hasAssignedTasks(6));
        MatcherAssert.assertThat((Object)unstable, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTaskIds, clientStates, true, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignActiveStatefulTasksEvenlyOverClientsWhereNumberOfClientsIntegralDivisorOfNumberOfTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor, int maxSkew) {
        Set<TaskId> allTaskIds = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2);
        Map<TaskId, Long> lags = allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> 10L));
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_2);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_3);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(clientState1, clientState2, clientState3);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(2, null), Set.of(AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean unstable = new HighAvailabilityTaskAssignor().assign(clientStates, allTaskIds, allTaskIds, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)unstable, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.assertValidAssignment(0, allTaskIds, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(allTaskIds, clientStates, new StringBuilder());
        if (!rackAwareStrategy.equals("min_traffic")) {
            AssignmentTestUtils.assertBalancedTasks(clientStates, maxSkew);
        }
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTaskIds, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignActiveStatefulTasksEvenlyOverClientsWhereNumberOfThreadsIntegralDivisorOfNumberOfTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor, int maxSkew) {
        Set<TaskId> allTaskIds = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2);
        Map<TaskId, Long> lags = allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> 10L));
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 3, AssignmentTestUtils.PID_1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 3, AssignmentTestUtils.PID_2);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 3, AssignmentTestUtils.PID_3);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(clientState1, clientState2, clientState3);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(2, null), Set.of(AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean unstable = new HighAvailabilityTaskAssignor().assign(clientStates, allTaskIds, allTaskIds, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)unstable, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.assertValidAssignment(0, allTaskIds, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(allTaskIds, clientStates, new StringBuilder());
        if (!rackAwareStrategy.equals("min_traffic")) {
            AssignmentTestUtils.assertBalancedTasks(clientStates, maxSkew);
        }
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTaskIds, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignActiveStatefulTasksEvenlyOverClientsWhereNumberOfClientsNotIntegralDivisorOfNumberOfTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor, int maxSkew) {
        Set<TaskId> allTaskIds = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2);
        Map<TaskId, Long> lags = allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> 10L));
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_2);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(clientState1, clientState2);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(2, null), Set.of(AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean unstable = new HighAvailabilityTaskAssignor().assign(clientStates, allTaskIds, allTaskIds, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)unstable, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.assertValidAssignment(0, allTaskIds, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(allTaskIds, clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedTasks(clientStates, maxSkew);
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTaskIds, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignActiveStatefulTasksEvenlyOverUnevenlyDistributedStreamThreads(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTaskIds = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2);
        Map<TaskId, Long> lags = allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> 10L));
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 2, AssignmentTestUtils.PID_2);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 3, AssignmentTestUtils.PID_3);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(clientState1, clientState2, clientState3);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean unstable = new HighAvailabilityTaskAssignor().assign(clientStates, allTaskIds, allTaskIds, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)unstable, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.assertValidAssignment(0, allTaskIds, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(allTaskIds, clientStates, new StringBuilder());
        MatcherAssert.assertThat((Object)clientState1, AssignmentTestUtils.hasActiveTasks(1));
        MatcherAssert.assertThat((Object)clientState2, AssignmentTestUtils.hasActiveTasks(2));
        MatcherAssert.assertThat((Object)clientState3, AssignmentTestUtils.hasActiveTasks(3));
        AssignmentTestUtils.TaskSkewReport taskSkewReport = AssignmentTestUtils.analyzeTaskAssignmentBalance(clientStates, 1);
        if (taskSkewReport.totalSkewedTasks() == 0) {
            Assertions.fail((String)("Expected a skewed task assignment, but was: " + String.valueOf(taskSkewReport)));
        }
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTaskIds, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignActiveStatefulTasksEvenlyOverClientsWithMoreClientsThanTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor, int maxSkew) {
        Set<TaskId> allTaskIds = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        Map<TaskId, Long> lags = allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> 10L));
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_2);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_3);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(clientState1, clientState2, clientState3);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean unstable = new HighAvailabilityTaskAssignor().assign(clientStates, allTaskIds, allTaskIds, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)unstable, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.assertValidAssignment(0, allTaskIds, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(allTaskIds, clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedTasks(clientStates, maxSkew);
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTaskIds, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignActiveStatefulTasksEvenlyOverClientsAndStreamThreadsWithEqualStreamThreadsPerClientAsTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor, int maxSkew) {
        Set<TaskId> allTaskIds = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2);
        Map<TaskId, Long> lags = allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> 10L));
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 9, AssignmentTestUtils.PID_1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 9, AssignmentTestUtils.PID_2);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 9, AssignmentTestUtils.PID_3);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(clientState1, clientState2, clientState3);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(2, null), Set.of(AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean unstable = new HighAvailabilityTaskAssignor().assign(clientStates, allTaskIds, allTaskIds, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)unstable, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.assertValidAssignment(0, allTaskIds, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(allTaskIds, clientStates, new StringBuilder());
        if (!rackAwareStrategy.equals("min_traffic")) {
            AssignmentTestUtils.assertBalancedTasks(clientStates, maxSkew);
        }
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTaskIds, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignWarmUpTasksIfStatefulActiveTasksBalancedOverStreamThreadsButNotOverClients(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTaskIds = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1);
        Map<TaskId, Long> lagsForCaughtUpClient = allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> 0L));
        Map<TaskId, Long> lagsForNotCaughtUpClient = allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> Long.MAX_VALUE));
        ClientState caughtUpClientState = new ClientState(allTaskIds, Collections.emptySet(), lagsForCaughtUpClient, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 5, AssignmentTestUtils.PID_1);
        ClientState notCaughtUpClientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), lagsForNotCaughtUpClient, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 5, AssignmentTestUtils.PID_2);
        ClientState notCaughtUpClientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), lagsForNotCaughtUpClient, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 5, AssignmentTestUtils.PID_3);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(caughtUpClientState, notCaughtUpClientState1, notCaughtUpClientState2);
        AssignmentConfigs configs = new AssignmentConfigs(0L, allTaskIds.size() / 3 + 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean unstable = new HighAvailabilityTaskAssignor().assign(clientStates, allTaskIds, allTaskIds, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)unstable, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)notCaughtUpClientState1.standbyTaskCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(allTaskIds.size() / 3)));
        MatcherAssert.assertThat((Object)notCaughtUpClientState2.standbyTaskCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(allTaskIds.size() / 3)));
        AssignmentTestUtils.assertValidAssignment(0, allTaskIds.size() / 3 + 1, allTaskIds, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTaskIds, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldEvenlyAssignActiveStatefulTasksIfClientsAreWarmedUpToBalanceTaskOverClients(String rackAwareStrategy, boolean enableRackAwareTaskAssignor, int maxSkew) {
        Set<TaskId> allTaskIds = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1);
        TaskId warmupTaskId1 = enableRackAwareTaskAssignor ? AssignmentTestUtils.TASK_1_1 : AssignmentTestUtils.TASK_0_1;
        TaskId warmupTaskId2 = enableRackAwareTaskAssignor ? AssignmentTestUtils.TASK_0_1 : AssignmentTestUtils.TASK_1_0;
        Set<TaskId> warmedUpTaskIds1 = Set.of(warmupTaskId1);
        Set<TaskId> warmedUpTaskIds2 = Set.of(warmupTaskId2);
        Map<TaskId, Long> lagsForCaughtUpClient = allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> 0L));
        Map<TaskId, Long> lagsForWarmedUpClient1 = allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> Long.MAX_VALUE));
        lagsForWarmedUpClient1.put(warmupTaskId1, 0L);
        Map<TaskId, Long> lagsForWarmedUpClient2 = allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> Long.MAX_VALUE));
        lagsForWarmedUpClient2.put(warmupTaskId2, 0L);
        ClientState caughtUpClientState = new ClientState(allTaskIds, Collections.emptySet(), lagsForCaughtUpClient, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 5, AssignmentTestUtils.PID_1);
        ClientState warmedUpClientState1 = new ClientState(Collections.emptySet(), warmedUpTaskIds1, lagsForWarmedUpClient1, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 5, AssignmentTestUtils.PID_2);
        ClientState warmedUpClientState2 = new ClientState(Collections.emptySet(), warmedUpTaskIds2, lagsForWarmedUpClient2, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 5, AssignmentTestUtils.PID_3);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(caughtUpClientState, warmedUpClientState1, warmedUpClientState2);
        AssignmentConfigs configs = new AssignmentConfigs(0L, allTaskIds.size() / 3 + 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean unstable = new HighAvailabilityTaskAssignor().assign(clientStates, allTaskIds, allTaskIds, rackAwareTaskAssignor, new AssignmentConfigs(Long.valueOf(0L), Integer.valueOf(allTaskIds.size() / 3 + 1), Integer.valueOf(0), Long.valueOf(60000L), AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS));
        MatcherAssert.assertThat((Object)unstable, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.assertValidAssignment(0, allTaskIds, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(allTaskIds, clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedTasks(clientStates, maxSkew);
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTaskIds, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignActiveStatefulTasksEvenlyOverStreamThreadsButBestEffortOverClients(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTaskIds = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2);
        Map<TaskId, Long> lags = allTaskIds.stream().collect(Collectors.toMap(k -> k, k -> 10L));
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 6, AssignmentTestUtils.PID_1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), lags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 3, AssignmentTestUtils.PID_2);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(clientState1, clientState2);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(2, null), Set.of(AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean unstable = new HighAvailabilityTaskAssignor().assign(clientStates, allTaskIds, allTaskIds, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)unstable, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.assertValidAssignment(0, allTaskIds, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(allTaskIds, clientStates, new StringBuilder());
        MatcherAssert.assertThat((Object)clientState1, AssignmentTestUtils.hasActiveTasks(6));
        MatcherAssert.assertThat((Object)clientState2, AssignmentTestUtils.hasActiveTasks(3));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTaskIds, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldComputeNewAssignmentIfThereAreUnassignedActiveTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor, int maxSkew) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        ClientState client1 = new ClientState(Collections.singleton(AssignmentTestUtils.TASK_0_0), Collections.emptySet(), Collections.singletonMap(AssignmentTestUtils.TASK_0_0, 0L), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_1);
        Map<ProcessId, ClientState> clientStates = Collections.singletonMap(AssignmentTestUtils.PID_1, client1);
        AssignmentConfigs configs = this.getConfigWithoutStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, Collections.singleton(AssignmentTestUtils.TASK_0_0), rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasActiveTasks(2));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasStandbyTasks(0));
        AssignmentTestUtils.assertValidAssignment(0, allTasks, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(allTasks, clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedTasks(clientStates, maxSkew);
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldComputeNewAssignmentIfThereAreUnassignedStandbyTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor, int maxSkew) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0);
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_0_0);
        ClientState client1 = new ClientState(Collections.singleton(AssignmentTestUtils.TASK_0_0), Collections.emptySet(), Collections.singletonMap(AssignmentTestUtils.TASK_0_0, 0L), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_1);
        ClientState client2 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.singletonMap(AssignmentTestUtils.TASK_0_0, 0L), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_2);
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)client1), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)client2)});
        AssignmentConfigs configs = this.getConfigWithStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)((ClientState)clientStates.get(AssignmentTestUtils.PID_2)).standbyTasks(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.assertValidAssignment(1, allTasks, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(allTasks, clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedTasks(clientStates, maxSkew);
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, true, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldComputeNewAssignmentIfActiveTasksWasNotOnCaughtUpClient(String rackAwareStrategy, boolean enableRackAwareTaskAssignor, int maxSkew) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_0_0);
        ClientState client1 = new ClientState(Collections.singleton(AssignmentTestUtils.TASK_0_0), Collections.emptySet(), Collections.singletonMap(AssignmentTestUtils.TASK_0_0, 500L), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_1);
        ClientState client2 = new ClientState(Collections.singleton(AssignmentTestUtils.TASK_0_1), Collections.emptySet(), Collections.singletonMap(AssignmentTestUtils.TASK_0_0, 0L), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_2);
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)client1), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)client2)});
        AssignmentConfigs configs = this.getConfigWithoutStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)((ClientState)clientStates.get(AssignmentTestUtils.PID_1)).activeTasks(), (Matcher)Matchers.is(Collections.singleton(AssignmentTestUtils.TASK_0_1)));
        MatcherAssert.assertThat((Object)((ClientState)clientStates.get(AssignmentTestUtils.PID_2)).activeTasks(), (Matcher)Matchers.is(Collections.singleton(AssignmentTestUtils.TASK_0_0)));
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)true));
        AssignmentTestUtils.assertValidAssignment(0, 1, allTasks, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(allTasks, clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedTasks(clientStates, maxSkew);
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignToMostCaughtUpIfActiveTasksWasNotOnCaughtUpClient(String rackAwareStrategy, boolean enableRackAwareTaskAssignor, int maxSkew) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0);
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_0_0);
        ClientState client1 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.singletonMap(AssignmentTestUtils.TASK_0_0, Long.MAX_VALUE), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_1);
        ClientState client2 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.singletonMap(AssignmentTestUtils.TASK_0_0, 1000L), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_2);
        ClientState client3 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.singletonMap(AssignmentTestUtils.TASK_0_0, 500L), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.PID_3);
        Map clientStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.PID_1, (Object)client1), Utils.mkEntry((Object)AssignmentTestUtils.PID_2, (Object)client2), Utils.mkEntry((Object)AssignmentTestUtils.PID_3, (Object)client3)});
        AssignmentConfigs configs = this.getConfigWithStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)((ClientState)clientStates.get(AssignmentTestUtils.PID_1)).activeTasks(), (Matcher)Matchers.is(Collections.emptySet()));
        MatcherAssert.assertThat((Object)((ClientState)clientStates.get(AssignmentTestUtils.PID_2)).activeTasks(), (Matcher)Matchers.is(Collections.emptySet()));
        MatcherAssert.assertThat((Object)((ClientState)clientStates.get(AssignmentTestUtils.PID_3)).activeTasks(), (Matcher)Matchers.is(Collections.singleton(AssignmentTestUtils.TASK_0_0)));
        MatcherAssert.assertThat((Object)((ClientState)clientStates.get(AssignmentTestUtils.PID_1)).standbyTasks(), (Matcher)Matchers.is(Collections.singleton(AssignmentTestUtils.TASK_0_0)));
        MatcherAssert.assertThat((Object)((ClientState)clientStates.get(AssignmentTestUtils.PID_2)).standbyTasks(), (Matcher)Matchers.is(Collections.singleton(AssignmentTestUtils.TASK_0_0)));
        MatcherAssert.assertThat((Object)((ClientState)clientStates.get(AssignmentTestUtils.PID_3)).standbyTasks(), (Matcher)Matchers.is(Collections.emptySet()));
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)true));
        AssignmentTestUtils.assertValidAssignment(1, 1, allTasks, Collections.emptySet(), clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(allTasks, clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedTasks(clientStates, maxSkew);
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, true, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignStandbysForStatefulTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        ClientState client1 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(Set.of(AssignmentTestUtils.TASK_0_0), statefulTasks, AssignmentTestUtils.PID_1);
        ClientState client2 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(Set.of(AssignmentTestUtils.TASK_0_1), statefulTasks, AssignmentTestUtils.PID_2);
        AssignmentConfigs configs = this.getConfigWithStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)client1.activeTasks(), (Matcher)CoreMatchers.equalTo(Set.of(AssignmentTestUtils.TASK_0_0)));
        MatcherAssert.assertThat((Object)client2.activeTasks(), (Matcher)CoreMatchers.equalTo(Set.of(AssignmentTestUtils.TASK_0_1)));
        MatcherAssert.assertThat((Object)client1.standbyTasks(), (Matcher)CoreMatchers.equalTo(Set.of(AssignmentTestUtils.TASK_0_1)));
        MatcherAssert.assertThat((Object)client2.standbyTasks(), (Matcher)CoreMatchers.equalTo(Set.of(AssignmentTestUtils.TASK_0_0)));
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, true, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldNotAssignStandbysForStatelessTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        Set<TaskId> statefulTasks = AssignmentTestUtils.EMPTY_TASKS;
        ClientState client1 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(AssignmentTestUtils.EMPTY_TASKS, statefulTasks, AssignmentTestUtils.PID_1);
        ClientState client2 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(AssignmentTestUtils.EMPTY_TASKS, statefulTasks, AssignmentTestUtils.PID_2);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2);
        AssignmentConfigs configs = this.getConfigWithStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)client1.activeTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)client2.activeTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        HighAvailabilityTaskAssignorTest.assertHasNoStandbyTasks(client1, client2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, true, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignWarmupReplicasEvenIfNoStandbyReplicasConfigured(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        ClientState client1 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1), statefulTasks, AssignmentTestUtils.PID_1);
        ClientState client2 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(AssignmentTestUtils.EMPTY_TASKS, statefulTasks, AssignmentTestUtils.PID_2);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2);
        AssignmentConfigs configs = this.getConfigWithoutStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)client1.activeTasks(), (Matcher)CoreMatchers.equalTo(Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1)));
        MatcherAssert.assertThat((Object)client2.standbyTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        HighAvailabilityTaskAssignorTest.assertHasNoStandbyTasks(client1);
        HighAvailabilityTaskAssignorTest.assertHasNoActiveTasks(client2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)true));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldNotAssignMoreThanMaxWarmupReplicas(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        ClientState client1 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3), statefulTasks, AssignmentTestUtils.PID_1);
        ClientState client2 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(AssignmentTestUtils.EMPTY_TASKS, statefulTasks, AssignmentTestUtils.PID_2);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2);
        AssignmentConfigs configs = new AssignmentConfigs(100L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)client1.activeTasks(), (Matcher)CoreMatchers.equalTo(Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3)));
        MatcherAssert.assertThat((Object)client2.standbyTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        HighAvailabilityTaskAssignorTest.assertHasNoStandbyTasks(client1);
        HighAvailabilityTaskAssignorTest.assertHasNoActiveTasks(client2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)true));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldNotAssignWarmupAndStandbyToTheSameClient(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        ClientState client1 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3), statefulTasks, AssignmentTestUtils.PID_1);
        ClientState client2 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(AssignmentTestUtils.EMPTY_TASKS, statefulTasks, AssignmentTestUtils.PID_2);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2);
        AssignmentConfigs configs = new AssignmentConfigs(100L, 1, 1, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)client1.activeTasks(), (Matcher)CoreMatchers.equalTo(Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3)));
        MatcherAssert.assertThat((Object)client2.standbyTasks(), (Matcher)CoreMatchers.equalTo(Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3)));
        HighAvailabilityTaskAssignorTest.assertHasNoStandbyTasks(client1);
        HighAvailabilityTaskAssignorTest.assertHasNoActiveTasks(client2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)true));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, true, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldNotAssignAnyStandbysWithInsufficientCapacity(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        ClientState client1 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1), statefulTasks, AssignmentTestUtils.PID_1);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1);
        AssignmentConfigs configs = this.getConfigWithStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)client1.activeTasks(), (Matcher)CoreMatchers.equalTo(Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1)));
        HighAvailabilityTaskAssignorTest.assertHasNoStandbyTasks(client1);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, true, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignActiveTasksToNotCaughtUpClientIfNoneExist(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        ClientState client1 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(AssignmentTestUtils.EMPTY_TASKS, statefulTasks, AssignmentTestUtils.PID_1);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1);
        AssignmentConfigs configs = this.getConfigWithStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)client1.activeTasks(), (Matcher)CoreMatchers.equalTo(Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1)));
        HighAvailabilityTaskAssignorTest.assertHasNoStandbyTasks(client1);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, true, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldNotAssignMoreThanMaxWarmupReplicasWithStandbys(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        ClientState client1 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(statefulTasks, statefulTasks, AssignmentTestUtils.PID_1);
        ClientState client2 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(AssignmentTestUtils.EMPTY_TASKS, statefulTasks, AssignmentTestUtils.PID_2);
        ClientState client3 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(AssignmentTestUtils.EMPTY_TASKS, statefulTasks, AssignmentTestUtils.PID_3);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2, client3);
        AssignmentConfigs configs = this.getConfigWithStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        AssignmentTestUtils.assertValidAssignment(1, 2, statefulTasks, Collections.emptySet(), clientStates, new StringBuilder());
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)true));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, true, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldDistributeStatelessTasksToBalanceTotalTaskLoad(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2);
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        Set<TaskId> statelessTasks = Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2);
        ClientState client1 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(statefulTasks, statefulTasks, AssignmentTestUtils.PID_1);
        ClientState client2 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(AssignmentTestUtils.EMPTY_TASKS, statefulTasks, AssignmentTestUtils.PID_2);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2);
        AssignmentConfigs configs = this.getConfigWithStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        AssignmentTestUtils.assertValidAssignment(1, 2, statefulTasks, statelessTasks, clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedStatefulAssignment(statefulTasks, clientStates, new StringBuilder());
        AssignmentTestUtils.TaskSkewReport taskSkewReport = AssignmentTestUtils.analyzeTaskAssignmentBalance(clientStates, 1);
        MatcherAssert.assertThat((String)taskSkewReport.toString(), taskSkewReport.skewedSubtopologies(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)true));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, true, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldDistributeStatefulActiveTasksToAllClients(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_1_3, AssignmentTestUtils.TASK_2_0);
        Map<TaskId, Long> allTaskLags = allTasks.stream().collect(Collectors.toMap(t -> t, t -> 0L));
        HashSet<TaskId> statefulTasks = new HashSet<TaskId>(allTasks);
        ClientState client1 = new ClientState(Collections.emptySet(), Collections.emptySet(), allTaskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 100);
        ClientState client2 = new ClientState(Collections.emptySet(), Collections.emptySet(), allTaskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 50);
        ClientState client3 = new ClientState(Collections.emptySet(), Collections.emptySet(), allTaskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2, client3);
        AssignmentConfigs configs = this.getConfigWithoutStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_1_3)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(2, null), Set.of(AssignmentTestUtils.TASK_2_0))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)client1.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)client2.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)client3.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldReturnFalseIfPreviousAssignmentIsReused(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        HashSet<TaskId> statefulTasks = new HashSet<TaskId>(allTasks);
        Set<TaskId> caughtUpTasks1 = enableRackAwareTaskAssignor ? Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_3) : Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2);
        Set<TaskId> caughtUpTasks2 = enableRackAwareTaskAssignor ? Set.of(AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2) : Set.of(AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_3);
        ClientState client1 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(caughtUpTasks1, statefulTasks, AssignmentTestUtils.PID_1);
        ClientState client2 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(caughtUpTasks2, statefulTasks, AssignmentTestUtils.PID_2);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2);
        AssignmentConfigs configs = this.getConfigWithoutStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)client1.activeTasks(), (Matcher)CoreMatchers.equalTo((Object)client1.prevActiveTasks()));
        MatcherAssert.assertThat((Object)client2.activeTasks(), (Matcher)CoreMatchers.equalTo((Object)client2.prevActiveTasks()));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldReturnFalseIfNoWarmupTasksAreAssigned(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        Set<TaskId> statefulTasks = AssignmentTestUtils.EMPTY_TASKS;
        ClientState client1 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(AssignmentTestUtils.EMPTY_TASKS, statefulTasks, AssignmentTestUtils.PID_1);
        ClientState client2 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(AssignmentTestUtils.EMPTY_TASKS, statefulTasks, AssignmentTestUtils.PID_2);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2);
        AssignmentConfigs configs = this.getConfigWithoutStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        HighAvailabilityTaskAssignorTest.assertHasNoStandbyTasks(client1, client2);
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldReturnTrueIfWarmupTasksAreAssigned(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        Set<TaskId> statefulTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        ClientState client1 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(allTasks, statefulTasks, AssignmentTestUtils.PID_1);
        ClientState client2 = HighAvailabilityTaskAssignorTest.getMockClientWithPreviousCaughtUpTasks(AssignmentTestUtils.EMPTY_TASKS, statefulTasks, AssignmentTestUtils.PID_2);
        AssignmentConfigs configs = this.getConfigWithoutStandbys(rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)client2.standbyTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldDistributeStatelessTasksEvenlyOverClientsWithEqualStreamThreadsPerClientAsTasksAndNoStatefulTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2);
        Set<TaskId> statefulTasks = AssignmentTestUtils.EMPTY_TASKS;
        HashSet<TaskId> statelessTasks = new HashSet<TaskId>(allTasks);
        HashMap taskLags = new HashMap();
        ClientState client1 = new ClientState(Collections.emptySet(), Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 7);
        ClientState client2 = new ClientState(Collections.emptySet(), Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 7);
        ClientState client3 = new ClientState(Collections.emptySet(), Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 7);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2, client3);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        AssignmentTestUtils.assertValidAssignment(0, AssignmentTestUtils.EMPTY_TASKS, statelessTasks, clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldDistributeStatelessTasksEvenlyOverClientsWithLessStreamThreadsPerClientAsTasksAndNoStatefulTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2);
        Set<TaskId> statefulTasks = AssignmentTestUtils.EMPTY_TASKS;
        HashSet<TaskId> statelessTasks = new HashSet<TaskId>(allTasks);
        HashMap taskLags = new HashMap();
        ClientState client1 = new ClientState(Collections.emptySet(), Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 2);
        ClientState client2 = new ClientState(Collections.emptySet(), Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 2);
        ClientState client3 = new ClientState(Collections.emptySet(), Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 2);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2, client3);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        AssignmentTestUtils.assertValidAssignment(0, AssignmentTestUtils.EMPTY_TASKS, statelessTasks, clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldDistributeStatelessTasksEvenlyOverClientsWithUnevenlyDistributedStreamThreadsAndNoStatefulTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2);
        Set<TaskId> statefulTasks = AssignmentTestUtils.EMPTY_TASKS;
        HashSet<TaskId> statelessTasks = new HashSet<TaskId>(allTasks);
        HashMap taskLags = new HashMap();
        ClientState client1 = new ClientState(Collections.emptySet(), Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        ClientState client2 = new ClientState(Collections.emptySet(), Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 2);
        ClientState client3 = new ClientState(Collections.emptySet(), Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 3);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2, client3);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        AssignmentTestUtils.assertValidAssignment(0, AssignmentTestUtils.EMPTY_TASKS, statelessTasks, clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldDistributeStatelessTasksEvenlyWithPreviousAssignmentAndNoStatefulTasks(String rackAwareStrategy, boolean enableRackAwareTaskAssignor) {
        Set<TaskId> allTasks = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2);
        Set<TaskId> statefulTasks = AssignmentTestUtils.EMPTY_TASKS;
        HashSet<TaskId> statelessTasks = new HashSet<TaskId>(allTasks);
        HashMap taskLags = new HashMap();
        ClientState client1 = new ClientState(statelessTasks, Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 3);
        ClientState client2 = new ClientState(Collections.emptySet(), Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 3);
        ClientState client3 = new ClientState(Collections.emptySet(), Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 3);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2, client3);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, rackAwareStrategy);
        Map tasksForTopicGroup = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopologyMetadata.Subtopology(0, null), Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3)), Utils.mkEntry((Object)new TopologyMetadata.Subtopology(1, null), Set.of(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2))});
        RackAwareTaskAssignor rackAwareTaskAssignor = AssignmentTestUtils.getRackAwareTaskAssignor(configs, tasksForTopicGroup);
        boolean probingRebalanceNeeded = new HighAvailabilityTaskAssignor().assign(clientStates, allTasks, statefulTasks, rackAwareTaskAssignor, configs);
        AssignmentTestUtils.assertValidAssignment(0, AssignmentTestUtils.EMPTY_TASKS, statelessTasks, clientStates, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, new StringBuilder());
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, allTasks, clientStates, false, enableRackAwareTaskAssignor);
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldAssignRandomInput(String rackAwareStrategy, boolean enableRackAwareTaskAssignor, int maxSkew) {
        int nodeSize = 50;
        int tpSize = 60;
        int partitionSize = 3;
        int clientSize = 50;
        int replicaCount = 3;
        int maxCapacity = 3;
        SortedMap<TaskId, Set<TopicPartition>> taskTopicPartitionMap = AssignmentTestUtils.getTaskTopicPartitionMap(60, 3, false);
        AssignmentConfigs assignorConfiguration = this.getConfigWithStandbys(3, rackAwareStrategy);
        RackAwareTaskAssignor rackAwareTaskAssignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(AssignmentTestUtils.getRandomCluster(50, 60, 3), taskTopicPartitionMap, AssignmentTestUtils.getTaskTopicPartitionMap(60, 3, true), AssignmentTestUtils.getTasksForTopicGroup(60, 3), AssignmentTestUtils.getRandomProcessRacks(50, 50), AssignmentTestUtils.mockInternalTopicManagerForRandomChangelog(50, 60, 3), assignorConfiguration, this.time));
        SortedSet taskIds = (SortedSet)taskTopicPartitionMap.keySet();
        List<Set<TaskId>> statefulAndStatelessTasks = AssignmentTestUtils.getRandomSubset(taskIds, 2);
        Set<TaskId> statefulTasks = statefulAndStatelessTasks.get(0);
        Set<TaskId> statelessTasks = statefulAndStatelessTasks.get(1);
        SortedMap<ProcessId, ClientState> clientStateMap = AssignmentTestUtils.getRandomClientState(50, 60, 3, 3, false, statefulTasks);
        new HighAvailabilityTaskAssignor().assign(clientStateMap, (Set)taskIds, statefulTasks, rackAwareTaskAssignor, assignorConfiguration);
        AssignmentTestUtils.assertValidAssignment(3, statefulTasks, statelessTasks, clientStateMap, new StringBuilder());
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStateMap, new StringBuilder());
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, taskIds, clientStateMap, true, enableRackAwareTaskAssignor);
        if (rackAwareStrategy.equals("balance_subtopology")) {
            AssignmentTestUtils.assertBalancedTasks(clientStateMap, maxSkew);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameter"})
    public void shouldRemainOriginalAssignmentWithoutTrafficCostForMinCostStrategy(String rackAwareStrategy, boolean enableRackAwareTaskAssignor, int maxSkew) {
        int nodeSize = 50;
        int tpSize = 60;
        int partitionSize = 3;
        int clientSize = 50;
        boolean replicaCount = true;
        int maxCapacity = 3;
        SortedMap<TaskId, Set<TopicPartition>> taskTopicPartitionMap = AssignmentTestUtils.getTaskTopicPartitionMap(60, 3, false);
        Cluster cluster = AssignmentTestUtils.getRandomCluster(50, 60, 3);
        SortedMap<TaskId, Set<TopicPartition>> taskChangelogTopicPartitionMap = AssignmentTestUtils.getTaskTopicPartitionMap(60, 3, true);
        Map<TopologyMetadata.Subtopology, Set<TaskId>> subtopologySetMap = AssignmentTestUtils.getTasksForTopicGroup(60, 3);
        Map<ProcessId, Map<String, Optional<String>>> processRackMap = AssignmentTestUtils.getRandomProcessRacks(50, 50);
        InternalTopicManager mockInternalTopicManager = AssignmentTestUtils.mockInternalTopicManagerForRandomChangelog(50, 60, 3);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 1, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, 0, 10, rackAwareStrategy);
        RackAwareTaskAssignor rackAwareTaskAssignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(cluster, taskTopicPartitionMap, taskChangelogTopicPartitionMap, subtopologySetMap, processRackMap, mockInternalTopicManager, configs, this.time));
        SortedSet taskIds = (SortedSet)taskTopicPartitionMap.keySet();
        List<Set<TaskId>> statefulAndStatelessTasks = AssignmentTestUtils.getRandomSubset(taskIds, 2);
        Set<TaskId> statefulTasks = statefulAndStatelessTasks.get(0);
        Set<TaskId> statelessTasks = statefulAndStatelessTasks.get(1);
        SortedMap<ProcessId, ClientState> clientStateMap = AssignmentTestUtils.getRandomClientState(50, 60, 3, 3, false, statefulTasks);
        new HighAvailabilityTaskAssignor().assign(clientStateMap, (Set)taskIds, statefulTasks, rackAwareTaskAssignor, configs);
        AssignmentTestUtils.assertValidAssignment(1, statefulTasks, statelessTasks, clientStateMap, new StringBuilder());
        if (rackAwareStrategy.equals("none")) {
            return;
        }
        if (rackAwareStrategy.equals("balance_subtopology")) {
            AssignmentTestUtils.assertBalancedTasks(clientStateMap, maxSkew);
            return;
        }
        SortedMap<ProcessId, ClientState> clientStateMapCopy = AssignmentTestUtils.copyClientStateMap(clientStateMap);
        configs = new AssignmentConfigs(0L, 1, 1, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, 0, 10, "none");
        rackAwareTaskAssignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(cluster, taskTopicPartitionMap, taskChangelogTopicPartitionMap, subtopologySetMap, processRackMap, mockInternalTopicManager, configs, this.time));
        new HighAvailabilityTaskAssignor().assign(clientStateMapCopy, (Set)taskIds, statefulTasks, rackAwareTaskAssignor, configs);
        for (Map.Entry<ProcessId, ClientState> entry : clientStateMap.entrySet()) {
            MatcherAssert.assertThat((Object)entry.getValue().statefulActiveTasks(), (Matcher)Matchers.equalTo((Object)((ClientState)clientStateMapCopy.get(entry.getKey())).statefulActiveTasks()));
            MatcherAssert.assertThat((Object)entry.getValue().standbyTasks(), (Matcher)Matchers.equalTo((Object)((ClientState)clientStateMapCopy.get(entry.getKey())).standbyTasks()));
        }
    }

    private static void assertHasNoActiveTasks(ClientState ... clients) {
        for (ClientState client : clients) {
            MatcherAssert.assertThat((Object)client.activeTasks(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        }
    }

    private static void assertHasNoStandbyTasks(ClientState ... clients) {
        for (ClientState client : clients) {
            MatcherAssert.assertThat((Object)client, AssignmentTestUtils.hasStandbyTasks(0));
        }
    }

    private static ClientState getMockClientWithPreviousCaughtUpTasks(Set<TaskId> statefulActiveTasks, Set<TaskId> statefulTasks, ProcessId processId) {
        if (!statefulTasks.containsAll(statefulActiveTasks)) {
            throw new IllegalArgumentException("Need to initialize stateful tasks set before creating mock clients");
        }
        HashMap<TaskId, Long> taskLags = new HashMap<TaskId, Long>();
        for (TaskId task : statefulTasks) {
            if (statefulActiveTasks.contains(task)) {
                taskLags.put(task, 0L);
                continue;
            }
            taskLags.put(task, Long.MAX_VALUE);
        }
        return new ClientState(statefulActiveTasks, Collections.emptySet(), taskLags, AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, processId);
    }
}

