/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.KafkaStreamsState;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.DefaultKafkaStreamsState;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KafkaStreamsStateTest {
    @Test
    public void shouldCorrectlyReturnTasksByLag() {
        DefaultKafkaStreamsState state = new DefaultKafkaStreamsState(ProcessId.randomProcessId(), 10, Utils.mkMap((Map.Entry[])new Map.Entry[0]), Utils.mkSortedSet((Comparable[])new TaskId[]{AssignmentTestUtils.NAMED_TASK_T0_0_0, AssignmentTestUtils.NAMED_TASK_T0_0_1}), Utils.mkSortedSet((Comparable[])new TaskId[0]), new TreeMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"c1", Set.of(AssignmentTestUtils.NAMED_TASK_T0_0_0, AssignmentTestUtils.NAMED_TASK_T0_0_1))})), Optional.empty(), Optional.of(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T0_0_0, (Object)2000L), Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T0_0_1, (Object)1000L)})), Optional.empty());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaStreamsStateTest.lambda$shouldCorrectlyReturnTasksByLag$0((KafkaStreamsState)state));
        MatcherAssert.assertThat((Object)state.lagFor(AssignmentTestUtils.NAMED_TASK_T0_0_0), (Matcher)CoreMatchers.equalTo((Object)2000L));
        MatcherAssert.assertThat((Object)state.lagFor(AssignmentTestUtils.NAMED_TASK_T0_0_1), (Matcher)CoreMatchers.equalTo((Object)1000L));
        MatcherAssert.assertThat((Object)state.prevTasksByLag("c0"), (Matcher)CoreMatchers.equalTo(new TreeSet()));
        MatcherAssert.assertThat((Object)state.prevTasksByLag("c1"), (Matcher)CoreMatchers.equalTo(new TreeSet<TaskId>(Arrays.asList(AssignmentTestUtils.NAMED_TASK_T0_0_1, AssignmentTestUtils.NAMED_TASK_T0_0_0))));
    }

    @Test
    public void shouldThrowExceptionOnLagOperationsIfLagsWereNotComputed() {
        DefaultKafkaStreamsState state = new DefaultKafkaStreamsState(ProcessId.randomProcessId(), 10, Utils.mkMap((Map.Entry[])new Map.Entry[0]), Utils.mkSortedSet((Comparable[])new TaskId[]{AssignmentTestUtils.NAMED_TASK_T0_0_0, AssignmentTestUtils.NAMED_TASK_T0_0_1}), Utils.mkSortedSet((Comparable[])new TaskId[0]), new TreeMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"c1", Set.of(AssignmentTestUtils.NAMED_TASK_T0_0_0, AssignmentTestUtils.NAMED_TASK_T0_0_1))})), Optional.empty(), Optional.empty(), Optional.empty());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> KafkaStreamsStateTest.lambda$shouldThrowExceptionOnLagOperationsIfLagsWereNotComputed$1((KafkaStreamsState)state));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> KafkaStreamsStateTest.lambda$shouldThrowExceptionOnLagOperationsIfLagsWereNotComputed$2((KafkaStreamsState)state));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((KafkaStreamsState)state).statefulTasksToLagSums());
    }

    private static /* synthetic */ void lambda$shouldThrowExceptionOnLagOperationsIfLagsWereNotComputed$2(KafkaStreamsState state) throws Throwable {
        state.prevTasksByLag("c1");
    }

    private static /* synthetic */ void lambda$shouldThrowExceptionOnLagOperationsIfLagsWereNotComputed$1(KafkaStreamsState state) throws Throwable {
        state.lagFor(AssignmentTestUtils.NAMED_TASK_T0_0_0);
    }

    private static /* synthetic */ void lambda$shouldCorrectlyReturnTasksByLag$0(KafkaStreamsState state) throws Throwable {
        state.lagFor(AssignmentTestUtils.NAMED_TASK_T0_1_0);
    }
}

