/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.ConstrainedPrioritySet;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignmentUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class StandbyTaskAssignmentUtilsTest {
    private static final Set<TaskId> ACTIVE_TASKS = Set.of(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
    private Map<ProcessId, ClientState> clients;
    private ConstrainedPrioritySet clientsByTaskLoad;

    @BeforeEach
    public void setup() {
        this.clients = AssignmentTestUtils.getClientStatesMap((ClientState[])ACTIVE_TASKS.stream().map(xva$0 -> StandbyTaskAssignmentUtilsTest.mkState(xva$0)).toArray(ClientState[]::new));
        this.clientsByTaskLoad = new ConstrainedPrioritySet((client, task) -> !this.clients.get(client).hasAssignedTask(task), client -> this.clients.get(client).assignedTaskLoad());
        this.clientsByTaskLoad.offerAll(this.clients.keySet());
    }

    @Test
    public void shouldReturnNumberOfStandbyTasksThatWereNotAssigned() {
        Logger logMock = (Logger)Mockito.mock(Logger.class);
        int numStandbyReplicas = 3;
        Map tasksToRemainingStandbys = StandbyTaskAssignmentUtils.computeTasksToRemainingStandbys((int)3, ACTIVE_TASKS);
        tasksToRemainingStandbys.keySet().forEach(taskId -> StandbyTaskAssignmentUtils.pollClientAndMaybeAssignAndUpdateRemainingStandbyTasks((int)3, this.clients, (Map)tasksToRemainingStandbys, (ConstrainedPrioritySet)this.clientsByTaskLoad, (TaskId)taskId, (Logger)logMock));
        Assertions.assertTrue((boolean)ACTIVE_TASKS.stream().allMatch(activeTask -> (Integer)tasksToRemainingStandbys.get(activeTask) == 1));
        Assertions.assertTrue((boolean)this.areStandbyTasksPresentForAllActiveTasks(2));
        ((Logger)Mockito.verify((Object)logMock, (VerificationMode)Mockito.times((int)ACTIVE_TASKS.size()))).warn(ArgumentMatchers.anyString(), new Object[]{ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.any()});
    }

    @Test
    public void shouldReturnZeroWhenAllStandbyTasksWereSuccessfullyAssigned() {
        Logger logMock = (Logger)Mockito.mock(Logger.class);
        boolean numStandbyReplicas = true;
        Map tasksToRemainingStandbys = StandbyTaskAssignmentUtils.computeTasksToRemainingStandbys((int)1, ACTIVE_TASKS);
        tasksToRemainingStandbys.keySet().forEach(taskId -> StandbyTaskAssignmentUtils.pollClientAndMaybeAssignAndUpdateRemainingStandbyTasks((int)1, this.clients, (Map)tasksToRemainingStandbys, (ConstrainedPrioritySet)this.clientsByTaskLoad, (TaskId)taskId, (Logger)logMock));
        Assertions.assertTrue((boolean)ACTIVE_TASKS.stream().allMatch(activeTask -> (Integer)tasksToRemainingStandbys.get(activeTask) == 0));
        Assertions.assertTrue((boolean)this.areStandbyTasksPresentForAllActiveTasks(1));
        Mockito.verifyNoInteractions((Object[])new Object[]{logMock});
    }

    @Test
    public void shouldComputeTasksToRemainingStandbys() {
        MatcherAssert.assertThat((Object)StandbyTaskAssignmentUtils.computeTasksToRemainingStandbys((int)0, ACTIVE_TASKS), (Matcher)CoreMatchers.equalTo(ACTIVE_TASKS.stream().collect(Collectors.toMap(Function.identity(), it -> 0))));
        MatcherAssert.assertThat((Object)StandbyTaskAssignmentUtils.computeTasksToRemainingStandbys((int)5, ACTIVE_TASKS), (Matcher)CoreMatchers.equalTo(ACTIVE_TASKS.stream().collect(Collectors.toMap(Function.identity(), it -> 5))));
    }

    private boolean areStandbyTasksPresentForAllActiveTasks(int expectedNumberOfStandbyTasks) {
        return ACTIVE_TASKS.stream().allMatch(taskId -> this.clients.values().stream().filter(client -> client.hasStandbyTask(taskId)).count() == (long)expectedNumberOfStandbyTasks);
    }

    private static ClientState mkState(TaskId ... activeTasks) {
        return StandbyTaskAssignmentUtilsTest.mkState(1, activeTasks);
    }

    private static ClientState mkState(int capacity, TaskId ... activeTasks) {
        ClientState clientState = new ClientState(capacity);
        for (TaskId activeTask : activeTasks) {
            clientState.assignActive(activeTask);
        }
        return clientState;
    }
}

