/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.tasks;

import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ReadOnlyTask;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TaskExecutionMetadata;
import org.apache.kafka.streams.processor.internals.TasksRegistry;
import org.apache.kafka.streams.processor.internals.tasks.DefaultTaskManager;
import org.apache.kafka.streams.processor.internals.tasks.TaskExecutor;
import org.apache.kafka.streams.processor.internals.tasks.TaskManager;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultTaskManagerTest {
    private static final long VERIFICATION_TIMEOUT = 15000L;
    private final Time time = new MockTime(1L);
    private final TaskId taskId = new TaskId(0, 0, "A");
    private final StreamTask task = StreamsTestUtils.TaskBuilder.statelessTask(this.taskId).build();
    private final TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
    private final TaskExecutor taskExecutor = (TaskExecutor)Mockito.mock(TaskExecutor.class);
    private final StreamsException exception = (StreamsException)((Object)Mockito.mock(StreamsException.class));
    private final TaskExecutionMetadata taskExecutionMetadata = (TaskExecutionMetadata)Mockito.mock(TaskExecutionMetadata.class);
    private final TaskManager taskManager = new DefaultTaskManager(this.time, "TaskManager", this.tasks, (taskManager, name, time, taskExecutionMetadata) -> this.taskExecutor, this.taskExecutionMetadata, 1);

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.task.isProcessable(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.task(this.taskId)).thenReturn((Object)this.task);
    }

    @Test
    public void shouldShutdownTaskExecutors() {
        Duration duration = (Duration)Mockito.mock(Duration.class);
        this.taskManager.shutdown(duration);
        ((TaskExecutor)Mockito.verify((Object)this.taskExecutor)).requestShutdown();
        ((TaskExecutor)Mockito.verify((Object)this.taskExecutor)).awaitShutdown(duration);
    }

    @Test
    public void shouldStartTaskExecutors() {
        this.taskManager.startTaskExecutors();
        ((TaskExecutor)Mockito.verify((Object)this.taskExecutor)).start();
    }

    @Test
    public void shouldAddTask() {
        this.taskManager.add(Collections.singleton(this.task));
        ((TasksRegistry)Mockito.verify((Object)this.tasks)).addTask((Task)this.task);
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Assertions.assertEquals((int)1, (int)this.taskManager.getTasks().size());
    }

    @Test
    public void shouldAssignTaskThatCanBeProcessed() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
        Assertions.assertNull((Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldBlockOnAwait() throws InterruptedException {
        AwaitingRunnable awaitingRunnable = new AwaitingRunnable();
        Thread awaitingThread = new Thread(awaitingRunnable);
        awaitingThread.start();
        Assertions.assertFalse((boolean)awaitingRunnable.awaitDone.await(100L, TimeUnit.MILLISECONDS));
        awaitingRunnable.shutdown();
    }

    @Test
    public void shouldReturnFromAwaitOnInterruption() throws InterruptedException {
        AwaitingRunnable awaitingRunnable = new AwaitingRunnable();
        Thread awaitingThread = new Thread(awaitingRunnable);
        awaitingThread.start();
        ((TasksRegistry)Mockito.verify((Object)this.tasks, (VerificationMode)Mockito.timeout((long)15000L).atLeastOnce())).activeTasks();
        awaitingThread.interrupt();
        Assertions.assertTrue((boolean)awaitingRunnable.awaitDone.await(15000L, TimeUnit.MILLISECONDS));
        awaitingRunnable.shutdown();
    }

    @Test
    public void shouldReturnFromAwaitOnSignalProcessableTasks() throws InterruptedException {
        AwaitingRunnable awaitingRunnable = new AwaitingRunnable();
        Thread awaitingThread = new Thread(awaitingRunnable);
        awaitingThread.start();
        ((TasksRegistry)Mockito.verify((Object)this.tasks, (VerificationMode)Mockito.timeout((long)15000L).atLeastOnce())).activeTasks();
        this.taskManager.signalTaskExecutors();
        Assertions.assertTrue((boolean)awaitingRunnable.awaitDone.await(15000L, TimeUnit.MILLISECONDS));
        awaitingRunnable.shutdown();
    }

    @Test
    public void shouldReturnFromAwaitOnUnassignment() throws InterruptedException {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        StreamTask task = this.taskManager.assignNextTask(this.taskExecutor);
        Assertions.assertNotNull((Object)task);
        AwaitingRunnable awaitingRunnable = new AwaitingRunnable();
        Thread awaitingThread = new Thread(awaitingRunnable);
        awaitingThread.start();
        ((TasksRegistry)Mockito.verify((Object)this.tasks, (VerificationMode)Mockito.timeout((long)15000L).atLeastOnce())).activeTasks();
        this.taskManager.unassignTask(task, this.taskExecutor);
        Assertions.assertTrue((boolean)awaitingRunnable.awaitDone.await(15000L, TimeUnit.MILLISECONDS));
        awaitingRunnable.shutdown();
    }

    @Test
    public void shouldReturnFromAwaitOnAdding() throws InterruptedException {
        AwaitingRunnable awaitingRunnable = new AwaitingRunnable();
        Thread awaitingThread = new Thread(awaitingRunnable);
        awaitingThread.start();
        ((TasksRegistry)Mockito.verify((Object)this.tasks, (VerificationMode)Mockito.timeout((long)15000L).atLeastOnce())).activeTasks();
        this.taskManager.add(Collections.singleton(this.task));
        Assertions.assertTrue((boolean)awaitingRunnable.awaitDone.await(15000L, TimeUnit.MILLISECONDS));
        awaitingRunnable.shutdown();
    }

    @Test
    public void shouldReturnFromAwaitOnUnlocking() throws InterruptedException {
        this.taskManager.add(Collections.singleton(this.task));
        this.taskManager.lockTasks(Collections.singleton(this.task.id()));
        AwaitingRunnable awaitingRunnable = new AwaitingRunnable();
        Thread awaitingThread = new Thread(awaitingRunnable);
        awaitingThread.start();
        ((TasksRegistry)Mockito.verify((Object)this.tasks, (VerificationMode)Mockito.timeout((long)15000L).atLeastOnce())).activeTasks();
        this.taskManager.unlockAllTasks();
        Assertions.assertTrue((boolean)awaitingRunnable.awaitDone.await(15000L, TimeUnit.MILLISECONDS));
        awaitingRunnable.shutdown();
    }

    @Test
    public void shouldAssignTasksThatCanBeSystemTimePunctuated() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Mockito.when((Object)this.task.canPunctuateSystemTime()).thenReturn((Object)true);
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
        Assertions.assertNull((Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldAssignTasksThatCanBeStreamTimePunctuated() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canPunctuateTask((Task)ArgumentMatchers.eq((Object)this.task))).thenReturn((Object)true);
        Mockito.when((Object)this.task.canPunctuateStreamTime()).thenReturn((Object)true);
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
        Assertions.assertNull((Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldNotAssignTasksIfUncaughtExceptionPresent() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        this.ensureTaskMakesProgress();
        this.taskManager.assignNextTask(this.taskExecutor);
        this.taskManager.setUncaughtException(new StreamsException("Exception"), this.taskId);
        this.taskManager.unassignTask(this.task, this.taskExecutor);
        Assertions.assertNull((Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldNotAssignTasksForPunctuationIfPunctuationDisabled() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canPunctuateTask((Task)ArgumentMatchers.eq((Object)this.task))).thenReturn((Object)false);
        Mockito.when((Object)this.task.canPunctuateStreamTime()).thenReturn((Object)true);
        Mockito.when((Object)this.task.canPunctuateSystemTime()).thenReturn((Object)true);
        Assertions.assertNull((Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldNotAssignTasksForProcessingIfProcessingDisabled() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)false);
        Mockito.when((Object)this.task.isProcessable(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Assertions.assertNull((Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldUnassignTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
        this.taskManager.unassignTask(this.task, this.taskExecutor);
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldNotUnassignNotOwnedTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
        TaskExecutor anotherExecutor = (TaskExecutor)Mockito.mock(TaskExecutor.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.taskManager.unassignTask(this.task, anotherExecutor));
    }

    @Test
    public void shouldNotRemoveUnlockedTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.taskManager.remove(this.task.id()));
    }

    @Test
    public void shouldNotRemoveAssignedTask() {
        this.taskManager.add(Collections.singleton(this.task));
        this.taskManager.assignNextTask(this.taskExecutor);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.taskManager.remove(this.task.id()));
    }

    @Test
    public void shouldRemoveTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.task(this.task.id())).thenReturn((Object)this.task);
        Mockito.when((Object)this.tasks.contains(this.task.id())).thenReturn((Object)true);
        this.taskManager.lockTasks(Collections.singleton(this.task.id()));
        this.taskManager.remove(this.task.id());
        ((TasksRegistry)Mockito.verify((Object)this.tasks)).removeTask((Task)this.task);
        Mockito.reset((Object[])new TasksRegistry[]{this.tasks});
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.emptySet());
        Assertions.assertEquals((int)0, (int)this.taskManager.getTasks().size());
    }

    @Test
    public void shouldNotAssignLockedTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Mockito.when((Object)this.tasks.task(this.task.id())).thenReturn((Object)this.task);
        Mockito.when((Object)this.tasks.contains(this.task.id())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.taskManager.lockTasks(Collections.singleton(this.task.id())).isDone());
        Assertions.assertNull((Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldLockAnEmptySetOfTasks() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Mockito.when((Object)this.tasks.task(this.task.id())).thenReturn((Object)this.task);
        Mockito.when((Object)this.tasks.contains(this.task.id())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.taskManager.lockTasks(Collections.emptySet()).isDone());
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldLockATaskThatWasVoluntarilyReleased() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Mockito.when((Object)this.tasks.task(this.task.id())).thenReturn((Object)this.task);
        Mockito.when((Object)this.tasks.contains(this.task.id())).thenReturn((Object)true);
        Mockito.when((Object)this.taskExecutor.unassign()).thenReturn((Object)future);
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
        KafkaFuture lockingFuture = this.taskManager.lockTasks(Collections.singleton(this.task.id()));
        Assertions.assertFalse((boolean)lockingFuture.isDone());
        this.taskManager.unassignTask(this.task, this.taskExecutor);
        future.complete(null);
        Assertions.assertTrue((boolean)lockingFuture.isDone());
        Assertions.assertNull((Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldNotAssignAnyLockedTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Mockito.when((Object)this.tasks.task(this.task.id())).thenReturn((Object)this.task);
        Mockito.when((Object)this.tasks.contains(this.task.id())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.taskManager.lockAllTasks().isDone());
        Assertions.assertNull((Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldNotSetUncaughtExceptionsForUnassignedTasks() {
        this.taskManager.add(Collections.singleton(this.task));
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.taskManager.setUncaughtException(this.exception, this.task.id()));
        Assertions.assertEquals((Object)"An uncaught exception can only be set as long as the task is still assigned", (Object)e.getMessage());
    }

    @Test
    public void shouldNotSetUncaughtExceptionsTwice() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.taskManager.assignNextTask(this.taskExecutor);
        this.taskManager.setUncaughtException(this.exception, this.task.id());
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.taskManager.setUncaughtException(this.exception, this.task.id()));
        Assertions.assertEquals((Object)"The uncaught exception must be cleared before restarting processing", (Object)e.getMessage());
    }

    @Test
    public void shouldReturnAndClearExceptionsOnDrainExceptions() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.taskManager.assignNextTask(this.taskExecutor);
        this.taskManager.setUncaughtException(this.exception, this.task.id());
        Assertions.assertEquals((Object)this.taskManager.drainUncaughtExceptions(), Collections.singletonMap(this.task.id(), this.exception));
        Assertions.assertEquals((Object)this.taskManager.drainUncaughtExceptions(), Collections.emptyMap());
    }

    @Test
    public void shouldUnassignLockingTask() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.task(this.task.id())).thenReturn((Object)this.task);
        Mockito.when((Object)this.tasks.contains(this.task.id())).thenReturn((Object)true);
        Mockito.when((Object)this.taskExecutor.unassign()).thenReturn((Object)future);
        Mockito.when((Object)this.taskExecutionMetadata.canProcessTask((Task)ArgumentMatchers.eq((Object)this.task), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
        Mockito.when((Object)this.taskExecutor.currentTask()).thenReturn((Object)new ReadOnlyTask((Task)this.task));
        KafkaFuture lockFuture = this.taskManager.lockAllTasks();
        Assertions.assertFalse((boolean)lockFuture.isDone());
        ((TaskExecutor)Mockito.verify((Object)this.taskExecutor)).unassign();
        this.taskManager.unassignTask(this.task, this.taskExecutor);
        future.complete((Object)this.task);
        Assertions.assertTrue((boolean)lockFuture.isDone());
    }

    private void ensureTaskMakesProgress() {
        Mockito.when((Object)this.taskExecutionMetadata.canPunctuateTask((Task)ArgumentMatchers.eq((Object)this.task))).thenReturn((Object)true);
        Mockito.when((Object)this.task.canPunctuateStreamTime()).thenReturn((Object)true);
    }

    private class AwaitingRunnable
    implements Runnable {
        private final CountDownLatch awaitDone = new CountDownLatch(1);
        private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);

        private AwaitingRunnable() {
        }

        @Override
        public void run() {
            while (!this.shutdownRequested.get()) {
                try {
                    DefaultTaskManagerTest.this.taskManager.awaitProcessableTasks(this.shutdownRequested::get);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.awaitDone.countDown();
            }
        }

        public void shutdown() {
            this.shutdownRequested.set(true);
            DefaultTaskManagerTest.this.taskManager.signalTaskExecutors();
        }
    }
}

