/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.query.Position;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PositionTest {
    @Test
    public void shouldCreateFromMap() {
        Map map = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"topic", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L)})), Utils.mkEntry((Object)"topic1", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L), Utils.mkEntry((Object)7, (Object)0L)}))});
        Position position = Position.fromMap((Map)map);
        MatcherAssert.assertThat((Object)position.getTopics(), (Matcher)Matchers.equalTo(Set.of("topic", "topic1")));
        MatcherAssert.assertThat((Object)position.getPartitionPositions("topic"), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L)})));
        ((Map)map.get("topic1")).put(99, 99L);
        MatcherAssert.assertThat((Object)position.getPartitionPositions("topic1"), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L), Utils.mkEntry((Object)7, (Object)0L)})));
    }

    @Test
    public void shouldCreateFromNullMap() {
        Position position = Position.fromMap(null);
        MatcherAssert.assertThat((Object)position.getTopics(), (Matcher)Matchers.equalTo(Collections.emptySet()));
    }

    @Test
    public void shouldMerge() {
        Position position = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"topic", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L)})), Utils.mkEntry((Object)"topic1", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L), Utils.mkEntry((Object)7, (Object)0L)}))}));
        Position position1 = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"topic", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)7L)})), Utils.mkEntry((Object)"topic1", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)8, (Object)1L)})), Utils.mkEntry((Object)"topic2", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)9, (Object)5L)}))}));
        Position merged = position.merge(position1);
        MatcherAssert.assertThat((Object)merged.getTopics(), (Matcher)Matchers.equalTo(Set.of("topic", "topic1", "topic2")));
        MatcherAssert.assertThat((Object)merged.getPartitionPositions("topic"), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)7L)})));
        MatcherAssert.assertThat((Object)merged.getPartitionPositions("topic1"), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L), Utils.mkEntry((Object)7, (Object)0L), Utils.mkEntry((Object)8, (Object)1L)})));
        MatcherAssert.assertThat((Object)merged.getPartitionPositions("topic2"), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)9, (Object)5L)})));
    }

    @Test
    public void shouldUpdateComponentMonotonically() {
        Position position = Position.emptyPosition();
        position.withComponent("topic", 3, 5L);
        position.withComponent("topic", 3, 4L);
        MatcherAssert.assertThat((Object)((Long)position.getPartitionPositions("topic").get(3)), (Matcher)Matchers.equalTo((Object)5L));
        position.withComponent("topic", 3, 6L);
        MatcherAssert.assertThat((Object)((Long)position.getPartitionPositions("topic").get(3)), (Matcher)Matchers.equalTo((Object)6L));
    }

    @Test
    public void shouldCopy() {
        Position position = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"topic", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L)})), Utils.mkEntry((Object)"topic1", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L), Utils.mkEntry((Object)7, (Object)0L)}))}));
        Position copy = position.copy();
        position.withComponent("topic", 0, 6L);
        position.withComponent("topic1", 8, 1L);
        position.withComponent("topic2", 2, 4L);
        MatcherAssert.assertThat((Object)copy.getTopics(), (Matcher)Matchers.equalTo(Set.of("topic", "topic1")));
        MatcherAssert.assertThat((Object)copy.getPartitionPositions("topic"), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L)})));
        MatcherAssert.assertThat((Object)copy.getPartitionPositions("topic1"), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L), Utils.mkEntry((Object)7, (Object)0L)})));
        MatcherAssert.assertThat((Object)position.getTopics(), (Matcher)Matchers.equalTo(Set.of("topic", "topic1", "topic2")));
        MatcherAssert.assertThat((Object)position.getPartitionPositions("topic"), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)6L)})));
        MatcherAssert.assertThat((Object)position.getPartitionPositions("topic1"), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L), Utils.mkEntry((Object)7, (Object)0L), Utils.mkEntry((Object)8, (Object)1L)})));
        MatcherAssert.assertThat((Object)position.getPartitionPositions("topic2"), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)2, (Object)4L)})));
    }

    @Test
    public void shouldMergeNull() {
        Position position = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"topic", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L)})), Utils.mkEntry((Object)"topic1", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L), Utils.mkEntry((Object)7, (Object)0L)}))}));
        Position merged = position.merge(null);
        MatcherAssert.assertThat((Object)merged.getTopics(), (Matcher)Matchers.equalTo(Set.of("topic", "topic1")));
        MatcherAssert.assertThat((Object)merged.getPartitionPositions("topic"), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L)})));
        MatcherAssert.assertThat((Object)merged.getPartitionPositions("topic1"), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)5L), Utils.mkEntry((Object)7, (Object)0L)})));
    }

    @Test
    public void shouldMatchOnEqual() {
        Position position1 = Position.emptyPosition();
        Position position2 = Position.emptyPosition();
        position1.withComponent("topic1", 0, 1L);
        position2.withComponent("topic1", 0, 1L);
        position1.withComponent("topic1", 1, 2L);
        position2.withComponent("topic1", 1, 2L);
        position1.withComponent("topic1", 2, 1L);
        position2.withComponent("topic1", 2, 1L);
        position1.withComponent("topic2", 0, 0L);
        position2.withComponent("topic2", 0, 0L);
        Assertions.assertEquals((Object)position1, (Object)position2);
    }

    @Test
    public void shouldNotMatchOnUnEqual() {
        Position position1 = Position.emptyPosition();
        Position position2 = Position.emptyPosition();
        position1.withComponent("topic1", 0, 1L);
        position2.withComponent("topic1", 0, 1L);
        position1.withComponent("topic1", 1, 2L);
        position1.withComponent("topic1", 2, 1L);
        position2.withComponent("topic1", 2, 1L);
        position1.withComponent("topic2", 0, 0L);
        position2.withComponent("topic2", 0, 0L);
        Assertions.assertNotEquals((Object)position1, (Object)position2);
    }

    @Test
    public void shouldNotMatchNull() {
        Position position = Position.emptyPosition();
        Assertions.assertNotEquals((Object)position, null);
    }

    @Test
    public void shouldMatchSelf() {
        Position position = Position.emptyPosition();
        Assertions.assertEquals((Object)position, (Object)position);
    }

    @Test
    public void shouldNotHash() {
        Position position = Position.emptyPosition();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((Position)position).hashCode());
        HashSet set = new HashSet();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.add(position));
        HashMap map = new HashMap();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put(position, 5));
    }
}

