/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.StateQueryResult;
import org.apache.kafka.streams.query.internals.SucceededQueryResult;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class StateQueryResultTest {
    StateQueryResult<String> stringStateQueryResult;
    final QueryResult<String> noResultsFound = new SucceededQueryResult(null);
    final QueryResult<String> validResult = new SucceededQueryResult((Object)"Foo");

    StateQueryResultTest() {
    }

    @BeforeEach
    public void setUp() {
        this.stringStateQueryResult = new StateQueryResult();
    }

    @Test
    void getOnlyPartitionResultNoResultsTest() {
        this.stringStateQueryResult.addResult(0, this.noResultsFound);
        QueryResult result = this.stringStateQueryResult.getOnlyPartitionResult();
        MatcherAssert.assertThat((String)"Zero query results shouldn't error", (Object)result, (Matcher)Matchers.nullValue());
    }

    @Test
    void getOnlyPartitionResultWithSingleResultTest() {
        this.stringStateQueryResult.addResult(0, this.validResult);
        QueryResult result = this.stringStateQueryResult.getOnlyPartitionResult();
        MatcherAssert.assertThat((String)"Valid query results still works", (Object)((String)result.getResult()), (Matcher)Matchers.is((Object)"Foo"));
    }

    @Test
    void getOnlyPartitionResultMultipleResults() {
        this.stringStateQueryResult.addResult(0, this.validResult);
        this.stringStateQueryResult.addResult(1, this.validResult);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.stringStateQueryResult.getOnlyPartitionResult(), (String)"More than one query result throws IllegalArgumentException");
    }
}

