/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.util.Collection;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.StreamsMetadata;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.internals.StreamsMetadataImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StreamsMetadataTest {
    private static final HostInfo HOST_INFO = new HostInfo("local", 12);
    public static final Set<String> STATE_STORE_NAMES = Set.of("store1", "store2");
    private static final TopicPartition TP_0 = new TopicPartition("t", 0);
    private static final TopicPartition TP_1 = new TopicPartition("t", 1);
    public static final Set<TopicPartition> TOPIC_PARTITIONS = Set.of(TP_0, TP_1);
    public static final Set<String> STAND_BY_STORE_NAMES = Set.of("store2");
    public static final Set<TopicPartition> STANDBY_TOPIC_PARTITIONS = Set.of(TP_1);
    private StreamsMetadata streamsMetadata;

    @BeforeEach
    public void setUp() {
        this.streamsMetadata = new StreamsMetadataImpl(HOST_INFO, STATE_STORE_NAMES, TOPIC_PARTITIONS, STAND_BY_STORE_NAMES, STANDBY_TOPIC_PARTITIONS);
    }

    @Test
    public void shouldNotAllowModificationOfInternalStateViaGetters() {
        MatcherAssert.assertThat((Object)StreamsMetadataTest.isUnmodifiable(this.streamsMetadata.stateStoreNames()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)StreamsMetadataTest.isUnmodifiable(this.streamsMetadata.topicPartitions()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)StreamsMetadataTest.isUnmodifiable(this.streamsMetadata.standbyTopicPartitions()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)StreamsMetadataTest.isUnmodifiable(this.streamsMetadata.standbyStateStoreNames()), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldBeEqualsIfSameObject() {
        StreamsMetadataImpl same = new StreamsMetadataImpl(HOST_INFO, STATE_STORE_NAMES, TOPIC_PARTITIONS, STAND_BY_STORE_NAMES, STANDBY_TOPIC_PARTITIONS);
        MatcherAssert.assertThat((Object)this.streamsMetadata, (Matcher)Matchers.equalTo((Object)same));
        MatcherAssert.assertThat((Object)this.streamsMetadata.hashCode(), (Matcher)Matchers.equalTo((Object)same.hashCode()));
    }

    @Test
    public void shouldNotBeEqualIfDifferInHostInfo() {
        StreamsMetadataImpl differHostInfo = new StreamsMetadataImpl(new HostInfo("different", 122), STATE_STORE_NAMES, TOPIC_PARTITIONS, STAND_BY_STORE_NAMES, STANDBY_TOPIC_PARTITIONS);
        MatcherAssert.assertThat((Object)this.streamsMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differHostInfo)));
        MatcherAssert.assertThat((Object)this.streamsMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differHostInfo.hashCode())));
    }

    @Test
    public void shouldNotBeEqualIfDifferStateStoreNames() {
        StreamsMetadataImpl differStateStoreNames = new StreamsMetadataImpl(HOST_INFO, Set.of("store1"), TOPIC_PARTITIONS, STAND_BY_STORE_NAMES, STANDBY_TOPIC_PARTITIONS);
        MatcherAssert.assertThat((Object)this.streamsMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differStateStoreNames)));
        MatcherAssert.assertThat((Object)this.streamsMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differStateStoreNames.hashCode())));
    }

    @Test
    public void shouldNotBeEqualIfDifferInTopicPartitions() {
        StreamsMetadataImpl differTopicPartitions = new StreamsMetadataImpl(HOST_INFO, STATE_STORE_NAMES, Set.of(TP_0), STAND_BY_STORE_NAMES, STANDBY_TOPIC_PARTITIONS);
        MatcherAssert.assertThat((Object)this.streamsMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differTopicPartitions)));
        MatcherAssert.assertThat((Object)this.streamsMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differTopicPartitions.hashCode())));
    }

    @Test
    public void shouldNotBeEqualIfDifferInStandByStores() {
        StreamsMetadataImpl differStandByStores = new StreamsMetadataImpl(HOST_INFO, STATE_STORE_NAMES, TOPIC_PARTITIONS, Set.of("store1"), STANDBY_TOPIC_PARTITIONS);
        MatcherAssert.assertThat((Object)this.streamsMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differStandByStores)));
        MatcherAssert.assertThat((Object)this.streamsMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differStandByStores.hashCode())));
    }

    @Test
    public void shouldNotBeEqualIfDifferInStandByTopicPartitions() {
        StreamsMetadataImpl differStandByTopicPartitions = new StreamsMetadataImpl(HOST_INFO, STATE_STORE_NAMES, TOPIC_PARTITIONS, STAND_BY_STORE_NAMES, Set.of(TP_0));
        MatcherAssert.assertThat((Object)this.streamsMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differStandByTopicPartitions)));
        MatcherAssert.assertThat((Object)this.streamsMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differStandByTopicPartitions.hashCode())));
    }

    private static boolean isUnmodifiable(Collection<?> collection) {
        try {
            collection.clear();
            return false;
        }
        catch (UnsupportedOperationException e) {
            return true;
        }
    }
}

