/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SimpleTimeZone;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.processor.internals.ChangelogRecordDeserializationHelper;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.AbstractDualSchemaRocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.AbstractSegments;
import org.apache.kafka.streams.state.internals.KeyValueSegment;
import org.apache.kafka.streams.state.internals.KeyValueSegments;
import org.apache.kafka.streams.state.internals.PositionSerde;
import org.apache.kafka.streams.state.internals.PrefixedSessionKeySchemas;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedSessionSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.rocksdb.WriteBatch;

public abstract class AbstractDualSchemaRocksDBSegmentedBytesStoreTest {
    private static final String METRICS_SCOPE = "metrics-scope";
    private long windowSizeForTimeWindow = 500L;
    private InternalMockProcessorContext<?, ?> context;
    private AbstractDualSchemaRocksDBSegmentedBytesStore<KeyValueSegment> bytesStore;
    private File stateDir;
    private final Window[] windows = new Window[4];
    private Window nextSegmentWindow;
    private Window startEdgeWindow;
    private Window endEdgeWindow;
    private final long startEdgeTime = 9223372036854775107L;
    private final long endEdgeTime = 9223372036854775207L;
    final long retention = 1000L;
    final long segmentInterval = 60000L;
    final String storeName = "bytes-store";

    abstract SchemaType schemaType();

    @BeforeEach
    public void before() {
        if (this.getBaseSchema() instanceof PrefixedSessionKeySchemas.TimeFirstSessionKeySchema) {
            this.windows[0] = new SessionWindow(10L, 10L);
            this.windows[1] = new SessionWindow(500L, 1000L);
            this.windows[2] = new SessionWindow(1000L, 1500L);
            this.windows[3] = new SessionWindow(30000L, 60000L);
            this.nextSegmentWindow = new SessionWindow(61000L, 61000L);
            this.startEdgeWindow = new SessionWindow(0L, 9223372036854775107L);
            this.endEdgeWindow = new SessionWindow(9223372036854775207L, Long.MAX_VALUE);
        }
        if (this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema) {
            this.windows[0] = WindowKeySchema.timeWindowForSize((long)10L, (long)this.windowSizeForTimeWindow);
            this.windows[1] = WindowKeySchema.timeWindowForSize((long)500L, (long)this.windowSizeForTimeWindow);
            this.windows[2] = WindowKeySchema.timeWindowForSize((long)1000L, (long)this.windowSizeForTimeWindow);
            this.windows[3] = WindowKeySchema.timeWindowForSize((long)60000L, (long)this.windowSizeForTimeWindow);
            this.nextSegmentWindow = WindowKeySchema.timeWindowForSize((long)61000L, (long)this.windowSizeForTimeWindow);
            this.startEdgeWindow = WindowKeySchema.timeWindowForSize((long)9223372036854775107L, (long)this.windowSizeForTimeWindow);
            this.endEdgeWindow = WindowKeySchema.timeWindowForSize((long)9223372036854775207L, (long)this.windowSizeForTimeWindow);
        }
        this.bytesStore = this.getBytesStore();
        this.stateDir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(this.stateDir, Serdes.String(), Serdes.Long(), new MockRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        this.bytesStore.init(this.context, this.bytesStore);
    }

    @AfterEach
    public void close() {
        this.bytesStore.close();
    }

    AbstractDualSchemaRocksDBSegmentedBytesStore<KeyValueSegment> getBytesStore() {
        switch (this.schemaType().ordinal()) {
            case 0: {
                return new RocksDBTimeOrderedWindowSegmentedBytesStore("bytes-store", METRICS_SCOPE, 1000L, 60000L, true);
            }
            case 1: {
                return new RocksDBTimeOrderedWindowSegmentedBytesStore("bytes-store", METRICS_SCOPE, 1000L, 60000L, false);
            }
            case 2: {
                return new RocksDBTimeOrderedSessionSegmentedBytesStore("bytes-store", METRICS_SCOPE, 1000L, 60000L, true);
            }
            case 3: {
                return new RocksDBTimeOrderedSessionSegmentedBytesStore("bytes-store", METRICS_SCOPE, 1000L, 60000L, false);
            }
        }
        throw new IllegalStateException("Unknown SchemaType: " + String.valueOf((Object)this.schemaType()));
    }

    AbstractSegments<KeyValueSegment> newSegments() {
        return new KeyValueSegments("bytes-store", METRICS_SCOPE, 1000L, 60000L);
    }

    SegmentedBytesStore.KeySchema getBaseSchema() {
        switch (this.schemaType().ordinal()) {
            case 0: 
            case 1: {
                return new PrefixedWindowKeySchemas.TimeFirstWindowKeySchema();
            }
            case 2: 
            case 3: {
                return new PrefixedSessionKeySchemas.TimeFirstSessionKeySchema();
            }
        }
        throw new IllegalStateException("Unknown SchemaType: " + String.valueOf((Object)this.schemaType()));
    }

    SegmentedBytesStore.KeySchema getIndexSchema() {
        switch (this.schemaType().ordinal()) {
            case 0: {
                return new PrefixedWindowKeySchemas.KeyFirstWindowKeySchema();
            }
            case 2: {
                return new PrefixedSessionKeySchemas.KeyFirstSessionKeySchema();
            }
        }
        return null;
    }

    @Test
    public void shouldPutAndFetch() {
        String keyA = "a";
        String keyB = "b";
        String keyC = "c";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(10L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[2])), this.serializeValue(100L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"c", this.windows[3])), this.serializeValue(200L));
        Assertions.assertEquals(Collections.emptyList(), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, this.windows[2].start())));
        Assertions.assertEquals(Collections.emptyList(), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 0L, this.windows[2].start())));
        Assertions.assertEquals(Collections.emptyList(), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(null, Bytes.wrap((byte[])"b".getBytes()), 0L, this.windows[2].start())));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"c", this.windows[3]), (Object)200L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"b".getBytes()), null, 0L, this.windows[3].start())));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"c", this.windows[3]), (Object)200L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(null, null, 0L, this.windows[3].start())));
    }

    @Test
    public void shouldPutAndBackwardFetch() {
        String keyA = "a";
        String keyB = "b";
        String keyC = "c";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(10L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[2])), this.serializeValue(100L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"c", this.windows[3])), this.serializeValue(200L));
        Assertions.assertEquals(Collections.emptyList(), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), 0L, this.windows[2].start())));
        Assertions.assertEquals(Collections.emptyList(), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 0L, this.windows[2].start())));
        Assertions.assertEquals(Collections.emptyList(), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(null, Bytes.wrap((byte[])"b".getBytes()), 0L, this.windows[2].start())));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"c", this.windows[3]), (Object)200L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"b".getBytes()), null, 0L, this.windows[3].start())));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"c", this.windows[3]), (Object)200L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(null, null, 0L, this.windows[3].start())));
    }

    @Test
    public void shouldPutAndFetchEdgeSingleKey() {
        String keyA = "a";
        String keyB = "b";
        Bytes serializedKeyAStart = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyAEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.endEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBStart = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.endEdgeWindow), false, Integer.MAX_VALUE);
        this.bytesStore.put(serializedKeyAStart, this.serializeValue(10L));
        this.bytesStore.put(serializedKeyAEnd, this.serializeValue(50L));
        this.bytesStore.put(serializedKeyBStart, this.serializeValue(100L));
        this.bytesStore.put(serializedKeyBEnd, this.serializeValue(150L));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 9223372036854775107L, 9223372036854775207L)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"b".getBytes()), 9223372036854775107L, 9223372036854775207L)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, Long.MAX_VALUE)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"b".getBytes()), 0L, Long.MAX_VALUE)));
    }

    @Test
    public void shouldPutAndFetchEdgeKeyRange() {
        String keyA = "a";
        String keyB = "b";
        Bytes serializedKeyAStart = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyAEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.endEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBStart = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.endEdgeWindow), false, Integer.MAX_VALUE);
        this.bytesStore.put(serializedKeyAStart, this.serializeValue(10L));
        this.bytesStore.put(serializedKeyAEnd, this.serializeValue(50L));
        this.bytesStore.put(serializedKeyBStart, this.serializeValue(100L));
        this.bytesStore.put(serializedKeyBEnd, this.serializeValue(150L));
        List<KeyValue> expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L));
        Assertions.assertEquals(expected, this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 9223372036854775107L, 9223372036854775207L)));
        expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L));
        Assertions.assertEquals(expected, this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 0L, Long.MAX_VALUE)));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(null, Bytes.wrap((byte[])"a".getBytes()), 9223372036854775107L, 9223372036854775206L)));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"b".getBytes()), null, 9223372036854775108L, 9223372036854775207L)));
        expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L));
        Assertions.assertEquals(expected, this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(null, null, 0L, Long.MAX_VALUE)));
        expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L));
        Assertions.assertEquals(expected, this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(null, null, 9223372036854775107L, 9223372036854775207L)));
    }

    @Test
    public void shouldPutAndBackwardFetchEdgeSingleKey() {
        String keyA = "a";
        String keyB = "b";
        Bytes serializedKeyAStart = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyAEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.endEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBStart = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.endEdgeWindow), false, Integer.MAX_VALUE);
        this.bytesStore.put(serializedKeyAStart, this.serializeValue(10L));
        this.bytesStore.put(serializedKeyAEnd, this.serializeValue(50L));
        this.bytesStore.put(serializedKeyBStart, this.serializeValue(100L));
        this.bytesStore.put(serializedKeyBEnd, this.serializeValue(150L));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), 9223372036854775107L, 9223372036854775207L)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"b".getBytes()), 9223372036854775107L, 9223372036854775207L)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), 0L, Long.MAX_VALUE)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"b".getBytes()), 0L, Long.MAX_VALUE)));
    }

    @Test
    public void shouldPutAndBackwardFetchEdgeKeyRange() {
        String keyA = "a";
        String keyB = "b";
        Bytes serializedKeyAStart = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyAEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.endEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBStart = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.endEdgeWindow), false, Integer.MAX_VALUE);
        this.bytesStore.put(serializedKeyAStart, this.serializeValue(10L));
        this.bytesStore.put(serializedKeyAEnd, this.serializeValue(50L));
        this.bytesStore.put(serializedKeyBStart, this.serializeValue(100L));
        this.bytesStore.put(serializedKeyBEnd, this.serializeValue(150L));
        List<KeyValue> expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L));
        Assertions.assertEquals(expected, this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 9223372036854775107L, 9223372036854775207L)));
        expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L));
        Assertions.assertEquals(expected, this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 0L, Long.MAX_VALUE)));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(null, Bytes.wrap((byte[])"a".getBytes()), 9223372036854775107L, 9223372036854775206L)));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"b".getBytes()), null, 9223372036854775108L, 9223372036854775207L)));
        expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L));
        Assertions.assertEquals(expected, this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(null, null, 0L, Long.MAX_VALUE)));
        expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L));
        Assertions.assertEquals(expected, this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(null, null, 9223372036854775107L, 9223372036854775207L)));
    }

    @Test
    public void shouldPutAndFetchWithPrefixKey() {
        if (!(this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema)) {
            return;
        }
        String keyA = "a";
        String keyB = "aa";
        String keyC = "aaa";
        this.windowSizeForTimeWindow = 1L;
        TimeWindow maxWindow = new TimeWindow(0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE);
        Bytes serializedKeyA = this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)maxWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyB = this.serializeKey((Windowed<String>)new Windowed((Object)"aa", (Window)maxWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyC = this.serializeKey((Windowed<String>)new Windowed((Object)"aaa", (Window)maxWindow), false, Integer.MAX_VALUE);
        Assertions.assertTrue((serializedKeyA.compareTo(serializedKeyB) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((serializedKeyB.compareTo(serializedKeyC) > 0 ? 1 : 0) != 0);
        this.bytesStore.put(serializedKeyA, this.serializeValue(10L));
        this.bytesStore.put(serializedKeyB, this.serializeValue(50L));
        this.bytesStore.put(serializedKeyC, this.serializeValue(100L));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, Long.MAX_VALUE)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"aa".getBytes()), 0L, Long.MAX_VALUE)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(null, Bytes.wrap((byte[])"aa".getBytes()), 0L, Long.MAX_VALUE)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"aaa", (Window)maxWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"aa".getBytes()), null, 0L, Long.MAX_VALUE)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"aaa", (Window)maxWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(null, null, 0L, Long.MAX_VALUE)));
    }

    @Test
    public void shouldPutAndBackwardFetchWithPrefix() {
        if (!(this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema)) {
            return;
        }
        String keyA = "a";
        String keyB = "aa";
        String keyC = "aaa";
        this.windowSizeForTimeWindow = 1L;
        TimeWindow maxWindow = new TimeWindow(0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE);
        Bytes serializedKeyA = this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)maxWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyB = this.serializeKey((Windowed<String>)new Windowed((Object)"aa", (Window)maxWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyC = this.serializeKey((Windowed<String>)new Windowed((Object)"aaa", (Window)maxWindow), false, Integer.MAX_VALUE);
        Assertions.assertTrue((serializedKeyA.compareTo(serializedKeyB) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((serializedKeyB.compareTo(serializedKeyC) > 0 ? 1 : 0) != 0);
        this.bytesStore.put(serializedKeyA, this.serializeValue(10L));
        this.bytesStore.put(serializedKeyB, this.serializeValue(50L));
        this.bytesStore.put(serializedKeyC, this.serializeValue(100L));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), 0L, Long.MAX_VALUE)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"aa".getBytes()), 0L, Long.MAX_VALUE)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(null, Bytes.wrap((byte[])"aa".getBytes()), 0L, Long.MAX_VALUE)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"aaa", (Window)maxWindow), (Object)100L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(Bytes.wrap((byte[])"aa".getBytes()), null, 0L, Long.MAX_VALUE)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"aaa", (Window)maxWindow), (Object)100L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardFetch(null, null, 0L, Long.MAX_VALUE)));
    }

    @Test
    public void shouldFetchSessionForSingleKey() {
        if (!(this.getBaseSchema() instanceof PrefixedSessionKeySchemas.TimeFirstSessionKeySchema)) {
            return;
        }
        String keyA = "a";
        String keyB = "b";
        String keyC = "c";
        StateSerdes stateSerdes = StateSerdes.withBuiltinTypes((String)"dummy", String.class, Long.class);
        Bytes key1 = Bytes.wrap((byte[])stateSerdes.keySerializer().serialize("dummy", (Object)"a"));
        Bytes key2 = Bytes.wrap((byte[])stateSerdes.keySerializer().serialize("dummy", (Object)"b"));
        Bytes key3 = Bytes.wrap((byte[])stateSerdes.keySerializer().serialize("dummy", (Object)"c"));
        byte[] expectedValue1 = this.serializeValue(10L);
        byte[] expectedValue2 = this.serializeValue(50L);
        byte[] expectedValue3 = this.serializeValue(100L);
        byte[] expectedValue4 = this.serializeValue(200L);
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), expectedValue1);
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), expectedValue2);
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[2])), expectedValue3);
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"c", this.windows[3])), expectedValue4);
        byte[] value1 = ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.bytesStore).fetchSession(key1, this.windows[0].start(), this.windows[0].end());
        Assertions.assertNull((Object)value1);
        byte[] value2 = ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.bytesStore).fetchSession(key1, this.windows[1].start(), this.windows[1].end());
        Assertions.assertNull((Object)value2);
        byte[] value3 = ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.bytesStore).fetchSession(key2, this.windows[2].start(), this.windows[2].end());
        Assertions.assertNull((Object)value3);
        byte[] value4 = ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.bytesStore).fetchSession(key3, this.windows[3].start(), this.windows[3].end());
        Assertions.assertEquals((Object)Bytes.wrap((byte[])value4), (Object)Bytes.wrap((byte[])expectedValue4));
        byte[] noValue = ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.bytesStore).fetchSession(key3, 2000L, 3000L);
        Assertions.assertNull((Object)noValue);
    }

    @Test
    public void shouldFetchSessionForTimeRange() {
        if (!(this.getBaseSchema() instanceof PrefixedSessionKeySchemas.TimeFirstSessionKeySchema)) {
            return;
        }
        String keyA = "a";
        String keyB = "b";
        String keyC = "c";
        Window[] sessionWindows = new Window[4];
        sessionWindows[0] = new SessionWindow(100L, 100L);
        sessionWindows[1] = new SessionWindow(50L, 200L);
        sessionWindows[2] = new SessionWindow(200L, 300L);
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", sessionWindows[0])), this.serializeValue(10L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"b", sessionWindows[1])), this.serializeValue(100L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"c", sessionWindows[2])), this.serializeValue(200L));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"a", sessionWindows[0]), (Object)10L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)((RocksDBTimeOrderedSessionSegmentedBytesStore)this.bytesStore).fetchSessions(100L, 100L)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", sessionWindows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", sessionWindows[1]), (Object)100L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)((RocksDBTimeOrderedSessionSegmentedBytesStore)this.bytesStore).fetchSessions(100L, 200L)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", sessionWindows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", sessionWindows[1]), (Object)100L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)((RocksDBTimeOrderedSessionSegmentedBytesStore)this.bytesStore).fetchSessions(99L, 201L)));
        try (KeyValueIterator values = ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.bytesStore).fetchSessions(101L, 199L);){
            Assertions.assertTrue((boolean)this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)values).isEmpty());
        }
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", sessionWindows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", sessionWindows[1]), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"c", sessionWindows[2]), (Object)200L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)((RocksDBTimeOrderedSessionSegmentedBytesStore)this.bytesStore).fetchSessions(100L, 300L)));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", sessionWindows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", sessionWindows[1]), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"c", sessionWindows[2]), (Object)200L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)((RocksDBTimeOrderedSessionSegmentedBytesStore)this.bytesStore).fetchSessions(99L, 301L)));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"b", sessionWindows[1]), (Object)100L)), this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)((RocksDBTimeOrderedSessionSegmentedBytesStore)this.bytesStore).fetchSessions(101L, 299L)));
    }

    @Test
    public void shouldSkipAndRemoveDanglingIndex() {
        String keyA = "a";
        String keyB = "b";
        if (this.getIndexSchema() == null) {
            Assertions.assertThrows(IllegalStateException.class, () -> this.bytesStore.putIndex(Bytes.wrap((byte[])"a".getBytes()), new byte[0]));
        } else {
            Bytes serializedKey1 = this.serializeKeyForIndex((Windowed<String>)new Windowed((Object)"a", this.windows[1]));
            this.bytesStore.putIndex(serializedKey1, new byte[0]);
            byte[] value = this.bytesStore.getIndex(serializedKey1);
            MatcherAssert.assertThat((Object)Bytes.wrap((byte[])value), (Matcher)CoreMatchers.is((Object)Bytes.wrap((byte[])new byte[0])));
            Bytes serializedKey0 = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]));
            this.bytesStore.put(serializedKey0, this.serializeValue(10L));
            Bytes serializedKey2 = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[2]));
            this.bytesStore.put(serializedKey2, this.serializeValue(20L));
            List<KeyValue> expected = this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", this.windows[2]), (Object)20L)) : Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"b", this.windows[2]), (Object)20L));
            Assertions.assertEquals(expected, this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 1L, 2000L)));
            value = this.bytesStore.getIndex(serializedKey1);
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
    }

    @Test
    public void shouldFindValuesWithinRange() {
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(10L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2])), this.serializeValue(100L));
        List<KeyValue> expected = this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L)) : Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L));
        Assertions.assertEquals(expected, this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 1L, 999L)));
    }

    @Test
    public void shouldRemove() {
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(30L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.bytesStore.remove(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])));
        try (KeyValueIterator value = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 100L);){
            Assertions.assertFalse((boolean)value.hasNext());
        }
        if (this.getIndexSchema() != null) {
            Bytes indexKey = this.serializeKeyForIndex((Windowed<String>)new Windowed((Object)"a", this.windows[0]));
            byte[] value = this.bytesStore.getIndex(indexKey);
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
    }

    @Test
    public void shouldRollSegments() {
        AbstractSegments<KeyValueSegment> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(100L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2])), this.serializeValue(500L));
        Assertions.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(1000L));
        Assertions.assertEquals(Set.of(segments.segmentName(0L), segments.segmentName(1L)), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 1500L));
        Assertions.assertEquals(Collections.emptyList(), results);
        List<KeyValue<Windowed<String>, Long>> results1 = this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 59000L, 60000L));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[3]), (Object)1000L)), results1);
        segments.close();
    }

    @Test
    public void shouldGetAllSegments() {
        AbstractSegments<KeyValueSegment> segments = this.newSegments();
        String keyA = "a";
        String keyB = "b";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        Assertions.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[3])), this.serializeValue(100L));
        Assertions.assertEquals(Set.of(segments.segmentName(0L), segments.segmentName(1L)), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"b", this.windows[3]), (Object)100L)), results);
        segments.close();
    }

    @Test
    public void shouldGetAllBackwards() {
        AbstractSegments<KeyValueSegment> segments = this.newSegments();
        String keyA = "a";
        String keyB = "b";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        Assertions.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[3])), this.serializeValue(100L));
        Assertions.assertEquals(Set.of(segments.segmentName(0L), segments.segmentName(1L)), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardAll());
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"b", this.windows[3]), (Object)100L)), results);
        segments.close();
    }

    @Test
    public void shouldFetchAllSegments() {
        AbstractSegments<KeyValueSegment> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        Assertions.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(100L));
        Assertions.assertEquals(Set.of(segments.segmentName(0L), segments.segmentName(1L)), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetchAll(0L, 60000L));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L)), results);
        segments.close();
    }

    @Test
    public void shouldLoadSegmentsWithOldStyleDateFormattedName() {
        AbstractSegments<KeyValueSegment> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(100L));
        this.bytesStore.close();
        String firstSegmentName = segments.segmentName(0L);
        String[] nameParts = firstSegmentName.split("\\.");
        long segmentId = Long.parseLong(nameParts[1]);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        formatter.setTimeZone(new SimpleTimeZone(0, "UTC"));
        String formatted = formatter.format(new Date(segmentId * 60000L));
        File parent = new File(this.stateDir, "bytes-store");
        File oldStyleName = new File(parent, nameParts[0] + "-" + formatted);
        Assertions.assertTrue((boolean)new File(parent, firstSegmentName).renameTo(oldStyleName));
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init(this.context, this.bytesStore);
        List<KeyValue<Windowed<String>, Long>> results = this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 60000L));
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L))));
        segments.close();
    }

    @Test
    public void shouldLoadSegmentsWithOldStyleColonFormattedName() {
        AbstractSegments<KeyValueSegment> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(100L));
        this.bytesStore.close();
        String firstSegmentName = segments.segmentName(0L);
        String[] nameParts = firstSegmentName.split("\\.");
        File parent = new File(this.stateDir, "bytes-store");
        File oldStyleName = new File(parent, nameParts[0] + ":" + Long.parseLong(nameParts[1]));
        Assertions.assertTrue((boolean)new File(parent, firstSegmentName).renameTo(oldStyleName));
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init(this.context, this.bytesStore);
        List<KeyValue<Windowed<String>, Long>> results = this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 60000L));
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L))));
        segments.close();
    }

    @Test
    public void shouldBeAbleToWriteToReInitializedStore() {
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.close();
        this.bytesStore.init(this.context, this.bytesStore);
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(100L));
    }

    @Test
    public void shouldCreateWriteBatches() {
        String key = "a";
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        records.add(new ConsumerRecord("", 0, 0L, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]), true).get(), (Object)this.serializeValue(50L)));
        records.add(new ConsumerRecord("", 0, 0L, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3]), true).get(), (Object)this.serializeValue(100L)));
        Map writeBatchMap = this.bytesStore.getWriteBatches(records);
        Assertions.assertEquals((int)2, (int)writeBatchMap.size());
        int expectedCount = this.getIndexSchema() == null ? 1 : 2;
        for (WriteBatch batch : writeBatchMap.values()) {
            Assertions.assertEquals((int)expectedCount, (int)batch.count());
        }
    }

    @Test
    public void shouldRestoreToByteStoreForActiveTask() {
        this.shouldRestoreToByteStore();
    }

    @Test
    public void shouldRestoreToByteStoreForStandbyTask() {
        this.context.transitionToStandby(null);
        this.shouldRestoreToByteStore();
    }

    private void shouldRestoreToByteStore() {
        this.bytesStore.init(this.context, this.bytesStore);
        Assertions.assertEquals((int)0, (int)this.bytesStore.getSegments().size());
        String key = "a";
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        records.add(new ConsumerRecord("", 0, 0L, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]), true).get(), (Object)this.serializeValue(50L)));
        records.add(new ConsumerRecord("", 0, 0L, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3]), true).get(), (Object)this.serializeValue(100L)));
        this.bytesStore.restoreAllInternal(records);
        Assertions.assertEquals((int)2, (int)this.bytesStore.getSegments().size());
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L));
        List<KeyValue<Windowed<String>, Long>> results = this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assertions.assertEquals(expected, results);
    }

    @Test
    public void shouldMatchPositionAfterPut() {
        this.bytesStore.init(this.context, this.bytesStore);
        String keyA = "a";
        String keyB = "b";
        String keyC = "c";
        this.context.setRecordContext(new ProcessorRecordContext(0L, 1L, 0, "", (Headers)new RecordHeaders()));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(10L));
        this.context.setRecordContext(new ProcessorRecordContext(0L, 2L, 0, "", (Headers)new RecordHeaders()));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.context.setRecordContext(new ProcessorRecordContext(0L, 3L, 0, "", (Headers)new RecordHeaders()));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[2])), this.serializeValue(100L));
        this.context.setRecordContext(new ProcessorRecordContext(0L, 4L, 0, "", (Headers)new RecordHeaders()));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"c", this.windows[3])), this.serializeValue(200L));
        Position expected = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)4L)}))}));
        Position actual = this.bytesStore.getPosition();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldRestoreRecordsAndConsistencyVectorSingleTopic() {
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("__iq.consistency.offset.vector.enabled__", (Object)true);
        File dir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(dir, Serdes.String(), Serdes.String(), new StreamsMetricsImpl(new Metrics(), "mock", "processId", (Time)new MockTime()), new StreamsConfig((Map)props), MockRecordCollector::new, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())), Time.SYSTEM);
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init(this.context, this.bytesStore);
        Assertions.assertEquals((int)0, (int)this.bytesStore.getSegments().size());
        this.bytesStore.restoreAllInternal(this.getChangelogRecords());
        Assertions.assertEquals((int)2, (int)this.bytesStore.getSegments().size());
        String key = "a";
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[3]), (Object)200L));
        List<KeyValue<Windowed<String>, Long>> results = this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assertions.assertEquals(expected, results);
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions(""), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions(""), (Matcher)Matchers.hasEntry((Object)0, (Object)3L));
    }

    @Test
    public void shouldRestoreRecordsAndConsistencyVectorMultipleTopics() {
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("__iq.consistency.offset.vector.enabled__", (Object)true);
        File dir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(dir, Serdes.String(), Serdes.String(), new StreamsMetricsImpl(new Metrics(), "mock", "processId", (Time)new MockTime()), new StreamsConfig((Map)props), MockRecordCollector::new, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())), Time.SYSTEM);
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init(this.context, this.bytesStore);
        Assertions.assertEquals((int)0, (int)this.bytesStore.getSegments().size());
        this.bytesStore.restoreAllInternal(this.getChangelogRecordsMultipleTopics());
        Assertions.assertEquals((int)2, (int)this.bytesStore.getSegments().size());
        String key = "a";
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[3]), (Object)200L));
        List<KeyValue<Windowed<String>, Long>> results = this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assertions.assertEquals(expected, results);
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions("A"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions("A"), (Matcher)Matchers.hasEntry((Object)0, (Object)3L));
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions("B"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions("B"), (Matcher)Matchers.hasEntry((Object)0, (Object)2L));
    }

    @Test
    public void shouldHandleTombstoneRecords() {
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("__iq.consistency.offset.vector.enabled__", (Object)true);
        File dir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(dir, Serdes.String(), Serdes.String(), new StreamsMetricsImpl(new Metrics(), "mock", "processId", (Time)new MockTime()), new StreamsConfig((Map)props), MockRecordCollector::new, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())), Time.SYSTEM);
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init(this.context, this.bytesStore);
        Assertions.assertEquals((int)0, (int)this.bytesStore.getSegments().size());
        this.bytesStore.restoreAllInternal(this.getChangelogRecordsWithTombstones());
        Assertions.assertEquals((int)1, (int)this.bytesStore.getSegments().size());
        String key = "a";
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        if (this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema) {
            expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L));
        }
        List<KeyValue<Windowed<String>, Long>> results = this.toListAndCloseIterator((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assertions.assertEquals(expected, results);
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions("A"), (Matcher)Matchers.hasEntry((Object)0, (Object)2L));
    }

    @Test
    public void shouldNotThrowWhenRestoringOnMissingHeaders() {
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("__iq.consistency.offset.vector.enabled__", (Object)true);
        File dir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(dir, Serdes.String(), Serdes.String(), new StreamsMetricsImpl(new Metrics(), "mock", "processId", (Time)new MockTime()), new StreamsConfig((Map)props), MockRecordCollector::new, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())), Time.SYSTEM);
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init(this.context, this.bytesStore);
        this.bytesStore.restoreAllInternal(this.getChangelogRecordsWithoutHeaders());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition(), (Matcher)CoreMatchers.is((Object)Position.emptyPosition()));
    }

    private List<ConsumerRecord<byte[], byte[]>> getChangelogRecords() {
        ArrayList<ConsumerRecord<byte[], byte[]>> records = new ArrayList<ConsumerRecord<byte[], byte[]>>();
        RecordHeaders headers = new RecordHeaders();
        Position position1 = Position.emptyPosition();
        position1 = position1.withComponent("", 0, 1L);
        headers.add((Header)ChangelogRecordDeserializationHelper.CHANGELOG_VERSION_HEADER_RECORD_CONSISTENCY);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position1).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]), true).get(), (Object)this.serializeValue(50L), (Headers)headers, Optional.empty()));
        headers.remove("c");
        position1 = position1.withComponent("", 0, 2L);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position1).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2]), true).get(), (Object)this.serializeValue(100L), (Headers)headers, Optional.empty()));
        headers.remove("c");
        position1 = position1.withComponent("", 0, 3L);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position1).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3]), true).get(), (Object)this.serializeValue(200L), (Headers)headers, Optional.empty()));
        return records;
    }

    private List<ConsumerRecord<byte[], byte[]>> getChangelogRecordsMultipleTopics() {
        ArrayList<ConsumerRecord<byte[], byte[]>> records = new ArrayList<ConsumerRecord<byte[], byte[]>>();
        RecordHeaders headers = new RecordHeaders();
        Position position1 = Position.emptyPosition();
        position1 = position1.withComponent("A", 0, 1L);
        headers.add((Header)ChangelogRecordDeserializationHelper.CHANGELOG_VERSION_HEADER_RECORD_CONSISTENCY);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position1).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]), true).get(), (Object)this.serializeValue(50L), (Headers)headers, Optional.empty()));
        headers.remove("c");
        position1 = position1.withComponent("B", 0, 2L);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position1).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2]), true).get(), (Object)this.serializeValue(100L), (Headers)headers, Optional.empty()));
        headers.remove("c");
        position1 = position1.withComponent("A", 0, 3L);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position1).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3]), true).get(), (Object)this.serializeValue(200L), (Headers)headers, Optional.empty()));
        return records;
    }

    private List<ConsumerRecord<byte[], byte[]>> getChangelogRecordsWithTombstones() {
        ArrayList<ConsumerRecord<byte[], byte[]>> records = new ArrayList<ConsumerRecord<byte[], byte[]>>();
        RecordHeaders headers = new RecordHeaders();
        Position position = Position.emptyPosition();
        position = position.withComponent("A", 0, 1L);
        headers.add((Header)ChangelogRecordDeserializationHelper.CHANGELOG_VERSION_HEADER_RECORD_CONSISTENCY);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]), true).get(), (Object)this.serializeValue(50L), (Headers)headers, Optional.empty()));
        position = position.withComponent("A", 0, 2L);
        headers.add((Header)ChangelogRecordDeserializationHelper.CHANGELOG_VERSION_HEADER_RECORD_CONSISTENCY);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2]), true).get(), null, (Headers)headers, Optional.empty()));
        return records;
    }

    private List<ConsumerRecord<byte[], byte[]>> getChangelogRecordsWithoutHeaders() {
        ArrayList<ConsumerRecord<byte[], byte[]>> records = new ArrayList<ConsumerRecord<byte[], byte[]>>();
        records.add(new ConsumerRecord("", 0, 0L, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2])).get(), (Object)this.serializeValue(50L)));
        return records;
    }

    @Test
    public void shouldMeasureExpiredRecords() {
        Properties streamsConfig = StreamsTestUtils.getStreamsConfig();
        AbstractDualSchemaRocksDBSegmentedBytesStore<KeyValueSegment> bytesStore = this.getBytesStore();
        InternalMockProcessorContext context = new InternalMockProcessorContext(TestUtils.tempDirectory(), new StreamsConfig((Map)streamsConfig));
        Time time = Time.SYSTEM;
        context.setSystemTimeMs(time.milliseconds());
        bytesStore.init(context, bytesStore);
        bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"dummy", this.nextSegmentWindow)), this.serializeValue(0L));
        Bytes key = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]));
        byte[] value = this.serializeValue(5L);
        bytesStore.put(key, value);
        Map metrics = context.metrics().metrics();
        String threadId = Thread.currentThread().getName();
        Metric dropTotal = (Metric)metrics.get(new MetricName("dropped-records-total", "stream-task-metrics", "", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)threadId), Utils.mkEntry((Object)"task-id", (Object)"0_0")})));
        Metric dropRate = (Metric)metrics.get(new MetricName("dropped-records-rate", "stream-task-metrics", "", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)threadId), Utils.mkEntry((Object)"task-id", (Object)"0_0")})));
        Assertions.assertEquals((Object)1.0, (Object)dropTotal.metricValue());
        Assertions.assertNotEquals((Object)0.0, (Object)dropRate.metricValue());
        bytesStore.close();
    }

    private Set<String> segmentDirs() {
        File windowDir = new File(this.stateDir, "bytes-store");
        return Set.of(Objects.requireNonNull(windowDir.list()));
    }

    private Bytes serializeKey(Windowed<String> key) {
        return this.serializeKey(key, false);
    }

    private Bytes serializeKey(Windowed<String> key, boolean changeLog) {
        return this.serializeKey(key, changeLog, 0);
    }

    private Bytes serializeKey(Windowed<String> key, boolean changeLog, int seq) {
        StateSerdes stateSerdes = StateSerdes.withBuiltinTypes((String)"dummy", String.class, Long.class);
        if (this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema) {
            if (changeLog) {
                return WindowKeySchema.toStoreKeyBinary(key, (int)seq, (StateSerdes)stateSerdes);
            }
            return PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary(key, (int)seq, (StateSerdes)stateSerdes);
        }
        if (this.getBaseSchema() instanceof PrefixedSessionKeySchemas.TimeFirstSessionKeySchema) {
            if (changeLog) {
                return Bytes.wrap((byte[])SessionKeySchema.toBinary(key, (Serializer)stateSerdes.keySerializer(), (String)"dummy"));
            }
            return Bytes.wrap((byte[])PrefixedSessionKeySchemas.TimeFirstSessionKeySchema.toBinary(key, (Serializer)stateSerdes.keySerializer(), (String)"dummy"));
        }
        throw new IllegalStateException("Unrecognized serde schema");
    }

    private Bytes serializeKeyForIndex(Windowed<String> key) {
        StateSerdes stateSerdes = StateSerdes.withBuiltinTypes((String)"dummy", String.class, Long.class);
        if (this.getIndexSchema() instanceof PrefixedWindowKeySchemas.KeyFirstWindowKeySchema) {
            return PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.toStoreKeyBinary(key, (int)0, (StateSerdes)stateSerdes);
        }
        if (this.getIndexSchema() instanceof PrefixedSessionKeySchemas.KeyFirstSessionKeySchema) {
            return Bytes.wrap((byte[])PrefixedSessionKeySchemas.KeyFirstSessionKeySchema.toBinary(key, (Serializer)stateSerdes.keySerializer(), (String)"dummy"));
        }
        throw new IllegalStateException("Unrecognized serde schema");
    }

    private byte[] serializeValue(long value) {
        return new LongSerializer().serialize("", Long.valueOf(value));
    }

    private List<KeyValue<Windowed<String>, Long>> toListAndCloseIterator(KeyValueIterator<Bytes, byte[]> iterator) {
        try (KeyValueIterator<Bytes, byte[]> keyValueIterator = iterator;){
            ArrayList<KeyValue<Windowed<String>, Long>> results = new ArrayList<KeyValue<Windowed<String>, Long>>();
            StateSerdes stateSerdes = StateSerdes.withBuiltinTypes((String)"dummy", String.class, Long.class);
            while (iterator.hasNext()) {
                KeyValue deserialized;
                KeyValue next = (KeyValue)iterator.next();
                if (this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema) {
                    deserialized = KeyValue.pair((Object)PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.fromStoreKey((byte[])((Bytes)next.key).get(), (long)this.windowSizeForTimeWindow, (Deserializer)stateSerdes.keyDeserializer(), (String)stateSerdes.topic()), (Object)((Long)stateSerdes.valueDeserializer().deserialize("dummy", (byte[])next.value)));
                    results.add((KeyValue<Windowed<String>, Long>)deserialized);
                    continue;
                }
                if (this.getBaseSchema() instanceof PrefixedSessionKeySchemas.TimeFirstSessionKeySchema) {
                    deserialized = KeyValue.pair((Object)PrefixedSessionKeySchemas.TimeFirstSessionKeySchema.from((byte[])((Bytes)next.key).get(), (Deserializer)stateSerdes.keyDeserializer(), (String)"dummy"), (Object)((Long)stateSerdes.valueDeserializer().deserialize("dummy", (byte[])next.value)));
                    results.add((KeyValue<Windowed<String>, Long>)deserialized);
                    continue;
                }
                throw new IllegalStateException("Unrecognized serde schema");
            }
            ArrayList<KeyValue<Windowed<String>, Long>> arrayList = results;
            return arrayList;
        }
    }

    static enum SchemaType {
        WindowSchemaWithIndex,
        WindowSchemaWithoutIndex,
        SessionSchemaWithIndex,
        SessionSchemaWithoutIndex;

    }
}

