/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.KeyValueStoreTestDriver;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractKeyValueStoreTest {
    protected InternalMockProcessorContext<?, ?> context;
    protected KeyValueStore<Integer, String> store;
    protected KeyValueStoreTestDriver<Integer, String> driver;

    protected abstract <K, V> KeyValueStore<K, V> createKeyValueStore(StateStoreContext var1);

    @BeforeEach
    public void before() {
        this.driver = KeyValueStoreTestDriver.create(Integer.class, String.class);
        this.context = (InternalMockProcessorContext)this.driver.context();
        this.context.setTime(10L);
        this.store = this.createKeyValueStore((StateStoreContext)this.context);
    }

    @AfterEach
    public void after() {
        this.store.close();
        this.driver.clear();
    }

    private static Map<Integer, String> getContentsAndCloseIterator(KeyValueIterator<Integer, String> iter) {
        try (KeyValueIterator<Integer, String> keyValueIterator = iter;){
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            while (iter.hasNext()) {
                KeyValue entry = (KeyValue)iter.next();
                result.put((Integer)entry.key, (String)entry.value);
            }
            HashMap<Integer, String> hashMap = result;
            return hashMap;
        }
    }

    @Test
    public void shouldNotIncludeDeletedFromRangeResult() {
        this.store.close();
        StringSerializer serializer = new StringSerializer(){
            private int numCalls = 0;

            public byte[] serialize(String topic, String data) {
                if (++this.numCalls > 3) {
                    Assertions.fail((String)"Value serializer is called; it should never happen");
                }
                return super.serialize(topic, data);
            }
        };
        this.context.setValueSerde(Serdes.serdeFrom((Serializer)serializer, (Deserializer)new StringDeserializer()));
        this.store = this.createKeyValueStore(this.driver.context());
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.delete((Object)0);
        this.store.delete((Object)1);
        Map<Integer, String> expectedContents = Collections.singletonMap(2, "two");
        Assertions.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContentsAndCloseIterator((KeyValueIterator<Integer, String>)this.store.all()));
    }

    @Test
    public void shouldDeleteIfSerializedValueIsNull() {
        this.store.close();
        StringSerializer serializer = new StringSerializer(){

            public byte[] serialize(String topic, String data) {
                if (data.equals("null")) {
                    return null;
                }
                return super.serialize(topic, data);
            }
        };
        this.context.setValueSerde(Serdes.serdeFrom((Serializer)serializer, (Deserializer)new StringDeserializer()));
        this.store = this.createKeyValueStore(this.driver.context());
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)0, (Object)"null");
        this.store.put((Object)1, (Object)"null");
        Map<Integer, String> expectedContents = Collections.singletonMap(2, "two");
        Assertions.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContentsAndCloseIterator((KeyValueIterator<Integer, String>)this.store.all()));
    }

    @Test
    public void testPutGetRange() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        Assertions.assertEquals((int)5, (int)this.driver.sizeOf(this.store));
        Assertions.assertEquals((Object)"zero", (Object)this.store.get((Object)0));
        Assertions.assertEquals((Object)"one", (Object)this.store.get((Object)1));
        Assertions.assertEquals((Object)"two", (Object)this.store.get((Object)2));
        Assertions.assertNull((Object)this.store.get((Object)3));
        Assertions.assertEquals((Object)"four", (Object)this.store.get((Object)4));
        Assertions.assertEquals((Object)"five", (Object)this.store.get((Object)5));
        this.store.flush();
        this.store.delete((Object)5);
        Assertions.assertEquals((int)4, (int)this.driver.sizeOf(this.store));
        this.store.flush();
        Assertions.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assertions.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assertions.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assertions.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assertions.assertNull((Object)this.driver.flushedEntryStored(5));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(0));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(1));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(2));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(4));
        Assertions.assertTrue((boolean)this.driver.flushedEntryRemoved(5));
        HashMap<Integer, String> expectedContents = new HashMap<Integer, String>();
        expectedContents.put(2, "two");
        expectedContents.put(4, "four");
        Assertions.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContentsAndCloseIterator((KeyValueIterator<Integer, String>)this.store.range((Object)2, (Object)4)));
        Assertions.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContentsAndCloseIterator((KeyValueIterator<Integer, String>)this.store.range((Object)2, (Object)6)));
        expectedContents.put(0, "zero");
        expectedContents.put(1, "one");
        Assertions.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContentsAndCloseIterator((KeyValueIterator<Integer, String>)this.store.all()));
    }

    @Test
    public void testPutGetReverseRange() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        Assertions.assertEquals((int)5, (int)this.driver.sizeOf(this.store));
        Assertions.assertEquals((Object)"zero", (Object)this.store.get((Object)0));
        Assertions.assertEquals((Object)"one", (Object)this.store.get((Object)1));
        Assertions.assertEquals((Object)"two", (Object)this.store.get((Object)2));
        Assertions.assertNull((Object)this.store.get((Object)3));
        Assertions.assertEquals((Object)"four", (Object)this.store.get((Object)4));
        Assertions.assertEquals((Object)"five", (Object)this.store.get((Object)5));
        this.store.flush();
        this.store.delete((Object)5);
        Assertions.assertEquals((int)4, (int)this.driver.sizeOf(this.store));
        this.store.flush();
        Assertions.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assertions.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assertions.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assertions.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assertions.assertNull((Object)this.driver.flushedEntryStored(5));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(0));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(1));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(2));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(4));
        Assertions.assertTrue((boolean)this.driver.flushedEntryRemoved(5));
        HashMap<Integer, String> expectedContents = new HashMap<Integer, String>();
        expectedContents.put(2, "two");
        expectedContents.put(4, "four");
        Assertions.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContentsAndCloseIterator((KeyValueIterator<Integer, String>)this.store.reverseRange((Object)2, (Object)4)));
        Assertions.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContentsAndCloseIterator((KeyValueIterator<Integer, String>)this.store.reverseRange((Object)2, (Object)6)));
        expectedContents.put(0, "zero");
        expectedContents.put(1, "one");
        Assertions.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContentsAndCloseIterator((KeyValueIterator<Integer, String>)this.store.reverseAll()));
    }

    @Test
    public void testPutGetWithDefaultSerdes() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        Assertions.assertEquals((int)5, (int)this.driver.sizeOf(this.store));
        Assertions.assertEquals((Object)"zero", (Object)this.store.get((Object)0));
        Assertions.assertEquals((Object)"one", (Object)this.store.get((Object)1));
        Assertions.assertEquals((Object)"two", (Object)this.store.get((Object)2));
        Assertions.assertNull((Object)this.store.get((Object)3));
        Assertions.assertEquals((Object)"four", (Object)this.store.get((Object)4));
        Assertions.assertEquals((Object)"five", (Object)this.store.get((Object)5));
        this.store.flush();
        this.store.delete((Object)5);
        this.store.flush();
        Assertions.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assertions.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assertions.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assertions.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assertions.assertNull((Object)this.driver.flushedEntryStored(5));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(0));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(1));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(2));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(4));
        Assertions.assertTrue((boolean)this.driver.flushedEntryRemoved(5));
    }

    @Test
    public void testRestore() {
        this.store.close();
        this.driver.addEntryToRestoreLog(0, "zero");
        this.driver.addEntryToRestoreLog(1, "one");
        this.driver.addEntryToRestoreLog(2, "two");
        this.driver.addEntryToRestoreLog(3, "three");
        this.store = this.createKeyValueStore(this.driver.context());
        this.context.restore(this.store.name(), this.driver.restoredEntries());
        Assertions.assertEquals((int)0, (int)this.driver.checkForRestoredEntries(this.store));
        Assertions.assertEquals((int)4, (int)this.driver.sizeOf(this.store));
    }

    @Test
    public void testRestoreWithDefaultSerdes() {
        this.store.close();
        this.driver.addEntryToRestoreLog(0, "zero");
        this.driver.addEntryToRestoreLog(1, "one");
        this.driver.addEntryToRestoreLog(2, "two");
        this.driver.addEntryToRestoreLog(3, "three");
        this.store = this.createKeyValueStore(this.driver.context());
        this.context.restore(this.store.name(), this.driver.restoredEntries());
        Assertions.assertEquals((int)0, (int)this.driver.checkForRestoredEntries(this.store));
        Assertions.assertEquals((int)4, (int)this.driver.sizeOf(this.store));
    }

    @Test
    public void testPutIfAbsent() {
        Assertions.assertNull((Object)this.store.putIfAbsent((Object)0, (Object)"zero"));
        Assertions.assertNull((Object)this.store.putIfAbsent((Object)1, (Object)"one"));
        Assertions.assertNull((Object)this.store.putIfAbsent((Object)2, (Object)"two"));
        Assertions.assertNull((Object)this.store.putIfAbsent((Object)4, (Object)"four"));
        Assertions.assertEquals((Object)"four", (Object)this.store.putIfAbsent((Object)4, (Object)"unexpected value"));
        Assertions.assertEquals((int)4, (int)this.driver.sizeOf(this.store));
        Assertions.assertEquals((Object)"zero", (Object)this.store.get((Object)0));
        Assertions.assertEquals((Object)"one", (Object)this.store.get((Object)1));
        Assertions.assertEquals((Object)"two", (Object)this.store.get((Object)2));
        Assertions.assertNull((Object)this.store.get((Object)3));
        Assertions.assertEquals((Object)"four", (Object)this.store.get((Object)4));
        this.store.flush();
        Assertions.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assertions.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assertions.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assertions.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(0));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(1));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(2));
        Assertions.assertFalse((boolean)this.driver.flushedEntryRemoved(4));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutNullKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.store.put(null, (Object)"anyValue"));
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutNullValue() {
        this.store.put((Object)1, null);
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutIfAbsentNullKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.store.putIfAbsent(null, (Object)"anyValue"));
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutIfAbsentNullValue() {
        this.store.putIfAbsent((Object)1, null);
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutAllNullKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.store.putAll(Collections.singletonList(new KeyValue(null, (Object)"anyValue"))));
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutAllNullKey() {
        this.store.putAll(Collections.singletonList(new KeyValue((Object)1, null)));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnDeleteNullKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.store.delete(null));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnGetNullKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.store.get(null));
    }

    @Test
    public void shouldReturnValueOnRangeNullToKey() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        LinkedList<KeyValue> expectedContents = new LinkedList<KeyValue>();
        expectedContents.add(new KeyValue((Object)0, (Object)"zero"));
        expectedContents.add(new KeyValue((Object)1, (Object)"one"));
        try (KeyValueIterator iterator = this.store.range(null, (Object)1);){
            Assertions.assertEquals(expectedContents, (Object)Utils.toList((Iterator)iterator));
        }
    }

    @Test
    public void shouldReturnValueOnRangeKeyToNull() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        LinkedList<KeyValue> expectedContents = new LinkedList<KeyValue>();
        expectedContents.add(new KeyValue((Object)1, (Object)"one"));
        expectedContents.add(new KeyValue((Object)2, (Object)"two"));
        try (KeyValueIterator iterator = this.store.range((Object)1, null);){
            Assertions.assertEquals(expectedContents, (Object)Utils.toList((Iterator)iterator));
        }
    }

    @Test
    public void shouldReturnValueOnRangeNullToNull() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        LinkedList<KeyValue> expectedContents = new LinkedList<KeyValue>();
        expectedContents.add(new KeyValue((Object)0, (Object)"zero"));
        expectedContents.add(new KeyValue((Object)1, (Object)"one"));
        expectedContents.add(new KeyValue((Object)2, (Object)"two"));
        try (KeyValueIterator iterator = this.store.range(null, null);){
            Assertions.assertEquals(expectedContents, (Object)Utils.toList((Iterator)iterator));
        }
    }

    @Test
    public void shouldReturnValueOnReverseRangeNullToKey() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        LinkedList<KeyValue> expectedContents = new LinkedList<KeyValue>();
        expectedContents.add(new KeyValue((Object)1, (Object)"one"));
        expectedContents.add(new KeyValue((Object)0, (Object)"zero"));
        try (KeyValueIterator iterator = this.store.reverseRange(null, (Object)1);){
            Assertions.assertEquals(expectedContents, (Object)Utils.toList((Iterator)iterator));
        }
    }

    @Test
    public void shouldReturnValueOnReverseRangeKeyToNull() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        LinkedList<KeyValue> expectedContents = new LinkedList<KeyValue>();
        expectedContents.add(new KeyValue((Object)2, (Object)"two"));
        expectedContents.add(new KeyValue((Object)1, (Object)"one"));
        try (KeyValueIterator iterator = this.store.reverseRange((Object)1, null);){
            Assertions.assertEquals(expectedContents, (Object)Utils.toList((Iterator)iterator));
        }
    }

    @Test
    public void shouldReturnValueOnReverseRangeNullToNull() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        LinkedList<KeyValue> expectedContents = new LinkedList<KeyValue>();
        expectedContents.add(new KeyValue((Object)2, (Object)"two"));
        expectedContents.add(new KeyValue((Object)1, (Object)"one"));
        expectedContents.add(new KeyValue((Object)0, (Object)"zero"));
        try (KeyValueIterator iterator = this.store.reverseRange(null, null);){
            Assertions.assertEquals(expectedContents, (Object)Utils.toList((Iterator)iterator));
        }
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((long)0L, (long)this.store.approximateNumEntries(), (String)"A newly created store should have no entries");
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        this.store.flush();
        Assertions.assertEquals((long)5L, (long)this.store.approximateNumEntries());
    }

    @Test
    public void shouldPutAll() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)1, (Object)"one"));
        entries.add(new KeyValue((Object)2, (Object)"two"));
        this.store.putAll(entries);
        List allReturned = StreamsTestUtils.toListAndCloseIterator(this.store.all());
        List<KeyValue> expectedReturned = Arrays.asList(KeyValue.pair((Object)1, (Object)"one"), KeyValue.pair((Object)2, (Object)"two"));
        MatcherAssert.assertThat(allReturned, (Matcher)IsEqual.equalTo(expectedReturned));
    }

    @Test
    public void shouldPutReverseAll() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)1, (Object)"one"));
        entries.add(new KeyValue((Object)2, (Object)"two"));
        this.store.putAll(entries);
        List allReturned = StreamsTestUtils.toListAndCloseIterator(this.store.reverseAll());
        List<KeyValue> expectedReturned = Arrays.asList(KeyValue.pair((Object)2, (Object)"two"), KeyValue.pair((Object)1, (Object)"one"));
        MatcherAssert.assertThat(allReturned, (Matcher)IsEqual.equalTo(expectedReturned));
    }

    @Test
    public void shouldDeleteFromStore() {
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.delete((Object)2);
        Assertions.assertNull((Object)this.store.get((Object)2));
    }

    @Test
    public void shouldReturnSameResultsForGetAndRangeWithEqualKeys() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)1, (Object)"one"));
        entries.add(new KeyValue((Object)2, (Object)"two"));
        entries.add(new KeyValue((Object)3, (Object)"three"));
        this.store.putAll(entries);
        try (KeyValueIterator iterator = this.store.range((Object)2, (Object)2);){
            Assertions.assertEquals((Object)((KeyValue)iterator.next()).value, (Object)this.store.get((Object)2));
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldReturnSameResultsForGetAndReverseRangeWithEqualKeys() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)1, (Object)"one"));
        entries.add(new KeyValue((Object)2, (Object)"two"));
        entries.add(new KeyValue((Object)3, (Object)"three"));
        this.store.putAll(entries);
        try (KeyValueIterator iterator = this.store.reverseRange((Object)2, (Object)2);){
            Assertions.assertEquals((Object)((KeyValue)iterator.next()).value, (Object)this.store.get((Object)2));
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldNotThrowConcurrentModificationException() {
        this.store.put((Object)0, (Object)"zero");
        try (KeyValueIterator results = this.store.range((Object)0, (Object)2);){
            this.store.put((Object)1, (Object)"one");
            Assertions.assertEquals((Object)new KeyValue((Object)0, (Object)"zero"), (Object)results.next());
        }
    }

    @Test
    public void shouldNotThrowInvalidRangeExceptionWithNegativeFromKey() {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            try (KeyValueIterator iterator = this.store.range((Object)-1, (Object)1);){
                Assertions.assertFalse((boolean)iterator.hasNext());
            }
            List messages = appender.getMessages();
            MatcherAssert.assertThat((Object)messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }

    @Test
    public void shouldNotThrowInvalidReverseRangeExceptionWithNegativeFromKey() {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            try (KeyValueIterator iterator = this.store.reverseRange((Object)-1, (Object)1);){
                Assertions.assertFalse((boolean)iterator.hasNext());
            }
            List messages = appender.getMessages();
            MatcherAssert.assertThat((Object)messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }

    @Test
    public void shouldNotThrowInvalidRangeExceptionWithFromLargerThanTo() {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            try (KeyValueIterator iterator = this.store.range((Object)2, (Object)1);){
                Assertions.assertFalse((boolean)iterator.hasNext());
            }
            List messages = appender.getMessages();
            MatcherAssert.assertThat((Object)messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }

    @Test
    public void shouldNotThrowInvalidReverseRangeExceptionWithFromLargerThanTo() {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            try (KeyValueIterator iterator = this.store.reverseRange((Object)2, (Object)1);){
                Assertions.assertFalse((boolean)iterator.hasNext());
            }
            List messages = appender.getMessages();
            MatcherAssert.assertThat((Object)messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }

    @Test
    public void prefixScanShouldNotThrowConcurrentModificationException() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)222, (Object)"two-hundred-twenty-two");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)22, (Object)"twenty-two");
        this.store.put((Object)3, (Object)"three");
        try (KeyValueIterator iter = this.store.prefixScan((Object)2, (Serializer)new IntegerSerializer());){
            this.store.delete((Object)22);
            while (iter.hasNext()) {
                iter.next();
            }
        }
    }
}

