/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.state.internals.BufferValue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BufferValueTest {
    @Test
    public void shouldDeduplicateNullValues() {
        BufferValue bufferValue = new BufferValue(null, null, null, null);
        Assertions.assertSame((Object)bufferValue.priorValue(), (Object)bufferValue.oldValue());
    }

    @Test
    public void shouldDeduplicateIdenticalValues() {
        byte[] bytes = new byte[]{0};
        BufferValue bufferValue = new BufferValue(bytes, bytes, null, null);
        Assertions.assertSame((Object)bufferValue.priorValue(), (Object)bufferValue.oldValue());
    }

    @Test
    public void shouldDeduplicateEqualValues() {
        BufferValue bufferValue = new BufferValue(new byte[]{0}, new byte[]{0}, null, null);
        Assertions.assertSame((Object)bufferValue.priorValue(), (Object)bufferValue.oldValue());
    }

    @Test
    public void shouldStoreDifferentValues() {
        byte[] priorValue = new byte[]{0};
        byte[] oldValue = new byte[]{1};
        BufferValue bufferValue = new BufferValue(priorValue, oldValue, null, null);
        Assertions.assertSame((Object)priorValue, (Object)bufferValue.priorValue());
        Assertions.assertSame((Object)oldValue, (Object)bufferValue.oldValue());
        Assertions.assertNotEquals((Object)bufferValue.priorValue(), (Object)bufferValue.oldValue());
    }

    @Test
    public void shouldStoreDifferentValuesWithPriorNull() {
        byte[] priorValue = null;
        byte[] oldValue = new byte[]{1};
        BufferValue bufferValue = new BufferValue(priorValue, oldValue, null, null);
        Assertions.assertNull((Object)bufferValue.priorValue());
        Assertions.assertSame((Object)oldValue, (Object)bufferValue.oldValue());
        Assertions.assertNotEquals((Object)bufferValue.priorValue(), (Object)bufferValue.oldValue());
    }

    @Test
    public void shouldStoreDifferentValuesWithOldNull() {
        byte[] priorValue = new byte[]{0};
        byte[] oldValue = null;
        BufferValue bufferValue = new BufferValue(priorValue, oldValue, null, null);
        Assertions.assertSame((Object)priorValue, (Object)bufferValue.priorValue());
        Assertions.assertNull((Object)bufferValue.oldValue());
        Assertions.assertNotEquals((Object)bufferValue.priorValue(), (Object)bufferValue.oldValue());
    }

    @Test
    public void shouldAccountForDeduplicationInSizeEstimate() {
        ProcessorRecordContext context = new ProcessorRecordContext(0L, 0L, 0, "topic", (Headers)new RecordHeaders());
        Assertions.assertEquals((long)25L, (long)new BufferValue(null, null, null, context).residentMemorySizeEstimate());
        Assertions.assertEquals((long)26L, (long)new BufferValue(new byte[]{0}, null, null, context).residentMemorySizeEstimate());
        Assertions.assertEquals((long)26L, (long)new BufferValue(null, new byte[]{0}, null, context).residentMemorySizeEstimate());
        Assertions.assertEquals((long)26L, (long)new BufferValue(new byte[]{0}, new byte[]{0}, null, context).residentMemorySizeEstimate());
        Assertions.assertEquals((long)27L, (long)new BufferValue(new byte[]{0}, new byte[]{1}, null, context).residentMemorySizeEstimate());
        Assertions.assertEquals((long)28L, (long)new BufferValue(new byte[]{0}, new byte[]{1}, new byte[]{0}, context).residentMemorySizeEstimate());
    }

    @Test
    public void shouldSerializeNulls() {
        ProcessorRecordContext context = new ProcessorRecordContext(0L, 0L, 0, "topic", (Headers)new RecordHeaders());
        byte[] serializedContext = context.serialize();
        byte[] bytes = new BufferValue(null, null, null, context).serialize(0).array();
        byte[] withoutContext = Arrays.copyOfRange(bytes, serializedContext.length, bytes.length);
        MatcherAssert.assertThat((Object)withoutContext, (Matcher)Matchers.is((Object)ByteBuffer.allocate(12).putInt(-1).putInt(-1).putInt(-1).array()));
    }

    @Test
    public void shouldSerializePrior() {
        ProcessorRecordContext context = new ProcessorRecordContext(0L, 0L, 0, "topic", (Headers)new RecordHeaders());
        byte[] serializedContext = context.serialize();
        byte[] priorValue = new byte[]{5};
        byte[] bytes = new BufferValue(priorValue, null, null, context).serialize(0).array();
        byte[] withoutContext = Arrays.copyOfRange(bytes, serializedContext.length, bytes.length);
        MatcherAssert.assertThat((Object)withoutContext, (Matcher)Matchers.is((Object)ByteBuffer.allocate(13).putInt(1).put(priorValue).putInt(-1).putInt(-1).array()));
    }

    @Test
    public void shouldSerializeOld() {
        ProcessorRecordContext context = new ProcessorRecordContext(0L, 0L, 0, "topic", (Headers)new RecordHeaders());
        byte[] serializedContext = context.serialize();
        byte[] oldValue = new byte[]{5};
        byte[] bytes = new BufferValue(null, oldValue, null, context).serialize(0).array();
        byte[] withoutContext = Arrays.copyOfRange(bytes, serializedContext.length, bytes.length);
        MatcherAssert.assertThat((Object)withoutContext, (Matcher)Matchers.is((Object)ByteBuffer.allocate(13).putInt(-1).putInt(1).put(oldValue).putInt(-1).array()));
    }

    @Test
    public void shouldSerializeNew() {
        ProcessorRecordContext context = new ProcessorRecordContext(0L, 0L, 0, "topic", (Headers)new RecordHeaders());
        byte[] serializedContext = context.serialize();
        byte[] newValue = new byte[]{5};
        byte[] bytes = new BufferValue(null, null, newValue, context).serialize(0).array();
        byte[] withoutContext = Arrays.copyOfRange(bytes, serializedContext.length, bytes.length);
        MatcherAssert.assertThat((Object)withoutContext, (Matcher)Matchers.is((Object)ByteBuffer.allocate(13).putInt(-1).putInt(-1).putInt(1).put(newValue).array()));
    }

    @Test
    public void shouldCompactDuplicates() {
        ProcessorRecordContext context = new ProcessorRecordContext(0L, 0L, 0, "topic", (Headers)new RecordHeaders());
        byte[] serializedContext = context.serialize();
        byte[] duplicate = new byte[]{5};
        byte[] bytes = new BufferValue(duplicate, duplicate, null, context).serialize(0).array();
        byte[] withoutContext = Arrays.copyOfRange(bytes, serializedContext.length, bytes.length);
        MatcherAssert.assertThat((Object)withoutContext, (Matcher)Matchers.is((Object)ByteBuffer.allocate(13).putInt(1).put(duplicate).putInt(-2).putInt(-1).array()));
    }

    @Test
    public void shouldDeserializePrior() {
        ProcessorRecordContext context = new ProcessorRecordContext(0L, 0L, 0, "topic", (Headers)new RecordHeaders());
        byte[] serializedContext = context.serialize();
        byte[] priorValue = new byte[]{5};
        ByteBuffer serialValue = ByteBuffer.allocate(serializedContext.length + 12 + priorValue.length).put(serializedContext).putInt(1).put(priorValue).putInt(-1).putInt(-1);
        serialValue.position(0);
        BufferValue deserialize = BufferValue.deserialize((ByteBuffer)serialValue);
        MatcherAssert.assertThat((Object)deserialize, (Matcher)Matchers.is((Object)new BufferValue(priorValue, null, null, context)));
    }

    @Test
    public void shouldDeserializeOld() {
        ProcessorRecordContext context = new ProcessorRecordContext(0L, 0L, 0, "topic", (Headers)new RecordHeaders());
        byte[] serializedContext = context.serialize();
        byte[] oldValue = new byte[]{5};
        ByteBuffer serialValue = ByteBuffer.allocate(serializedContext.length + 12 + oldValue.length).put(serializedContext).putInt(-1).putInt(1).put(oldValue).putInt(-1);
        serialValue.position(0);
        MatcherAssert.assertThat((Object)BufferValue.deserialize((ByteBuffer)serialValue), (Matcher)Matchers.is((Object)new BufferValue(null, oldValue, null, context)));
    }

    @Test
    public void shouldDeserializeNew() {
        ProcessorRecordContext context = new ProcessorRecordContext(0L, 0L, 0, "topic", (Headers)new RecordHeaders());
        byte[] serializedContext = context.serialize();
        byte[] newValue = new byte[]{5};
        ByteBuffer serialValue = ByteBuffer.allocate(serializedContext.length + 12 + newValue.length).put(serializedContext).putInt(-1).putInt(-1).putInt(1).put(newValue);
        serialValue.position(0);
        MatcherAssert.assertThat((Object)BufferValue.deserialize((ByteBuffer)serialValue), (Matcher)Matchers.is((Object)new BufferValue(null, null, newValue, context)));
    }

    @Test
    public void shouldDeserializeCompactedDuplicates() {
        ProcessorRecordContext context = new ProcessorRecordContext(0L, 0L, 0, "topic", (Headers)new RecordHeaders());
        byte[] serializedContext = context.serialize();
        byte[] duplicate = new byte[]{5};
        ByteBuffer serialValue = ByteBuffer.allocate(serializedContext.length + 12 + duplicate.length).put(serializedContext).putInt(1).put(duplicate).putInt(-2).putInt(-1);
        serialValue.position(0);
        BufferValue bufferValue = BufferValue.deserialize((ByteBuffer)serialValue);
        MatcherAssert.assertThat((Object)bufferValue, (Matcher)Matchers.is((Object)new BufferValue(duplicate, duplicate, null, context)));
        Assertions.assertSame((Object)bufferValue.priorValue(), (Object)bufferValue.oldValue());
    }
}

